/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.IdentityObjectIntMap;
import com.esotericsoftware.kryo.util.IntMap;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.minlog.Log;

public class DefaultClassResolver
implements ClassResolver {
    public static final byte NAME = -1;
    protected Kryo kryo;
    protected final IntMap<Registration> idToRegistration = new IntMap();
    protected final ObjectMap<Class, Registration> classToRegistration = new ObjectMap();
    protected IdentityObjectIntMap<Class> classToNameId;
    protected IntMap<Class> nameIdToClass;
    protected ObjectMap<String, Class> nameToClass;
    protected int nextNameId;
    private int memoizedClassId = -1;
    private Registration memoizedClassIdValue;

    public void setKryo(Kryo kryo) {
        this.kryo = kryo;
    }

    public Registration register(Registration registration) {
        if (registration == null) {
            throw new IllegalArgumentException("registration cannot be null.");
        }
        if (Log.TRACE) {
            if (registration.getId() == -1) {
                Log.trace("kryo", "Register class name: " + Util.className(registration.getType()) + " (" + registration.getSerializer().getClass().getName() + ")");
            } else {
                Log.trace("kryo", "Register class ID " + registration.getId() + ": " + Util.className(registration.getType()) + " (" + registration.getSerializer().getClass().getName() + ")");
            }
        }
        this.classToRegistration.put(registration.getType(), registration);
        this.idToRegistration.put(registration.getId(), registration);
        if (registration.getType().isPrimitive()) {
            this.classToRegistration.put(Util.getWrapperClass(registration.getType()), registration);
        }
        return registration;
    }

    public Registration registerImplicit(Class clazz) {
        return this.register(new Registration(clazz, this.kryo.getDefaultSerializer(clazz), -1));
    }

    public Registration getRegistration(Class clazz) {
        return this.classToRegistration.get(clazz);
    }

    public Registration getRegistration(int n) {
        return this.idToRegistration.get(n);
    }

    public Registration writeClass(Output output, Class clazz) {
        if (clazz == null) {
            if (Log.TRACE || Log.DEBUG && this.kryo.getDepth() == 1) {
                Util.log("Write", null);
            }
            output.writeByte((byte)0);
            return null;
        }
        Registration registration = this.kryo.getRegistration(clazz);
        if (registration.getId() == -1) {
            this.writeName(output, clazz, registration);
        } else {
            if (Log.TRACE) {
                Log.trace("kryo", "Write class " + registration.getId() + ": " + Util.className(clazz));
            }
            output.writeInt(registration.getId() + 2, true);
        }
        return registration;
    }

    protected void writeName(Output output, Class clazz, Registration registration) {
        int n;
        output.writeByte(1);
        if (this.classToNameId != null && (n = this.classToNameId.get(clazz, -1)) != -1) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write class name reference " + n + ": " + Util.className(clazz));
            }
            output.writeInt(n, true);
            return;
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Write class name: " + Util.className(clazz));
        }
        n = this.nextNameId++;
        if (this.classToNameId == null) {
            this.classToNameId = new IdentityObjectIntMap();
        }
        this.classToNameId.put(clazz, n);
        output.write(n);
        output.writeString(clazz.getName());
    }

    public Registration readClass(Input input) {
        int n = input.readInt(true);
        switch (n) {
            case 0: {
                if (Log.TRACE || Log.DEBUG && this.kryo.getDepth() == 1) {
                    Util.log("Read", null);
                }
                return null;
            }
            case 1: {
                return this.readName(input);
            }
        }
        if (n == this.memoizedClassId) {
            return this.memoizedClassIdValue;
        }
        Registration registration = this.idToRegistration.get(n - 2);
        if (registration == null) {
            throw new KryoException("Encountered unregistered class ID: " + (n - 2));
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read class " + (n - 2) + ": " + Util.className(registration.getType()));
        }
        this.memoizedClassId = n;
        this.memoizedClassIdValue = registration;
        return registration;
    }

    protected Registration readName(Input input) {
        Class<?> clazz;
        int n = input.readInt(true);
        if (this.nameIdToClass == null) {
            this.nameIdToClass = new IntMap();
        }
        if ((clazz = this.nameIdToClass.get(n)) == null) {
            String string = input.readString();
            if (this.nameToClass != null) {
                clazz = this.nameToClass.get(string);
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName(string, false, this.kryo.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new KryoException("Unable to find class: " + string, classNotFoundException);
                }
                if (this.nameToClass == null) {
                    this.nameToClass = new ObjectMap();
                }
                this.nameToClass.put(string, clazz);
            }
            this.nameIdToClass.put(n, clazz);
            if (Log.TRACE) {
                Log.trace("kryo", "Read class name: " + string);
            }
        } else if (Log.TRACE) {
            Log.trace("kryo", "Read class name reference " + n + ": " + Util.className(clazz));
        }
        return this.kryo.getRegistration(clazz);
    }

    public void reset() {
        if (!this.kryo.isRegistrationRequired()) {
            if (this.classToNameId != null) {
                this.classToNameId.clear();
            }
            if (this.nameIdToClass != null) {
                this.nameIdToClass.clear();
            }
            this.nextNameId = 0;
        }
    }
}

