/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedFieldSerializer<T>
extends FieldSerializer<T> {
    private int[] tags;

    public TaggedFieldSerializer(Kryo kryo, Class clazz) {
        super(kryo, clazz);
    }

    @Override
    protected void initializeCachedFields() {
        int n;
        FieldSerializer.CachedField[] cachedFieldArray = this.getFields();
        int n2 = cachedFieldArray.length;
        for (n = 0; n < n2; ++n) {
            Field field = cachedFieldArray[n].getField();
            Tag tag = field.getAnnotation(Tag.class);
            Deprecated deprecated = field.getAnnotation(Deprecated.class);
            if (tag != null && deprecated == null) continue;
            if (Log.TRACE) {
                if (tag == null) {
                    Log.trace("kryo", "Ignoring field without tag: " + cachedFieldArray[n]);
                } else {
                    Log.trace("kryo", "Ignoring deprecated field: " + cachedFieldArray[n]);
                }
            }
            super.removeField(field.getName());
        }
        cachedFieldArray = this.getFields();
        this.tags = new int[cachedFieldArray.length];
        n2 = cachedFieldArray.length;
        for (n = 0; n < n2; ++n) {
            this.tags[n] = cachedFieldArray[n].getField().getAnnotation(Tag.class).value();
        }
    }

    @Override
    public void removeField(String string) {
        super.removeField(string);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T t) {
        FieldSerializer.CachedField[] cachedFieldArray = this.getFields();
        output.writeInt(cachedFieldArray.length, true);
        int n = cachedFieldArray.length;
        for (int i = 0; i < n; ++i) {
            output.writeInt(this.tags[i], true);
            cachedFieldArray[i].write(output, t);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> clazz) {
        T t = kryo.newInstance(clazz);
        kryo.reference(t);
        int n = input.readInt(true);
        int[] nArray = this.tags;
        FieldSerializer.CachedField[] cachedFieldArray = this.getFields();
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            int n3 = input.readInt(true);
            FieldSerializer.CachedField cachedField = null;
            int n4 = nArray.length;
            for (int j = 0; j < n4; ++j) {
                if (nArray[j] != n3) continue;
                cachedField = cachedFieldArray[j];
                break;
            }
            if (cachedField == null) {
                throw new KryoException("Unknown field tag: " + n3 + " (" + this.getType().getName() + ")");
            }
            cachedField.read(input, t);
        }
        return t;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tag {
        public int value();
    }
}

