/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import java.io.IOException;
import java.io.OutputStream;

public class Output
extends OutputStream {
    private int maxCapacity;
    private int capacity;
    private int position;
    private int total;
    private byte[] buffer;
    private OutputStream outputStream;

    public Output() {
    }

    public Output(int n) {
        this(n, n);
    }

    public Output(int n, int n2) {
        if (n2 < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + n2);
        }
        this.capacity = n;
        this.maxCapacity = n2 == -1 ? Integer.MAX_VALUE : n2;
        this.buffer = new byte[n];
    }

    public Output(byte[] byArray) {
        this(byArray, byArray.length);
    }

    public Output(byte[] byArray, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        this.setBuffer(byArray, n);
    }

    public Output(OutputStream outputStream) {
        this(4096, 4096);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public Output(OutputStream outputStream, int n) {
        this(n, n);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.position = 0;
        this.total = 0;
    }

    public void setBuffer(byte[] byArray) {
        this.setBuffer(byArray, byArray.length);
    }

    public void setBuffer(byte[] byArray, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        if (n < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + n);
        }
        this.buffer = byArray;
        this.maxCapacity = n == -1 ? Integer.MAX_VALUE : n;
        this.capacity = byArray.length;
        this.position = 0;
        this.total = 0;
        this.outputStream = null;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[this.position];
        System.arraycopy(this.buffer, 0, byArray, 0, this.position);
        return byArray;
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int total() {
        return this.total + this.position;
    }

    public void clear() {
        this.position = 0;
        this.total = 0;
    }

    private boolean require(int n) throws KryoException {
        if (this.capacity - this.position >= n) {
            return false;
        }
        if (n > this.maxCapacity) {
            throw new KryoException("Buffer overflow. Max capacity: " + this.maxCapacity + ", required: " + n);
        }
        this.flush();
        while (this.capacity - this.position < n) {
            if (this.capacity == this.maxCapacity) {
                throw new KryoException("Buffer overflow. Available: " + (this.capacity - this.position) + ", required: " + n);
            }
            this.capacity = Math.min(this.capacity * 2, this.maxCapacity);
            if (this.capacity < 0) {
                this.capacity = this.maxCapacity;
            }
            byte[] byArray = new byte[this.capacity];
            System.arraycopy(this.buffer, 0, byArray, 0, this.position);
            this.buffer = byArray;
        }
        return true;
    }

    public void flush() throws KryoException {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.write(this.buffer, 0, this.position);
        }
        catch (IOException iOException) {
            throw new KryoException(iOException);
        }
        this.total += this.position;
        this.position = 0;
    }

    public void close() throws KryoException {
        this.flush();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void write(int n) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)n;
    }

    public void write(byte[] byArray) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws KryoException {
        this.writeBytes(byArray, n, n2);
    }

    public void writeByte(byte by) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = by;
    }

    public void writeByte(int n) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)n;
    }

    public void writeBytes(byte[] byArray) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int n3 = Math.min(this.capacity - this.position, n2);
        while (true) {
            System.arraycopy(byArray, n, this.buffer, this.position, n3);
            this.position += n3;
            if ((n2 -= n3) == 0) {
                return;
            }
            n += n3;
            n3 = Math.min(this.capacity, n2);
            this.require(n3);
        }
    }

    public void writeInt(int n) throws KryoException {
        this.require(4);
        byte[] byArray = this.buffer;
        byArray[this.position++] = (byte)(n >> 24);
        byArray[this.position++] = (byte)(n >> 16);
        byArray[this.position++] = (byte)(n >> 8);
        byArray[this.position++] = (byte)n;
    }

    public int writeInt(int n, boolean bl) throws KryoException {
        if (!bl) {
            n = n << 1 ^ n >> 31;
        }
        if (n >>> 7 == 0) {
            this.require(1);
            this.buffer[this.position++] = (byte)n;
            return 1;
        }
        if (n >>> 14 == 0) {
            this.require(2);
            this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(n >>> 7);
            return 2;
        }
        if (n >>> 21 == 0) {
            this.require(3);
            this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(n >>> 7 | 0x80);
            this.buffer[this.position++] = (byte)(n >>> 14);
            return 3;
        }
        if (n >>> 28 == 0) {
            this.require(4);
            this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(n >>> 7 | 0x80);
            this.buffer[this.position++] = (byte)(n >>> 14 | 0x80);
            this.buffer[this.position++] = (byte)(n >>> 21);
            return 4;
        }
        this.require(5);
        this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
        this.buffer[this.position++] = (byte)(n >>> 7 | 0x80);
        this.buffer[this.position++] = (byte)(n >>> 14 | 0x80);
        this.buffer[this.position++] = (byte)(n >>> 21 | 0x80);
        this.buffer[this.position++] = (byte)(n >>> 28);
        return 5;
    }

    public void writeString(String string) throws KryoException {
        int n;
        if (string == null) {
            this.writeByte(128);
            return;
        }
        int n2 = string.length();
        if (n2 == 0) {
            this.writeByte(129);
            return;
        }
        boolean bl = false;
        if (n2 > 1 && n2 < 64) {
            bl = true;
            for (n = 0; n < n2; ++n) {
                char c = string.charAt(n);
                if (c <= '\u007f') continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            if (this.capacity - this.position < n2) {
                this.writeAscii_slow(string, n2);
            } else {
                string.getBytes(0, n2, this.buffer, this.position);
                this.position += n2;
            }
            int n3 = this.position - 1;
            this.buffer[n3] = (byte)(this.buffer[n3] | 0x80);
        } else {
            this.writeUtf8Length(n2 + 1);
            if (this.capacity - this.position >= n2) {
                char c;
                byte[] byArray = this.buffer;
                int n4 = this.position;
                for (n = 0; n < n2 && (c = string.charAt(n)) <= '\u007f'; ++n) {
                    byArray[n4++] = (byte)c;
                }
                this.position = n4;
            }
            if (n < n2) {
                this.writeString_slow(string, n2, n);
            }
        }
    }

    public void writeString(CharSequence charSequence) throws KryoException {
        int n;
        if (charSequence == null) {
            this.writeByte(128);
            return;
        }
        int n2 = charSequence.length();
        if (n2 == 0) {
            this.writeByte(129);
            return;
        }
        this.writeUtf8Length(n2 + 1);
        if (this.capacity - this.position >= n2) {
            char c;
            byte[] byArray = this.buffer;
            int n3 = this.position;
            for (n = 0; n < n2 && (c = charSequence.charAt(n)) <= '\u007f'; ++n) {
                byArray[n3++] = (byte)c;
            }
            this.position = n3;
        }
        if (n < n2) {
            this.writeString_slow(charSequence, n2, n);
        }
    }

    public void writeAscii(String string) throws KryoException {
        if (string == null) {
            this.writeByte(128);
            return;
        }
        int n = string.length();
        if (n == 0) {
            this.writeByte(129);
            return;
        }
        if (this.capacity - this.position < n) {
            this.writeAscii_slow(string, n);
        } else {
            string.getBytes(0, n, this.buffer, this.position);
            this.position += n;
        }
        int n2 = this.position - 1;
        this.buffer[n2] = (byte)(this.buffer[n2] | 0x80);
    }

    private void writeUtf8Length(int n) {
        if (n >>> 6 == 0) {
            this.require(1);
            this.buffer[this.position++] = (byte)(n | 0x80);
        } else if (n >>> 13 == 0) {
            this.require(2);
            byte[] byArray = this.buffer;
            byArray[this.position++] = (byte)(n | 0x40 | 0x80);
            byArray[this.position++] = (byte)(n >>> 6);
        } else if (n >>> 20 == 0) {
            this.require(3);
            byte[] byArray = this.buffer;
            byArray[this.position++] = (byte)(n | 0x40 | 0x80);
            byArray[this.position++] = (byte)(n >>> 6 | 0x80);
            byArray[this.position++] = (byte)(n >>> 13);
        } else if (n >>> 27 == 0) {
            this.require(4);
            byte[] byArray = this.buffer;
            byArray[this.position++] = (byte)(n | 0x40 | 0x80);
            byArray[this.position++] = (byte)(n >>> 6 | 0x80);
            byArray[this.position++] = (byte)(n >>> 13 | 0x80);
            byArray[this.position++] = (byte)(n >>> 20);
        } else {
            this.require(5);
            byte[] byArray = this.buffer;
            byArray[this.position++] = (byte)(n | 0x40 | 0x80);
            byArray[this.position++] = (byte)(n >>> 6 | 0x80);
            byArray[this.position++] = (byte)(n >>> 13 | 0x80);
            byArray[this.position++] = (byte)(n >>> 20 | 0x80);
            byArray[this.position++] = (byte)(n >>> 27);
        }
    }

    private void writeString_slow(CharSequence charSequence, int n, int n2) {
        while (n2 < n) {
            char c;
            if (this.position == this.capacity) {
                this.require(Math.min(this.capacity, n - n2));
            }
            if ((c = charSequence.charAt(n2)) <= '\u007f') {
                this.buffer[this.position++] = (byte)c;
            } else if (c > '\u07ff') {
                this.buffer[this.position++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.require(2);
                this.buffer[this.position++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[this.position++] = (byte)(0x80 | c & 0x3F);
            } else {
                this.buffer[this.position++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.require(1);
                this.buffer[this.position++] = (byte)(0x80 | c & 0x3F);
            }
            ++n2;
        }
    }

    private void writeAscii_slow(String string, int n) throws KryoException {
        byte[] byArray = this.buffer;
        int n2 = 0;
        int n3 = Math.min(n, this.capacity - this.position);
        while (n2 < n) {
            string.getBytes(n2, n2 + n3, byArray, this.position);
            this.position += n3;
            if (!this.require(n3 = Math.min(n - (n2 += n3), this.capacity))) continue;
            byArray = this.buffer;
        }
    }

    public void writeFloat(float f) throws KryoException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public int writeFloat(float f, float f2, boolean bl) throws KryoException {
        return this.writeInt((int)(f * f2), bl);
    }

    public void writeShort(int n) throws KryoException {
        this.require(2);
        this.buffer[this.position++] = (byte)(n >>> 8);
        this.buffer[this.position++] = (byte)n;
    }

    public void writeLong(long l) throws KryoException {
        this.require(8);
        byte[] byArray = this.buffer;
        byArray[this.position++] = (byte)(l >>> 56);
        byArray[this.position++] = (byte)(l >>> 48);
        byArray[this.position++] = (byte)(l >>> 40);
        byArray[this.position++] = (byte)(l >>> 32);
        byArray[this.position++] = (byte)(l >>> 24);
        byArray[this.position++] = (byte)(l >>> 16);
        byArray[this.position++] = (byte)(l >>> 8);
        byArray[this.position++] = (byte)l;
    }

    public int writeLong(long l, boolean bl) throws KryoException {
        if (!bl) {
            l = l << 1 ^ l >> 63;
        }
        if (l >>> 7 == 0L) {
            this.require(1);
            this.buffer[this.position++] = (byte)l;
            return 1;
        }
        if (l >>> 14 == 0L) {
            this.require(2);
            this.buffer[this.position++] = (byte)(l & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 7);
            return 2;
        }
        if (l >>> 21 == 0L) {
            this.require(3);
            this.buffer[this.position++] = (byte)(l & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 14);
            return 3;
        }
        if (l >>> 28 == 0L) {
            this.require(4);
            this.buffer[this.position++] = (byte)(l & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 21);
            return 4;
        }
        if (l >>> 35 == 0L) {
            this.require(5);
            this.buffer[this.position++] = (byte)(l & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 28);
            return 5;
        }
        if (l >>> 42 == 0L) {
            this.require(6);
            this.buffer[this.position++] = (byte)(l & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 35);
            return 6;
        }
        if (l >>> 49 == 0L) {
            this.require(7);
            this.buffer[this.position++] = (byte)(l & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 35 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 42);
            return 7;
        }
        if (l >>> 56 == 0L) {
            this.require(8);
            this.buffer[this.position++] = (byte)(l & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 35 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 42 | 0x80L);
            this.buffer[this.position++] = (byte)(l >>> 49);
            return 8;
        }
        this.require(9);
        this.buffer[this.position++] = (byte)(l & 0x7FL | 0x80L);
        this.buffer[this.position++] = (byte)(l >>> 7 | 0x80L);
        this.buffer[this.position++] = (byte)(l >>> 14 | 0x80L);
        this.buffer[this.position++] = (byte)(l >>> 21 | 0x80L);
        this.buffer[this.position++] = (byte)(l >>> 28 | 0x80L);
        this.buffer[this.position++] = (byte)(l >>> 35 | 0x80L);
        this.buffer[this.position++] = (byte)(l >>> 42 | 0x80L);
        this.buffer[this.position++] = (byte)(l >>> 49 | 0x80L);
        this.buffer[this.position++] = (byte)(l >>> 56);
        return 9;
    }

    public void writeBoolean(boolean bl) throws KryoException {
        this.require(1);
        this.buffer[this.position++] = (byte)(bl ? 1 : 0);
    }

    public void writeChar(char c) throws KryoException {
        this.require(2);
        this.buffer[this.position++] = (byte)(c >>> 8);
        this.buffer[this.position++] = (byte)c;
    }

    public void writeDouble(double d) throws KryoException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public int writeDouble(double d, double d2, boolean bl) throws KryoException {
        return this.writeLong((long)(d * d2), bl);
    }

    public static int intLength(int n, boolean bl) {
        if (!bl) {
            n = n << 1 ^ n >> 31;
        }
        if (n >>> 7 == 0) {
            return 1;
        }
        if (n >>> 14 == 0) {
            return 2;
        }
        if (n >>> 21 == 0) {
            return 3;
        }
        if (n >>> 28 == 0) {
            return 4;
        }
        return 5;
    }

    public static int longLength(long l, boolean bl) {
        if (!bl) {
            l = l << 1 ^ l >> 63;
        }
        if (l >>> 7 == 0L) {
            return 1;
        }
        if (l >>> 14 == 0L) {
            return 2;
        }
        if (l >>> 21 == 0L) {
            return 3;
        }
        if (l >>> 28 == 0L) {
            return 4;
        }
        if (l >>> 35 == 0L) {
            return 5;
        }
        if (l >>> 42 == 0L) {
            return 6;
        }
        if (l >>> 49 == 0L) {
            return 7;
        }
        if (l >>> 56 == 0L) {
            return 8;
        }
        return 9;
    }
}

