/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.jsonbeans.Json;
import com.esotericsoftware.jsonbeans.JsonException;
import com.esotericsoftware.kryo.io.ByteBufferInputStream;
import com.esotericsoftware.kryo.io.ByteBufferOutputStream;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.Serialization;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;

public class JsonSerialization
implements Serialization {
    private final Json json = new Json();
    private final ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream();
    private final ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();
    private final OutputStreamWriter writer = new OutputStreamWriter(this.byteBufferOutputStream);
    private boolean logging = true;
    private boolean prettyPrint = true;
    private byte[] logBuffer = new byte[0];

    public JsonSerialization() {
        this.json.addClassTag("RegisterTCP", FrameworkMessage.RegisterTCP.class);
        this.json.addClassTag("RegisterUDP", FrameworkMessage.RegisterUDP.class);
        this.json.addClassTag("KeepAlive", FrameworkMessage.KeepAlive.class);
        this.json.addClassTag("DiscoverHost", FrameworkMessage.DiscoverHost.class);
        this.json.addClassTag("Ping", FrameworkMessage.Ping.class);
    }

    public void setLogging(boolean bl, boolean bl2) {
        this.logging = bl;
        this.prettyPrint = bl2;
    }

    public void write(Connection connection, ByteBuffer byteBuffer, Object object) {
        this.byteBufferOutputStream.setByteBuffer(byteBuffer);
        int n = byteBuffer.position();
        try {
            this.json.toJson(object, Object.class, this.writer);
            this.writer.flush();
        }
        catch (Exception exception) {
            throw new JsonException("Error writing object: " + object, exception);
        }
    }

    public Object read(Connection connection, ByteBuffer byteBuffer) {
        this.byteBufferInputStream.setByteBuffer(byteBuffer);
        return this.json.fromJson(Object.class, this.byteBufferInputStream);
    }

    public void writeLength(ByteBuffer byteBuffer, int n) {
        byteBuffer.putInt(n);
    }

    public int readLength(ByteBuffer byteBuffer) {
        return byteBuffer.getInt();
    }

    public int getLengthLength() {
        return 4;
    }
}

