/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.jsonbeans;

import com.esotericsoftware.jsonbeans.JsonException;
import com.esotericsoftware.jsonbeans.OrderedMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;

public class JsonReader {
    private static final byte[] _json_actions = JsonReader.init__json_actions_0();
    private static final short[] _json_key_offsets = JsonReader.init__json_key_offsets_0();
    private static final char[] _json_trans_keys = JsonReader.init__json_trans_keys_0();
    private static final byte[] _json_single_lengths = JsonReader.init__json_single_lengths_0();
    private static final byte[] _json_range_lengths = JsonReader.init__json_range_lengths_0();
    private static final short[] _json_index_offsets = JsonReader.init__json_index_offsets_0();
    private static final byte[] _json_trans_targs = JsonReader.init__json_trans_targs_0();
    private static final byte[] _json_trans_actions = JsonReader.init__json_trans_actions_0();
    private static final byte[] _json_eof_actions = JsonReader.init__json_eof_actions_0();
    static final int json_start = 1;
    static final int json_first_final = 69;
    static final int json_error = 0;
    static final int json_en_object = 9;
    static final int json_en_array = 42;
    static final int json_en_main = 1;
    private final ArrayList elements = new ArrayList(8);
    private Object root;
    private Object current;

    public Object parse(String string) {
        char[] cArray = string.toCharArray();
        return this.parse(cArray, 0, cArray.length);
    }

    public Object parse(Reader reader) {
        try {
            int n;
            char[] cArray = new char[1024];
            int n2 = 0;
            while ((n = reader.read(cArray, n2, cArray.length - n2)) != -1) {
                if (n == 0) {
                    char[] cArray2 = new char[cArray.length * 2];
                    System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                    cArray = cArray2;
                    continue;
                }
                n2 += n;
            }
            Object object = this.parse(cArray, 0, n2);
            return object;
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Object parse(InputStream inputStream) {
        try {
            return this.parse(new InputStreamReader(inputStream, "ISO-8859-1"));
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object parse(char[] var1_1, int var2_2, int var3_3) {
        var5_4 = var2_2;
        var7_6 = var6_5 = var3_3;
        var8_7 = 0;
        var9_8 = new int[4];
        var10_9 = 0;
        var11_10 = new ArrayList<String>(8);
        var12_11 = false;
        var13_12 = null;
        var14_13 = false;
        if (var14_13) {
            System.out.println();
        }
        try {
            var4_14 = 1;
            var8_7 = 0;
            var16_15 = 0;
            var20_16 = 0;
            block29: while (true) {
                switch (var20_16) {
                    case 0: {
                        if (var5_4 == var6_5) {
                            var20_16 = 4;
                            continue block29;
                        }
                        if (var4_14 == 0) {
                            var20_16 = 5;
                            continue block29;
                        }
                    }
                    case 1: {
                        var19_25 = JsonReader._json_key_offsets[var4_14];
                        var16_15 = JsonReader._json_index_offsets[var4_14];
                        var15_17 = JsonReader._json_single_lengths[var4_14];
                        if (var15_17 <= 0) ** GOTO lbl45
                        var21_26 = var19_25;
                        var23_40 = var19_25 + var15_17 - 1;
                        while (var23_40 >= var21_26) {
                            var22_35 = var21_26 + (var23_40 - var21_26 >> 1);
                            if (var1_1[var5_4] < JsonReader._json_trans_keys[var22_35]) {
                                var23_40 = var22_35 - 1;
                                continue;
                            }
                            if (var1_1[var5_4] > JsonReader._json_trans_keys[var22_35]) {
                                var21_26 = var22_35 + 1;
                                continue;
                            }
                            var16_15 += var22_35 - var19_25;
                            ** GOTO lbl59
                        }
                        var19_25 += var15_17;
                        var16_15 += var15_17;
lbl45:
                        // 2 sources

                        if ((var15_17 = JsonReader._json_range_lengths[var4_14]) > 0) {
                            var21_26 = var19_25;
                            var23_40 = var19_25 + (var15_17 << 1) - 2;
                            while (var23_40 >= var21_26) {
                                var22_35 = var21_26 + (var23_40 - var21_26 >> 1 & -2);
                                if (var1_1[var5_4] < JsonReader._json_trans_keys[var22_35]) {
                                    var23_40 = var22_35 - 2;
                                    continue;
                                }
                                if (var1_1[var5_4] > JsonReader._json_trans_keys[var22_35 + 1]) {
                                    var21_26 = var22_35 + 2;
                                    continue;
                                }
                                var16_15 += var22_35 - var19_25 >> 1;
                                ** GOTO lbl59
                            }
                            var16_15 += var15_17;
                        }
lbl59:
                        // 5 sources

                        var4_14 = JsonReader._json_trans_targs[var16_15];
                        if (JsonReader._json_trans_actions[var16_15] != 0) {
                            var17_23 = JsonReader._json_trans_actions[var16_15];
                            var18_24 = JsonReader._json_actions[var17_23++];
                            while (var18_24-- > 0) {
                                switch (JsonReader._json_actions[var17_23++]) {
                                    case 0: {
                                        var10_9 = var5_4;
                                        var12_11 = false;
                                        break;
                                    }
                                    case 1: {
                                        var12_11 = true;
                                        break;
                                    }
                                    case 2: {
                                        var21_27 = new String(var1_1, var10_9, var5_4 - var10_9);
                                        var10_9 = var5_4;
                                        if (var12_11) {
                                            var21_27 = this.unescape(var21_27);
                                        }
                                        if (var14_13) {
                                            System.out.println("name: " + var21_27);
                                        }
                                        var11_10.add(var21_27);
                                        break;
                                    }
                                    case 3: {
                                        var21_28 = new String(var1_1, var10_9, var5_4 - var10_9);
                                        var10_9 = var5_4;
                                        if (var12_11) {
                                            var21_28 = this.unescape(var21_28);
                                        }
                                        v0 = var22_36 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var14_13) {
                                            System.out.println("string: " + var22_36 + "=" + var21_28);
                                        }
                                        this.string(var22_36, var21_28);
                                        break;
                                    }
                                    case 4: {
                                        var21_29 = new String(var1_1, var10_9, var5_4 - var10_9);
                                        var10_9 = var5_4;
                                        v1 = var22_37 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var14_13) {
                                            System.out.println("number: " + var22_37 + "=" + Float.parseFloat(var21_29));
                                        }
                                        this.number(var22_37, Float.parseFloat(var21_29));
                                        break;
                                    }
                                    case 5: {
                                        v2 = var21_30 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var14_13) {
                                            System.out.println("boolean: " + var21_30 + "=true");
                                        }
                                        this.bool(var21_30, true);
                                        break;
                                    }
                                    case 6: {
                                        v3 = var21_31 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var14_13) {
                                            System.out.println("boolean: " + var21_31 + "=false");
                                        }
                                        this.bool(var21_31, false);
                                        break;
                                    }
                                    case 7: {
                                        v4 = var21_32 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var14_13) {
                                            System.out.println("null: " + var21_32);
                                        }
                                        this.string(var21_32, null);
                                        break;
                                    }
                                    case 8: {
                                        v5 = var21_33 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var14_13) {
                                            System.out.println("startObject: " + var21_33);
                                        }
                                        this.startObject(var21_33);
                                        if (var8_7 == var9_8.length) {
                                            var22_38 = new int[var9_8.length * 2];
                                            System.arraycopy(var9_8, 0, var22_38, 0, var9_8.length);
                                            var9_8 = var22_38;
                                        }
                                        var9_8[var8_7++] = var4_14;
                                        var4_14 = 9;
                                        var20_16 = 2;
                                        continue block29;
                                    }
                                    case 9: {
                                        if (var14_13) {
                                            System.out.println("endObject");
                                        }
                                        this.pop();
                                        var4_14 = var9_8[--var8_7];
                                        var20_16 = 2;
                                        continue block29;
                                    }
                                    case 10: {
                                        v6 = var21_34 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var14_13) {
                                            System.out.println("startArray: " + var21_34);
                                        }
                                        this.startArray(var21_34);
                                        if (var8_7 == var9_8.length) {
                                            var22_39 = new int[var9_8.length * 2];
                                            System.arraycopy(var9_8, 0, var22_39, 0, var9_8.length);
                                            var9_8 = var22_39;
                                        }
                                        var9_8[var8_7++] = var4_14;
                                        var4_14 = 42;
                                        var20_16 = 2;
                                        continue block29;
                                    }
                                    case 11: {
                                        if (var14_13) {
                                            System.out.println("endArray");
                                        }
                                        this.pop();
                                        var4_14 = var9_8[--var8_7];
                                        var20_16 = 2;
                                        continue block29;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var4_14 == 0) {
                            var20_16 = 5;
                            continue block29;
                        }
                        if (++var5_4 != var6_5) {
                            var20_16 = 1;
                            continue block29;
                        }
                    }
                    case 4: {
                        if (var5_4 != var7_6) break block29;
                        var21_26 = JsonReader._json_eof_actions[var4_14];
                        var22_35 = JsonReader._json_actions[var21_26++];
                        while (var22_35-- > 0) {
                            switch (JsonReader._json_actions[var21_26++]) {
                                case 3: {
                                    var23_42 = new String(var1_1, var10_9, var5_4 - var10_9);
                                    var10_9 = var5_4;
                                    if (var12_11) {
                                        var23_42 = this.unescape(var23_42);
                                    }
                                    v7 = var24_47 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                    if (var14_13) {
                                        System.out.println("string: " + var24_47 + "=" + var23_42);
                                    }
                                    this.string(var24_47, var23_42);
                                    break;
                                }
                                case 4: {
                                    var23_43 = new String(var1_1, var10_9, var5_4 - var10_9);
                                    var10_9 = var5_4;
                                    v8 = var24_47 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                    if (var14_13) {
                                        System.out.println("number: " + var24_47 + "=" + Float.parseFloat(var23_43));
                                    }
                                    this.number(var24_47, Float.parseFloat(var23_43));
                                    break;
                                }
                                case 5: {
                                    v9 = var23_44 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                    if (var14_13) {
                                        System.out.println("boolean: " + var23_44 + "=true");
                                    }
                                    this.bool(var23_44, true);
                                    break;
                                }
                                case 6: {
                                    v10 = var23_45 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                    if (var14_13) {
                                        System.out.println("boolean: " + var23_45 + "=false");
                                    }
                                    this.bool(var23_45, false);
                                    break;
                                }
                                case 7: {
                                    v11 = var23_46 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                    if (var14_13) {
                                        System.out.println("null: " + var23_46);
                                    }
                                    this.string(var23_46, null);
                                }
                            }
                        }
                        break block29;
                    }
                }
                break;
            }
        }
        catch (RuntimeException var15_18) {
            var13_12 = var15_18;
        }
        if (var5_4 < var6_5) {
            var15_20 = 1;
            for (var16_15 = 0; var16_15 < var5_4; ++var16_15) {
                if (var1_1[var16_15] != '\n') continue;
                ++var15_20;
            }
            throw new JsonException("Error parsing JSON on line " + var15_20 + " near: " + new String(var1_1, var5_4, var6_5 - var5_4), var13_12);
        }
        if (this.elements.size() != 0) {
            var15_21 = this.elements.get(0);
            this.elements.clear();
            if (var15_21 instanceof OrderedMap) {
                throw new JsonException("Error parsing JSON, unmatched brace.");
            }
            throw new JsonException("Error parsing JSON, unmatched bracket.");
        }
        var15_22 = this.root;
        this.root = null;
        return var15_22;
    }

    private static byte[] init__json_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 2, 0, 2, 2, 0, 3, 2, 3, 9, 2, 3, 11, 2, 4, 9, 2, 4, 11, 2, 5, 9, 2, 5, 11, 2, 6, 9, 2, 6, 11, 2, 7, 9, 2, 7, 11};
    }

    private static short[] init__json_key_offsets_0() {
        return new short[]{0, 0, 18, 20, 22, 31, 33, 35, 39, 41, 53, 55, 57, 61, 79, 81, 83, 88, 99, 106, 115, 122, 124, 134, 136, 145, 149, 151, 158, 166, 174, 182, 190, 195, 203, 211, 219, 224, 232, 240, 248, 253, 262, 282, 284, 286, 291, 310, 317, 319, 329, 331, 340, 344, 346, 353, 361, 369, 377, 385, 390, 398, 406, 414, 419, 427, 435, 443, 448, 457, 460, 467, 475, 482, 487, 495, 503, 511, 519, 522, 530, 538, 546, 549, 557, 565, 573, 576, 576};
    }

    private static char[] init__json_trans_keys_0() {
        return new char[]{' ', '\"', '$', '-', '[', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', '0', '9', '0', '9', '+', '-', '0', '9', '0', '9', ' ', '\"', '$', ',', '_', '}', '\t', '\r', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ':', '\t', '\r', ' ', '\"', '$', '-', '[', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ',', '}', '\t', '\r', ' ', '\"', '$', '_', '}', '\t', '\r', 'A', 'Z', 'a', 'z', ' ', ',', ':', ']', '}', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', ',', ':', ']', '}', '\t', '\r', '0', '9', ' ', ',', '.', 'E', 'e', '}', '\t', '\r', '0', '9', '0', '9', ' ', ',', 'E', 'e', '}', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ',', '}', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', '}', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', '}', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', '\"', '$', ',', '-', '[', ']', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ',', ']', '\t', '\r', ' ', '\"', '$', '-', '[', ']', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', ' ', ',', ':', ']', '}', '\t', '\r', '0', '9', ' ', ',', '.', 'E', ']', 'e', '\t', '\r', '0', '9', '0', '9', ' ', ',', 'E', ']', 'e', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ',', ']', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ']', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ']', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ']', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', '.', 'E', 'e', '\t', '\r', '0', '9', ' ', 'E', 'e', '\t', '\r', '0', '9', ' ', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', '\t', '\r', '\u0000'};
    }

    private static byte[] init__json_single_lengths_0() {
        return new byte[]{0, 10, 2, 2, 7, 0, 0, 2, 0, 6, 2, 2, 2, 10, 2, 2, 3, 5, 5, 7, 5, 0, 6, 0, 5, 2, 0, 3, 6, 6, 6, 6, 3, 6, 6, 6, 3, 6, 6, 6, 3, 7, 12, 2, 2, 3, 11, 5, 0, 6, 0, 5, 2, 0, 3, 6, 6, 6, 6, 3, 6, 6, 6, 3, 6, 6, 6, 3, 7, 1, 5, 4, 3, 1, 6, 6, 6, 6, 1, 6, 6, 6, 1, 6, 6, 6, 1, 0, 0};
    }

    private static byte[] init__json_range_lengths_0() {
        return new byte[]{0, 4, 0, 0, 1, 1, 1, 1, 1, 3, 0, 0, 1, 4, 0, 0, 1, 3, 1, 1, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 0, 0, 1, 4, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0};
    }

    private static short[] init__json_index_offsets_0() {
        return new short[]{0, 0, 15, 18, 21, 30, 32, 34, 38, 40, 50, 53, 56, 60, 75, 78, 81, 86, 95, 102, 111, 118, 120, 129, 131, 139, 143, 145, 151, 159, 167, 175, 183, 188, 196, 204, 212, 217, 225, 233, 241, 246, 255, 272, 275, 278, 283, 299, 306, 308, 317, 319, 327, 331, 333, 339, 347, 355, 363, 371, 376, 384, 392, 400, 405, 413, 421, 429, 434, 443, 446, 453, 460, 466, 470, 478, 486, 494, 502, 505, 513, 521, 529, 532, 540, 548, 556, 559, 560};
    }

    private static byte[] init__json_trans_targs_0() {
        return new byte[]{1, 2, 70, 5, 69, 70, 74, 79, 83, 69, 1, 71, 70, 70, 0, 69, 4, 3, 69, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 71, 0, 72, 0, 8, 8, 73, 0, 73, 0, 9, 10, 18, 17, 18, 87, 9, 18, 18, 0, 12, 41, 11, 12, 41, 11, 12, 13, 12, 0, 13, 14, 20, 21, 16, 20, 28, 33, 37, 16, 13, 22, 20, 20, 0, 16, 19, 15, 16, 19, 15, 16, 17, 87, 16, 0, 17, 10, 18, 18, 87, 17, 18, 18, 0, 12, 0, 13, 0, 0, 12, 18, 15, 15, 15, 15, 15, 15, 15, 15, 0, 16, 17, 0, 0, 87, 16, 20, 22, 0, 16, 17, 23, 25, 25, 87, 16, 22, 0, 24, 0, 16, 17, 25, 25, 87, 16, 24, 0, 26, 26, 27, 0, 27, 0, 16, 17, 87, 16, 27, 0, 16, 17, 0, 0, 29, 87, 16, 20, 16, 17, 0, 0, 30, 87, 16, 20, 16, 17, 0, 0, 31, 87, 16, 20, 16, 17, 0, 0, 32, 87, 16, 20, 16, 17, 87, 16, 0, 16, 17, 0, 0, 34, 87, 16, 20, 16, 17, 0, 0, 35, 87, 16, 20, 16, 17, 0, 0, 36, 87, 16, 20, 16, 17, 87, 16, 0, 16, 17, 0, 0, 38, 87, 16, 20, 16, 17, 0, 0, 39, 87, 16, 20, 16, 17, 0, 0, 40, 87, 16, 20, 16, 17, 87, 16, 0, 11, 11, 11, 11, 11, 11, 11, 11, 0, 42, 43, 47, 46, 48, 45, 88, 47, 55, 60, 64, 45, 42, 49, 47, 47, 0, 45, 68, 44, 45, 68, 44, 45, 46, 88, 45, 0, 46, 43, 47, 48, 45, 88, 47, 55, 60, 64, 45, 46, 49, 47, 47, 0, 45, 46, 0, 88, 0, 45, 47, 49, 0, 45, 46, 50, 52, 88, 52, 45, 49, 0, 51, 0, 45, 46, 52, 88, 52, 45, 51, 0, 53, 53, 54, 0, 54, 0, 45, 46, 88, 45, 54, 0, 45, 46, 0, 88, 56, 0, 45, 47, 45, 46, 0, 88, 57, 0, 45, 47, 45, 46, 0, 88, 58, 0, 45, 47, 45, 46, 0, 88, 59, 0, 45, 47, 45, 46, 88, 45, 0, 45, 46, 0, 88, 61, 0, 45, 47, 45, 46, 0, 88, 62, 0, 45, 47, 45, 46, 0, 88, 63, 0, 45, 47, 45, 46, 88, 45, 0, 45, 46, 0, 88, 65, 0, 45, 47, 45, 46, 0, 88, 66, 0, 45, 47, 45, 46, 0, 88, 67, 0, 45, 47, 45, 46, 88, 45, 0, 44, 44, 44, 44, 44, 44, 44, 44, 0, 69, 69, 0, 69, 0, 0, 0, 0, 69, 70, 69, 6, 7, 7, 69, 71, 0, 69, 7, 7, 69, 72, 0, 69, 69, 73, 0, 69, 0, 0, 0, 75, 0, 69, 70, 69, 0, 0, 0, 76, 0, 69, 70, 69, 0, 0, 0, 77, 0, 69, 70, 69, 0, 0, 0, 78, 0, 69, 70, 69, 69, 0, 69, 0, 0, 0, 80, 0, 69, 70, 69, 0, 0, 0, 81, 0, 69, 70, 69, 0, 0, 0, 82, 0, 69, 70, 69, 69, 0, 69, 0, 0, 0, 84, 0, 69, 70, 69, 0, 0, 0, 85, 0, 69, 70, 69, 0, 0, 0, 86, 0, 69, 70, 69, 69, 0, 0, 0, 0};
    }

    private static byte[] init__json_trans_actions_0() {
        return new byte[]{0, 0, 1, 1, 21, 1, 1, 1, 1, 17, 0, 1, 1, 1, 0, 28, 1, 1, 7, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 19, 0, 1, 1, 0, 25, 1, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 21, 1, 1, 1, 1, 17, 0, 1, 1, 1, 0, 28, 1, 1, 7, 0, 0, 0, 0, 19, 0, 0, 0, 0, 1, 1, 19, 0, 1, 1, 0, 5, 0, 5, 0, 0, 5, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 7, 7, 0, 0, 31, 7, 0, 0, 0, 9, 9, 0, 0, 0, 37, 9, 0, 0, 0, 0, 9, 9, 0, 0, 37, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 37, 9, 0, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 13, 13, 49, 13, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 15, 15, 55, 15, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 11, 11, 43, 11, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 1, 0, 1, 21, 23, 1, 1, 1, 1, 17, 0, 1, 1, 1, 0, 28, 1, 1, 7, 0, 0, 0, 0, 23, 0, 0, 0, 0, 1, 1, 21, 23, 1, 1, 1, 1, 17, 0, 1, 1, 1, 0, 7, 7, 0, 34, 0, 7, 0, 0, 0, 9, 9, 0, 0, 40, 0, 9, 0, 0, 0, 0, 9, 9, 0, 40, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 40, 9, 0, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 13, 13, 52, 13, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 15, 15, 58, 15, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 11, 11, 46, 11, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 7, 0, 0, 0, 0, 7, 0, 9, 0, 0, 0, 9, 0, 0, 9, 0, 0, 9, 0, 0, 9, 9, 0, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 13, 13, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 15, 15, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 11, 11, 0, 0, 0, 0};
    }

    private static byte[] init__json_eof_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 9, 9, 9, 7, 7, 7, 7, 13, 7, 7, 7, 15, 7, 7, 7, 11, 0, 0};
    }

    private void set(String string, Object object) {
        if (this.current instanceof OrderedMap) {
            ((OrderedMap)this.current).put(string, object);
        } else if (this.current instanceof ArrayList) {
            ((ArrayList)this.current).add(object);
        } else {
            this.root = object;
        }
    }

    protected void startObject(String string) {
        OrderedMap orderedMap = new OrderedMap();
        if (this.current != null) {
            this.set(string, orderedMap);
        }
        this.elements.add(orderedMap);
        this.current = orderedMap;
    }

    protected void startArray(String string) {
        ArrayList arrayList = new ArrayList();
        if (this.current != null) {
            this.set(string, arrayList);
        }
        this.elements.add(arrayList);
        this.current = arrayList;
    }

    protected void pop() {
        this.root = this.elements.remove(this.elements.size() - 1);
        this.current = this.elements.size() > 0 ? this.elements.get(0) : null;
    }

    protected void string(String string, String string2) {
        this.set(string, string2);
    }

    protected void number(String string, float f) {
        this.set(string, Float.valueOf(f));
    }

    protected void bool(String string, boolean bl) {
        this.set(string, bl);
    }

    private String unescape(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 16);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) != '\\') {
                stringBuilder.append(c);
                continue;
            }
            if (n2 == n) break;
            if ((c = string.charAt(n2++)) == 'u') {
                stringBuilder.append(Character.toChars(Integer.parseInt(string.substring(n2, n2 + 4), 16)));
                n2 += 4;
                continue;
            }
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    break;
                }
                case 'b': {
                    c = '\b';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                default: {
                    throw new JsonException("Illegal escaped character: \\" + c);
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

