//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : Trip Planner
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  University of California, Irvine
//                  Irvine, CA 92617-3435
//                  e-mail: pattis@ics.uci.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   Trip Planner hardwires the constants for the user's car (because the
// informaition does not change often). It prompts for today's cost of gas
// (gas cost can change daily) and the distance of the planned trip. Then, it
// calculates and displays the one-way trip gas cost, the number of stops
// needed, assuming the gas tank starts full), and the amount of fuel remaining
// on arrival. This is a straight-line (or linear) program, which follows the
// input/calculate/output form: it prompts for input, calculates useful
// information from these values, and finally outputs its results.
//
// Known Bugs     : None
//
// Future Plans   : None
//
// Program History:
//    5/22/01: R. Pattis - Operational
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


import edu.uci.ics.pattis.introlib.Prompt;


public class TripPlanner {


	public static void main(String[] args) {
	  
	  //Declare Variables
	    
		double mileage   = 30.0;	 					 	// Miles/Gallons
		double tankSize  = 12.0;							// Gallons

		double gasPrice;											// Dollars/Gallon (input)
		double distance;											// Miles          (input)

		double tanksUsed;											// Fractions OK   (temporary)
		int    gasStops;
		  
		double tripCost;											// Dollars        (output)
		  
		  
		//Input
		  
		System.out.println("Expense calculator for car trip\n\n");
		gasPrice = Prompt.forDouble("Enter gas price (in $/gallons)");
		distance = Prompt.forDouble("Enter trip distance (in miles)");
		  
		  
		//Calculate
		  
		tanksUsed = distance/(mileage*tankSize);
		gasStops  = (int)tanksUsed;													//Truncate to int  
		tripCost  = tanksUsed * tankSize * gasPrice;
		  
		  
		//Output
		  
		System.out.println();
		System.out.println("Car Data");
    System.out.println("  Mileage                     " + mileage + " miles/gallon");
    System.out.println("  Tank Size                   " + tankSize + " gallons");
    System.out.println("Total trip gas cost        = $" + tripCost);
    System.out.println("# of stops for gas         =  " + gasStops);
    System.out.println("Gas in tank at destination =  " +
                          (tankSize * (1.-(tanksUsed-gasStops))) + " gallons");
	}
}
