//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : File I/O
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  University of California, Irvine
//                  Irvine, CA 92617-3435
//                  e-mail: pattis@ics.uci.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   This program illustrates various important error detection and
// recover methods defined in the TypedBufferReader class. It attempts to
// read a sequence of lines ofthe form: name score score score printit
// If any errors are detected (via NumberFormatExceptions) the problem
// is reported and that line in the file is skipped. The program attempts
// to process further lines in the file.//
//   
//
// Known Bugs     : None
//
// Future Plans   : None
//
// Program History:
//    5/22/01: R. Pattis - Operational
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


import edu.uci.ics.pattis.introlib.TypedBufferReader;
import java.io.EOFException;


public class Application {

	public static void main(String[] args) {
	  try {
	  
		  TypedBufferReader inputFile = new TypedBufferReader("Enter name of file ");
		  int count = 0;
		  for (;;)
		    try {
		      String  name    = inputFile.readString();
		      int     s1      = inputFile.readInt();
		      int     s2      = inputFile.readInt();
		      int     s3      = inputFile.readInt();
		      boolean printIt = inputFile.readBoolean();
		      count++;
		      if (printIt)
		        System.out.println(name + " has average " + (s1+s2+s3)/3); 
		    } 
		    catch (EOFException eofe) {break;}
		    catch (NumberFormatException noe) {
          System.out.println("  Error reading file " + inputFile.getFileName() +
                              " on line " + inputFile.getLineNumber() +
                              "; problem token: " + inputFile.getLastTokenUntyped());
		      inputFile.ignoreRestOfLine();
		      System.out.println("  Ignoring this line");
		    }

		    inputFile.close();
		    System.out.println(count + " values processed");
		    
				  
				}catch (Exception e) {
		      e.printStackTrace();
		      System.out.println("main method in Application class terminating");
		      System.exit(0);  
		    }
		    
  }

}
