//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : Ordinal Date
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  University of California, Irvine
//                  Irvine, CA 92617-3435
//                  e-mail: pattis@ics.uci.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   This program illustrates how to use static methods written from a library.
// It repeatedly prompts the user for a year, month, and day, and computes and
// then displays what day of the year that is: January 1 is the first day,
// January 2 is the second day, etc. and a few other pieces of information about
// the date.
//
// Known Bugs     : None
//
// Future Plans   : None
//
// Program History:
//    6/03/01: R. Pattis - Operational for 15-100
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


import edu.uci.ics.pattis.introlib.Prompt;
import dates.DateUtility;



public class Application {

	public static void main(String[] args)
	{
	  
    for (;;) {
	    //Input (notice restrictions on input values)
		  int year  = Prompt.forInt("Enter year",  0, 5000);
		  int month = Prompt.forInt("Enter month", 1, 12);
		  int day   = Prompt.forInt("Enter Day",   1, DateUtility.daysIn(month, year));
		  
		  //Calculate
		  int ordinal = DateUtility.ordinalDate(month, day, year);
		  
		  //Output
		  System.out.println (DateUtility.americanFormat(month,day,year) +
		                      " is the " + ordinal + " day of " + year);
		  
		  System.out.println((DateUtility.ordinalDate(DateUtility.DECEMBER,31,year) - ordinal + 1) + 
		                     " days left until Jan 1st, " + (year+1));		  
		  
		  System.out.println("Note: " + year + " is " +
		                     (DateUtility.isLeapYear(year) ? "" : "not ") + "a leap year\n\n");
	  }
		  

	}


}
