//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : Ordinal Date
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  University of California, Irvine
//                  Irvine, CA 92617-3435
//                  e-mail: pattis@ics.uci.edu
/
// Maintainer     : Author
//
//
// Description:
//
//   This program illustrates how to write/use static methods written
// in the Application class. It repeatedly prompts the user for a year,
// month, and day, and computes and then displays what day of the year
// that is: January 1 is the first day, January 2 is the second day, etc.
// and a few other pieces of information about the date
//
// Known Bugs     : None
//
// Future Plans   : None
//
// Program History:
//    9/20/01: R. Pattis - Operational for 15-100
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


import edu.uci.ics.pattis.introlib.Prompt;



public class Application {


  //Here are five static methods, all put in the Application class, and all
  //  called from the main method (although some methods call others, such as
  //  daysIn calling isLeapYear)
  //
  //Running this program under control of the debugger, tracing the method
  //  calls, is especially insightful



  //Returns whether year is a leap year?
	public static boolean isLeapYear (int year)
	{return (year%4 == 0 && year%100 != 0) || year%400 == 0;}



  //Returns the number of days in month (in year)
	public static int daysIn (int month, int year) throws IllegalArgumentException
	{
	  if (year < 1)
	    throw new IllegalArgumentException("daysIn: year ("+year+") not positive");
	  if (month < JANUARY || month > DECEMBER)
	    throw new IllegalArgumentException("daysIn: month ("+month+") not in range [1,12]");
	  
	  //Thirty days hath September, April, June and November...
	  if (month == APRIL     ||
	      month == JUNE      ||
	      month == SEPTEMBER ||
	      month == NOVEMBER)
	    return 30;
	    
	  //...all the rest have thirty one...
	  else if (month == JANUARY || 
				     month == MARCH   ||
				     month == MAY     ||
				     month == JULY    ||
				     month == AUGUST  ||
				     month == OCTOBER ||
				     month == DECEMBER)
	    return 31;
	   
	  //...except Febuary (must be FEBRUARY: see possible exception)
	  else 
	    return 28 + (isLeapYear(year) ? 1 : 0);
	}
	


  //Returns the ordinal (1st, 2nd, 3rd, etc) representing month, day, year
	public static int ordinalDate (int month, int day, int year)
	{
	  int ordinal = 0;
	  
	  //Scan every earlier month, summing the # of days in that month...
	  for (int m=JANUARY;  m < month;  m++)
	    ordinal += daysIn(m, year);
	  
	  //...and add day in the current month
	  return ordinal + day;
	}



  public static String americanFormat (int month, int day, int year)
  {return month + "/" + day + "/" + year;}
  
  
  
  public static String europeanFormat (int month, int day, int year)
  {return day + "/" + month + "/" + year;}



  ///////////////////////////////////////////////////////
  //
  //Main Method: Execution of the Application starts here
  //
  ///////////////////////////////////////////////////////
  
  
	public static void main(String[] args)
	{
    for (;;) {
	    //Input (notice restrictions on input values)
		  int year  = Prompt.forInt("Enter year",  0, 5000);
		  int month = Prompt.forInt("Enter month", 1, 12);
		  int day   = Prompt.forInt("Enter Day",   1, daysIn(month, year));
		  
		  //Calculate
		  int ordinal = ordinalDate(month, day, year);
		  
		  //Output
		  System.out.println (americanFormat(month,day,year) +
		                      " is the " + ordinal + " day of " + year);
		  
		  System.out.println((ordinalDate(DECEMBER,31,year) - ordinal + 1) + 
		                     " days left until Jan 1st, " + (year+1));		  
		  
		  System.out.println("Note: " + year + " is " +
		                     (isLeapYear(year) ? "" : "not ") + "a leap year\n\n");
	  }
		  
	}




  //Fields: all public static final (constants used by methods)
  //These could be private in this code, but see Date Calculator #2
  //  where they must be public, so other classes can use them.
  
  public static final int JANUARY   =  1;  
  public static final int FEBRUARY  =  2;  
  public static final int MARCH     =  3;  
  public static final int APRIL     =  4;  
  public static final int MAY       =  5;  
  public static final int JUNE      =  6;  
  public static final int JULY      =  7;  
  public static final int AUGUST    =  8;  
  public static final int SEPTEMBER =  9;  
  public static final int OCTOBER   = 10;  
  public static final int NOVEMBER  = 11;  
  public static final int DECEMBER  = 12;  

}
