//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
// Program        : Class Examples
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  University of California, Irvine
//                  Irvine, CA 92617-3435
//                  e-mail: pattis@ics.uci.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   This program illustrates the use of a variety of simple classes in Java
// (some in the Java library, some I've written). In each case, one (or more)
// object is constructed, and each is referenced by a variable. Then, some
// methods from the class are called on the object via the variable name(s)
// -which is an implicit argument to the method call. Each method called uses
// the object to perform some useful action. Objects illustrate in this program
// include
//
// 1. DiceEnsemble     : for playing dice games
// 2. StringTokenizer  : for processing tokens in a string
// 3. Timer            : for timing the response of a user or CPU time running a program
// 4. TypedBufferReader: for reading files
// 5. DecimalFormat    : for formating decimal values (int or double)
// 6. BigInteger       : for infinite precision integers
// 7. Integer          : a wrapper class for storing int values
// 8. String           : general purpose
//
// This "construct then use pattern" is applicable to object in most situations.
//
// Known Bugs     : None
//
// Future Plans   : None
//
// Program History:
//   5/16/01: R. Pattis - Operational in Java
//   8/29/04: R. Pattis - Update for use in 15-200
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


//Imports for my classes (which must be added to the project)

import edu.uci.ics.pattis.introlib.Prompt;
import edu.uci.ics.pattis.introlib.DiceEnsemble;
import edu.uci.ics.pattis.introlib.Timer;
import edu.uci.ics.pattis.introlib.TypedBufferReader;


//Imports for Java classes (which are automatically in the project)

import java.util.StringTokenizer;
import java.io.EOFException;
import java.math.BigInteger;
import java.lang.Integer;
import java.text.DecimalFormat;



public class Application {

	public static void main(String[] args)
	{
    //Example of DiceEnsemble class (class from my library: see import above)
    //Throw dice individually; then specify the number to throw
    DiceEnsemble dice = new DiceEnsemble(2,6);
    for (;;) {
      if (!Prompt.forBoolean("\nThrow dice(again)?"))
        break;
      dice.roll();
      System.out.println("On throw # " + dice.getRollCount());
      System.out.println("Pip sum  = " + dice.getPipSum());
    }
    
    int toRoll = Prompt.forInt("\nEnter # of times to roll");
    System.out.print("Pip sums = ");
    for (;;) {
      if (toRoll == 0)
         break;
      dice.roll();
      System.out.print(dice.getPipSum()+" ");
      toRoll--;
    }
    System.out.println();
    
    
    
    //Example of StringTokenizer (class from Java library: see import above)
    //Note that the nextToken method is a mutator: it not only returns the
    //  next token in the String, it REMOVES that token from the StringTokenizer
    //  too, so subsequent calls to nextToken return different tokens!
    //Prompt the user for a String and then returns all the tokens it contains.
    String          s  = Prompt.forString("\nEnter string to tokenize");
    StringTokenizer st = new StringTokenizer(s);
    for (;;) {
      System.out.println("  " + st.countTokens() + " tokens remaining");
      if (!st.hasMoreTokens())  // or (st.countTokens() == 0)
        break;
      System.out.println("    --> next token = " + st.nextToken());
    }
    
    
    
    //Example of Timer class (class from my library: see import above)
    //Asks the user to press return twice, estimating 5 seconds between presses.
    Timer t = new Timer();
    System.out.println("\nYou will be asked to guess when 5 seconds has elapsed");
    Prompt.forString("Press return when ready to start...");
    t.start();
    Prompt.forString("...now press return when you think 5 seconds have elapsed");
    t.stop();
    System.out.println("Actual lapsed time = " + t.getElapsed() + " seconds");
    if (t.getElapsed() == 5.)
      System.out.println("Perfect"); 
    else
      System.out.println("Accurate to " + (100-100*Math.abs(t.getElapsed()-5.)/5.) + "%");
    
    
    
    //Example of TypedBufferReader (class from Java library: see import above)
    //Reads all the integers in a file, echoing them to the terminal (or terminates
    //  if a non-int value is read)
    TypedBufferReader inputFile = new TypedBufferReader("\nEnter name of file (its ints will be summed)");
    System.out.print("Read: ");
    int sum = 0;
    for (;;)
      try {
        int value = inputFile.readInt();
        System.out.print(value+" ");
        sum += value;
      }
      catch (EOFException eofe) {break;}
      catch (NumberFormatException nfe)
        {
          System.out.println("Stopped because could not parse: "+inputFile.getLastTokenUntyped());
          break;
        }
    inputFile.close();
    System.out.println("\nSum of ("+inputFile.getFileName()+")= " + sum);
  
  
  
	  //Example of DecimalFormat (class from Java library: see import above)
    //The initial value to the constructor can be changed by applyPattern
    //See the JavaDoc web page for using this very general mechanism
    //  (# is digit, don't print if 0; 0 is digit, print if 0)
    for (;;) {
      if (!Prompt.forBoolean("\nPrint DecimalFormat(again)?"))
        break;
	    DecimalFormat df = new DecimalFormat("0.###");
	    double test = Prompt.forDouble("  Enter double to print formated");
      System.out.println("  Pattern(" + df.toPattern() + ") = " + df.format(test));	    
      df.applyPattern("0.#####E0");
      System.out.println("  Pattern(" + df.toPattern() + ") = " + df.format(test));	    
      df.applyPattern("###,###.#");
      System.out.println("  Pattern(" + df.toPattern() + ") = " + df.format(test));	    
      df.applyPattern(Prompt.forString("  Enter a pattern to apply"));
      System.out.println("  Pattern(" + df.toPattern() + ") = " + df.format(test));	    
    }
    


    //Example of BigInteger (class from Java library: see import above)
    //Computes big factorials (enter a number like 100).
    //Prompt for two BigIntegers and then prints their product.
    BigInteger factorial = BigInteger.ONE;
    int f = Prompt.forInt("\nEnter value to compute factorial of");
    for (int i=2; i<=f; i++)
      factorial = factorial.multiply( new BigInteger(""+i) );
    System.out.println(f+"! = " + factorial);
     
	  System.out.println("\nNumbers of any size (much bigger than int) can be entered");
	  BigInteger a = Prompt.forBigInteger("Enter multiplicand #1");
	  BigInteger b = Prompt.forBigInteger("Enter multiplicand #2");
	  System.out.println(a + " x " + b + " = " + a.multiply(b));
	  

	  
    //Example of Integer (wrapper class from Java library: see import above)
    //Computes a product of two ints in a very convoluted way.
	  System.out.println("\nThe Integer wrapper class (note some static members)");
	  System.out.println("minimum int = " + Integer.MIN_VALUE);
	  System.out.println("maximum int = " + Integer.MAX_VALUE);
	  Integer m = new Integer(Prompt.forInt("Enter multiplicand #1"));
	  Integer n = new Integer(Prompt.forString("Enter multiplicand #2"));
	  
	  System.out.println(m + " x " + n + " = " + m.intValue()*n.intValue());
	  //Note that parseInt is a static method in the Integer wrapper class
	  //Also note that there are no mutators among the methods in this class
	  

	  
    //Example of String (class from Java libraray: see import above)
    //Call some simple String methods
	  String s1 = Prompt.forString("\nEnter string 1");
	  String s2 = Prompt.forString("Enter string 2");
	  System.out.println("s1.length()                = " + s1.length());
	  System.out.println("s2.length()                = " + s2.length());
	  System.out.println("s1.compareTo(s2)           = " + s1.compareTo(s2));
	  System.out.println("s1.compareToIgnoreCase(s2) = " + s1.compareToIgnoreCase(s2));
	  System.out.println("s1.toUpperCase()           = " + s1.toUpperCase());
	  System.out.println("s2.toLowerCase()           = " + s2.toLowerCase());
	  System.out.println("s2.startsWith(s1)          = " + s2.startsWith(s1));
		  
		  
	}


}
