import edu.uci.ics.pattis.introlib.Prompt;
import edu.uci.ics.pattis.introlib.Decision;


public class SequenceDriver {


  //Present menu and get user's choice

  private static char menuPrompt () {
    System.out.println("\n\nAccessors            Mutator         General");
    System.out.println("  g - get              m - makeEmpty   a = autotest");
    System.out.println("  s - getSize          p - putAt       q = quit");
    System.out.println("  e - isEmpty          i - insert");
    System.out.println("  ? - findIndex        I - insertAt");
    System.out.println("  c - countTrue        r - removeAt");
    System.out.println("  f - filterTrue       R - remove");
    System.out.println("  t - toString         ! - reverse");
    System.out.println("  T - toStringAllIndex");

    return Prompt.forChar("\nEnter Command","gse?cftTmpiIrR!aq");
  }



  ////////////////
  //Driver Program
  ////////////////

  public static void main(String[] args){
    //Construct object to test
    Sequence s = new Sequence(Prompt.forInt("Enter intial length of sequence array",1));

    //Test Sequence object using any method
    //Sequence tested with Strings, because it is easy
    for (;;) try {
      char selection = menuPrompt();

      if (selection == 'g') {
        int i = Prompt.forInt("  Enter index to get");
        System.out.println("  get("+i+") = " + s.get(i));
      }

      else if (selection == 's')
        System.out.println("  size = " + s.getSize());

      else if (selection == 'e')
        System.out.println("  isEmpty = " + s.isEmpty());

      else if (selection == '?') {
        String o = Prompt.forString("  Enter String to find");
        System.out.println("  findIndex = " + s.findIndex(o));
      }

      else if (selection == 'c') {
        Decision d = new ComesAfter(Prompt.forString("  Enter String to be smaller"));
        System.out.println("  countTrue with this decision = " + s.countTrue(d));
        d = new LengthLess(Prompt.forInt("  Enter length to be less than"));
        System.out.println("  countTrue with this decision = " + s.countTrue(d));
      }

      else if (selection == 'f') {
        Decision d = new ComesAfter(Prompt.forString("  Enter String to be smaller"));
        System.out.println("  Sequence filtered with this decision = " + s.filterTrue(d));
        d = new LengthLess(Prompt.forInt("  Enter length to be less than"));
        System.out.println("  Sequence filtered this decision = " + s.filterTrue(d));
      }

      else if (selection == 't')
        System.out.println("  toString = " + s.toString());

      else if (selection == 'T')
        System.out.println("  toStringAllIndex = " + s.toStringAllIndex());

      else if (selection == 'm')
        s.makeEmpty();

      else if (selection == 'p') {
        String o = Prompt.forString("  Enter String to put  ");
        int    i = Prompt.forInt   ("  Enter index to put at");
        System.out.println("  s.putAt = " + s.putAt(o,i));
      }

      else if (selection == 'i') {
        String o = Prompt.forString("  Enter String to insert");
        s.insert(o);
      }

      else if (selection == 'I') {
        String o = Prompt.forString("  Enter String to insert  ");
        int    i = Prompt.forInt   ("  Enter index to insert at");
        s.insertAt(o,i);
      }

      else if (selection == 'r') {
        int    i = Prompt.forInt("  Enter index to remove at");
        System.out.println("  removeAt = " + s.removeAt(i));
      }

      else if (selection == 'R') {
        String o = Prompt.forString("  Enter String to remove");
        s.remove(o);
      }

      else if (selection == '!')
        s.reverse();

      else if (selection == 'a')
        doAutotest(); //see method below

      else if (selection == 'q')
        break;

      else
        System.out.println("\""+selection+"\" is unknown command");

    } catch (Exception e) {
      System.out.println("Exception Caught/Handled: " + e.getMessage());
      e.printStackTrace();
    }
  }
  
  
  private static void loadStandard(Sequence s, String toLoad) {
    for (int i=0; i<toLoad.length(); i++)
      s.insert(toLoad.charAt(i)+"");
  }
  
  private static void doAutotest() {
    System.out.println("\n\nAutotest of Sequence");
    Sequence s = new Sequence();
    
    //Testing getSize and isEmpty on newly constructed
    System.out.println("\n Test getSize and isEmpty on newly constructed object");
    System.out.println("  s.getSize() = " + s.getSize() + " --> 0");
    System.out.println("  s.isEmpty() = " + s.isEmpty() + " --> true");
    
    //testing insert
    loadStandard(s,"abcde");  //See this method which tests insert
    System.out.println("\n Test insert");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=5,length=8,[0]=a,[1]=b,[2]=c,[3]=d,[4]=e]");

    //testing getSize, isEmpty, get, and findIndex
    System.out.println("\n Test getSize, isEmpty");
    System.out.println("  s.getSize() = " + s.getSize() + " --> 5");
    System.out.println("  s.isEmpty() = " + s.isEmpty() + " --> false");

    System.out.println("\n Test get");
    System.out.println("  s.get(0) = " + s.get(0) + " --> a");
    System.out.println("  s.get(1) = " + s.get(1) + " --> b");
    System.out.println("  s.get(2) = " + s.get(2) + " --> c");
    System.out.println("  s.get(3) = " + s.get(3) + " --> d");
    System.out.println("  s.get(4) = " + s.get(4) + " --> e");
    try {
      System.out.println("  testing s.get(-1)");
      System.out.println("    = " + s.get(-1));
      System.out.println("    Exception should have been thrown!");
    } catch (Exception e) {System.out.println("    Exception correctly thrown");
     }
    try {
      System.out.println("  testing s.get(5)");
      System.out.println("    = " + s.get(5));
      System.out.println("    Exception not thrown!");
    } catch (Exception e) {System.out.println("    Exception correctly thrown");
     }
    
    System.out.println("\n Test findIndex");
    System.out.println("  s.findIndex(\"a\") = " + s.findIndex("a") + " --> 0");
    System.out.println("  s.findIndex(\"b\") = " + s.findIndex("b") + " --> 1");
    System.out.println("  s.findIndex(\"c\") = " + s.findIndex("c") + " --> 2");
    System.out.println("  s.findIndex(\"d\") = " + s.findIndex("d") + " --> 3");
    System.out.println("  s.findIndex(\"e\") = " + s.findIndex("e") + " --> 4");
    System.out.println("  s.findIndex(\"x\") = " + s.findIndex("x") + " --> -1");
 
    //testing countTrue and filterTrue
    s = new Sequence();
    s.insert("dog");
    s.insert("cat");
    s.insert("bear");
    s.insert("elephant");
    s.insert("pig");
    s.insert("iguana");
       
    System.out.println("\n Test countTrue and filterTrue");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=6,length=8,[0]=dog,[1]=cat,[2]=bear,[3]=elephant,[4]=pig,[5]=iguana]");

    System.out.println();
    System.out.println("  s.countTrue(new LengthLess(6))  = " + s.countTrue(new LengthLess(6)) + " --> 4");
    System.out.println("  s.filterTrue(new LengthLess(6)) = " + s.filterTrue(new LengthLess(6)) + " --> Sequence[used=4,length=4,[0]=dog,[1]=cat,[2]=bear,[3]=pig]");

    System.out.println();
    System.out.println("  s.countTrue(new ComesAfter(\"dog\"))  = " + s.countTrue(new ComesAfter("dog")) + " --> 3");
    System.out.println("  s.filterTrue(new ComesAfter(\"dog\")) = " + s.filterTrue(new ComesAfter("dog")) + " --> Sequence[used=3,length=4,[0]=elephant,[1]=pig,[2]=iguana]");
 
    //testing 
    System.out.println("\n Test makeEmpty ");
    s = new Sequence();
    loadStandard(s,"abcde");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=5,length=8,[0]=a,[1]=b,[2]=c,[3]=d,[4]=e]");
    System.out.println("  s.makeEmpty()");;
    s.makeEmpty();
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=0,length=8]");
    System.out.println("  s.getSize() = " + s.getSize() + " --> 0");
    System.out.println("  s.isEmpty() = " + s.isEmpty() + " --> true");
 
    //testing putAt
    System.out.println("\n Test putAt"); 
    loadStandard(s,"abcde");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=5,length=8,[0]=a,[1]=b,[2]=c,[3]=d,[4]=e]");
    System.out.println("  s.putAt(\"wasA\",0) = " + s.putAt("wasA",0) + " --> a");
    System.out.println("  s.putAt(\"wasB\",1) = " + s.putAt("wasB",1) + " --> b");
    System.out.println("  s.putAt(\"wasC\",2) = " + s.putAt("wasC",2) + " --> c");
    System.out.println("  s.putAt(\"wasD\",3) = " + s.putAt("wasD",3) + " --> d");
    System.out.println("  s.putAt(\"wasE\",4) = " + s.putAt("wasE",4) + " --> e");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=5,length=8,[0]=wasA,[1]=wasB,[2]=wasC,[3]=wasD,[4]=wasE]");
    try {
      System.out.println("  testing s.putAt(\"x\",-1)");
      System.out.println("    = " + s.putAt("x",-1));
      System.out.println("    Exception should have been thrown!");
    } catch (Exception e) {System.out.println("    Exception correctly thrown");
     }
    try {
      System.out.println("  testing s.putAt(\"x\",5)");
      System.out.println("    = " + s.putAt("x",5));
      System.out.println("    Exception not thrown!");
    } catch (Exception e) {System.out.println("    Exception correctly thrown");
     }

    //testing putAt
    System.out.println("\n Test insertAt"); 
    s = new Sequence();
    loadStandard(s,"abcde");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=5,length=8,[0]=a,[1]=b,[2]=c,[3]=d,[4]=e]");

    System.out.println();
    System.out.println("  s.insertAt(\"preA\",0)");
    s.insertAt("preA",0);
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=6,length=8,[0]=preA,[1]=a,[2]=b,[3]=c,[4]=d,[5]=e]");

    System.out.println();
    System.out.println("  s.insertAt(\"preC\",3)");
    s.insertAt("preC",3);
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=7,length=8,[0]=preA,[1]=a,[2]=b,[3]=preC,[4]=c,[5]=d,[6]=e]");

    System.out.println();
    System.out.println("  s.insertAt(\"preE\",6)");
    s.insertAt("preE",6);
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=8,length=8,[0]=preA,[1]=a,[2]=b,[3]=preC,[4]=c,[5]=d,[6]=preE,[7]=e]");
    
    System.out.println();
    System.out.println("  s.insertAt(\"end\",8)");
    s.insertAt("end",8);
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=9,length=16,[0]=preA,[1]=a,[2]=b,[3]=preC,[4]=c,[5]=d,[6]=preE,[7]=e,[8]=end]");
    
    try {
      System.out.println();
      System.out.println("  testing s.insertAt(\"x\",-1)");
      s.insertAt("x",-1);
      System.out.println("    Exception should have been thrown!");
    } catch (Exception e) {System.out.println("    Exception correctly thrown");
     }
    try {
      System.out.println();
      System.out.println("  testing s.insertAt(\"x\",10)");
      s.insertAt("x",10);
      System.out.println("    Exception not thrown!");
    } catch (Exception e) {System.out.println("    Exception correctly thrown");
     }
    
    //testing removeAt
    System.out.println("\n Test removeAt"); 
    s = new Sequence();
    loadStandard(s,"abcde");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=5,length=8,[0]=a,[1]=b,[2]=c,[3]=d,[4]=e]");

    try {
      System.out.println("  testing s.removeAt(-1)");
      s.removeAt(-1);
      System.out.println("    Exception should have been thrown!");
    } catch (Exception e) {System.out.println("    Exception correctly thrown");
     }
    try {
      System.out.println("  testing s.removeAt(5)");
      s.removeAt(5);
      System.out.println("    Exception not thrown!");
    } catch (Exception e) {System.out.println("    Exception correctly thrown");
     }

    System.out.println();
    System.out.println("  s.removeAt(2) = " + s.removeAt(2) + " --> c");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=4,length=8,[0]=a,[1]=b,[2]=d,[3]=e]");

    System.out.println();
    System.out.println("  s.removeAt(0) = " + s.removeAt(0) + " --> a");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=3,length=8,[0]=b,[1]=d,[2]=e]");

    System.out.println();
    System.out.println("  s.removeAt(2) = " + s.removeAt(2) + " --> e");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=2,length=8,[0]=b,[1]=d]");

    System.out.println();
    System.out.println("  s.removeAt(1) = " + s.removeAt(1) + " --> d");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=1,length=8,[0]=b]");

    System.out.println();
    System.out.println("  s.removeAt(0) = " + s.removeAt(0) + " --> b");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=0,length=8]");

    //testing remove
    System.out.println("\n Test remove"); 
    s = new Sequence();
    loadStandard(s,"abcde");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=5,length=8,[0]=a,[1]=b,[2]=c,[3]=d,[4]=e]");

    System.out.println();
    System.out.println("  s.remove(\"x\")");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=5,length=8,[0]=a,[1]=b,[2]=c,[3]=d,[4]=e]");
   
    System.out.println();
    System.out.println("  s.remove(\"c\")");
    s.remove("c");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=4,length=8,[0]=a,[1]=b,[2]=d,[3]=e]");

    System.out.println();
    System.out.println("  s.remove(\"a\")");
    s.remove("a");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=3,length=8,[0]=b,[1]=d,[2]=e]");

    System.out.println();
    System.out.println("  s.remove(\"e\")");
    s.remove("e");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=2,length=8,[0]=b,[1]=d]");

    System.out.println();
    System.out.println("  s.remove(\"d\")");
    s.remove("d");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=1,length=8,[0]=b]");

    System.out.println();
    System.out.println("  s.remove(\"b\")");
    s.remove("b");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=0,length=8]");

    //testing reverse
    System.out.println("\n Test reverse"); 
    s = new Sequence();
    loadStandard(s,"abcd");
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=4,length=4,[0]=a,[1]=b,[2]=c,[3]=d]");

    System.out.println();
    System.out.println("  s.reverse()");
    s.reverse();
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=4,length=4,[0]=d,[1]=c,[2]=b,[3]=a]");

    System.out.println();
    System.out.println("  s.reverse()");
    s.reverse();
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=4,length=4,[0]=a,[1]=b,[2]=c,[3]=d]");

    s = new Sequence();
    loadStandard(s,"abcde");
    System.out.println();
   System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=5,length=8,[0]=a,[1]=b,[2]=c,[3]=d,[4]=e]");

    System.out.println();
    System.out.println("  s.reverse()");
    s.reverse();
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=5,length=8,[0]=e,[1]=d,[2]=c,[3]=b,[4]=a]");

    System.out.println();
    System.out.println("  s.reverse()");
    s.reverse();
    System.out.println("  s.toString() = " + s.toString() + " --> Sequence[used=5,length=8,[0]=a,[1]=b,[2]=c,[3]=d,[4]=e]");


 }
  
  
  
}
