import edu.uci.ics.pattis.introlib.Decision;


public class Sequence {

  //Instance variables:
  //sequence: the array storing the sequence
  //size    : the number of values actually stored in the sequence/array
  //Note: used <= sequence.length
  //IMPORTANT: remember to update used when values are inserted/removed
  //           from the sequence array; these two act together
  private Object[] sequence;
  private int      used      = 0;



  //Construct an empty sequence by allocating the sequence array of length 
  //  initialLength
  //Throw IllegalArgumentException if initialLength < 1
  public Sequence (int initialLength)
  throws IllegalArgumentException {
    if (initialLength < 1)
      throw new IllegalArgumentException("Sequence: initialLength)"+initialLength+") < 1");

    sequence = new Object[initialLength];
  }


  //Construct an empty sequence by allocating the sequence array of length 1
  public Sequence ()
  {this(1);}



  //make the Sequence empty (storing all null with used = 0)
  public void makeEmpty() {
  }


  //put the value o at index i in the Sequence; return the value that was
  //  stored in this index before it was changed
  //Note that the size of the Sequence (and length of sequence array) DOES NOT increase
  //Throw IllegalArgumentException if the Sequence does not already store
  //  a value at index i (e.g., if i<0 or i>=used)
  //Test this code by putting a value at the start, middle, and end
  //  (as well as before the start and after the end: throwing an exception)
  public Object putAt (Object o, int i) 
  throws IllegalArgumentException {
    return null;
  }


  //return the value at index i in the Sequence;
  //Throw IllegalArgumentException if the Sequence does not already store
  //  a values at index i (e.g., if i<0 or i>=used)
  //Test this code by getting a value at the start, middle, and end
  //  (as well as before the start and after the end: throwing an exception)
  public Object get (int i) 
  throws IllegalArgumentException {
    return null;
  }


  //insert the value o at the end of the Sequence, increasing its size by 1 
  //double the length of the array storing the Sequence if necessary
  public void insert (Object o) {
  }


  //insert the value o at the index i in the Sequence, moving all values at
  //  indexes i and beyond to the right by one, increasing its size by 1 
  //Throw IllegalArgumentException if the index i is i<0 or i>used
  //Note that we can insert at index "used", which has the same
  //  effect as calling insert (i.e., putting a o at the end of the Sequence).
  //double the length of the array storing the Sequence if necessary
  //Test this code by inserting a value at the start, middle, and end
  //  (as well as before the start and after the end: throwing an exception)
  public void insertAt (Object o, int i) 
  throws IllegalArgumentException {
  }


  //remove the value at index i in the Sequence. moving all values at higher
  //  index to the left by one; return the removed value
  //Note that the size of the Sequence decreases by one (and null is stored
  //  where previously the last index stored a value which has been shifted
  //  left)
  //Throw IllegalArgumentException if the Sequence does not already store
  //  a value at index i (e.g., if i<0 or i>=used)
  //Test this code by removing a value at the start, middle, and end
  //  (as well as before the start and after the end: throwing an exception)
  public Object removeAt (int i) 
  throws IllegalArgumentException {
    return null;
  }


  //returns the lowest index at which Object o is stored in the Sequence, or
  //  -1 if it is not stored anywhwere in the Sequence
  //Hint: use the .equals (not == check) which is defined for Object
  //Test this code for various values in and not in the Sequence
  public int findIndex (Object o) { 
    return -1;
  }


  //removes Object o from the lowest index at which it is stored in the
  //  Sequence; if it is not stored in the Sequence, make no changes
  //Hint: use the findIndex and removeAt methods defined above
  //  (write NO LOOPs here)
  //Test this code by removing a value at the start, middle, and end
  //  (as well as before the start and after the end: throwing an exception)
  public void remove (Object o) { 
  }


  //reverse the order of the values in the Sequence
  //Note that the size of the Sequence (and length of sequence array) DOES NOT increase
  public void reverse () {
  }


  //return a count of the number of values in the Sequence for which Decision
  //  d.isOK returns true
  public int countTrue (Decision d) {
    return 0;
  }


  //return a new Sequence of the values in this Sequence for which Decision
  //  d.isOK returns true
  //Hint: construct and return a new Sequence, inserting the required values
  //  into it.
  public Sequence filterTrue (Decision d) {
    return null;
  }


  //return the size of the Sequence (the number of values actually stored
  //  in the Sequence, NOT the length of the sequence array)
  public int getSize() {
    return 0;
  }


  //return whether or not the Sequence is empty.
  public boolean isEmpty() {
    return false;
  }


  //returns a String representation of the Sequence, showing its size, the
  //  length of the array representing it, and the values in the array.
  public String toString () {
    String answer = "Sequence[used="+used+",length="+sequence.length;
    for (int i=0; i<used; i++)
      answer += ",["+i+"]="+sequence[i];
    return answer+"]";
  }


  //returns a String representation of the Sequence, showing its size, the
  //  length of the array representing it, and ALL the values in the array
  // (so you can see if indexes size to length-1 is null.
  public String toStringAllIndex () {
    String answer = "Sequence[used="+used+",length="+sequence.length;
    for (int i=0; i<sequence.length; i++)
      if (sequence[i] == null)
        answer += ",["+i+"]=null";
      else
        answer += ",["+i+"]="+sequence[i];
    return answer+"]";
  }


  //double the length of the sequence array
  private void doubleLength() {
    Object[] temp = new Object[2*sequence.length];
    for (int i=0; i<sequence.length; i++)
      temp[i] = sequence[i];
    sequence = temp;
  }
}
