/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.pattis.introlib;

import edu.uci.ics.pattis.introlib.Prompt;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class TypedBufferWriter {
    private PrintWriter bw;
    private String fileName;

    public TypedBufferWriter(String fileName) {
        this.fileName = TypedBufferWriter.stripQuotes(fileName);
        while (true) {
            try {
                this.bw = new PrintWriter(new FileOutputStream(fileName), true);
            }
            catch (FileNotFoundException e) {
                fileName = Prompt.forString("Unable to open file named \"" + fileName + "; re-enter");
                continue;
            }
            break;
        }
    }

    public TypedBufferWriter(OutputStream os) {
        this.fileName = "some.OutputStream";
        this.bw = new PrintWriter((Writer)new OutputStreamWriter(os), true);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void print(int o) {
        this.bw.print(o);
    }

    public void println(int o) {
        this.bw.println(o);
    }

    public void print(double o) {
        this.bw.print(o);
    }

    public void println(double o) {
        this.bw.println(o);
    }

    public void print(boolean o) {
        this.bw.print(o);
    }

    public void println(boolean o) {
        this.bw.println(o);
    }

    public void print(char o) {
        this.bw.print(o);
    }

    public void println(char o) {
        this.bw.println(o);
    }

    public void print(String o) {
        this.bw.print(o);
    }

    public void println(String o) {
        this.bw.println(o);
    }

    public void print(Object o) {
        this.bw.print(o.toString());
    }

    public void println(Object o) {
        this.bw.println(o.toString());
    }

    public void println() {
        this.bw.println();
    }

    public void close() {
        this.bw.close();
    }

    private static String stripQuotes(String s) {
        String answer = "";
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != '\"') {
                answer = String.valueOf(answer) + s.charAt(i);
            }
            ++i;
        }
        return answer;
    }
}

