/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.pattis.introlib;

import edu.uci.ics.pattis.introlib.Prompt;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class TypedBufferReader {
    private BufferedReader br;
    private String fileName;
    private String whitespace;
    private int lineNumber;
    private StringTokenizer currentLine;
    private String currentLineRaw;
    private String untypedToken = "";

    public TypedBufferReader(String prompt) {
        this(prompt, "");
    }

    public TypedBufferReader(String prompt, String extraWhitespace) {
        boolean direct = prompt.charAt(0) == '\"';
        this.whitespace = " \t\n\r\f" + extraWhitespace;
        while (true) {
            try {
                this.fileName = direct ? prompt.substring(1) : Prompt.forString(prompt);
                this.fileName = TypedBufferReader.stripQuotes(this.fileName);
                this.br = new BufferedReader(new FileReader(this.fileName));
            }
            catch (Exception e) {
                if (!direct) {
                    System.out.println("File not found; reenter");
                    continue;
                }
                System.out.println(String.valueOf(prompt) + "\" not found; reenter");
                prompt = "Enter file name";
                direct = false;
                continue;
            }
            break;
        }
        this.currentLineRaw = "";
        this.currentLine = new StringTokenizer("", this.whitespace);
        this.lineNumber = 0;
    }

    public TypedBufferReader(InputStream is) {
        this(is, "");
    }

    public TypedBufferReader(InputStream is, String extraWhitespace) {
        this.whitespace = " \t\n\r\f" + extraWhitespace;
        this.fileName = "some-InputStream";
        this.br = new BufferedReader(new InputStreamReader(is));
        this.currentLineRaw = "";
        this.currentLine = new StringTokenizer("", this.whitespace);
        this.lineNumber = 0;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    private String readNextToken() throws EOFException {
        while (true) {
            if (this.currentLine.hasMoreTokens()) {
                this.untypedToken = this.currentLine.nextToken();
                this.currentLineRaw = this.currentLineRaw.substring(this.currentLineRaw.indexOf(this.untypedToken) + this.untypedToken.length());
                return this.untypedToken;
            }
            try {
                if (this.currentLineRaw == null) {
                    throw new EOFException();
                }
                this.currentLineRaw = this.br.readLine();
                ++this.lineNumber;
                if (this.currentLineRaw == null) {
                    throw new EOFException();
                }
                this.currentLine = new StringTokenizer(this.currentLineRaw, this.whitespace);
            }
            catch (IOException eof) {
                throw new EOFException();
            }
        }
    }

    public String readLine() throws EOFException {
        if (this.currentLineRaw == null) {
            throw new EOFException();
        }
        if (this.currentLineRaw.equals("")) {
            try {
                this.currentLineRaw = this.br.readLine();
                ++this.lineNumber;
                if (this.currentLineRaw == null) {
                    throw new EOFException();
                }
            }
            catch (IOException eof) {
                throw new EOFException();
            }
        }
        String answer = this.currentLineRaw;
        this.currentLineRaw = "";
        this.currentLine = new StringTokenizer("", this.whitespace);
        return answer;
    }

    public int readInt() throws NumberFormatException, EOFException {
        return Integer.parseInt(this.readNextToken());
    }

    public double readDouble() throws NumberFormatException, EOFException {
        return Double.parseDouble(this.readNextToken());
    }

    public String readString() throws EOFException {
        return this.readNextToken();
    }

    public boolean readBoolean() throws NumberFormatException, EOFException {
        String temp = this.readNextToken();
        if (temp.equals("true")) {
            return true;
        }
        if (temp.equals("false")) {
            return false;
        }
        throw new NumberFormatException();
    }

    public String getLastTokenUntyped() {
        return this.untypedToken;
    }

    public void ignoreRestOfLine() {
        this.currentLine = new StringTokenizer("", this.whitespace);
    }

    public String readAllTokens() {
        StringBuffer result = new StringBuffer();
        try {
            while (true) {
                result.append(String.valueOf(this.readString()) + " ");
            }
        }
        catch (EOFException eofe) {
            return result.toString();
        }
    }

    public void close() {
        try {
            this.br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String stripQuotes(String s) {
        String answer = "";
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != '\"') {
                answer = String.valueOf(answer) + s.charAt(i);
            }
            ++i;
        }
        return answer;
    }
}

