/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.pattis.introlib;

public class Timer {
    private boolean runningNow;
    private long elapsedPrior;
    private long lastStartTime;

    public void reset() {
        this.runningNow = false;
        this.elapsedPrior = 0L;
    }

    public void start() {
        if (this.runningNow) {
            return;
        }
        this.runningNow = true;
        this.lastStartTime = System.currentTimeMillis();
    }

    public void stop() {
        if (!this.runningNow) {
            return;
        }
        this.runningNow = false;
        this.elapsedPrior += System.currentTimeMillis() - this.lastStartTime;
    }

    public double getElapsed() {
        return (double)(this.elapsedPrior + (this.runningNow ? System.currentTimeMillis() - this.lastStartTime : 0L)) / 1000.0;
    }

    public String toString() {
        return "Timer[running=" + this.runningNow + "/" + "elapsedPrior=" + this.elapsedPrior + "/" + "deltaWhileRunning=" + (this.runningNow ? System.currentTimeMillis() - this.lastStartTime : 0L) + "]";
    }
}

