/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.pattis.introlib;

import edu.uci.ics.pattis.introlib.Prompt;

public class Rational {
    private int numerator;
    private int denominator;
    public static final Rational ZERO = new Rational();
    public static final Rational ONE = new Rational(1);

    public Rational(int numerator, int denominator) throws IllegalArgumentException {
        if (denominator == 0) {
            throw new IllegalArgumentException("Exception in Rational Construtor; - denominator 0");
        }
        if (numerator == 0) {
            denominator = 1;
        }
        if (denominator < 0) {
            denominator = -denominator;
            numerator = -numerator;
        }
        int common = Rational.gcd(numerator, denominator);
        this.numerator = numerator / common;
        this.denominator = denominator / common;
    }

    public Rational(int numerator) {
        this(numerator, 1);
    }

    public Rational() {
        this(0, 1);
    }

    public Rational(Rational other) {
        this(other.numerator, other.denominator);
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public boolean equals(Rational other) {
        return this.numerator == other.numerator && this.denominator == other.denominator;
    }

    public int compareTo(Rational other) {
        int left = this.numerator * other.denominator;
        int right = this.denominator * other.numerator;
        return left - right;
    }

    public Rational abs() {
        return new Rational(Math.abs(this.numerator), this.denominator);
    }

    public Rational negate() {
        return new Rational(-this.numerator, this.denominator);
    }

    public Rational reciprocal() throws IllegalStateException {
        if (this.equals(ZERO)) {
            throw new IllegalStateException("Exception in Rational reciprocal: attempt to invert zero");
        }
        return new Rational(this.denominator, this.numerator);
    }

    public Rational add(Rational other) {
        int a = this.numerator;
        int b = this.denominator;
        int c = other.numerator;
        int d = other.denominator;
        return new Rational(a * d + c * b, b * d);
    }

    public Rational subtract(Rational other) {
        int a = this.numerator;
        int b = this.denominator;
        int c = other.numerator;
        int d = other.denominator;
        return new Rational(a * d - c * b, b * d);
    }

    public Rational multiply(Rational other) {
        int a = this.numerator;
        int b = this.denominator;
        int c = other.numerator;
        int d = other.denominator;
        return new Rational(a * c, b * d);
    }

    public Rational divide(Rational other) throws IllegalArgumentException {
        int a = this.numerator;
        int b = this.denominator;
        int c = other.numerator;
        int d = other.denominator;
        return new Rational(a * d, b * c);
    }

    public String toString() {
        return String.valueOf(this.numerator) + "/" + this.denominator;
    }

    public String toDecimalString(int decimalPlaces) {
        String answer = new String("");
        int num = this.numerator;
        int denom = this.denominator;
        if (num < 0) {
            num = -num;
            answer = String.valueOf(answer) + "-";
        }
        if (num >= denom) {
            answer = String.valueOf(answer) + num / denom;
            num %= denom;
        }
        answer = String.valueOf(answer) + ".";
        num *= 10;
        int i = 1;
        while (i <= decimalPlaces) {
            answer = String.valueOf(answer) + num / denom;
            num %= denom;
            num *= 10;
            ++i;
        }
        return answer;
    }

    public static Rational prompt(String message) {
        System.out.println(message);
        while (true) {
            try {
                int numerator = Prompt.forInt("  Enter numerator  ");
                int denominator = Prompt.forInt("  Enter denominator");
                return new Rational(numerator, denominator);
            }
            catch (IllegalArgumentException iae) {
                System.out.println("Illegal rational entered; please try again");
                continue;
            }
            break;
        }
    }

    private static int gcd(int x, int y) {
        x = Math.abs(x);
        y = Math.abs(y);
        while (x != 0 && y != 0) {
            if (x > y) {
                x %= y;
                continue;
            }
            y %= x;
        }
        return x + y;
    }
}

