/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.pattis.introlib;

import edu.uci.ics.pattis.introlib.ValidatorTranslator;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class PromptDialog {
    JTextField answerText;
    ValidatorTranslator vt;

    PromptDialog(String title, String message, String defaultText, ValidatorTranslator vT) {
        this.vt = vT;
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 1));
        pp.add(new JLabel(message));
        this.answerText = new JTextField();
        this.answerText.setText(defaultText);
        pp.add(this.answerText);
        final JOptionPane op = new JOptionPane(pp, 3);
        final JDialog jd = new JDialog(null, title, true);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        jd.setLocation(d.width / 4, d.height / 4);
        jd.toFront();
        jd.setDefaultCloseOperation(0);
        jd.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                op.setValue(PromptDialog.this.answerText.getText());
            }
        });
        op.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (!jd.isVisible() || e.getSource() != op || !prop.equals("value") && !prop.equals("inputValue")) {
                    return;
                }
                Object value = op.getValue();
                if (value == JOptionPane.UNINITIALIZED_VALUE) {
                    return;
                }
                if (PromptDialog.this.vt.isValid(PromptDialog.this.answerText.getText())) {
                    op.setValue(PromptDialog.this.vt.getValue(PromptDialog.this.answerText.getText()));
                    jd.setVisible(false);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    op.setValue(JOptionPane.UNINITIALIZED_VALUE);
                }
            }
        });
        this.answerText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                op.setValue(PromptDialog.this.answerText.getText());
            }
        });
        jd.setContentPane(op);
        jd.pack();
        jd.setVisible(true);
    }

    Object getValue() {
        return this.vt.getValue(this.answerText.getText());
    }
}

