/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.pattis.introlib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;

public class Prompt {
    private static BufferedReader keyboard = new BufferedReader(new InputStreamReader(System.in));

    public static int forInt(String message) {
        while (true) {
            try {
                System.out.print(String.valueOf(message) + ": ");
                return Integer.parseInt(keyboard.readLine());
            }
            catch (NumberFormatException e) {
                System.out.println("NumberFormatException: Please enter a valid integer (" + e.getMessage() + " was not valid)");
                continue;
            }
            catch (IOException e) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public static int forInt(String message, int low, int high) {
        while (true) {
            try {
                int answer = Prompt.forInt(String.valueOf(message) + "[" + low + "," + high + "]");
                if (low <= answer && answer <= high) {
                    return answer;
                }
                throw new Exception("Please enter a value in the specified range");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    public static int forInt(String message, int defaultValue) {
        while (true) {
            try {
                System.out.print(String.valueOf(message) + "(" + defaultValue + "): ");
                String answer = keyboard.readLine();
                if (answer.equals("")) {
                    return defaultValue;
                }
                return Integer.parseInt(answer);
            }
            catch (NumberFormatException e) {
                System.out.println("NumberFormatException: Please enter a valid integer (" + e.getMessage() + " was not valid)");
                continue;
            }
            catch (IOException e) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public static int forInt(String message, int low, int high, int defaultValue) {
        while (true) {
            try {
                int answer = Prompt.forInt(String.valueOf(message) + "[" + low + "," + high + "]", defaultValue);
                if (low <= answer && answer <= high) {
                    return answer;
                }
                throw new Exception("Please enter a value in the specified range");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    public static double forDouble(String message) {
        while (true) {
            try {
                System.out.print(String.valueOf(message) + ": ");
                return Double.parseDouble(keyboard.readLine());
            }
            catch (NumberFormatException e) {
                System.out.println("NumberFormatException: Please enter a valid double (" + e.getMessage() + " was not valid)");
                continue;
            }
            catch (IOException e) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public static double forDouble(String message, double low, double high) {
        while (true) {
            try {
                double answer = Prompt.forDouble(String.valueOf(message) + "[" + low + "," + high + "]");
                if (low <= answer && answer <= high) {
                    return answer;
                }
                throw new Exception("Please enter a value in the specified range");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    public static double forDouble(String message, double defaultValue) {
        while (true) {
            try {
                System.out.print(String.valueOf(message) + "(" + defaultValue + "): ");
                String answer = keyboard.readLine();
                if (answer.equals("")) {
                    return defaultValue;
                }
                return Double.parseDouble(answer);
            }
            catch (NumberFormatException e) {
                System.out.println("NumberFormatException: Please enter a valid double (" + e.getMessage() + " was not valid)");
                continue;
            }
            catch (IOException e) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public static double forDouble(String message, double low, double high, double defaultValue) {
        while (true) {
            try {
                double answer = Prompt.forDouble(String.valueOf(message) + "[" + low + "," + high + "]", defaultValue);
                if (low <= answer && answer <= high) {
                    return answer;
                }
                throw new Exception("Please enter a value in the specified range");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    public static String forString(String message) {
        while (true) {
            try {
                System.out.print(String.valueOf(message) + ": ");
                return keyboard.readLine();
            }
            catch (IOException e) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public static String forString(String message, String defaultValue) {
        while (true) {
            try {
                System.out.print(String.valueOf(message) + "(" + defaultValue + "): ");
                String answer = keyboard.readLine();
                return answer.equals("") ? defaultValue : answer;
            }
            catch (IOException e) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public static String forString(String message, String[] legal) {
        while (true) {
            try {
                while (true) {
                    System.out.print(String.valueOf(message) + "(");
                    int i = 0;
                    while (i < legal.length) {
                        System.out.print(String.valueOf(legal[i]) + (i == legal.length - 1 ? "): " : " "));
                        ++i;
                    }
                    String answer = keyboard.readLine();
                    int i2 = 0;
                    while (i2 < legal.length) {
                        if (answer.equals(legal[i2])) {
                            return answer;
                        }
                        ++i2;
                    }
                    System.out.println("Please enter one of the legal Strings");
                }
            }
            catch (IOException e) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public static String forString(String message, String[] legal, String defaultValue) {
        while (true) {
            try {
                while (true) {
                    System.out.print(String.valueOf(message) + "(");
                    int i = 0;
                    while (i < legal.length) {
                        System.out.print(String.valueOf(legal[i]) + (i == legal.length - 1 ? "): " : " "));
                        ++i;
                    }
                    String answer = keyboard.readLine();
                    if (answer.length() == 0) {
                        return defaultValue;
                    }
                    int i2 = 0;
                    while (i2 < legal.length) {
                        if (answer.equals(legal[i2])) {
                            return answer;
                        }
                        ++i2;
                    }
                    System.out.println("Please enter one of the legal Strings");
                }
            }
            catch (IOException e) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public static boolean forBoolean(String message) {
        while (true) {
            block6: {
                String temp;
                block5: {
                    try {
                        System.out.print(String.valueOf(message) + ": ");
                        temp = keyboard.readLine();
                        if (!temp.equals("true")) break block5;
                        return true;
                    }
                    catch (IOException e) {
                        System.out.println("IOException: Terminating Program");
                        System.exit(0);
                        continue;
                    }
                }
                if (!temp.equals("false")) break block6;
                return false;
            }
            System.out.println("Please enter true or false");
            continue;
            break;
        }
    }

    public static boolean forBoolean(String message, boolean defaultValue) {
        while (true) {
            block7: {
                String temp;
                block6: {
                    try {
                        System.out.print(String.valueOf(message) + "(" + defaultValue + "): ");
                        temp = keyboard.readLine();
                        if (temp.equals("")) {
                            return defaultValue;
                        }
                        if (!temp.equals("true")) break block6;
                        return true;
                    }
                    catch (IOException e) {
                        System.out.println("IOException: Terminating Program");
                        System.exit(0);
                        continue;
                    }
                }
                if (!temp.equals("false")) break block7;
                return false;
            }
            System.out.println("Please enter true or false");
            continue;
            break;
        }
    }

    public static char forChar(String message) {
        while (true) {
            try {
                System.out.print(String.valueOf(message) + ": ");
                String answer = keyboard.readLine();
                if (answer.length() == 0) {
                    throw new Exception("Please enter one character");
                }
                return answer.charAt(0);
            }
            catch (IOException e) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    public static char forChar(String message, char defaultValue) {
        while (true) {
            try {
                System.out.print(String.valueOf(message) + "(" + defaultValue + "): ");
                String answer = keyboard.readLine();
                if (answer.length() == 0) {
                    return defaultValue;
                }
                return answer.charAt(0);
            }
            catch (IOException e) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    public static char forChar(String message, String legal) {
        while (true) {
            try {
                System.out.print(String.valueOf(message) + "[" + legal + "]: ");
                String answer = keyboard.readLine();
                if (answer.length() == 0 || legal.indexOf(answer.charAt(0)) == -1) {
                    throw new Exception("Please enter one legal character");
                }
                return answer.charAt(0);
            }
            catch (IOException e) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    public static char forChar(String message, String legal, char defaultValue) {
        while (true) {
            try {
                System.out.print(String.valueOf(message) + "[" + legal + "](" + defaultValue + "): ");
                String answer = keyboard.readLine();
                if (answer.length() == 0 && legal.indexOf(defaultValue) != -1) {
                    return defaultValue;
                }
                if (answer.length() != 0 && legal.indexOf(answer.charAt(0)) != -1) {
                    return answer.charAt(0);
                }
                throw new Exception("Please enter one legal character");
            }
            catch (IOException e) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    public static BigInteger forBigInteger(String message) {
        while (true) {
            try {
                System.out.print(String.valueOf(message) + ": ");
                return new BigInteger(keyboard.readLine());
            }
            catch (NumberFormatException E) {
                System.out.println("NumberFormatException: Please enter a valid integer (" + E.getMessage() + " was not valid)");
                continue;
            }
            catch (IOException E) {
                System.out.println("IOException: Terminating Program");
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        while (true) {
            System.out.println("Prompt Driver");
            char s = Prompt.forChar("Enter type to prompt: i(nt), d(ouble), b(oolean), c(char), S(tring)", "idbcS");
            if (s == 'i') {
                int answer = 0;
                s = Prompt.intMenuPrompt();
                if (s == 'p') {
                    answer = Prompt.forInt("  Enter int");
                } else if (s == 'd') {
                    answer = Prompt.forInt("  Enter int", 0);
                } else if (s == 'r') {
                    answer = Prompt.forInt("  Enter int", 1, 10);
                } else if (s == 'R') {
                    answer = Prompt.forInt("  Enter int", 1, 10, 1);
                }
                System.out.println("  entered = " + answer);
            } else if (s == 'd') {
                double answer = 0.0;
                s = Prompt.intMenuPrompt();
                if (s == 'p') {
                    answer = Prompt.forDouble("  Enter double");
                } else if (s == 'd') {
                    answer = Prompt.forDouble("  Enter double", 0.0);
                } else if (s == 'r') {
                    answer = Prompt.forDouble("  Enter double", 0.0, 2.0);
                } else if (s == 'R') {
                    answer = Prompt.forDouble("  Enter double", 0.0, 2.0, 0.5);
                }
                System.out.println("  entered = " + answer);
            } else if (s == 'S') {
                String answer = "";
                s = Prompt.booleanMenuPrompt();
                if (s == 'p') {
                    answer = Prompt.forString("  Enter String");
                } else if (s == 'd') {
                    answer = Prompt.forString("  Enter String", "default");
                }
                System.out.println("  entered = " + answer);
            } else if (s == 'b') {
                boolean answer = false;
                s = Prompt.booleanMenuPrompt();
                if (s == 'p') {
                    answer = Prompt.forBoolean("  Enter boolean");
                } else if (s == 'd') {
                    answer = Prompt.forBoolean("  Enter boolean", false);
                }
                System.out.println("  entered = " + answer);
            } else if (s == 'c') {
                char answer = '?';
                s = Prompt.intMenuPrompt();
                if (s == 'p') {
                    answer = Prompt.forChar("  Enter char");
                } else if (s == 'd') {
                    answer = Prompt.forChar("  Enter char", '!');
                } else if (s == 'r') {
                    answer = Prompt.forChar("  Enter char", "aeiou");
                } else if (s == 'R') {
                    answer = Prompt.forChar("  Enter char", "aeiou", 'a');
                }
                System.out.println("  entered = " + answer);
            }
            System.out.println();
        }
    }

    private static char intMenuPrompt() {
        System.out.println("  p - plain");
        System.out.println("  d - with default");
        System.out.println("  r - with range");
        System.out.println("  R - with range/default");
        return Prompt.forChar("Enter Selection", "pdrR");
    }

    private static char booleanMenuPrompt() {
        System.out.println("  p - plain");
        System.out.println("  d - with default");
        return Prompt.forChar("Enter Selection", "pd");
    }
}

