/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.pattis.introlib;

import edu.uci.ics.pattis.introlib.Prompt;

public class ModularCounter {
    private int value;
    private int modulus;

    public ModularCounter(int value, int modulus) throws IllegalArgumentException {
        if (modulus < 1) {
            throw new IllegalArgumentException("ModularCounter - modulus(" + modulus + ") non-positive");
        }
        if (value < 0 || value >= modulus) {
            throw new IllegalArgumentException("ModularCounter - value(" + value + ") not in range [0," + (modulus - 1) + "]");
        }
        this.value = value;
        this.modulus = modulus;
    }

    public ModularCounter(int modulus) {
        this(0, modulus);
    }

    public int getValue() {
        return this.value;
    }

    public int getModulus() {
        return this.modulus;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ModularCounter)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        ModularCounter otherMC = (ModularCounter)other;
        return this.value == otherMC.value && this.modulus == otherMC.modulus;
    }

    public boolean isZero() {
        return this.value == 0;
    }

    public int compareTo(ModularCounter mc) {
        return this.value - mc.value;
    }

    public String toString() {
        return String.valueOf(this.value) + "(mod " + this.modulus + ")";
    }

    public void reset() {
        this.value = 0;
    }

    public void inc() {
        this.value = this.value < this.modulus - 1 ? ++this.value : 0;
    }

    public void inc(int delta) throws IllegalArgumentException {
        if (delta < 0) {
            throw new IllegalArgumentException("ModularCounter: inc - delta(" + delta + ") non-positive");
        }
        int i = 1;
        while (i <= delta) {
            this.inc();
            ++i;
        }
    }

    public void dec() {
        this.value = this.value == 0 ? this.modulus - 1 : --this.value;
    }

    public void dec(int delta) throws IllegalArgumentException {
        if (delta < 0) {
            throw new IllegalArgumentException("ModularCounter: inc - delta(" + delta + ") non-positive");
        }
        int i = 1;
        while (i <= delta) {
            this.dec();
            ++i;
        }
    }

    public void update(int delta) {
        if (delta >= 0) {
            int i = 1;
            while (i <= delta) {
                this.inc();
                ++i;
            }
        } else {
            int i = 1;
            while (i <= -delta) {
                this.dec();
                ++i;
            }
        }
    }

    public static ModularCounter prompt(String message) {
        System.out.println(message);
        while (true) {
            try {
                int value = Prompt.forInt("  Enter value  ");
                int modulus = Prompt.forInt("  Enter modulus");
                return new ModularCounter(value, modulus);
            }
            catch (Exception e) {
                System.out.println("Illegal ModularCounter entered; please try again");
                continue;
            }
            break;
        }
    }
}

