/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.pattis.introlib;

public class Matrix {
    private Object[][] values;

    public Matrix(int rowSize, int colSize) throws IllegalArgumentException {
        if (rowSize < 1) {
            throw new IllegalArgumentException("Matrix constructor: rowSize (" + rowSize + ") < 1");
        }
        if (colSize < 1) {
            throw new IllegalArgumentException("Matrix constructor: colSize (" + colSize + ") < 1");
        }
        this.values = new Object[rowSize][colSize];
    }

    public Matrix(Matrix other) {
        this(other.getRowSize(), other.getColSize());
        int r = 0;
        while (r < other.getRowSize()) {
            int c = 0;
            while (c < other.getColSize()) {
                this.values[r][c] = other.values[r][c];
                ++c;
            }
            ++r;
        }
    }

    public int getRowSize() {
        return this.values.length;
    }

    public int getColSize() {
        return this.values[0].length;
    }

    public int getSize() {
        return this.getRowSize() * this.getColSize();
    }

    public Object getObject(int row, int col) throws ArrayIndexOutOfBoundsException {
        return this.values[row][col];
    }

    public Matrix getRow(int row) throws ArrayIndexOutOfBoundsException {
        Matrix answer = new Matrix(1, this.getColSize());
        int c = 0;
        while (c < this.getColSize()) {
            answer.values[0][c] = this.values[0][c];
            ++c;
        }
        return answer;
    }

    public Matrix getCol(int col) throws ArrayIndexOutOfBoundsException {
        Matrix answer = new Matrix(this.getRowSize(), 1);
        int r = 0;
        while (r < this.getRowSize()) {
            answer.values[r][0] = this.values[r][0];
            ++r;
        }
        return answer;
    }

    public void setObject(int row, int col, Object o) throws ArrayIndexOutOfBoundsException {
        this.values[row][col] = o;
    }

    public String toString() {
        String answer = "Matrix[rows=" + this.getRowSize() + "/" + "cols=" + this.getColSize();
        int r = 0;
        while (r < this.getRowSize()) {
            int c = 0;
            while (c < this.getColSize()) {
                answer = String.valueOf(answer) + "[" + r + "," + c + "]=" + this.getObject(r, c);
                ++c;
            }
            ++r;
        }
        return String.valueOf(answer) + "]";
    }
}

