/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.pattis.introlib;

import edu.uci.ics.pattis.introlib.Prompt;
import edu.uci.ics.pattis.introlib.PromptDialog;
import edu.uci.ics.pattis.introlib.ValidatorTranslator;
import java.math.BigInteger;
import javax.swing.JOptionPane;

public class GUIPrompt {
    public static int forInt(String message) {
        ValidatorTranslator vt = new ValidatorTranslator(){

            @Override
            public boolean isValid(String s) {
                try {
                    Integer.parseInt(s);
                    return true;
                }
                catch (NumberFormatException pe) {
                    return false;
                }
            }

            @Override
            public Object getValue(String s) {
                try {
                    return new Integer(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
        PromptDialog pd = new PromptDialog("Enter int", message, "", vt);
        return (Integer)pd.getValue();
    }

    public static int forInt(String message, final int low, final int high) {
        ValidatorTranslator vt = new ValidatorTranslator(){

            @Override
            public boolean isValid(String s) {
                try {
                    int temp = Integer.parseInt(s);
                    return low <= temp && temp <= high;
                }
                catch (NumberFormatException pe) {
                    return false;
                }
            }

            @Override
            public Object getValue(String s) {
                try {
                    return new Integer(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
        PromptDialog pd = new PromptDialog("Enter int", message, "", vt);
        return (Integer)pd.getValue();
    }

    public static double forDouble(String message) {
        ValidatorTranslator vt = new ValidatorTranslator(){

            @Override
            public boolean isValid(String s) {
                try {
                    Double.parseDouble(s);
                    return true;
                }
                catch (NumberFormatException pe) {
                    return false;
                }
            }

            @Override
            public Object getValue(String s) {
                try {
                    return new Double(Double.parseDouble(s));
                }
                catch (NumberFormatException pe) {
                    return null;
                }
            }
        };
        PromptDialog pd = new PromptDialog("Enter double", message, "", vt);
        return (Double)pd.getValue();
    }

    public static String forString(String message) {
        ValidatorTranslator vt = new ValidatorTranslator(){

            @Override
            public boolean isValid(String s) {
                return true;
            }

            @Override
            public Object getValue(String s) {
                return s;
            }
        };
        PromptDialog pd = new PromptDialog("Enter char", message, "", vt);
        return (String)pd.getValue();
    }

    public static boolean forBoolean(String message) {
        Object[] options = new Object[]{"true", "false"};
        int answer = JOptionPane.showOptionDialog(null, message, "Enter boolean", -1, 3, null, options, options[0]);
        return answer == 0;
    }

    public static char forChar(String message) {
        ValidatorTranslator vt = new ValidatorTranslator(){

            @Override
            public boolean isValid(String s) {
                return s.length() == 1;
            }

            @Override
            public Object getValue(String s) {
                return new Character(s.charAt(0));
            }
        };
        PromptDialog pd = new PromptDialog("Enter char", message, "", vt);
        return ((Character)pd.getValue()).charValue();
    }

    public static char forChar(String message, final String legal) {
        ValidatorTranslator vt = new ValidatorTranslator(){

            @Override
            public boolean isValid(String s) {
                return s.length() == 1 && legal.indexOf(s.charAt(0)) != -1;
            }

            @Override
            public Object getValue(String s) {
                return new Character(s.charAt(0));
            }
        };
        PromptDialog pd = new PromptDialog("Enter char", message, "", vt);
        return ((Character)pd.getValue()).charValue();
    }

    public static BigInteger forBigInteger(String message) {
        ValidatorTranslator vt = new ValidatorTranslator(){

            @Override
            public boolean isValid(String s) {
                try {
                    new BigInteger(s);
                    return true;
                }
                catch (NumberFormatException pe) {
                    return false;
                }
            }

            @Override
            public Object getValue(String s) {
                try {
                    return new BigInteger(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
        PromptDialog pd = new PromptDialog("Enter BigInteger", message, "", vt);
        return (BigInteger)pd.getValue();
    }

    public static void main(String[] args) {
        while (true) {
            System.out.println("\nLegend\n  i = int\n  d = double\n  b = boolean\n  c = char\n  s = string\n  B = BigInt\n  q = quit");
            char c = Prompt.forChar("Enter type to prompt for", "idbcsBq");
            if (c == 'i') {
                System.out.println("Answer returned from prompt = " + GUIPrompt.forInt("Test: Enter int"));
                continue;
            }
            if (c == 'd') {
                System.out.println("Answer returned from prompt = " + GUIPrompt.forDouble("Test: Enter double"));
                continue;
            }
            if (c == 'b') {
                System.out.println("Answer returned from prompt = " + GUIPrompt.forBoolean("Test: Enter boolean"));
                continue;
            }
            if (c == 'c') {
                System.out.println("Answer returned from prompt = " + GUIPrompt.forChar("Test: Enter char"));
                continue;
            }
            if (c == 's') {
                System.out.println("Answer returned from prompt = " + GUIPrompt.forString("Test: Enter String"));
                continue;
            }
            if (c == 'B') {
                System.out.println("Answer returned from prompt = " + GUIPrompt.forBigInteger("Test: Enter BigInteger"));
                continue;
            }
            if (c == 'q') break;
        }
    }
}

