/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.pattis.introlib;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileSelector {
    private final JFileChooser fileChooser;
    private final String titleLabel;
    private final String actionLabel;
    private final boolean multipleFiles;
    private final String extensions;
    private final String separator;

    private FileSelector(String titleLabel, String actionLabel, boolean multipleFiles, String extensions, String separator) {
        this.titleLabel = titleLabel;
        this.actionLabel = actionLabel;
        this.multipleFiles = multipleFiles;
        this.extensions = extensions;
        this.separator = separator;
        this.fileChooser = this.getImageChooser(500, 0, 0);
    }

    public static FileSelector getFileNameSelector(String titleLabel, String actionLabel, String extensions) {
        return new FileSelector(titleLabel, actionLabel, false, extensions, "");
    }

    public static FileSelector getFileNamesSelector(String titleLabel, String actionLabel, String extensions, String separator) {
        return new FileSelector(titleLabel, actionLabel, true, extensions, separator);
    }

    public String select() {
        File[] toLoad;
        if (!this.multipleFiles) {
            int choice = this.fileChooser.showDialog(null, this.actionLabel);
            File toLoad2 = choice == 0 ? this.fileChooser.getSelectedFile() : null;
            return toLoad2 == null ? null : toLoad2.getPath();
        }
        StringBuffer answer = new StringBuffer();
        int choice = this.fileChooser.showDialog(null, this.actionLabel);
        File[] fileArray = toLoad = choice == 0 ? this.fileChooser.getSelectedFiles() : null;
        if (toLoad == null) {
            return "";
        }
        int filesIn = 0;
        int i = 0;
        while (i < toLoad.length) {
            if (toLoad[i].isFile()) {
                answer.append(String.valueOf(filesIn++ == 0 ? "" : this.separator) + toLoad[i].getPath());
            } else {
                try {
                    File[] fileNames = toLoad[i].listFiles();
                    int j = 0;
                    while (j < fileNames.length) {
                        String extension;
                        String fileName = fileNames[j].getCanonicalPath();
                        int index = fileName.lastIndexOf(".");
                        String string = extension = index == -1 ? "" : fileName.substring(fileName.lastIndexOf(".")).toLowerCase();
                        if (this.extensions.indexOf(extension) != -1) {
                            answer.append(String.valueOf(filesIn++ == 0 ? "" : this.separator) + fileName);
                        }
                        ++j;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return answer.toString();
    }

    private JFileChooser getImageChooser(int size, int x, int y) {
        JFileChooser imageChoices = new JFileChooser();
        imageChoices.setLocation(x, y);
        imageChoices.setPreferredSize(new Dimension(size, size));
        imageChoices.setDialogTitle(this.titleLabel);
        imageChoices.setCurrentDirectory(new File("."));
        imageChoices.setFileSelectionMode(this.multipleFiles ? 2 : 0);
        imageChoices.setMultiSelectionEnabled(this.multipleFiles);
        imageChoices.setAcceptAllFileFilterUsed(false);
        imageChoices.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String extension;
                if (FileSelector.this.extensions.equals("*")) {
                    return true;
                }
                int index = f.getName().lastIndexOf(".");
                String string = extension = index == -1 ? "" : f.getName().substring(f.getName().lastIndexOf(".")).toLowerCase();
                return f.isDirectory() || FileSelector.this.extensions.indexOf(extension) != -1;
            }

            @Override
            public String getDescription() {
                return FileSelector.this.extensions;
            }
        });
        return imageChoices;
    }
}

