/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.pattis.introlib;

public class DiceEnsemble {
    private int sidesPerDie;
    private int rollCount;
    private int[] pips;

    public DiceEnsemble(int numberOfDice, int sidesPerDie) throws IllegalArgumentException {
        if (numberOfDice < 1) {
            throw new IllegalArgumentException("DiceEnsemble constructor: Number of dice (" + numberOfDice + ") < 1");
        }
        if (sidesPerDie < 1) {
            throw new IllegalArgumentException("DiceEnsemble constructor: Sides per die (" + sidesPerDie + ") < 1");
        }
        this.sidesPerDie = sidesPerDie;
        this.pips = new int[numberOfDice];
    }

    public DiceEnsemble() {
        this(2, 6);
    }

    public DiceEnsemble roll() {
        ++this.rollCount;
        int i = 0;
        while (i < this.pips.length) {
            this.pips[i] = (int)Math.round(Math.random() * (double)this.sidesPerDie + 0.5);
            ++i;
        }
        return this;
    }

    public int getNumberOfDice() {
        return this.pips.length;
    }

    public int getSidesPerDie() {
        return this.sidesPerDie;
    }

    public int getPips(int dieIndex) throws IllegalStateException, IllegalArgumentException {
        if (this.rollCount == 0) {
            throw new IllegalStateException("getPip called, but dice not rolled");
        }
        if (dieIndex < 1 || dieIndex > this.pips.length) {
            throw new IllegalStateException("getPip called, but dieIndex(" + dieIndex + ") is not in the range [1," + this.pips.length + "]");
        }
        return this.pips[dieIndex - 1];
    }

    public int getPipSum() throws IllegalStateException {
        if (this.rollCount == 0) {
            throw new IllegalStateException("getPipSum called, but dice not rolled");
        }
        int pipSum = 0;
        int i = 0;
        while (i < this.pips.length) {
            pipSum += this.pips[i];
            ++i;
        }
        return pipSum;
    }

    public int getRollCount() {
        return this.rollCount;
    }

    public boolean allSame() throws IllegalStateException {
        if (this.rollCount == 0) {
            throw new IllegalStateException("allSame called, but dice not rolled");
        }
        int unique = this.pips[0];
        int i = 1;
        while (i < this.pips.length) {
            if (unique != this.pips[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String result = "DiceEnsemble[sidesPerDie=" + this.getSidesPerDie() + "," + "rollCount=" + this.getRollCount() + "," + "pips=[";
        int i = 0;
        while (i < this.pips.length) {
            result = String.valueOf(result) + this.pips[i] + (i < this.pips.length - 1 ? "," : "]]");
            ++i;
        }
        return result;
    }
}

