/*
 * Decompiled with CFR 0.152.
 */
import edu.uci.ics.pattis.introlib.Decision;

public class Sequence {
    private Object[] sequence;
    private int used = 0;

    public Sequence(int initialLength) throws IllegalArgumentException {
        if (initialLength < 1) {
            throw new IllegalArgumentException("Sequence: initialLength)" + initialLength + ") < 1");
        }
        this.sequence = new Object[initialLength];
    }

    public Sequence() {
        this(1);
    }

    public void makeEmpty() {
        int i = 0;
        while (i < this.used) {
            this.sequence[i] = null;
            ++i;
        }
        this.used = 0;
    }

    public Object putAt(Object o, int i) throws IllegalArgumentException {
        if (i < 0 || i >= this.used) {
            throw new IllegalArgumentException("put: index i (" + i + ") <0 or >=" + this.used);
        }
        Object answer = this.sequence[i];
        this.sequence[i] = o;
        return answer;
    }

    public Object get(int i) throws IllegalArgumentException {
        if (i < 0 || i >= this.used) {
            throw new IllegalArgumentException("get: index i (" + i + ") <0 or >=" + this.used);
        }
        return this.sequence[i];
    }

    public void insert(Object o) {
        if (this.used == this.sequence.length) {
            this.doubleLength();
        }
        this.sequence[this.used++] = o;
    }

    public void insertAt(Object o, int i) throws IllegalArgumentException {
        if (i < 0 || i > this.used) {
            throw new IllegalArgumentException("insertAt: index i (" + i + ") <0 or >" + this.used);
        }
        if (this.used == this.sequence.length) {
            this.doubleLength();
        }
        int j = this.used;
        while (j > i) {
            this.sequence[j] = this.sequence[j - 1];
            --j;
        }
        this.sequence[i] = o;
        ++this.used;
    }

    public Object removeAt(int i) throws IllegalArgumentException {
        if (i < 0 || i >= this.used) {
            throw new IllegalArgumentException("removeAt: index i (" + i + ") <0 or >=" + this.used);
        }
        Object answer = this.sequence[i];
        int j = i;
        while (j < this.used - 1) {
            this.sequence[j] = this.sequence[j + 1];
            ++j;
        }
        --this.used;
        this.sequence[this.used] = null;
        return answer;
    }

    public int findIndex(Object o) {
        int i = 0;
        while (i < this.used) {
            if (o.equals(this.sequence[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void remove(Object o) {
        int i = this.findIndex(o);
        if (i != -1) {
            this.removeAt(i);
        }
    }

    public void reverse() {
        int left = 0;
        int right = this.used - 1;
        while (left < right) {
            Object oldLeft = this.sequence[left];
            this.sequence[left] = this.sequence[right];
            this.sequence[right] = oldLeft;
            ++left;
            --right;
        }
    }

    public int countTrue(Decision d) {
        int count = 0;
        int i = 0;
        while (i < this.used) {
            if (d.isOK(this.sequence[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public Sequence filterTrue(Decision d) {
        Sequence answer = new Sequence();
        int i = 0;
        while (i < this.used) {
            if (d.isOK(this.sequence[i])) {
                answer.insert(this.sequence[i]);
            }
            ++i;
        }
        return answer;
    }

    public int getSize() {
        return this.used;
    }

    public boolean isEmpty() {
        return this.used == 0;
    }

    public String toString() {
        String answer = "Sequence[used=" + this.used + ",length=" + this.sequence.length;
        int i = 0;
        while (i < this.used) {
            answer = String.valueOf(answer) + ",[" + i + "]=" + this.sequence[i];
            ++i;
        }
        return String.valueOf(answer) + "]";
    }

    public String toStringAllIndex() {
        String answer = "Sequence[used=" + this.used + ",length=" + this.sequence.length;
        int i = 0;
        while (i < this.sequence.length) {
            answer = this.sequence[i] == null ? String.valueOf(answer) + ",[" + i + "]=null" : String.valueOf(answer) + ",[" + i + "]=" + this.sequence[i];
            ++i;
        }
        return String.valueOf(answer) + "]";
    }

    private void doubleLength() {
        Object[] temp = new Object[2 * this.sequence.length];
        int i = 0;
        while (i < this.sequence.length) {
            temp[i] = this.sequence[i];
            ++i;
        }
        this.sequence = temp;
    }
}

