//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : SimpleStackDriver
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  University of California, Irvine
//                  Irvine, CA 92617-3435
//                  e-mail: pattis@ics.uci.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   This program implements a driver for the SimpleStack class.
// Most of its menu selections allow the user to call the individual
// methods declared in this class (both mutators and accessors) on an object
// that it constructs. Other menu items perform combinations of these methods.
// In this way, programmers can learn about this class by experimenting with
// its methods.
//
// Known Bugs     : None
//
// Future Plans   : None
//
// Program History:
//   9/24/01: R. Pattis - Operational in Java
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


import edu.uci.ics.pattis.introlib.Prompt;
import java.io.EOFException;



public class SimpleStackDriver {


	//Present menu and get user's choice

	private static char menuPrompt () {
		System.out.println("\n\nAccessors          Mutator         General");
		System.out.println("  ? - isEmpty        m - makeEmpty   f - flush: pop all");
		System.out.println("  s - getSize        v - push        q = quit");
		System.out.println("  p - peek           ^ - pop");
		System.out.println("  t - toString");

		return Prompt.forChar("\nEnter Command","?sptmv^fq");
	}



	////////////////
	//Driver Program
	////////////////

	public static void main(String[] args){
		//Construct object to test
		SimpleStack s = new SimpleStack();


		//Test object using any method
		for (;;)
			try {
				char selection = menuPrompt();

				if (selection == '?')
					System.out.println("  isEmpty = " + s.isEmpty());

				else if (selection == 's')
					System.out.println("  size = " + s.getSize());

				else if (selection == 'p')
					System.out.println("  peek = " + s.peek());

				else if (selection == 't')
					System.out.println("  toString = " + s);

				else if (selection == 'm')
					s.makeEmpty();

				else if (selection == 'v')
					s.push(Prompt.forString("  Enter String to push"));

				else if (selection == '^')
					System.out.println("  pop = " + s.pop());

				else if (selection == 'f')
					for(;!s.isEmpty();)
						System.out.println("  pop = " + s.pop());

				else if (selection == 'q')
					break;

				else
					System.out.println("\""+selection+"\" is unknown command");

			}catch(Exception e) {
				System.out.println("  Exception Caught/Handled: "+e.getMessage());
			}
	}
}
