//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Class          : SimpleStack
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  University of California, Irvine
//                  Irvine, CA 92617-3435
//                  e-mail: pattis@ics.uci.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   Objects constructed from the SimpleStack class act as collections of
// any objects. We can push objects into this collection and pop
// objects from the collection (according to the Last-In/First-Out
// ordering). Note that NO METHODS are called on these objects inside
// this class: we just move references around. 
//
// Future Plans   : None
//
// Program History:
//   9/25/01: R. Pattis - Operational for 15-100
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



public class SimpleStack  { 

	//Constructors
	public SimpleStack (int initialSize) throws IllegalArgumentException
	{
		if (initialSize < 1)
			throw new IllegalArgumentException("SimpleStack Constructor: initialSize("+initialSize+") < 1");

		stack = new Object[initialSize];
	}


	public SimpleStack ()
	{this(1);}



	//Mutators
	public void makeEmpty () {
		for (int i=0; i<=top; i++)
			stack[i] = null;
		top = -1;
	}


	public void push (Object o) {
		if ( getSize() == stack.length)
			doubleLength();

		top++;
		stack[top] = o;        //or just stack[++top] = o;
	}


	public Object pop () throws IllegalStateException {
		if ( isEmpty() )
			throw new IllegalStateException("SimpleStack pop: Stack is empty");

		Object answer = stack[top];
		stack[top] = null;
		top--;
		return answer;
	}




	//Accessors
	public Object peek () throws IllegalStateException
	{
		if ( isEmpty() )
			throw new IllegalStateException("SimpleStack peek: Stack is empty");

		return stack[top];  
	}


	public boolean isEmpty ()
	{return top == -1;}


	public int getSize ()
	{return top+1;}


	public String toString () {
		String answer = "SimpleStack[top="+top+"/length="+stack.length;
		for (int i=0; i<=top; i++)
			answer += ";stack["+i+"]="+stack[i];
		answer +=  "]";

		return answer;
	}




	//Private Helper
	private void doubleLength () {
		Object[] temp = new Object[stack.length*2];
		for (int i=0; i<stack.length; i++)
			temp[i] = stack[i];
		stack = temp;
	}



	//Instance variables
	private Object[] stack;
	private int      top = -1;  //Hand simulate push for why -1
}




