//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : SimpleQueue Driver
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  Carnegie Mellon University
//                  5000 Forbes Avenue
//                  Pittsburgh, PA 15213-3891
//                  e-mail: pattis@cs.cmu.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   This program implements a driver for the SimpleQueue class.
// Most of its menu selections allow the user to call the individual
// methods declared in this class (both mutators and accessors) on an object
// that it constructs. Other menu items perform combinations of these methods.
// In this way, programmers can learn about this class by experimenting with
// its methods.
//
//   To use this driver, the SimpleQueue must support iterators.
//
// Known Bugs     : None
//
// Future Plans   : None
//
// Program History:
//   9/24/01: R. Pattis - Operational in Java
//   9/19/04: R. Pattis - Enhanced to test SimpleQueue with Iterators
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


import edu.cmu.cs.pattis.cs151xx.Prompt;
import edu.cmu.cs.pattis.cs151xx.SimpleQueue;
import java.util.Iterator;



public class Application {


  //Present menu and get user's choice
  
  private static char menuPrompt ()
  {
    System.out.println("\n\nAccessors          Mutator         General");
    System.out.println("  ? - isEmpty        m - makeEmpty   f - flush   : dequeue all");
    System.out.println("  s - getSize        e - enqueue     i - Iterator: print all");
    System.out.println("  p - peek           d - dequeue     I - Iterator: submenu");
    System.out.println("  t - toString                       q - quit ");
    
    return Prompt.forChar("\nEnter Command","?sptmedfiIq");
  }
  
  
  
  ////////////////
  //Driver Program
  ////////////////
  
	public static void main(String[] args)
	{
    //Construct object to test
	  SimpleQueue q = new SimpleQueue();
	  
	  //Test queue object using any method
	  for (;;)
	    try {
  	    char selection = menuPrompt();
  	    
        if (selection == '?')
          System.out.println("  isEmpty = " + q.isEmpty());
          
        else if (selection == 's')
          System.out.println("  size = " + q.getSize());
       
        else if (selection == 'p')
          System.out.println("  peek = " + q.peek());

        else if (selection == 't')
          System.out.println("  toString = " + q);

        else if (selection == 'm')
          q.makeEmpty();
          
        else if (selection == 'e')
          q.enqueue(Prompt.forString("  Enter String to enqueue"));
          
        else if (selection == 'd')
          System.out.println("  dequeue = " + q.dequeue());
          
        else if (selection == 'f')
          for(;!q.isEmpty();)
  	        System.out.println("  dequeue = " + q.dequeue());
  	    
        else if (selection == 'i') {
          System.out.print("  values (via iterator) = ");
          for (Iterator i = q.iterator(); i.hasNext(); )
  	        System.out.print(i.next() + (i.hasNext()? ",":"\n"));
  	    
        }else if (selection == 'I') {
          Iterator i = q.iterator();
          for (;;) {
            char s = Prompt.forChar("  [h]asNext, [n]ext, [r]emove, [q]quit","hnrq");
            if (s == 'h')
              System.out.println("    hasNext = " + i.hasNext());
            else if (s == 'n')
              System.out.println("    next = " + i.next());
            else if (s == 'r')
              i.remove();
            else if (s == 'q')
              break;
  	      }
  	      
        }else if (selection == 'q')
          break;
        
        else
          System.out.println("\""+selection+"\" is unknown command");

      }catch(Exception e) {
        System.out.println("  Exception Caught/Handled: "+e.getClass() + "\n   with text: " + e.getMessage());
      }
  }
}
