//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : SimpleQueueDriver
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  University of California, Irvine
//                  Irvine, CA 92617-3435
//                  e-mail: pattis@ics.uci.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   This program implements a driver for the SimpleQueue class.
// Most of its menu selections allow the user to call the individual
// methods declared in this class (both mutators and accessors) on an object
// that it constructs. Other menu items perform combinations of these methods.
// In this way, programmers can learn about this class by experimenting with
// its methods.
//
// Known Bugs     : None
//
// Future Plans   : None
//
// Program History:
//   9/24/01: R. Pattis - Operational in Java
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


import edu.uci.ics.pattis.introlib.Prompt;


public class SimpleQueueDriver {


  //Present menu and get user's choice
  
  private static char menuPrompt () {
    System.out.println("\n\nAccessors          Mutator         General");
    System.out.println("  ? - isEmpty        m - makeEmpty   f - flush: dequeue all");
    System.out.println("  s - getSize        e - enqueue     q = quit");
    System.out.println("  p - peek           d - dequeue");
    System.out.println("  t - toString");
    
    return Prompt.forChar("\nEnter Command","?sptmedfq");
  }
  
  
  
  ////////////////
  //Driver Program
  ////////////////
  
	public static void main(String[] args){
    //Construct object to test
	  SimpleQueue q = new SimpleQueue();
	  
	  //Test queue object using any method
	  for (;;)
	    try {
  	    char selection = menuPrompt();
  	    
        if (selection == '?')
          System.out.println("  isEmpty = " + q.isEmpty());
          
        else if (selection == 's')
          System.out.println("  size = " + q.getSize());
       
        else if (selection == 'p')
          System.out.println("  peek = " + q.peek());

        else if (selection == 't')
          System.out.println("  toString = " + q);

        else if (selection == 'm')
          q.makeEmpty();
          
        else if (selection == 'e')
          q.enqueue(Prompt.forString("  Enter String to enqueue"));
          
        else if (selection == 'd')
          System.out.println("  dequeue = " + q.dequeue());
          
        else if (selection == 'f')
          for(;!q.isEmpty();)
  	        System.out.println("  dequeue = " + q.dequeue());
  	    
        else if (selection == 'q')
          break;
        
        else
          System.out.println("\""+selection+"\" is unknown command");

      }catch(Exception e) {
        System.out.println("  Exception Caught/Handled: "+e.getMessage());
      }
  }
}
