//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Class          : SimpleQueue
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  University of California, Irvine
//                  Irvine, CA 92617-3435
//                  e-mail: pattis@ics.uci.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   Objects constructed from the SimpleQueue class act as collections of
// any objects. We can enqueue objects into this collection and dequeue
// objects from the collection (according to the First-In/First-Out
// ordering). Note that NO METHODS are called on these objects inside
// this class: we just move references around. 
//
// Future Plans   : None
//
// Program History:
//   9/25/01: R. Pattis - Operational for 15-100
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


public class SimpleQueue  { 


	//Constructors
	public SimpleQueue (int initialSize) throws IllegalArgumentException {
		if (initialSize < 1)
			throw new IllegalArgumentException("SimpleQueue Constructor: initialSize("+initialSize+") < 1");

		q = new Object[initialSize];
	}


	public SimpleQueue ()
	{this(1);}



	//Mutators  
	public void makeEmpty () {
		for (int i=0; i<=rear; i++)
			q[i] = null;
		rear  = -1;
	}


	public void enqueue (Object o) {
		if ( getSize() == q.length)
			doubleLength();

		rear++;
		q[rear] = o;        //or just q[++rear] = o;
	}


	public Object dequeue () throws IllegalStateException {
		if ( isEmpty() )
			throw new IllegalStateException("SimpleQueue dequeue: queue is empty");

		Object answer = q[0];

		//Shift all remaining values (q[1..rear]) left by 1 index, into
		//  positions  q[0..rear-1]
		for (int i=0; i<rear; i++)
			q[i] = q[i+1];

		//Remove duplicate in q[rear]; it has been copied into
		//  q[rear-1] too 
		q[rear] = null;
		rear--;                 //or just q[rear--] = null;
		return answer;
	}



	//Accessorts
	public Object peek () throws IllegalStateException {
		if ( isEmpty() )
			throw new IllegalStateException("SimpleQueue peek: queue is empty");

		return q[0];  
	}


	public boolean isEmpty ()
	{return rear == -1;}



	public int getSize ()
	{return rear+1;}


	public String toString () {
		String answer = "SimpleQueue[rear="+rear+"/length="+q.length;
		for (int i=0; i<=rear; i++)
			answer += ";q["+i+"]="+q[i];
		answer +=  "]";

		return answer;
	}



	//Private Helper
	private void doubleLength () {
		Object[] temp = new Object[q.length*2];
		for (int i=0; i<q.length; i++)
			temp[i] = q[i];
		q = temp;
	}



	//Instance Variables  
	private Object[] q;
	private int      rear = -1;  //Hand simulate enqueue for why -1
}
