//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : RPN Calculator
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  Carnegie Mellon University
//                  5000 Forbes Avenue
//                  Pittsburgh, PA 15213-3891
//                  e-mail: pattis@cs.cmu.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   This program implements a Reverse Polish Notation calculator using
// general (Object) stack class. Notice the use of the Integer and Boolean
// wrapper classes, the instanceof operator, and casting (FROM the generic
// stack, but not TO the generic stack), because primitives (int,boolean)
// cannot be used with this class.
//
// The rules for RPN calculation
//   1) Literal        : push it onto the stack (as Integer or Boolean)
//   2) Binary Operator: pop first (right operand) and second (left operand)
//                       values off the stack; check the types, and apply
//                       the operator and push the result back on the stack.
// In a well formed RPN expression, one value should remain on the stack:
// the answer. Notice how this is checked, and how failure popping the
// stack is handled (via try/catch of an exception). 
//
// Known Bugs     : None
//
// Future Plans   : Show toProcess and remaining tokens on error
//
// Program History:
//   9/28/01: R. Pattis - Operational in Java
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


import edu.cmu.cs.pattis.cs151xx.Prompt;
import edu.cmu.cs.pattis.cs151xx.SimpleStack;

import java.util.StringTokenizer;



public class RelationalLogicalApplication {


	public static void main(String[] args)
	{
    //Construct object to test
    
		SimpleStack operands = new SimpleStack();
	  
	  
    //Read-Evaluate Loop
	  for (;;)
	    try {
	      operands.makeEmpty();  //Guarantee for each iteration
	      
		    StringTokenizer rpnTokens = new StringTokenizer(Prompt.forString("\n\nEnter RPN Expression"));
		    
		    for (;rpnTokens.hasMoreTokens();) {
		      String toProcess = rpnTokens.nextToken();
		      
          try {
            //Try: + - * /
	          if (toProcess.equals("+")) {
	            int rightOp = ((Integer)operands.pop()).intValue();
	            int leftOp  = ((Integer)operands.pop()).intValue();
	            operands.push(new Integer(leftOp + rightOp));
	          }
	          
	          else if (toProcess.equals("-")) {
	            int rightOp = ((Integer)operands.pop()).intValue();
	            int leftOp  = ((Integer)operands.pop()).intValue();
	            operands.push(new Integer(leftOp - rightOp));
	          }
	          
	          else if (toProcess.equals("*")) {
	            int rightOp = ((Integer)operands.pop()).intValue();
	            int leftOp  = ((Integer)operands.pop()).intValue();
	            operands.push(new Integer(leftOp * rightOp));
	          }
	          
	          else if (toProcess.equals("/")) {
	            int rightOp = ((Integer)operands.pop()).intValue();
	            int leftOp  = ((Integer)operands.pop()).intValue();
	            operands.push(new Integer(leftOp / rightOp));
	          }
	          
	          //Try: < <= == != >= >
	          else if (toProcess.equals("<")) {
	            int rightOp = ((Integer)operands.pop()).intValue();
	            int leftOp  = ((Integer)operands.pop()).intValue();
	            operands.push(new Boolean(leftOp < rightOp));
	          }
	          
	          else if (toProcess.equals("<=")) {
	            int rightOp = ((Integer)operands.pop()).intValue();
	            int leftOp  = ((Integer)operands.pop()).intValue();
	            operands.push(new Boolean(leftOp <= rightOp));
	          }
	          			          
	          else if (toProcess.equals("==")) {
	            int rightOp = ((Integer)operands.pop()).intValue();
	            int leftOp  = ((Integer)operands.pop()).intValue();
	            operands.push(new Boolean(leftOp == rightOp));
	          }
	          
	          else if (toProcess.equals("!=")) {
	            int rightOp = ((Integer)operands.pop()).intValue();
	            int leftOp  = ((Integer)operands.pop()).intValue();
	            operands.push(new Boolean(leftOp != rightOp));
	          }
	          
	          else if (toProcess.equals(">=")) {
	            int rightOp = ((Integer)operands.pop()).intValue();
	            int leftOp  = ((Integer)operands.pop()).intValue();
	            operands.push(new Boolean(leftOp >= rightOp));
	          }
	          
	          else if (toProcess.equals(">")) {
	            int rightOp = ((Integer)operands.pop()).intValue();
	            int leftOp  = ((Integer)operands.pop()).intValue();
	            operands.push(new Boolean(leftOp > rightOp));
	          }
	          
	          //Try: ! (a unary operator) && and ||
	          else if (toProcess.equals("!")) {
	            boolean rightOp = ((Boolean)operands.pop()).booleanValue();
	            operands.push(new Boolean(!rightOp));
	          }
	          
	          else if (toProcess.equals("&&")) {
	            boolean rightOp = ((Boolean)operands.pop()).booleanValue();
	            boolean leftOp  = ((Boolean)operands.pop()).booleanValue();
	            operands.push(new Boolean(leftOp && rightOp));
	          }
	          
	          else if (toProcess.equals("||")) {
	            boolean rightOp = ((Boolean)operands.pop()).booleanValue();
	            boolean leftOp  = ((Boolean)operands.pop()).booleanValue();
	            operands.push(new Boolean(leftOp || rightOp));
	          }
	          
	          //Try: Operand
	          else
	            try {
                if ( toProcess.equals("true") || toProcess.equals("false") )
                  operands.push( new Boolean(toProcess.equals("true")) );
                else
                  operands.push( new Integer(Integer.parseInt(toProcess)) );
              }catch (NumberFormatException nfe)
                {throw new Exception("Expression Malformed: unknown token = " + toProcess);}
         
          }catch (ClassCastException e)
            {throw new Exception("Expression malformed: attempt cast int->boolean or boolean->int failed");}
		    }
		    
		    
		    if (operands.getSize() == 1)
		      System.out.println("Answer = " + operands.pop());
		    else
		      System.out.println("Expression malformed: resulting stack size ("+operands.getSize()+") not 1");
		       
		      
	  }catch (Exception e) {e.printStackTrace();}



  }
  
  
}
