//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : RPN Calculator
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  Carnegie Mellon University
//                  5000 Forbes Avenue
//                  Pittsburgh, PA 15213-3891
//                  e-mail: pattis@cs.cmu.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   This program implements a Reverse Polish Notation calculator using
// general (Object) stack class. Notice the use of the Integer wrapper
// class and casting (from the generic stack, but not to the generic
// stack), because primitives (int) cannot be used with this class.
//
// The rules for RPN calculation
//   1) Integer        : push it onto the stack
//   2) Binary Operator: pop first (right operand) and second (left operand)
//                       values off the stack; apply the operator and push
//                       the result back on the stack.
// In a well formed RPN expression, one value should remain on the stack:
// the answer. Notice how this is checked, and how failure popping the
// stack is handled (via try/catch of an exception). 
//
// Known Bugs     : None
//
// Future Plans   : Show toProcess and remaining tokens on error
//                  Convert to use BigInteger (easy; it is a class!)
//                  See/Use BigApplication.java, in this folder
//
// Program History:
//   9/28/01: R. Pattis - Operational in Java
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


import edu.cmu.cs.pattis.cs151xx.Prompt;
import edu.cmu.cs.pattis.cs151xx.SimpleStack;

import java.util.StringTokenizer;



public class Application {


	public static void main(String[] args)
	{
    //Construct object to test
    
	  SimpleStack operands = new SimpleStack();
	  
	  
	  //Read-Evaluate Loop
	  for (;;)
	    try {
	      operands.makeEmpty();  //Guarantee for each iteration
	      
		    StringTokenizer rpnTokens = new StringTokenizer(Prompt.forString("\n\nEnter RPN Expression"));
		    
		    for (;rpnTokens.hasMoreTokens();) {
		      String toProcess = rpnTokens.nextToken();
		      
		      if ("+-*/".indexOf(toProcess.charAt(0)) != -1) {
		        //Try to process as an operator
          	int rightOp, leftOp;
	          try {
	            rightOp = ((Integer)operands.pop()).intValue();
	            leftOp  = ((Integer)operands.pop()).intValue();
	          }catch(Exception e) {throw new Exception("Expression malformed: attempt to pop empty stack");}
	          
	          if (toProcess.charAt(0) == '+')
	            operands.push(new Integer(leftOp + rightOp));
	          
	          else if  (toProcess.charAt(0) == '-')
	            operands.push(new Integer(leftOp - rightOp));
	          
	          else if  (toProcess.charAt(0) == '*')
	            operands.push(new Integer(leftOp * rightOp));
	          
	          else if  (toProcess.charAt(0) == '/')
	            operands.push(new Integer(leftOp / rightOp));
	        }else
	          //Try to process as an operand
		        try {
		          operands.push(new Integer(Integer.parseInt(toProcess)));
		        }catch (NumberFormatException nfe)
		          {throw new Exception("Expression Malformed: unknown token = " + toProcess);}
		        
		    }
		    
		    
		    if (operands.getSize() == 1)
		      System.out.println("Answer = " + operands.pop());
		    else
		      System.out.println("Expression malformed: resulting stack size ("+operands.getSize()+") not 1");
		       
		      
	  }catch (Exception e) {e.printStackTrace();}



  }
  
  
}
