//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : DiceEnsemble Driver
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  University of California, Irvine
//                  Irvine, CA 92617-3435
//                  e-mail: pattis@ics.uci.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   This program implements a driver for the dDiceEnsemble class.
// Most of its menu selections allow the user to call the individual
// methods declared in this class (both mutators and accessors) on an
// object that it constructs. Other menu items perform combinations of
// these methods. In this way, programmers can learn about this class
// by experimenting with its methods.
//
//   If you run this program under the debugger, you can see how the
// instance variables of the dice object change when its mutator methods
// are called.
//
// Known Bugs     : None
//
// Future Plans   : None
//
// Program History:
//   9/11/01: R. Pattis - Operational in Java
//   7/28/04: R. Pattis - Revised to include new getPips method
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


//Imports for my classes (which must be added to the project)

import edu.uci.ics.pattis.introlib.Prompt;
import edu.uci.ics.pattis.introlib.DiceEnsemble;



public class Application {


  //Present menu and get user's choice
  
  private static char menuPrompt (DiceEnsemble d) {
    System.out.println("\n\n");
    System.out.println("Accessors                  Mutator      General");
    System.out.println("  n - number in ensemble     r - roll     m - multiple roll");
    System.out.println("  s - sides per dice                      a - alter ensemble");
    System.out.println("  p - pips                                q = quit");
    System.out.println("  P - pip sum");
    System.out.println("  = - all dice have same pips");
    System.out.println("  c - count of # rolls");
    System.out.println("  t - toString");
    
    return Prompt.forChar("\nEnter Command","nspP=ctrmaq");
  }
  
  
  
  ////////////////
  //Driver Program
  ////////////////
  
	public static void main(String[] args) {
    //Prompt for construction arguments
	  int numDice   = Prompt.forInt("Enter initial # of dice in ensemble");
	  int numSides  = Prompt.forInt("Enter initial # of sides per die   ");

    //Construct object to test
	  DiceEnsemble dice = new DiceEnsemble(numDice,numSides);
	  
	  //Test dice object using any method
	  for (;;)
	    try {
  	    char selection = menuPrompt(dice);
  	    
        if (selection == 'n')
          System.out.println("  Number of dice in ensemble = " + dice.getNumberOfDice());
          
        else if (selection == 's')
          System.out.println("  Number sides per die = " + dice.getSidesPerDie());
       
        else if (selection == 'p') {
          int dieIndex = Prompt.forInt("Enter index of die to return pips");
          System.out.println("  Pips on all die #"+dieIndex+" = " + dice.getPips(dieIndex));
        }

        else if (selection == 'P')
          System.out.println("  Sum of pips on all dice = " + dice.getPipSum());

        else if (selection == '=')
          System.out.println("  Do all dice show the same pips = " + dice.allSame());

        else if (selection == 'c')
          System.out.println("  Count of rolls of ensemble = " + dice.getRollCount());
          
        else if (selection == 't')
          System.out.println("  toString = " + dice);   //or explicitly as dice.toString
          
        else if (selection == 'r') {
          dice.roll();
          System.out.println("  Dice rolled; new pip sum = " + dice.getPipSum());
        }
          
        else if (selection == 'm') {
          //roll ensemble specfied number of times and report the pip sums each time
  	      int toRoll = Prompt.forInt("\nEnter # of times to roll");
  	      System.out.print("  Pip sums = ");
  	      for (int roll=1; roll<=toRoll; roll++) {
  	        dice.roll();
  	        System.out.print(dice.getPipSum()+" ");
  	      }
  	      System.out.println("\n");
        }
          
        else if (selection == 'a') {
          //dice refers to a newly constructed object (the old one is gone)
  	      int newNumDice   = Prompt.forInt("  Enter new # of dice in ensemble");
  	      int newNumSides  = Prompt.forInt("  Enter new # of sides per die   ");
  	      dice = new DiceEnsemble(newNumDice,newNumSides);
  	    }
  	    
        else if (selection == 'q') {
          System.out.println("\n\nUser terminated driver by selecting q");
          break;
        }
        
        else
          System.out.println("\""+selection+"\" is unknown command");
          
	   }catch(Exception e) {
	     System.out.println("  Exception Caught/Handled: "+e.getMessage());
	   }

  }
}
