//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : Craps Statistics
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  University of California, Irvine
//                  Irvine, CA 92617-3435
//                  e-mail: pattis@ics.uci.edu
//
// Maintainer     : Author
//
//
// Description:
//
//    Craps prompts the user to enter the number of games to play. It then
//  plays (simulates) that many games of craps, keeping the win/loss
//  information. At the end, it displays these statistics.
//
//    Craps is a dice game. The thrower loses if he/she immediately rolls a 2
//  (snake eyes), 3, or 12 (box cars). The thrower wins if he/she immediately
//  rolls a 7 or 11. If the thrower does not immediately win or lose, the number
//  thrown becomes the "point". Afterwards, the thrower tries to make his/her
//  point by rolling that same value again (and winning) before rolling a 7
//  (and losing). When trying to make his/her point, the thrower keeps rolling
//  if he/she rolls any number other than the point or 7.
//
//    This version of Craps Statistics uses the DiceEnsemble and Timer classes
//  to create objects that reduce the complexity of the code while increasing
//  the information it computes. Note that because dice.roll() returns the
//  dice ensemble, we can write the single declaration
//    int roll = dice.roll().getPipSum();
//  instead of having to write two statements (if dice.roll() were void)
//    dice.roll();
//    int roll = dice.getPipSum();
//
// Known Bugs     : None
//
// Future Plans   : None
//
// Program History:
//   8/ 8/00: R. Pattis - Operational in C++
//   5/15/01: R. Pattis - Translated to Java
//   5/16/01: R. Pattis - Changed identifiers to conform to Java style
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////




//Imports for my classes (which must be added to the project)

import edu.uci.ics.pattis.introlib.Prompt;
import edu.uci.ics.pattis.introlib.DiceEnsemble;
import edu.uci.ics.pattis.introlib.Timer;



public class Application {


	public static void main (String[] args)	{
		int winCount   = 0;             	          //Win/Lose/Dice Statistics
		int loseCount  = 0;

		DiceEnsemble dice     = new DiceEnsemble(2/*dice*/,6/*sides*/);
		Timer        gameTime = new Timer();

		int gamesToPlay = Prompt.forInt("Enter # of games to play");

		gameTime.start();
		for(int game=1;game<=gamesToPlay;game++) {  //Each iteration plays one game

			int firstRoll = dice.roll().getPipSum();	//Roll the dice and record their pip sum

			//Based on firstRoll, decide how to continue:
			//  immediate win/loss or trying to make point
			if (firstRoll == 7 || firstRoll == 11)
				winCount++;								      				//Win on the first roll with 7 or 11

			else if (firstRoll == 2 || firstRoll == 3 || firstRoll == 12)
				loseCount++;				                    //Lose on the first roll with 2, 3, or 12

			else {                                    //Try to make the point as the game continues
				int point = firstRoll;        					//point will never store 7, 11, 2, 3, or 12

				for (;;) {         					    	  		//Roll until roll point (win) or 7 (lose)
					int roll = dice.roll().getPipSum();

					if (roll == point) {					      	//If made the point first
						winCount++;			  						      //...win and this game is over
						break;
					}else if (roll == 7) {					      //If roll a 7 first
						loseCount++;		  						      //...lose and this game is over
						break; 
					}
				}
			}

		}
		gameTime.stop();


		//Display Statistics

		System.out.println("  Raw Wins/Lose = " + winCount + "/" + loseCount);
		System.out.println("  % Wins/Lose   = " + 100.0*winCount/(winCount+loseCount)
				+ "/" + 100.0*loseCount/(winCount+loseCount));
		System.out.println();

		System.out.println("  Dice Thrown   = " + dice.getRollCount());
		System.out.println("  Avg Dice/game = " + (double)dice.getRollCount()/(double)gamesToPlay);
		System.out.println();

		System.out.println("  Elapsed Time  = " + gameTime.getElapsed() + " seconds");
		System.out.println("  Speed         = " + (int)(gamesToPlay/gameTime.getElapsed()) + " games/second");
	}
}
