//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : Array Demonstation
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  University of California, Irvine
//                  Irvine, CA 92617-3435
//                  e-mail: pattis@ics.uci.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   This program shows how to declare, initialize, and manipulate a simple
// array of int values using a variety of for loops. It would be an excellent
// idea to hand simulate a few of them (especially the ones labelled
// "non-standard") to see how the for control structure and array data
// structure work together. Observing this code execute under control of
// the debugger would also be an excellent idea.
//
// Known Bugs     : None
//
// Future Plans   : None
//
// Program History:
//   6/07/01: R. Pattis - Operational for 15-100
//   9/25/01: R. Pattis - Extended and commented further
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


import edu.uci.ics.pattis.introlib.Prompt;
import edu.uci.ics.pattis.introlib.TypedBufferReader;

import java.io.EOFException;



public class Application {

	public static void main(String[] args)
	{
    //Prompt user for length of array and construct an object of that
    //  length (using the special array constructor) and store a
    //  reference to it in a
    //Try entering a negative length once and obserer what happens
    //Try entering a 0 length once and obserer what happens
    int   howBig = Prompt.forInt("Enter length for the array");
    int[] a      = new int[howBig];
    
    //The array is declared to have indexes from 0 to a.length-1
    //So if length is 10, the 10 indexes go from 0 to 9; this
    //  kind of indexing (starting at 0, not 1) takes some getting used
    //  to and is the source of many array problems
    
    
    //Each array object has an instance variable (public final int)
    //  length that stores the length of the array, specified when it was
    //  constructed (and unchangable)
    //If you want, uncomment the next line of code and execute the
    //  program to see what problem it is guaranteed to cause
    
    //a[a.length] = 0;
    
    
    //Prompt the user to store a value at each index in the object
    //Note standard for loop
    System.out.println();
    for (int i=0; i<a.length; i++)
      a[i] = Prompt.forInt("Enter value for ["+i+"]");
     
    
    
    //Compute/print the sum of all the array values  
    //Note standard for loop
    System.out.println();
    int sum = 0;
    for (int i=0; i<a.length; i++)
      sum += a[i];
    System.out.println("Sum = " + sum);
    
    
    
    //Print out the members stored in each index in the array
    //  ended by spaces 
    //Note standard for loop
    System.out.print("\nSpace Ended Array contains ("+a.length+"): ");  
    for (int i=0; i<a.length; i++)
      System.out.print(a[i]+" ");
    System.out.println();
     
    
    
    //Print out the members stored in each index in the array
    //  separated by commas 
    //Note standard for loop
    System.out.print("\nComma Separated Array contains ("+a.length+"): ");  
    for (int i=0; i<a.length; i++)
      System.out.print( a[i]+(i<a.length-1?",":"\n") );
     
    
    
    //Compute/print the maximum of all the array values  
    //Note non-standard for loop; index 0 is processed before the loop
    int max = a[0];
    for (int i=1; i<a.length; i++)
      if (a[i]>max)
        max = a[i];
    System.out.println("\nMax = " + max);
    
    
    
    //Compute/print the maximum of all the array values  
    //Note standard for loop
    max = Integer.MIN_VALUE;          //max declared above; just reinitialize it
    for (int i=0; i<a.length; i++)
      if (a[i]>max)
        max = a[i];
    System.out.println("\nMax = " + max);
    
    
    
    
    //Compute/print whether all the array values are 0  
    //Note standard for loop
    boolean all0 = true;
    for (int i=0; i<a.length; i++)
      if (a[i] != 0) {
        all0 = false;   //We know the answer
        break;          //Don't even bother looking at any more values
      }
    System.out.println("\nAll 0 = " + all0);
    
    
    
    //Compute/print whether the array values get bigger (from index 0 onward)  
    //Note non-standard for loop (see upper bound in continuation test)
    boolean increasingOrder = true;
    for (int i=0; i<a.length-1; i++)
      if (a[i]>a[i+1]) {
        increasingOrder = false;
        break;
      }
    System.out.println("\nIncreasing = " + increasingOrder);
    
    

    //We can make "a" refer to a different array object; notice the special
    //  form for array initialization used here, which requires no
    //  explicit length inside the []: Java infers the length from the
    //  number of values in {} 
    a = new int[]{1,2,3,4,5};
    System.out.print("\nNew Array contains ("+a.length+"): ");  
    for (int i=0; i<a.length; i++)
      System.out.print(a[i]+" ");
    System.out.println();
     
    
    
    //We can easily load a file into an array, but we need to keep track
    //  of how much of the array is actually used.
    //What do you think would happen if the file contained more values
    //  than could fit in the array?
    //Try the input.txt and badinput.txt files when prompted here
    //  badinput.txt has all Strings, but too manh of them for s
    String[] s = new String[8];
    TypedBufferReader tbr = new TypedBufferReader("\nEnter name for file of String");
    int sUsed = 0;
    for(;;)
      try {
        s[sUsed] = tbr.readString();  //or combined: s[sUsed++] = ...
        sUsed++;
      }catch (EOFException eofee) {break;}
    tbr.close();
    
    
    //Note use of s.length in following code (constrast to below)
    System.out.print("\nString Array (using length) contains ("+s.length+"): ");  
    for (int i=0; i<s.length; i++)
      System.out.print( s[i]+(i<s.length-1?",":"\n") );

    //Note use of bUsed in the following code, not b.length (contrast to above)
    System.out.print("\nString Array (using sUsed) contains ("+sUsed+"): ");  
    for (int i=0; i<sUsed; i++)
      System.out.print( s[i]+(i<sUsed-1?",":"\n") );
	}


}
