import edu.cmu.cs.pattis.cs151xx.orderedCollections.*;

import edu.cmu.cs.pattis.cs151xx.Prompt;
import edu.cmu.cs.pattis.cs151xx.Timer;

import java.util.Comparator;
import java.util.Collection;
import java.util.Iterator;


public class Application {
	
	
public static class StringByValue implements Comparator<String> {
  public int compare (String a, String b) {
    return -(a).compareTo(b);
  }
}

public static class IntByValue implements Comparator<Integer> {
  public int compare (Integer a, Integer b) {
    return (a).compareTo(b);
  }
}

  //Present menu and get user's choice
  
  private static char menuPrompt ()
  {
    System.out.println("\n\nAccessors          Mutator         General");
    System.out.println("  e - isEmpty        c - clear       f - flush: next until isEmpty");
    System.out.println("  s - size           a - add         T - time test");
    System.out.println("  p - peek           r - remove      q - quit");
    System.out.println("  t - toString");
    System.out.println("  A - toArray(s)");
    System.out.println("  C - toCollection");
    
    return Prompt.forChar("\nEnter Command","esptACcarfTq");
  }
  
  
  
  private static Class getClass(String[] possibilities)
  { 
    for (;;) try {
      String className = Prompt.forString("Enter Class to Test",possibilities);
  	  Class c = Class.forName("edu.cmu.cs.pattis.cs151xx.orderedCollections."+className);
  	  return c;
    }catch(Exception e) {
       System.out.println("  No such class");
    }
  }
  
  
  private static OrderedCollection getCollection(Class cl, Comparator<?> comparator) 
    throws Exception
  {
  	  if (cl.getName().indexOf("PriorityQueue") != -1)
  	    return (OrderedCollection)(cl.getConstructor(new Class[]{Class.forName("java.util.Comparator")})).
  	        newInstance(new Object[]{comparator});
  	  else
  	    return (OrderedCollection)(cl.getConstructor((Class[])null)).newInstance((Object[])null);
  }
  
  
  
  ////////////////
  //Driver Program
  ////////////////
  
	@SuppressWarnings("unchecked")
	public static void main(String[] args) throws Exception
	{
    //Construct object to test
    Class classToTest = getClass(new String[]
                                {"ArrayStack","LinkedStack","ArrayQueue","LinkedQueue",
                                 "ArrayPriorityQueue","ArrayUnsortedPriorityQueue"});
    OrderedCollection<String> o = (OrderedCollection<String>)getCollection(classToTest,new StringByValue()); 
	  
	  //Test object using any method
	  for (;;) try {

	    char selection = menuPrompt();
	    
      if (selection == 'e')
        System.out.println("  isEmpty = " + o.isEmpty());
        
      else if (selection == 's')
        System.out.println("  size = " + o.size());
     
      else if (selection == 'p')
        System.out.println("  peek = " + o.peek());

      else if (selection == 't')
        System.out.println("  toString = " + o.toString());

      else if (selection == 'A') {
        Object [] a = o.toArray();
        System.out.println("  toArray() = ");
        for (int i=0; i<a.length; i++)
          System.out.println("    " + a[i]);
          
        a = o.toArray(new String[o.size()]);
        System.out.println("toArray(Object[] a) = ");
        for (int i=0; i<a.length; i++)
          System.out.println("    " + a[i]);
      }     
          
      else if (selection == 'C') {
        Collection c = o.toCollection();
        System.out.println("  toCollection() = ");
        for (Iterator i=c.iterator(); i.hasNext(); )
          System.out.println("    " + i.next());
      }     
          
      else if (selection == 'c')
        o.clear();
        
      else if (selection == 'a')
        System.out.print("  add = " + o.add(Prompt.forString("  Enter String to add")));
        
      else if (selection == 'r')
        System.out.println("  remove = " + o.remove());
        
      else if (selection == 'f')
        for(;!o.isEmpty();)
	        System.out.println("  next = " + o.remove());
	    
      else if (selection == 'T') {
        int numToAddRemove = Prompt.forInt("Enter # to add then remove");
        OrderedCollection<Integer> tt = (OrderedCollection<Integer>)getCollection(classToTest, new IntByValue()); 
        Timer t = new Timer();
        Integer[] values = new Integer[numToAddRemove];
        for (int i=0; i<numToAddRemove; i++)
          values[i]= new Integer((int)(10000*Math.random()));
        System.out.println("Starting Test");
        t.start();
        for (int i=0; i<numToAddRemove; i++)
          tt.add(values[i]);
        for (int i=0; i<numToAddRemove; i++)
          tt.remove();
        t.stop();
        System.out.println("Ending Test");
        System.out.println("Time = " + t.getElapsed());
        
      }else if (selection == 'q')
        break;
      
      else
        System.out.println("\""+selection+"\" is unknown command");

		}catch (Exception e) {
	    e.printStackTrace();
	  }
  }
  
  
}
