//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : Directory Lister
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  Carnegie Mellon University
//                  5000 Forbes Avenue
//                  Pittsburgh, PA 15213-3891
//                  e-mail: pattis@cs.cmu.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   Thie program prompts the user to enter the name of a directory (typically a
// folder, but may also be just a file). Then it lists, one after another, all the
// folders and files it contains (indented to show inclusion).
//
//   This program illustrates recursion (because directories are
// defined recursively).
//
// Known Bugs     : None
//
// Future Plans   : Remove original directory specification from print. 
//
// Program History:
//  12/31/01: R. Pattis - Operational for 15-111
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


import edu.cmu.cs.pattis.cs151xx.Prompt;
import java.io.File;


public class Application {

  //Static variables manipulated by main and travers
  
  private static int totalFolders, totalFiles, totalBytes; 



	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	//
	//  If dirStart is a file (not a directory), accumulate statistics.
	//  If dirStart is a folder, accumulate statistics and recursively
	//    traverse all its children (which are also files or folders).
	//  The list() method returns an array sorted (ignoring case).
	//

  public static void traverse (File dirStart, String indent)
  {
    if (!dirStart.isDirectory()) {
      System.out.println(indent + dirStart +" ("+dirStart.length()+")");
      totalFiles++;
      totalBytes += dirStart.length();
    }else{
      System.out.println(indent + dirStart + " (folder)");
      totalFolders++;
      String childDir[] = dirStart.list();
      //Recursive traversal
      for (int i=0; i<childDir.length; i++)
        traverse(new File (dirStart +"\\" + childDir[i]),  indent+"  ");      
    }
      
  }  




	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	//
	//  Repeatedly prompt the user for a directory, and then
	//  traverse it, ultimately printing all accumulated statistics
	//

	public static void main (String[] args)
	{
	        
	  try {
	    for (;;) {
	      //Reset statistics
	      totalFolders = totalFiles = totalBytes = 0;

	      //Establish Directory (Folder or File)
	      String dirRoot   = Prompt.forString("\n\nEnter root directory (drag&drop)");
	      File   directory = new File(dirRoot);
	       
	      //Recursively traverse directory (initially with no indentation)
	      traverse(directory,"");
	       
			  //Display Accumuated Statistics
			  System.out.println("\n Folders Examined   = " + totalFolders);
			  System.out.println(" Files   Examined   = " + totalFiles);
			  System.out.println(" Total File Storage = " + totalBytes + " bytes");
		  }
		}catch (Exception e) {
      e.printStackTrace();
      System.out.println("main method in Application class terminating");
      System.exit(0);  
    }
  }
}