//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Program        : Cross Reference
//
// Author         : Richard E. Pattis
//                  Computer Science Department
//                  Carnegie Mellon University
//                  5000 Forbes Avenue
//                  Pittsburgh, PA 15213-3891
//                  e-mail: pattis@cs.cmu.edu
//
// Maintainer     : Author
//
//
// Description:
//
//   This program prompts for a file name, reads each of the words it contains
// (stripping out punctuation), and produces a cross reference (or concordance)
// of the text: it prints every word in the text (sorted alphabetically, case
// insensitive), followed by all the lines that it appears on (each line number
// appears just once for a word, even if that word appears multiple times on the
// line).
//
// This program is written with the Map and Listcollection classes. The data
// structure is modeled by: Map[String] -> List[Integer*].
//
//   Note this program uses Java 1.5 generic collections. By doing this correctly,
// there will be no Eclipse warnings (so there will also be no chance of a throwing
// a ClassCastException during executions) See Application for a non-generic translation.
//
// Known Bugs     : None
//
// Future Plans   : None
//
// Program History:
//  10/08/04: R. Pattis - Operational for 15-200
//  10/13/06: R. Pattis - Translate to use Java 1.5 generics
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


import edu.cmu.cs.pattis.cs151xx.Timer;
import edu.cmu.cs.pattis.cs151xx.TypedBufferReader;
import edu.cmu.cs.pattis.cs151xx.TypedBufferWriter;

import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Collections;

import java.util.Comparator;
import java.io.EOFException;



public class GenericApplication
{

	public static void main(String[] args)
	{
	  //Get input/output files; input file uses white-space and punctuation
	  //as token-separators
    TypedBufferReader input    = new TypedBufferReader("Enter name of file to XREF",
                                                       " \":?&/,.;+-*/()=!{}<>[]");
    TypedBufferWriter output   = new TypedBufferWriter(input.getFileName()+".xref.txt");;


    //Build the cross reference by reading all the words in the file
    //(timing this process)
    Map<String,List<Integer>> xref = new HashMap<String,List<Integer>>();                 //Generic
    Timer t = new Timer();
    t.start();
    for (;;)
      try {
        String         word  = input.readString();
        List<Integer>  lines = xref.get(word);                                           //Generic
        if (lines == null) {
          lines = new ArrayList<Integer>();//xref.put(word,lines=new ArrayList<Integer>());//Generic
          xref.put(word,lines);
        }
        
        //word is in map; lines refers to its associated list;  add current line,
        //if not already in the list (if it is in, it must be in the last index)
        Integer newLine = new Integer(input.getLineNumber());
        if (lines.isEmpty() || !lines.get(lines.size()-1).equals(newLine))
          lines.add(newLine);
      } catch (EOFException eofe) {break;}
    t.stop();
    input.close();



    //Sort the words (keys of the map) alphabetically
    List<String> allWords = new ArrayList<String>(xref.keySet());                        //Generic
    Collections.sort(
    		        allWords,
                new Comparator<String>() {                                               //Generic
	                public int compare (String o1, String o2)                              //Note: Object->String
	                {return o1.compareToIgnoreCase(o2);}                                   //Note: no casting
               });
    
    //Print the cross references in a file (sorted alphabetically by word)
    int lineEntries = 0;
    for (String w : allWords) {                                                          //Generic for loop    
      List<Integer> references = xref.get(w);                                            //Generic
      lineEntries += references.size();
      output.print(w + "\n  ");
      for (Iterator i = references.iterator(); i.hasNext(); /*see body*/)                //Can't us Generic for,
        output.print( i.next() + (i.hasNext() ? ", " : "\n\n"));                         //  because of use of i.hasNext()     
    }
    output.close();
      

    //Final output to the console: time and file name to check
    System.out.println("Processed " + xref.size() + " words and "
                       + lineEntries + " line entries for an average of "
                       + lineEntries/xref.size() + " lines/word");
    System.out.println("Time for processing = " + t.getElapsed() + " seconds");
    System.out.println("See " + output.getFileName());
  }	
}