/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.BlankArea;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MouseMotionEventDemo
extends JPanel
implements MouseMotionListener {
    BlankArea blankArea = new BlankArea(Color.YELLOW);
    JTextArea textArea;
    static final String NEWLINE = System.getProperty("line.separator");

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MouseMotionEventDemo.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("MouseMotionEventDemo");
        frame.setDefaultCloseOperation(3);
        MouseMotionEventDemo newContentPane = new MouseMotionEventDemo();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public MouseMotionEventDemo() {
        super(new GridLayout(0, 1));
        this.add(this.blankArea);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.textArea, 22, 30);
        scrollPane.setPreferredSize(new Dimension(200, 75));
        this.add(scrollPane);
        this.blankArea.addMouseMotionListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(new Dimension(450, 450));
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    void eventOutput(String eventDescription, MouseEvent e) {
        this.textArea.append(eventDescription + " (" + e.getX() + "," + e.getY() + ")" + " detected on " + e.getComponent().getClass().getName() + NEWLINE);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    public void mouseMoved(MouseEvent e) {
        this.eventOutput("Mouse moved", e);
    }

    public void mouseDragged(MouseEvent e) {
        this.eventOutput("Mouse dragged", e);
    }
}

