/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.ics163.gpsdrawupload;

import edu.uci.ics.ics163.gpsdrawupload.Haversine;
import edu.uci.ics.ics163.gpsdrawupload.Point;
import edu.uci.ics.ics163.gpsdrawupload.RESTRequest;
import edu.uci.ics.ics163.gpsdrawupload.StrokeManagerCallback;
import edu.uci.ics.ics163.gpsdrawupload.UploadCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StrokeManager
implements StrokeManagerCallback {
    static final int MAX_CHUNK_SIZE = 250;
    static final double FILTER_DIST = 10.0;
    Object strokeLock = new Object();
    Map<String, Set<Point>> strokes = new HashMap<String, Set<Point>>();
    Map<String, Color> strokeColors = new HashMap<String, Color>();
    UploadCallback callback;

    public StrokeManager() {
        this(null);
    }

    public StrokeManager(UploadCallback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeColor(String strokeName, int r, int g, int b) {
        Object object = this.strokeLock;
        synchronized (object) {
            Color color = new Color(r, g, b);
            this.strokeColors.put(strokeName, color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(String strokeName, Point point) {
        Object object = this.strokeLock;
        synchronized (object) {
            Set<Point> set = this.strokes.get(strokeName);
            if (set == null) {
                set = new HashSet<Point>();
            }
            if (point != null) {
                set.add(point);
            }
            this.strokes.put(strokeName, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoints(String strokeName, Set<Point> points) {
        Object object = this.strokeLock;
        synchronized (object) {
            Set<Point> set = this.strokes.get(strokeName);
            if (set == null) {
                set = new HashSet<Point>();
            }
            if (points != null) {
                set.addAll(points);
            }
            this.strokes.put(strokeName, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePoint(String strokeName, Point point) {
        Object object = this.strokeLock;
        synchronized (object) {
            Set<Point> set = this.strokes.remove(strokeName);
            if (set != null) {
                set.remove(point);
                if (set.size() > 0) {
                    this.strokes.put(strokeName, set);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePoints(String strokeName, Set<Point> points) {
        Object object = this.strokeLock;
        synchronized (object) {
            Set<Point> set = this.strokes.remove(strokeName);
            if (set != null) {
                set.removeAll(points);
                if (set.size() > 0) {
                    this.strokes.put(strokeName, set);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Set<Point>> removeAllStrokes() {
        Object object = this.strokeLock;
        synchronized (object) {
            Map<String, Set<Point>> ret = this.strokes;
            this.strokes = new HashMap<String, Set<Point>>();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(String group_name, String drawing_name) {
        Object object = this.strokeLock;
        synchronized (object) {
            Map<String, Set<Point>> tempstrokes = this.removeAllStrokes();
            for (Map.Entry<String, Set<Point>> stroke : tempstrokes.entrySet()) {
                ArrayList<Point> localPoints = new ArrayList<Point>();
                for (Point p : stroke.getValue()) {
                    localPoints.add(p);
                }
                Color strokeColor = this.strokeColors.get(stroke.getKey());
                if (strokeColor == null) {
                    strokeColor = new Color(0, 0, 0);
                }
                Collections.sort(localPoints);
                try {
                    while (localPoints.size() > 0) {
                        JSONObject params = new JSONObject();
                        params.put("group_name", (Object)group_name);
                        params.put("drawing_name", (Object)drawing_name);
                        params.put("stroke_name", (Object)stroke.getKey());
                        params.put("red", (Object)String.valueOf(strokeColor.r));
                        params.put("green", (Object)String.valueOf(strokeColor.g));
                        params.put("blue", (Object)String.valueOf(strokeColor.b));
                        int end = localPoints.size();
                        if (end > 250) {
                            end = 250;
                        }
                        ArrayList<Point> chunk = new ArrayList<Point>();
                        for (Point p : localPoints.subList(0, end)) {
                            chunk.add(p);
                        }
                        JSONArray jPoints = new JSONArray();
                        for (Point p : chunk) {
                            localPoints.remove(p);
                        }
                        List<Point> filteredChunk = StrokeManager.filterPoints(chunk);
                        for (Point p : filteredChunk) {
                            JSONObject point = new JSONObject();
                            point.put("time", (Object)("" + p.getTime()));
                            point.put("lat", (Object)("" + p.getLat()));
                            point.put("lng", (Object)("" + p.getLng()));
                            jPoints.put((Object)point);
                        }
                        params.put("stroke", (Object)jPoints);
                        HashSet<Point> submitUs = new HashSet<Point>();
                        for (Point p : filteredChunk) {
                            submitUs.add(p);
                        }
                        new RESTRequest(params, stroke.getKey(), submitUs, this);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static List<Point> filterPoints(List<Point> points) {
        ArrayList<Point> ret = new ArrayList<Point>();
        if (points == null) {
            return ret;
        }
        if (points.size() == 0) {
            return ret;
        }
        Point old = null;
        Point now = null;
        boolean addedLast = false;
        for (Point p : points) {
            addedLast = false;
            if (old == null) {
                old = p;
                ret.add(p);
                addedLast = true;
                continue;
            }
            now = p;
            if (Haversine.haversine(old.getLat(), old.getLng(), now.getLat(), now.getLng()) > 10.0) {
                ret.add(now);
                old = now;
                addedLast = true;
                continue;
            }
            addedLast = false;
        }
        if (!addedLast) {
            ret.add(now);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countStrokes() {
        Object object = this.strokeLock;
        synchronized (object) {
            return this.strokes.keySet().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countPoints() {
        Object object = this.strokeLock;
        synchronized (object) {
            int count = 0;
            for (Map.Entry<String, Set<Point>> s : this.strokes.entrySet()) {
                count += s.getValue().size();
            }
            return count;
        }
    }

    @Override
    public void onSuccess(String strokeId, Set<Point> points) {
        if (this.callback != null) {
            this.callback.onSuccess();
        }
    }

    @Override
    public void onFailure(String strokeId, Set<Point> points) {
        this.addPoints(strokeId, points);
        if (this.callback != null) {
            this.callback.onFailure();
        }
    }

    class Color {
        int r;
        int g;
        int b;

        Color(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

