/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.ics163.gpsdrawupload;

import java.security.InvalidParameterException;

public final class Point
implements Comparable<Point> {
    private final long time;
    private final double lat;
    private final double lng;

    public Point(long time, double lat, double lng) {
        if (time < 0L) {
            throw new InvalidParameterException("time must be greater than 0");
        }
        this.time = time;
        if (lat < -90.0 || lat > 90.0) {
            throw new InvalidParameterException("latitude must be greater than or equal to -90.0 and less than or equal to 90.0");
        }
        this.lat = lat;
        if (lng < -180.0 || lng > 180.0) {
            throw new InvalidParameterException("longitude must be greater than or equal to -180.0 and less than or equal to 180.0");
        }
        this.lng = lng;
    }

    public long getTime() {
        return this.time;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }

    @Override
    public int compareTo(Point that) {
        if (that == null) {
            return -1;
        }
        if (this.equals(that)) {
            return 0;
        }
        if (this.getTime() == that.getTime()) {
            if (this.getLat() == that.getLat()) {
                if (this.getLng() - that.getLng() > 0.0) {
                    return 1;
                }
                return -1;
            }
            if (this.getLat() - that.getLat() > 0.0) {
                return 1;
            }
            return -1;
        }
        return (int)(this.getTime() - that.getTime());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.lat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lng);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        if (Double.doubleToLongBits(this.lat) != Double.doubleToLongBits(other.lat)) {
            return false;
        }
        if (Double.doubleToLongBits(this.lng) != Double.doubleToLongBits(other.lng)) {
            return false;
        }
        return this.time == other.time;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("time:" + this.getTime());
        sb.append(",latitude:" + this.getLat());
        sb.append(",longitude:" + this.getLng());
        sb.append("]");
        return sb.toString();
    }
}

