/* Derived from softkeyboard example that ships with Android SDK 
 *  -djp3 
 */
/*
 * Copyright (C) 2008-2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

//TODO: Pick a package name 
package foo.bar.com;

import android.inputmethodservice.InputMethodService;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;

public class SoftKeyboardSkeleton extends InputMethodService{
    
	private View myView;

    /**
     * Main initialization of the input method component.  Be sure to call
     * to super class.
     */
    @Override public void onCreate() {
        Log.i("SoftKeyboardSkeleton","onCreate");
        super.onCreate();
        
        //TODO: Initialize a SensorManager
        //TODO: Define SensorEventListeners that process the sensor data
        
    }
    
    
	/**
     * This is the main point where we do our initialization of the input method
     * to begin operating on an application.  At this point we have been
     * bound to the client, and are now receiving all of the detailed information
     * about the target of our edits.
     */
    @Override public void onStartInput(EditorInfo attribute, boolean restarting) {
        Log.i("SoftKeyboardSkeleton","onStartInput updated");
        super.onStartInput(attribute, restarting);
        
        //TODO: register your SensorEventListeners with Android
    }
    
    
    /**
     * be generated.  This will be called the first time your input method
     * is displayed, and every time it needs to be re-created such as due to

     * a configuration change.
     */
    @Override public View onCreateInputView() {
        Log.i("SoftKeyboardSkeleton","onCreateInputView");
        
        myView = getLayoutInflater().inflate(R.layout.input,null);
        
        //TODO: use findViewById to initialize field variables to the UI elements that you want to update in real time
        
        return myView;
    }


    /**
     * This is called when the user is done editing a field.  We can use
     * this to reset our state.
     */
    @Override public void onFinishInput() {
        Log.i("SoftKeyboardSkeleton","onFinishInput");
        super.onFinishInput();
        
        
        //TODO: unregister your SensorEventListeners
    }
    

    /**
     * This is a convenience function that translates Java characters into Android Keycodes 
     * @param c
     * @return Android keycode
     */
    private int myTranslate(char c) {
    	switch(c){
    		case 'A':
    		case 'a': return KeyEvent.KEYCODE_A;
    		case 'B':
    		case 'b': return KeyEvent.KEYCODE_B;
    		case 'C':
    		case 'c': return KeyEvent.KEYCODE_C;
    		case 'D':
    		case 'd': return KeyEvent.KEYCODE_D;
    		case 'E':
    		case 'e': return KeyEvent.KEYCODE_E;
    		case 'F':
    		case 'f': return KeyEvent.KEYCODE_F;
    		case 'G':
    		case 'g': return KeyEvent.KEYCODE_G;
    		case 'H':
    		case 'h': return KeyEvent.KEYCODE_H;
    		case 'I':
    		case 'i': return KeyEvent.KEYCODE_I;
    		case 'J':
    		case 'j': return KeyEvent.KEYCODE_J;
    		case 'K':
    		case 'k': return KeyEvent.KEYCODE_K;
    		case 'L':
    		case 'l': return KeyEvent.KEYCODE_L;
    		case 'M':
    		case 'm': return KeyEvent.KEYCODE_M;
    		case 'N':
    		case 'n': return KeyEvent.KEYCODE_N;
    		case 'O':
    		case 'o': return KeyEvent.KEYCODE_O;
    		case 'P':
    		case 'p': return KeyEvent.KEYCODE_P;
    		case 'Q':
    		case 'q': return KeyEvent.KEYCODE_Q;
    		case 'R':
    		case 'r': return KeyEvent.KEYCODE_R;
    		case 'S':
    		case 's': return KeyEvent.KEYCODE_S;
    		case 'T':
    		case 't': return KeyEvent.KEYCODE_T;
    		case 'U':
    		case 'u': return KeyEvent.KEYCODE_U;
    		case 'V':
    		case 'v': return KeyEvent.KEYCODE_V;
    		case 'W':
    		case 'w': return KeyEvent.KEYCODE_W;
    		case 'X':
    		case 'x': return KeyEvent.KEYCODE_X;
    		case 'Y':
    		case 'y': return KeyEvent.KEYCODE_Y;
    		case 'Z':
    		case 'z': return KeyEvent.KEYCODE_Z;
    		case '0': return KeyEvent.KEYCODE_0;
    		case '!': 
    		case '1': return KeyEvent.KEYCODE_1;
    		case '2': return KeyEvent.KEYCODE_2;
    		case '3': return KeyEvent.KEYCODE_3;
    		case '4': return KeyEvent.KEYCODE_4;
    		case '5': return KeyEvent.KEYCODE_5;
    		case '6': return KeyEvent.KEYCODE_6;
    		case '7': return KeyEvent.KEYCODE_7;
    		case '8': return KeyEvent.KEYCODE_8;
    		case '9': return KeyEvent.KEYCODE_9;
    		case '\'': return KeyEvent.KEYCODE_APOSTROPHE;
    		case '.': return KeyEvent.KEYCODE_PERIOD;
    		case ',': return KeyEvent.KEYCODE_COMMA;
    		case '/':
    		case '?': return KeyEvent.KEYCODE_SLASH;
    		case ' ':
    		case '_': return KeyEvent.KEYCODE_SPACE;
    		case '~': return KeyEvent.KEYCODE_DEL;
    		default: return KeyEvent.KEYCODE_SPACE;
    	}
	}

    
    /**
     * 
     * Helper to send a key down / key up pair to the current editor.
     * @param keyEventCode, an Android keycode
     * @param shift, true if the shift key should be pressed (this is stateless, it doesn't keep the shift key down)
     */
    private void keyDownUp(int keyEventCode, boolean shift) {
        Log.i("SoftKeyboardSkeleton","keyDownUp");
        if(shift){
        	getCurrentInputConnection().sendKeyEvent( new KeyEvent(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_SHIFT_LEFT));
        	getCurrentInputConnection().sendKeyEvent( new KeyEvent(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_SHIFT_LEFT));
        }
        getCurrentInputConnection().sendKeyEvent( new KeyEvent(KeyEvent.ACTION_DOWN, keyEventCode));
        getCurrentInputConnection().sendKeyEvent( new KeyEvent(KeyEvent.ACTION_UP, keyEventCode));
    }
    
}
