/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl.tess;

import processing.opengl.tess.PriorityQ;

class PriorityQHeap
extends PriorityQ {
    PriorityQ.PQnode[] nodes = new PriorityQ.PQnode[33];
    PriorityQ.PQhandleElem[] handles;
    int size = 0;
    int max = 32;
    int freeList;
    boolean initialized;
    PriorityQ.Leq leq;

    public PriorityQHeap(PriorityQ.Leq leq) {
        int i = 0;
        while (i < this.nodes.length) {
            this.nodes[i] = new PriorityQ.PQnode();
            ++i;
        }
        this.handles = new PriorityQ.PQhandleElem[33];
        i = 0;
        while (i < this.handles.length) {
            this.handles[i] = new PriorityQ.PQhandleElem();
            ++i;
        }
        this.initialized = false;
        this.freeList = 0;
        this.leq = leq;
        this.nodes[1].handle = 1;
        this.handles[1].key = null;
    }

    void pqDeletePriorityQ() {
        this.handles = null;
        this.nodes = null;
    }

    void FloatDown(int curr) {
        PriorityQ.PQnode[] n = this.nodes;
        PriorityQ.PQhandleElem[] h = this.handles;
        int hCurr = n[curr].handle;
        while (true) {
            int child;
            if ((child = curr << 1) < this.size && PriorityQHeap.LEQ(this.leq, h[n[child + 1].handle].key, h[n[child].handle].key)) {
                ++child;
            }
            assert (child <= this.max);
            int hChild = n[child].handle;
            if (child > this.size || PriorityQHeap.LEQ(this.leq, h[hCurr].key, h[hChild].key)) break;
            n[curr].handle = hChild;
            h[hChild].node = curr;
            curr = child;
        }
        n[curr].handle = hCurr;
        h[hCurr].node = curr;
    }

    void FloatUp(int curr) {
        PriorityQ.PQnode[] n = this.nodes;
        PriorityQ.PQhandleElem[] h = this.handles;
        int hCurr = n[curr].handle;
        while (true) {
            int parent = curr >> 1;
            int hParent = n[parent].handle;
            if (parent == 0 || PriorityQHeap.LEQ(this.leq, h[hParent].key, h[hCurr].key)) break;
            n[curr].handle = hParent;
            h[hParent].node = curr;
            curr = parent;
        }
        n[curr].handle = hCurr;
        h[hCurr].node = curr;
    }

    boolean pqInit() {
        int i = this.size;
        while (i >= 1) {
            this.FloatDown(i);
            --i;
        }
        this.initialized = true;
        return true;
    }

    int pqInsert(Object keyNew) {
        int free;
        int curr;
        if ((curr = ++this.size) * 2 > this.max) {
            PriorityQ.PQnode[] saveNodes = this.nodes;
            PriorityQ.PQhandleElem[] saveHandles = this.handles;
            this.max <<= 1;
            PriorityQ.PQnode[] pqNodes = new PriorityQ.PQnode[this.max + 1];
            System.arraycopy(this.nodes, 0, pqNodes, 0, this.nodes.length);
            int i = this.nodes.length;
            while (i < pqNodes.length) {
                pqNodes[i] = new PriorityQ.PQnode();
                ++i;
            }
            this.nodes = pqNodes;
            if (this.nodes == null) {
                this.nodes = saveNodes;
                return Integer.MAX_VALUE;
            }
            PriorityQ.PQhandleElem[] pqHandles = new PriorityQ.PQhandleElem[this.max + 1];
            System.arraycopy(this.handles, 0, pqHandles, 0, this.handles.length);
            int i2 = this.handles.length;
            while (i2 < pqHandles.length) {
                pqHandles[i2] = new PriorityQ.PQhandleElem();
                ++i2;
            }
            this.handles = pqHandles;
            if (this.handles == null) {
                this.handles = saveHandles;
                return Integer.MAX_VALUE;
            }
        }
        if (this.freeList == 0) {
            free = curr;
        } else {
            free = this.freeList;
            this.freeList = this.handles[free].node;
        }
        this.nodes[curr].handle = free;
        this.handles[free].node = curr;
        this.handles[free].key = keyNew;
        if (this.initialized) {
            this.FloatUp(curr);
        }
        assert (free != Integer.MAX_VALUE);
        return free;
    }

    Object pqExtractMin() {
        PriorityQ.PQnode[] n = this.nodes;
        PriorityQ.PQhandleElem[] h = this.handles;
        int hMin = n[1].handle;
        Object min = h[hMin].key;
        if (this.size > 0) {
            n[1].handle = n[this.size].handle;
            h[n[1].handle].node = 1;
            h[hMin].key = null;
            h[hMin].node = this.freeList;
            this.freeList = hMin;
            if (--this.size > 0) {
                this.FloatDown(1);
            }
        }
        return min;
    }

    void pqDelete(int hCurr) {
        PriorityQ.PQnode[] n = this.nodes;
        PriorityQ.PQhandleElem[] h = this.handles;
        assert (hCurr >= 1 && hCurr <= this.max && h[hCurr].key != null);
        int curr = h[hCurr].node;
        n[curr].handle = n[this.size].handle;
        h[n[curr].handle].node = curr;
        if (curr <= --this.size) {
            if (curr <= 1 || PriorityQHeap.LEQ(this.leq, h[n[curr >> 1].handle].key, h[n[curr].handle].key)) {
                this.FloatDown(curr);
            } else {
                this.FloatUp(curr);
            }
        }
        h[hCurr].key = null;
        h[hCurr].node = this.freeList;
        this.freeList = hCurr;
    }

    Object pqMinimum() {
        return this.handles[this.nodes[1].handle].key;
    }

    boolean pqIsEmpty() {
        return this.size == 0;
    }
}

