/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.opengl.FrameBuffer;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;

public class Texture
implements PConstants {
    protected static final int TEX2D = 0;
    protected static final int TEXRECT = 1;
    protected static final int POINT = 2;
    protected static final int LINEAR = 3;
    protected static final int BILINEAR = 4;
    protected static final int TRILINEAR = 5;
    public int width;
    public int height;
    public int glName;
    public int glTarget;
    public int glFormat;
    public int glMinFilter;
    public int glMagFilter;
    public int glWrapS;
    public int glWrapT;
    public int glWidth;
    public int glHeight;
    protected PApplet parent;
    protected PGraphicsOpenGL pg;
    protected PGL pgl;
    protected PGL.Context context;
    protected boolean usingMipmaps;
    protected boolean usingRepeat;
    protected float maxTexcoordU;
    protected float maxTexcoordV;
    protected boolean bound;
    protected boolean invertedX;
    protected boolean invertedY;
    protected FrameBuffer tempFbo = null;
    protected boolean modified;
    protected int mx1;
    protected int my1;
    protected int mx2;
    protected int my2;
    protected Object bufferSource;
    protected LinkedList<BufferData> bufferCache = null;
    protected Method disposeBufferMethod;
    public static final int MAX_BUFFER_CACHE_SIZE = 3;

    public Texture(PApplet parent, int width, int height) {
        this(parent, width, height, new Parameters());
    }

    public Texture(PApplet parent, int width, int height, Object params) {
        this.parent = parent;
        this.pg = (PGraphicsOpenGL)parent.g;
        this.pgl = this.pg.pgl;
        this.context = this.pgl.createEmptyContext();
        this.glName = 0;
        this.init(width, height, (Parameters)params);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.glName != 0) {
                this.pg.finalizeTextureObject(this.glName, this.context.id());
            }
        }
        finally {
            super.finalize();
        }
    }

    public void init(int width, int height) {
        Parameters params = this.glName > 0 ? this.getParameters() : new Parameters();
        this.init(width, height, params);
    }

    public void init(int width, int height, Parameters params) {
        this.setParameters(params);
        this.setSize(width, height);
        this.allocate();
    }

    public void resize(int wide, int high) {
        this.release();
        Texture tex = new Texture(this.parent, wide, high, this.getParameters());
        tex.set(this);
        this.copyObject(tex);
        this.tempFbo = null;
    }

    public boolean available() {
        return this.glName > 0;
    }

    public void set(PImage img) {
        Texture tex = (Texture)this.pg.getCache(img);
        this.set(tex);
    }

    public void set(PImage img, int x, int y, int w, int h) {
        Texture tex = (Texture)this.pg.getCache(img);
        this.set(tex, x, y, w, h);
    }

    public void set(Texture tex) {
        this.copyTexture(tex, 0, 0, tex.width, tex.height, true);
    }

    public void set(Texture tex, int x, int y, int w, int h) {
        this.copyTexture(tex, x, y, w, h, true);
    }

    public void set(int texTarget, int texName, int texWidth, int texHeight, int w, int h) {
        this.copyTexture(texTarget, texName, texWidth, texHeight, 0, 0, w, h, true);
    }

    public void set(int texTarget, int texName, int texWidth, int texHeight, int target, int tex, int x, int y, int w, int h) {
        this.copyTexture(texTarget, texName, texWidth, texHeight, x, y, w, h, true);
    }

    public void set(int[] pixels) {
        this.set(pixels, 0, 0, this.width, this.height, 2);
    }

    public void set(int[] pixels, int format) {
        this.set(pixels, 0, 0, this.width, this.height, format);
    }

    public void set(int[] pixels, int x, int y, int w, int h) {
        this.set(pixels, x, y, w, h, 2);
    }

    public void set(int[] pixels, int x, int y, int w, int h, int format) {
        if (pixels == null) {
            pixels = null;
            PGraphics.showWarning("The pixels array is null.");
            return;
        }
        if (pixels.length != w * h) {
            PGraphics.showWarning("The pixels array has a length of " + pixels.length + ", but it should be " + w * h);
            return;
        }
        if (pixels.length == 0) {
            return;
        }
        boolean enabledTex = false;
        if (!this.pgl.texturingIsEnabled(this.glTarget)) {
            this.pgl.enableTexturing(this.glTarget);
            enabledTex = true;
        }
        this.pgl.bindTexture(this.glTarget, this.glName);
        if (this.usingMipmaps) {
            if (PGraphicsOpenGL.autoMipmapGenSupported) {
                int[] rgbaPixels = new int[w * h];
                this.convertToRGBA(pixels, rgbaPixels, format, w, h);
                this.pgl.texSubImage2D(this.glTarget, 0, x, y, w, h, 6408, 5121, IntBuffer.wrap(rgbaPixels));
                this.pgl.generateMipmap(this.glTarget);
                rgbaPixels = null;
            } else {
                int[] rgbaPixels = new int[w * h];
                this.convertToRGBA(pixels, rgbaPixels, format, w, h);
                this.pgl.texSubImage2D(this.glTarget, 0, x, y, w, h, 6408, 5121, IntBuffer.wrap(rgbaPixels));
                rgbaPixels = null;
            }
        } else {
            int[] rgbaPixels = new int[w * h];
            this.convertToRGBA(pixels, rgbaPixels, format, w, h);
            this.pgl.texSubImage2D(this.glTarget, 0, x, y, w, h, 6408, 5121, IntBuffer.wrap(rgbaPixels));
            rgbaPixels = null;
        }
        this.pgl.bindTexture(this.glTarget, 0);
        if (enabledTex) {
            this.pgl.disableTexturing(this.glTarget);
        }
        this.updateTexels(x, y, w, h);
    }

    public void setNative(int[] pixels) {
        this.setNative(pixels, 0, 0, this.width, this.height);
    }

    public void setNative(int[] pixels, int x, int y, int w, int h) {
        this.setNative(IntBuffer.wrap(pixels), x, y, w, h);
    }

    public void setNative(IntBuffer pixels, int x, int y, int w, int h) {
        if (pixels == null) {
            pixels = null;
            PGraphics.showWarning("The pixel buffer is null.");
            return;
        }
        if (pixels.capacity() != w * h) {
            PGraphics.showWarning("The pixels array has a length of " + pixels.capacity() + ", but it should be " + w * h);
            return;
        }
        if (pixels.capacity() == 0) {
            return;
        }
        boolean enabledTex = false;
        if (!this.pgl.texturingIsEnabled(this.glTarget)) {
            this.pgl.enableTexturing(this.glTarget);
            enabledTex = true;
        }
        this.pgl.bindTexture(this.glTarget, this.glName);
        if (this.usingMipmaps) {
            if (PGraphicsOpenGL.autoMipmapGenSupported) {
                this.pgl.texSubImage2D(this.glTarget, 0, x, y, w, h, 6408, 5121, pixels);
                this.pgl.generateMipmap(this.glTarget);
            } else {
                this.pgl.texSubImage2D(this.glTarget, 0, x, y, w, h, 6408, 5121, pixels);
            }
        } else {
            this.pgl.texSubImage2D(this.glTarget, 0, x, y, w, h, 6408, 5121, pixels);
        }
        this.pgl.bindTexture(this.glTarget, 0);
        if (enabledTex) {
            this.pgl.disableTexturing(this.glTarget);
        }
        this.updateTexels(x, y, w, h);
    }

    public void get(int[] pixels) {
        if (pixels == null) {
            throw new RuntimeException("Trying to copy texture to null pixels array");
        }
        if (pixels.length != this.width * this.height) {
            throw new RuntimeException("Trying to copy texture to pixels array of wrong size");
        }
        if (this.tempFbo == null) {
            this.tempFbo = new FrameBuffer(this.parent, this.glWidth, this.glHeight);
        }
        this.tempFbo.setColorBuffer(this);
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this.tempFbo);
        this.tempFbo.readPixels();
        this.pg.popFramebuffer();
        this.tempFbo.getPixels(pixels);
        this.convertToARGB(pixels);
        if (this.invertedX) {
            this.flipArrayOnX(pixels, 1);
        }
        if (this.invertedY) {
            this.flipArrayOnY(pixels, 1);
        }
    }

    public void loadPixels(int[] pixels) {
        if (this.hasBuffers()) {
            this.bufferUpdate(pixels);
        }
        if (this.isModified()) {
            this.get(pixels);
        }
        this.setModified(false);
    }

    public void put(Texture tex) {
        this.copyTexture(tex, 0, 0, tex.width, tex.height, false);
    }

    public void put(Texture tex, int x, int y, int w, int h) {
        this.copyTexture(tex, x, y, w, h, false);
    }

    public void put(int texTarget, int texName, int texWidth, int texHeight, int w, int h) {
        this.copyTexture(texTarget, texName, texWidth, texHeight, 0, 0, w, h, false);
    }

    public void put(int texTarget, int texName, int texWidth, int texHeight, int target, int tex, int x, int y, int w, int h) {
        this.copyTexture(texTarget, texName, texWidth, texHeight, x, y, w, h, false);
    }

    public boolean usingMipmaps() {
        return this.usingMipmaps;
    }

    public void usingMipmaps(boolean mipmaps, int sampling) {
        if (mipmaps) {
            if (this.glMinFilter != 9985 && this.glMinFilter != 9987) {
                if (sampling == 2) {
                    this.glMagFilter = 9728;
                    this.glMinFilter = 9728;
                } else if (sampling == 3) {
                    this.glMagFilter = 9728;
                    this.glMinFilter = 9729;
                } else if (sampling == 4) {
                    this.glMagFilter = 9729;
                    this.glMinFilter = 9729;
                } else if (sampling == 5) {
                    this.glMagFilter = 9729;
                    this.glMinFilter = 9729;
                } else {
                    throw new RuntimeException("Unknown texture filtering mode");
                }
            }
            this.usingMipmaps = true;
        } else {
            if (this.glMinFilter == 9985 || this.glMinFilter == 9987) {
                this.glMinFilter = 9729;
            }
            this.usingMipmaps = false;
        }
        this.bind();
        this.pgl.texParameteri(this.glTarget, 10241, this.glMinFilter);
        this.pgl.texParameteri(this.glTarget, 10240, this.glMagFilter);
        if (this.usingMipmaps && PGraphicsOpenGL.autoMipmapGenSupported) {
            this.pgl.generateMipmap(this.glTarget);
        }
        this.unbind();
    }

    public boolean usingRepeat() {
        return this.usingRepeat;
    }

    public void usingRepeat(boolean repeat) {
        if (repeat) {
            this.glWrapS = 10497;
            this.glWrapT = 10497;
            this.usingRepeat = true;
        } else {
            this.glWrapS = 33071;
            this.glWrapT = 33071;
            this.usingRepeat = false;
        }
        this.bind();
        this.pgl.texParameteri(this.glTarget, 10242, this.glWrapS);
        this.pgl.texParameteri(this.glTarget, 10243, this.glWrapT);
        this.unbind();
    }

    public float maxTexcoordU() {
        return this.maxTexcoordU;
    }

    public float maxTexcoordV() {
        return this.maxTexcoordV;
    }

    public boolean invertedX() {
        return this.invertedX;
    }

    public void invertedX(boolean v) {
        this.invertedX = v;
    }

    public boolean invertedY() {
        return this.invertedY;
    }

    public void invertedY(boolean v) {
        this.invertedY = v;
    }

    public void bind() {
        if (!this.pgl.texturingIsEnabled(this.glTarget)) {
            this.pgl.enableTexturing(this.glTarget);
        }
        this.pgl.bindTexture(this.glTarget, this.glName);
        this.bound = true;
    }

    public void unbind() {
        if (this.pgl.textureIsBound(this.glTarget, this.glName)) {
            if (!this.pgl.texturingIsEnabled(this.glTarget)) {
                this.pgl.enableTexturing(this.glTarget);
                this.pgl.bindTexture(this.glTarget, 0);
                this.pgl.disableTexturing(this.glTarget);
            } else {
                this.pgl.bindTexture(this.glTarget, 0);
            }
        }
        this.bound = false;
    }

    public boolean bound() {
        return this.bound;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public void setModified(boolean m) {
        this.modified = m;
    }

    public int getModifiedX1() {
        return this.mx1;
    }

    public int getModifiedX2() {
        return this.mx2;
    }

    public int getModifiedY1() {
        return this.my1;
    }

    public int getModifiedY2() {
        return this.my2;
    }

    public void updateTexels() {
        this.updateTexelsImpl(0, 0, this.width, this.height);
    }

    public void updateTexels(int x, int y, int w, int h) {
        this.updateTexelsImpl(x, y, w, h);
    }

    protected void updateTexelsImpl(int x, int y, int w, int h) {
        int x2 = x + w;
        int y2 = y + h;
        if (!this.modified) {
            this.mx1 = PApplet.max(0, x);
            this.mx2 = PApplet.min(this.width - 1, x2);
            this.my1 = PApplet.max(0, y);
            this.my2 = PApplet.min(this.height - 1, y2);
            this.modified = true;
        } else {
            if (x < this.mx1) {
                this.mx1 = PApplet.max(0, x);
            }
            if (x > this.mx2) {
                this.mx2 = PApplet.min(this.width - 1, x);
            }
            if (y < this.my1) {
                this.my1 = PApplet.max(0, y);
            }
            if (y > this.my2) {
                this.my2 = y;
            }
            if (x2 < this.mx1) {
                this.mx1 = PApplet.max(0, x2);
            }
            if (x2 > this.mx2) {
                this.mx2 = PApplet.min(this.width - 1, x2);
            }
            if (y2 < this.my1) {
                this.my1 = PApplet.max(0, y2);
            }
            if (y2 > this.my2) {
                this.my2 = PApplet.min(this.height - 1, y2);
            }
        }
    }

    public void setBufferSource(Object source) {
        this.bufferSource = source;
        this.getSourceMethods();
    }

    public void copyBufferFromSource(Object natRef, ByteBuffer byteBuf, int w, int h) {
        if (this.bufferCache == null) {
            this.bufferCache = new LinkedList();
        }
        if (this.bufferCache.size() + 1 <= 3) {
            this.bufferCache.add(new BufferData(natRef, byteBuf.asIntBuffer(), w, h));
        } else {
            try {
                this.disposeBufferMethod.invoke(this.bufferSource, natRef);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean hasBufferSource() {
        return this.bufferSource != null;
    }

    public boolean hasBuffers() {
        return this.bufferSource != null && this.bufferCache != null && this.bufferCache.size() > 0;
    }

    protected boolean bufferUpdate() {
        BufferData data = null;
        try {
            data = this.bufferCache.remove(0);
        }
        catch (NoSuchElementException ex) {
            PGraphics.showWarning("Don't have pixel data to copy to texture");
        }
        if (data != null) {
            if (data.w != this.width || data.h != this.height) {
                this.init(data.w, data.h);
            }
            this.setNative(data.rgbBuf, 0, 0, this.width, this.height);
            data.dispose();
            return true;
        }
        return false;
    }

    protected boolean bufferUpdate(int[] pixels) {
        BufferData data = null;
        try {
            data = this.bufferCache.remove(0);
        }
        catch (NoSuchElementException ex) {
            PGraphics.showWarning("Don't have pixel data to copy to texture");
        }
        if (data != null) {
            if (data.w != this.width || data.h != this.height) {
                this.init(data.w, data.h);
            }
            this.setNative(data.rgbBuf, 0, 0, this.width, this.height);
            data.rgbBuf.get(pixels);
            this.convertToARGB(pixels);
            data.dispose();
            return true;
        }
        return false;
    }

    protected void getSourceMethods() {
        try {
            this.disposeBufferMethod = this.bufferSource.getClass().getMethod("disposeBuffer", Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Provided source object doesn't have a disposeBuffer method.");
        }
    }

    protected void flipArrayOnX(int[] intArray, int mult) {
        int index = 0;
        int xindex = mult * (this.width - 1);
        int x = 0;
        while (x < this.width / 2) {
            int y = 0;
            while (y < this.height) {
                int i = index + mult * y * this.width;
                int j = xindex + mult * y * this.width;
                int c = 0;
                while (c < mult) {
                    int temp = intArray[i];
                    intArray[i] = intArray[j];
                    intArray[j] = temp;
                    ++i;
                    ++j;
                    ++c;
                }
                ++y;
            }
            index += mult;
            xindex -= mult;
            ++x;
        }
    }

    protected void flipArrayOnY(int[] intArray, int mult) {
        int index = 0;
        int yindex = mult * (this.height - 1) * this.width;
        int y = 0;
        while (y < this.height / 2) {
            int x = 0;
            while (x < mult * this.width) {
                int temp = intArray[index];
                intArray[index] = intArray[yindex];
                intArray[yindex] = temp;
                ++index;
                ++yindex;
                ++x;
            }
            yindex -= mult * this.width * 2;
            ++y;
        }
    }

    protected void convertToRGBA(int[] intArray, int[] tIntArray, int arrayFormat, int w, int h) {
        block17: {
            block16: {
                if (!PGL.BIG_ENDIAN) break block16;
                switch (arrayFormat) {
                    case 4: {
                        int i = 0;
                        while (i < intArray.length) {
                            tIntArray[i] = 0xFFFFFF00 | intArray[i];
                            ++i;
                        }
                        break block17;
                    }
                    case 1: {
                        int i = 0;
                        while (i < intArray.length) {
                            int pixel = intArray[i];
                            tIntArray[i] = pixel << 8 | 0xFF;
                            ++i;
                        }
                        break block17;
                    }
                    case 2: {
                        int i = 0;
                        while (i < intArray.length) {
                            int pixel = intArray[i];
                            tIntArray[i] = pixel << 8 | pixel >> 24 & 0xFF;
                            ++i;
                        }
                        break block0;
                    }
                }
                break block17;
            }
            switch (arrayFormat) {
                case 4: {
                    int i = 0;
                    while (i < intArray.length) {
                        tIntArray[i] = intArray[i] << 24 | 0xFFFFFF;
                        ++i;
                    }
                    break;
                }
                case 1: {
                    int i = 0;
                    while (i < intArray.length) {
                        int pixel = intArray[i];
                        tIntArray[i] = 0xFF000000 | (pixel & 0xFF) << 16 | (pixel & 0xFF0000) >> 16 | pixel & 0xFF00;
                        ++i;
                    }
                    break;
                }
                case 2: {
                    int i = 0;
                    while (i < intArray.length) {
                        int pixel = intArray[i];
                        tIntArray[i] = (pixel & 0xFF) << 16 | (pixel & 0xFF0000) >> 16 | pixel & 0xFF00FF00;
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    protected void convertToARGB(int[] intArray) {
        int t = 0;
        int p = 0;
        if (PGL.BIG_ENDIAN) {
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    int pixel = intArray[p++];
                    intArray[t++] = pixel >> 8 | pixel << 24 & 0xFF000000;
                    ++x;
                }
                ++y;
            }
        } else {
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    int pixel = intArray[p++];
                    intArray[t++] = (pixel & 0xFF) << 16 | (pixel & 0xFF0000) >> 16 | pixel & 0xFF00FF00;
                    ++x;
                }
                ++y;
            }
        }
    }

    protected void setSize(int w, int h) {
        this.width = w;
        this.height = h;
        if (PGraphicsOpenGL.npotTexSupported) {
            this.glWidth = w;
            this.glHeight = h;
        } else {
            this.glWidth = PGL.nextPowerOfTwo(w);
            this.glHeight = PGL.nextPowerOfTwo(h);
        }
        if (this.glWidth > PGraphicsOpenGL.maxTextureSize || this.glHeight > PGraphicsOpenGL.maxTextureSize) {
            this.glHeight = 0;
            this.glWidth = 0;
            throw new RuntimeException("Image width and height cannot be larger than " + PGraphicsOpenGL.maxTextureSize + " with this graphics card.");
        }
        this.maxTexcoordU = (float)this.width / (float)this.glWidth;
        this.maxTexcoordV = (float)this.height / (float)this.glHeight;
    }

    protected void allocate() {
        this.release();
        boolean enabledTex = false;
        if (!this.pgl.texturingIsEnabled(this.glTarget)) {
            this.pgl.enableTexturing(this.glTarget);
            enabledTex = true;
        }
        this.context = this.pgl.getCurrentContext();
        this.glName = this.pg.createTextureObject(this.context.id());
        this.pgl.bindTexture(this.glTarget, this.glName);
        this.pgl.texParameteri(this.glTarget, 10241, this.glMinFilter);
        this.pgl.texParameteri(this.glTarget, 10240, this.glMagFilter);
        this.pgl.texParameteri(this.glTarget, 10242, this.glWrapS);
        this.pgl.texParameteri(this.glTarget, 10243, this.glWrapT);
        this.pgl.texImage2D(this.glTarget, 0, this.glFormat, this.glWidth, this.glHeight, 0, 6408, 5121, null);
        this.pgl.initTexture(this.glTarget, 6408, this.width, this.height);
        this.pgl.bindTexture(this.glTarget, 0);
        if (enabledTex) {
            this.pgl.disableTexturing(this.glTarget);
        }
        this.bound = false;
    }

    protected void release() {
        if (this.glName != 0) {
            this.pg.finalizeTextureObject(this.glName, this.context.id());
            this.glName = 0;
        }
    }

    protected boolean contextIsOutdated() {
        boolean outdated;
        boolean bl = outdated = !this.pgl.contextIsCurrent(this.context);
        if (outdated) {
            this.pg.removeTextureObject(this.glName, this.context.id());
            this.glName = 0;
        }
        return outdated;
    }

    protected void copyTexture(Texture tex, int x, int y, int w, int h, boolean scale) {
        if (tex == null) {
            throw new RuntimeException("Source texture is null");
        }
        if (this.tempFbo == null) {
            this.tempFbo = new FrameBuffer(this.parent, this.glWidth, this.glHeight);
        }
        this.tempFbo.setColorBuffer(this);
        this.tempFbo.disableDepthTest();
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this.tempFbo);
        if (scale) {
            this.pgl.drawTexture(tex.glTarget, tex.glName, tex.glWidth, tex.glHeight, x, y, w, h, 0, 0, this.width, this.height);
        } else {
            this.pgl.drawTexture(tex.glTarget, tex.glName, tex.glWidth, tex.glHeight, x, y, w, h, x, y, w, h);
        }
        this.pg.popFramebuffer();
        this.updateTexels(x, y, w, h);
    }

    protected void copyTexture(int texTarget, int texName, int texWidth, int texHeight, int x, int y, int w, int h, boolean scale) {
        if (this.tempFbo == null) {
            this.tempFbo = new FrameBuffer(this.parent, this.glWidth, this.glHeight);
        }
        this.tempFbo.setColorBuffer(this);
        this.tempFbo.disableDepthTest();
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this.tempFbo);
        if (scale) {
            this.pgl.drawTexture(texTarget, texName, texWidth, texHeight, x, y, w, h, 0, 0, this.width, this.height);
        } else {
            this.pgl.drawTexture(texTarget, texName, texWidth, texHeight, x, y, w, h, x, y, w, h);
        }
        this.pg.popFramebuffer();
        this.updateTexels(x, y, w, h);
    }

    protected void copyObject(Texture src) {
        this.release();
        this.width = src.width;
        this.height = src.height;
        this.parent = src.parent;
        this.pg = src.pg;
        this.glName = src.glName;
        this.glTarget = src.glTarget;
        this.glFormat = src.glFormat;
        this.glMinFilter = src.glMinFilter;
        this.glMagFilter = src.glMagFilter;
        this.glWidth = src.glWidth;
        this.glHeight = src.glHeight;
        this.usingMipmaps = src.usingMipmaps;
        this.usingRepeat = src.usingRepeat;
        this.maxTexcoordU = src.maxTexcoordU;
        this.maxTexcoordV = src.maxTexcoordV;
        this.invertedX = src.invertedX;
        this.invertedY = src.invertedY;
    }

    public Parameters getParameters() {
        Parameters res = new Parameters();
        if (this.glTarget == 3553) {
            res.target = 0;
        }
        if (this.glFormat == 6407) {
            res.format = 1;
        } else if (this.glFormat == 6408) {
            res.format = 2;
        } else if (this.glFormat == 6406) {
            res.format = 4;
        }
        if (this.glMagFilter == 9728 && this.glMinFilter == 9728) {
            res.sampling = 2;
            res.mipmaps = false;
        } else if (this.glMagFilter == 9728 && this.glMinFilter == 9729) {
            res.sampling = 3;
            res.mipmaps = false;
        } else if (this.glMagFilter == 9728 && this.glMinFilter == 9985) {
            res.sampling = 3;
            res.mipmaps = true;
        } else if (this.glMagFilter == 9729 && this.glMinFilter == 9729) {
            res.sampling = 4;
            res.mipmaps = false;
        } else if (this.glMagFilter == 9729 && this.glMinFilter == 9985) {
            res.sampling = 4;
            res.mipmaps = true;
        } else if (this.glMagFilter == 9729 && this.glMinFilter == 9987) {
            res.sampling = 5;
            res.mipmaps = true;
        }
        if (this.glWrapS == 33071) {
            res.wrapU = 0;
        } else if (this.glWrapS == 10497) {
            res.wrapU = 1;
        }
        if (this.glWrapT == 33071) {
            res.wrapV = 0;
        } else if (this.glWrapT == 10497) {
            res.wrapV = 1;
        }
        return res;
    }

    protected void setParameters(Parameters params) {
        if (params.target != 0) {
            throw new RuntimeException("Unknown texture target");
        }
        this.glTarget = 3553;
        if (params.format == 1) {
            this.glFormat = 6407;
        } else if (params.format == 2) {
            this.glFormat = 6408;
        } else if (params.format == 4) {
            this.glFormat = 6406;
        } else {
            throw new RuntimeException("Unknown texture format");
        }
        if (params.sampling == 2) {
            this.glMagFilter = 9728;
            this.glMinFilter = 9728;
        } else if (params.sampling == 3) {
            this.glMagFilter = 9728;
            if (params.mipmaps) {
                // empty if block
            }
            this.glMinFilter = 9729;
        } else if (params.sampling == 4) {
            this.glMagFilter = 9729;
            if (params.mipmaps) {
                // empty if block
            }
            this.glMinFilter = 9729;
        } else if (params.sampling == 5) {
            this.glMagFilter = 9729;
            if (params.mipmaps) {
                // empty if block
            }
            this.glMinFilter = 9729;
        } else {
            throw new RuntimeException("Unknown texture filtering mode");
        }
        if (params.wrapU == 0) {
            this.glWrapS = 33071;
        } else if (params.wrapU == 1) {
            this.glWrapS = 10497;
        } else {
            throw new RuntimeException("Unknown wrapping mode");
        }
        if (params.wrapV == 0) {
            this.glWrapT = 33071;
        } else if (params.wrapV == 1) {
            this.glWrapT = 10497;
        } else {
            throw new RuntimeException("Unknown wrapping mode");
        }
        this.usingMipmaps = this.glMinFilter == 9985 || this.glMinFilter == 9987;
        this.usingRepeat = this.glWrapS == 10497 || this.glWrapT == 10497;
        this.invertedX = false;
        this.invertedY = false;
    }

    protected class BufferData {
        int w;
        int h;
        Object natBuf;
        IntBuffer rgbBuf;

        BufferData(Object nat, IntBuffer rgb, int w, int h) {
            this.natBuf = nat;
            this.rgbBuf = rgb;
            this.w = w;
            this.h = h;
        }

        void dispose() {
            try {
                Texture.this.disposeBufferMethod.invoke(Texture.this.bufferSource, this.natBuf);
                this.natBuf = null;
                this.rgbBuf = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class Parameters {
        public int target;
        public int format;
        public int sampling;
        public boolean mipmaps;
        public int wrapU;
        public int wrapV;

        public Parameters() {
            this.target = 0;
            this.format = 2;
            this.sampling = 4;
            this.mipmaps = true;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(int format) {
            this.target = 0;
            this.format = format;
            this.sampling = 4;
            this.mipmaps = true;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(int format, int sampling) {
            this.target = 0;
            this.format = format;
            this.sampling = sampling;
            this.mipmaps = true;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(int format, int sampling, boolean mipmaps) {
            this.target = 0;
            this.format = format;
            this.mipmaps = mipmaps;
            this.sampling = sampling == 5 && !mipmaps ? 4 : sampling;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(int format, int sampling, boolean mipmaps, int wrap) {
            this.target = 0;
            this.format = format;
            this.mipmaps = mipmaps;
            this.sampling = sampling == 5 && !mipmaps ? 4 : sampling;
            this.wrapU = wrap;
            this.wrapV = wrap;
        }

        public Parameters(Parameters src) {
            this.set(src);
        }

        public void set(int format) {
            this.format = format;
        }

        public void set(int format, int sampling) {
            this.format = format;
            this.sampling = sampling;
        }

        public void set(int format, int sampling, boolean mipmaps) {
            this.format = format;
            this.sampling = sampling;
            this.mipmaps = mipmaps;
        }

        public void set(Parameters src) {
            this.target = src.target;
            this.format = src.format;
            this.sampling = src.sampling;
            this.mipmaps = src.mipmaps;
            this.wrapU = src.wrapU;
            this.wrapV = src.wrapV;
        }
    }
}

