/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.GLU;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;
import processing.core.PApplet;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.tess.PGLU;
import processing.opengl.tess.PGLUtessellator;
import processing.opengl.tess.PGLUtessellatorCallbackAdapter;

public class PGL {
    protected static final int SIZEOF_SHORT = 2;
    protected static final int SIZEOF_INT = 4;
    protected static final int SIZEOF_FLOAT = 4;
    protected static final int SIZEOF_BYTE = 1;
    protected static final int SIZEOF_INDEX = 2;
    protected static final int INDEX_TYPE = 5123;
    protected static final int DEFAULT_IN_VERTICES = 16;
    protected static final int DEFAULT_IN_EDGES = 32;
    protected static final int DEFAULT_IN_TEXTURES = 16;
    protected static final int DEFAULT_TESS_VERTICES = 16;
    protected static final int DEFAULT_TESS_INDICES = 32;
    protected static final int MAX_LIGHTS = 8;
    protected static final int MAX_VERTEX_INDEX = Short.MAX_VALUE;
    protected static final int MAX_VERTEX_INDEX1 = 32768;
    protected static final int FLUSH_VERTEX_COUNT = 32768;
    protected static final int MAX_FONT_TEX_SIZE = 512;
    protected static final float MIN_CAPS_JOINS_WEIGHT = 2.0f;
    protected static final int MAX_CAPS_JOINS_LENGTH = 1000;
    protected static final int MIN_ARRAYCOPY_SIZE = 2;
    protected static final boolean MIPMAPS_ENABLED = false;
    protected static float FLOAT_EPS = Float.MIN_VALUE;
    protected static boolean BIG_ENDIAN;
    protected static final String SHADER_PREPROCESSOR_DIRECTIVE = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\n";
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int LESS = 513;
    public static final int LEQUAL = 515;
    public static final int CCW = 2305;
    public static final int CW = 2304;
    public static final int CULL_FACE = 2884;
    public static final int FRONT = 1028;
    public static final int BACK = 1029;
    public static final int FRONT_AND_BACK = 1032;
    public static final int VIEWPORT = 2978;
    public static final int SCISSOR_TEST = 3089;
    public static final int DEPTH_TEST = 2929;
    public static final int DEPTH_WRITEMASK = 2930;
    public static final int COLOR_BUFFER_BIT = 16384;
    public static final int DEPTH_BUFFER_BIT = 256;
    public static final int STENCIL_BUFFER_BIT = 1024;
    public static final int FUNC_ADD = 32774;
    public static final int FUNC_MIN = 32775;
    public static final int FUNC_MAX = 32776;
    public static final int FUNC_REVERSE_SUBTRACT = 32779;
    public static final int TEXTURE_2D = 3553;
    public static final int TEXTURE_BINDING_2D = 32873;
    public static final int RGB = 6407;
    public static final int RGBA = 6408;
    public static final int ALPHA = 6406;
    public static final int UNSIGNED_INT = 5125;
    public static final int UNSIGNED_BYTE = 5121;
    public static final int UNSIGNED_SHORT = 5123;
    public static final int FLOAT = 5126;
    public static final int NEAREST = 9728;
    public static final int LINEAR = 9729;
    public static final int LINEAR_MIPMAP_NEAREST = 9985;
    public static final int LINEAR_MIPMAP_LINEAR = 9987;
    public static final int CLAMP_TO_EDGE = 33071;
    public static final int REPEAT = 10497;
    public static final int RGBA8 = -1;
    public static final int DEPTH24_STENCIL8 = 35056;
    public static final int DEPTH_COMPONENT = 6402;
    public static final int DEPTH_COMPONENT16 = 33189;
    public static final int DEPTH_COMPONENT24 = 33190;
    public static final int DEPTH_COMPONENT32 = 33191;
    public static final int STENCIL_INDEX = 6401;
    public static final int STENCIL_INDEX1 = 36166;
    public static final int STENCIL_INDEX4 = 36167;
    public static final int STENCIL_INDEX8 = 36168;
    public static final int ARRAY_BUFFER = 34962;
    public static final int ELEMENT_ARRAY_BUFFER = 34963;
    public static final int SAMPLES = 32937;
    public static final int FRAMEBUFFER_COMPLETE = 36053;
    public static final int FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int FRAMEBUFFER_INCOMPLETE_FORMATS = 36058;
    public static final int FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = -1;
    public static final int FRAMEBUFFER_INCOMPLETE_READ_BUFFER = -1;
    public static final int FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int STATIC_DRAW = 35044;
    public static final int DYNAMIC_DRAW = 35048;
    public static final int STREAM_DRAW = 35040;
    public static final int READ_ONLY = -1;
    public static final int WRITE_ONLY = -1;
    public static final int READ_WRITE = -1;
    public static final int TRIANGLE_FAN = 6;
    public static final int TRIANGLE_STRIP = 5;
    public static final int TRIANGLES = 4;
    public static final int VENDOR = 7936;
    public static final int RENDERER = 7937;
    public static final int VERSION = 7938;
    public static final int EXTENSIONS = 7939;
    public static final int SHADING_LANGUAGE_VERSION = 35724;
    public static final int MAX_TEXTURE_SIZE = 3379;
    public static final int MAX_SAMPLES = -1;
    public static final int ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int DEPTH_BITS = 3414;
    public static final int STENCIL_BITS = 3415;
    public static final int TESS_WINDING_NONZERO = 100131;
    public static final int TESS_WINDING_ODD = 100130;
    public static final int TEXTURE0 = 33984;
    public static final int TEXTURE1 = 33985;
    public static final int TEXTURE2 = 33986;
    public static final int TEXTURE3 = 33987;
    public static final int TEXTURE_MIN_FILTER = 10241;
    public static final int TEXTURE_MAG_FILTER = 10240;
    public static final int TEXTURE_WRAP_S = 10242;
    public static final int TEXTURE_WRAP_T = 10243;
    public static final int BLEND = 3042;
    public static final int ONE = 1;
    public static final int ZERO = 0;
    public static final int SRC_ALPHA = 770;
    public static final int DST_ALPHA = 772;
    public static final int ONE_MINUS_SRC_ALPHA = 771;
    public static final int ONE_MINUS_DST_COLOR = 775;
    public static final int ONE_MINUS_SRC_COLOR = 769;
    public static final int DST_COLOR = 774;
    public static final int SRC_COLOR = 768;
    public static final int FRAMEBUFFER = 36160;
    public static final int COLOR_ATTACHMENT0 = 36064;
    public static final int COLOR_ATTACHMENT1 = -1;
    public static final int COLOR_ATTACHMENT2 = -1;
    public static final int COLOR_ATTACHMENT3 = -1;
    public static final int RENDERBUFFER = 36161;
    public static final int DEPTH_ATTACHMENT = 36096;
    public static final int STENCIL_ATTACHMENT = 36128;
    public static final int READ_FRAMEBUFFER = -1;
    public static final int DRAW_FRAMEBUFFER = -1;
    public static final int VERTEX_SHADER = 35633;
    public static final int FRAGMENT_SHADER = 35632;
    public static final int INFO_LOG_LENGTH = 35716;
    public static final int SHADER_SOURCE_LENGTH = 35720;
    public static final int COMPILE_STATUS = 35713;
    public static final int LINK_STATUS = 35714;
    public static final int VALIDATE_STATUS = 35715;
    public static final int MULTISAMPLE = -1;
    public static final int POINT_SMOOTH = -1;
    public static final int LINE_SMOOTH = -1;
    public static final int POLYGON_SMOOTH = -1;
    protected static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    protected static final int EGL_OPENGL_ES2_BIT = 4;
    public GL10 gl;
    public PGLU glu;
    public static EGLContext context;
    protected PGraphicsOpenGL pg;
    protected boolean initialized;
    protected AndroidRenderer renderer;
    protected static boolean[] texturingTargets;
    protected static int[] boundTextures;
    protected static final boolean FORCE_SCREEN_FBO = false;
    protected boolean firstOnscreenFrame = true;
    protected int fboWidth;
    protected int fboHeight;
    protected int backTex;
    protected int frontTex;
    protected int[] glColorTex = new int[2];
    protected int[] glColorFbo = new int[1];
    protected boolean loadedTexShader = false;
    protected int texShaderProgram;
    protected int texVertShader;
    protected int texFragShader;
    protected int texVertLoc;
    protected int texTCoordLoc;
    protected float[] texCoords = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    protected FloatBuffer texData;
    protected String texVertShaderSource = "attribute vec2 inVertex;attribute vec2 inTexcoord;varying vec2 vertTexcoord;void main() {  gl_Position = vec4(inVertex, 0, 1);  vertTexcoord = inTexcoord;}";
    protected String texFragShaderSource = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\nuniform sampler2D textureSampler;varying vec2 vertTexcoord;void main() {  gl_FragColor = texture2D(textureSampler, vertTexcoord.st);}";
    protected IntBuffer colorBuffer;
    protected FloatBuffer depthBuffer;
    protected ByteBuffer stencilBuffer;

    static {
        float eps = 1.0f;
        while ((double)((float)(1.0 + (double)(eps /= 2.0f) / 2.0)) != 1.0) {
        }
        FLOAT_EPS = eps;
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        texturingTargets = new boolean[1];
        boundTextures = new int[1];
    }

    public PGL(PGraphicsOpenGL pg) {
        this.pg = pg;
        this.renderer = new AndroidRenderer();
        this.glu = new PGLU();
        this.initialized = false;
    }

    protected void setFrameRate(float framerate) {
    }

    protected void initPrimarySurface(int antialias) {
    }

    protected void initOffscreenSurface(PGL primary) {
        this.initialized = true;
    }

    protected void updatePrimary() {
        if (!this.initialized) {
            String ext = GLES20.glGetString((int)7939);
            if (-1 < ext.indexOf("texture_non_power_of_two")) {
                this.fboWidth = this.pg.width;
                this.fboHeight = this.pg.height;
            } else {
                this.fboWidth = PGL.nextPowerOfTwo(this.pg.width);
                this.fboHeight = PGL.nextPowerOfTwo(this.pg.height);
            }
            boolean packed = ext.indexOf("packed_depth_stencil") != -1;
            GLES20.glGenTextures((int)2, (int[])this.glColorTex, (int)0);
            int i = 0;
            while (i < 2) {
                GLES20.glBindTexture((int)3553, (int)this.glColorTex[i]);
                GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
                GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
                GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
                GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
                GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.fboWidth, (int)this.fboHeight, (int)0, (int)6408, (int)5121, null);
                this.initTexture(3553, 6408, this.fboWidth, this.fboHeight);
                ++i;
            }
            GLES20.glBindTexture((int)3553, (int)0);
            GLES20.glGenFramebuffers((int)1, (int[])this.glColorFbo, (int)0);
            GLES20.glBindFramebuffer((int)36160, (int)this.glColorFbo[0]);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.glColorTex[0], (int)0);
            if (packed) {
                int[] depthStencil = new int[1];
                GLES20.glGenRenderbuffers((int)1, (int[])depthStencil, (int)0);
                GLES20.glBindRenderbuffer((int)36161, (int)depthStencil[0]);
                GLES20.glRenderbufferStorage((int)36161, (int)35056, (int)this.fboWidth, (int)this.fboHeight);
                GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)depthStencil[0]);
                GLES20.glFramebufferRenderbuffer((int)36160, (int)36128, (int)36161, (int)depthStencil[0]);
            } else {
                int[] depth = new int[1];
                int[] stencil = new int[1];
                GLES20.glGenRenderbuffers((int)1, (int[])depth, (int)0);
                GLES20.glBindRenderbuffer((int)36161, (int)depth[0]);
                GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)this.fboWidth, (int)this.fboHeight);
                GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)depth[0]);
                int[] temp = new int[1];
                GLES20.glGetIntegerv((int)3415, (int[])temp, (int)0);
                int stencilBits = temp[0];
                if (stencilBits == 8) {
                    GLES20.glGenRenderbuffers((int)1, (int[])stencil, (int)0);
                    GLES20.glBindRenderbuffer((int)36161, (int)stencil[0]);
                    GLES20.glRenderbufferStorage((int)36161, (int)36168, (int)this.fboWidth, (int)this.fboHeight);
                    GLES20.glFramebufferRenderbuffer((int)36160, (int)36128, (int)36161, (int)stencil[0]);
                }
            }
            this.validateFramebuffer();
            GLES20.glClearDepthf((float)1.0f);
            GLES20.glClearStencil((int)0);
            GLES20.glClear((int)1280);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            PGraphicsOpenGL.screenFramebuffer.glFbo = 0;
            this.backTex = 1;
            this.frontTex = 0;
            this.initialized = true;
        }
    }

    protected void updateOffscreen(PGL primary) {
        this.gl = primary.gl;
    }

    protected int primaryDrawBuffer() {
        if (PGraphicsOpenGL.screenFramebuffer.glFbo != 0) {
            return 1029;
        }
        return 36064;
    }

    protected boolean primaryIsFboBacked() {
        return PGraphicsOpenGL.screenFramebuffer.glFbo != 0;
    }

    protected int getFboTexTarget() {
        return 3553;
    }

    protected int getFboTexName() {
        return this.glColorTex[0];
    }

    protected int getFboWidth() {
        return this.fboWidth;
    }

    protected int getFboHeight() {
        return this.fboHeight;
    }

    protected void bindPrimaryColorFBO() {
        GLES20.glBindFramebuffer((int)36160, (int)this.glColorFbo[0]);
        PGraphicsOpenGL.screenFramebuffer.glFbo = this.glColorFbo[0];
        GLES20.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16384);
        GLES20.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    protected void bindPrimaryMultiFBO() {
        GLES20.glBindFramebuffer((int)36160, (int)this.glColorFbo[0]);
        PGraphicsOpenGL.screenFramebuffer.glFbo = this.glColorFbo[0];
    }

    protected void bindBackBufferTex() {
    }

    protected void unbindBackBufferTex() {
    }

    protected void beginOnscreenDraw(boolean clear) {
        if (clear) {
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            PGraphicsOpenGL.screenFramebuffer.glFbo = 0;
        } else {
            GLES20.glBindFramebuffer((int)36160, (int)this.glColorFbo[0]);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.glColorTex[this.frontTex], (int)0);
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)1280);
            if (this.firstOnscreenFrame) {
                GLES20.glClear((int)16384);
            } else {
                this.drawTexture(3553, this.glColorTex[this.backTex], this.fboWidth, this.fboHeight, 0, 0, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height);
            }
            PGraphicsOpenGL.screenFramebuffer.glFbo = this.glColorFbo[0];
        }
        if (this.firstOnscreenFrame) {
            this.firstOnscreenFrame = false;
        }
    }

    protected void endOnscreenDraw(boolean clear0) {
        if (!clear0) {
            GLES20.glBindFramebuffer((int)36160, (int)0);
            PGraphicsOpenGL.screenFramebuffer.glFbo = 0;
            GLES20.glClearDepthf((float)1.0f);
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16640);
            GLES20.glDisable((int)3042);
            this.drawTexture(3553, this.glColorTex[this.frontTex], this.fboWidth, this.fboHeight, 0, 0, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height);
            int temp = this.frontTex;
            this.frontTex = this.backTex;
            this.backTex = temp;
        }
    }

    protected void beginOffscreenDraw(boolean clear) {
    }

    protected void endOffscreenDraw(boolean clear0) {
    }

    protected boolean canDraw() {
        return true;
    }

    protected void requestDraw() {
        this.pg.parent.andresNeedsBetterAPI();
    }

    public String getString(int name) {
        return GLES20.glGetString((int)name);
    }

    public void getIntegerv(int name, int[] values, int offset) {
        if (-1 < name) {
            GLES20.glGetIntegerv((int)name, (int[])values, (int)offset);
        } else {
            Arrays.fill(values, 0);
        }
    }

    public void getBooleanv(int name, boolean[] values, int offset) {
        if (-1 < name) {
            GLES20.glGetBooleanv((int)name, (boolean[])values, (int)offset);
        } else {
            Arrays.fill(values, false);
        }
    }

    public void enable(int cap) {
        if (-1 < cap) {
            GLES20.glEnable((int)cap);
        }
    }

    public void disable(int cap) {
        if (-1 < cap) {
            GLES20.glDisable((int)cap);
        }
    }

    public void flush() {
        GLES20.glFlush();
    }

    public void finish() {
        GLES20.glFinish();
    }

    public int getError() {
        return GLES20.glGetError();
    }

    public String errorString(int err) {
        return GLU.gluErrorString((int)err);
    }

    public void frontFace(int mode) {
        GLES20.glFrontFace((int)mode);
    }

    public void cullFace(int mode) {
        GLES20.glCullFace((int)mode);
    }

    public void depthMask(boolean flag) {
        GLES20.glDepthMask((boolean)flag);
    }

    public void depthFunc(int func) {
        GLES20.glDepthFunc((int)func);
    }

    public void genTextures(int n, int[] ids, int offset) {
        GLES20.glGenTextures((int)n, (int[])ids, (int)offset);
    }

    public void deleteTextures(int n, int[] ids, int offset) {
        GLES20.glDeleteTextures((int)n, (int[])ids, (int)offset);
    }

    public void activeTexture(int unit) {
        GLES20.glActiveTexture((int)unit);
    }

    public void bindTexture(int target, int id) {
        GLES20.glBindTexture((int)target, (int)id);
        if (target == 3553) {
            PGL.boundTextures[0] = id;
        }
    }

    public void texImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, Buffer data) {
        GLES20.glTexImage2D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)border, (int)format, (int)type, (Buffer)data);
    }

    public void texSubImage2D(int target, int level, int xOffset, int yOffset, int width, int height, int format, int type, Buffer data) {
        GLES20.glTexSubImage2D((int)target, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)format, (int)type, (Buffer)data);
    }

    public void texParameteri(int target, int param, int value) {
        GLES20.glTexParameteri((int)target, (int)param, (int)value);
    }

    public void getTexParameteriv(int target, int param, int[] values, int offset) {
        GLES20.glGetTexParameteriv((int)target, (int)param, (int[])values, (int)offset);
    }

    public void generateMipmap(int target) {
        GLES20.glGenerateMipmap((int)target);
    }

    public void genBuffers(int n, int[] ids, int offset) {
        GLES20.glGenBuffers((int)n, (int[])ids, (int)offset);
    }

    public void deleteBuffers(int n, int[] ids, int offset) {
        GLES20.glDeleteBuffers((int)n, (int[])ids, (int)offset);
    }

    public void bindBuffer(int target, int id) {
        GLES20.glBindBuffer((int)target, (int)id);
    }

    public void bufferData(int target, int size, Buffer data, int usage) {
        GLES20.glBufferData((int)target, (int)size, (Buffer)data, (int)usage);
    }

    public void bufferSubData(int target, int offset, int size, Buffer data) {
        GLES20.glBufferSubData((int)target, (int)offset, (int)size, (Buffer)data);
    }

    public void drawArrays(int mode, int first, int count) {
        GLES20.glDrawArrays((int)mode, (int)first, (int)count);
    }

    public void drawElements(int mode, int count, int type, int offset) {
        GLES20.glDrawElements((int)mode, (int)count, (int)type, (int)offset);
    }

    public void enableVertexAttribArray(int loc) {
        GLES20.glEnableVertexAttribArray((int)loc);
    }

    public void disableVertexAttribArray(int loc) {
        GLES20.glDisableVertexAttribArray((int)loc);
    }

    public void vertexAttribPointer(int loc, int size, int type, boolean normalized, int stride, int offset) {
        GLES20.glVertexAttribPointer((int)loc, (int)size, (int)type, (boolean)normalized, (int)stride, (int)offset);
    }

    public void vertexAttribPointer(int loc, int size, int type, boolean normalized, int stride, Buffer data) {
        GLES20.glVertexAttribPointer((int)loc, (int)size, (int)type, (boolean)normalized, (int)stride, (Buffer)data);
    }

    public ByteBuffer mapBuffer(int target, int access) {
        return null;
    }

    public ByteBuffer mapBufferRange(int target, int offset, int length, int access) {
        return null;
    }

    public void unmapBuffer(int target) {
    }

    public void genFramebuffers(int n, int[] ids, int offset) {
        GLES20.glGenFramebuffers((int)n, (int[])ids, (int)offset);
    }

    public void deleteFramebuffers(int n, int[] ids, int offset) {
        GLES20.glDeleteFramebuffers((int)n, (int[])ids, (int)offset);
    }

    public void genRenderbuffers(int n, int[] ids, int offset) {
        GLES20.glGenRenderbuffers((int)n, (int[])ids, (int)offset);
    }

    public void deleteRenderbuffers(int n, int[] ids, int offset) {
        GLES20.glDeleteRenderbuffers((int)n, (int[])ids, (int)offset);
    }

    public void bindFramebuffer(int target, int id) {
        GLES20.glBindFramebuffer((int)target, (int)id);
    }

    public void blitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
    }

    public void framebufferTexture2D(int target, int attachment, int texTarget, int texId, int level) {
        GLES20.glFramebufferTexture2D((int)target, (int)attachment, (int)texTarget, (int)texId, (int)level);
    }

    public void bindRenderbuffer(int target, int id) {
        GLES20.glBindRenderbuffer((int)target, (int)id);
    }

    public void renderbufferStorageMultisample(int target, int samples, int format, int width, int height) {
    }

    public void renderbufferStorage(int target, int format, int width, int height) {
        GLES20.glRenderbufferStorage((int)target, (int)format, (int)width, (int)height);
    }

    public void framebufferRenderbuffer(int target, int attachment, int rendbufTarget, int rendbufId) {
        GLES20.glFramebufferRenderbuffer((int)target, (int)attachment, (int)rendbufTarget, (int)rendbufId);
    }

    public int checkFramebufferStatus(int target) {
        return GLES20.glCheckFramebufferStatus((int)target);
    }

    public int createProgram() {
        return GLES20.glCreateProgram();
    }

    public void deleteProgram(int id) {
        GLES20.glDeleteProgram((int)id);
    }

    public int createShader(int type) {
        return GLES20.glCreateShader((int)type);
    }

    public void deleteShader(int id) {
        GLES20.glDeleteShader((int)id);
    }

    public void linkProgram(int prog) {
        GLES20.glLinkProgram((int)prog);
    }

    public void validateProgram(int prog) {
        GLES20.glValidateProgram((int)prog);
    }

    public void useProgram(int prog) {
        GLES20.glUseProgram((int)prog);
    }

    public int getAttribLocation(int prog, String name) {
        return GLES20.glGetAttribLocation((int)prog, (String)name);
    }

    public int getUniformLocation(int prog, String name) {
        return GLES20.glGetUniformLocation((int)prog, (String)name);
    }

    public void uniform1i(int loc, int value) {
        GLES20.glUniform1i((int)loc, (int)value);
    }

    public void uniform2i(int loc, int value0, int value1) {
        GLES20.glUniform2i((int)loc, (int)value0, (int)value1);
    }

    public void uniform3i(int loc, int value0, int value1, int value2) {
        GLES20.glUniform3i((int)loc, (int)value0, (int)value1, (int)value2);
    }

    public void uniform4i(int loc, int value0, int value1, int value2, int value3) {
        GLES20.glUniform4i((int)loc, (int)value0, (int)value1, (int)value2, (int)value3);
    }

    public void uniform1f(int loc, float value) {
        GLES20.glUniform1f((int)loc, (float)value);
    }

    public void uniform2f(int loc, float value0, float value1) {
        GLES20.glUniform2f((int)loc, (float)value0, (float)value1);
    }

    public void uniform3f(int loc, float value0, float value1, float value2) {
        GLES20.glUniform3f((int)loc, (float)value0, (float)value1, (float)value2);
    }

    public void uniform4f(int loc, float value0, float value1, float value2, float value3) {
        GLES20.glUniform4f((int)loc, (float)value0, (float)value1, (float)value2, (float)value3);
    }

    public void uniform1iv(int loc, int count, int[] v, int offset) {
        GLES20.glUniform1iv((int)loc, (int)count, (int[])v, (int)offset);
    }

    public void uniform2iv(int loc, int count, int[] v, int offset) {
        GLES20.glUniform2iv((int)loc, (int)count, (int[])v, (int)offset);
    }

    public void uniform3iv(int loc, int count, int[] v, int offset) {
        GLES20.glUniform3iv((int)loc, (int)count, (int[])v, (int)offset);
    }

    public void uniform4iv(int loc, int count, int[] v, int offset) {
        GLES20.glUniform4iv((int)loc, (int)count, (int[])v, (int)offset);
    }

    public void uniform1fv(int loc, int count, float[] v, int offset) {
        GLES20.glUniform1fv((int)loc, (int)count, (float[])v, (int)offset);
    }

    public void uniform2fv(int loc, int count, float[] v, int offset) {
        GLES20.glUniform2fv((int)loc, (int)count, (float[])v, (int)offset);
    }

    public void uniform3fv(int loc, int count, float[] v, int offset) {
        GLES20.glUniform3fv((int)loc, (int)count, (float[])v, (int)offset);
    }

    public void uniform4fv(int loc, int count, float[] v, int offset) {
        GLES20.glUniform4fv((int)loc, (int)count, (float[])v, (int)offset);
    }

    public void uniformMatrix2fv(int loc, int count, boolean transpose, float[] mat, int offset) {
        GLES20.glUniformMatrix2fv((int)loc, (int)count, (boolean)transpose, (float[])mat, (int)offset);
    }

    public void uniformMatrix3fv(int loc, int count, boolean transpose, float[] mat, int offset) {
        GLES20.glUniformMatrix3fv((int)loc, (int)count, (boolean)transpose, (float[])mat, (int)offset);
    }

    public void uniformMatrix4fv(int loc, int count, boolean transpose, float[] mat, int offset) {
        GLES20.glUniformMatrix4fv((int)loc, (int)count, (boolean)transpose, (float[])mat, (int)offset);
    }

    public void vertexAttrib1f(int loc, float value) {
        GLES20.glVertexAttrib1f((int)loc, (float)value);
    }

    public void vertexAttrib2f(int loc, float value0, float value1) {
        GLES20.glVertexAttrib2f((int)loc, (float)value0, (float)value1);
    }

    public void vertexAttrib3f(int loc, float value0, float value1, float value2) {
        GLES20.glVertexAttrib3f((int)loc, (float)value0, (float)value1, (float)value2);
    }

    public void vertexAttrib4f(int loc, float value0, float value1, float value2, float value3) {
        GLES20.glVertexAttrib4f((int)loc, (float)value0, (float)value1, (float)value2, (float)value3);
    }

    public void vertexAttrib1fv(int loc, float[] v, int offset) {
        GLES20.glVertexAttrib1fv((int)loc, (float[])v, (int)offset);
    }

    public void vertexAttrib2fv(int loc, float[] v, int offset) {
        GLES20.glVertexAttrib2fv((int)loc, (float[])v, (int)offset);
    }

    public void vertexAttrib3fv(int loc, float[] v, int offset) {
        GLES20.glVertexAttrib3fv((int)loc, (float[])v, (int)offset);
    }

    public void vertexAttrib4fv(int loc, float[] v, int offset) {
        GLES20.glVertexAttrib4fv((int)loc, (float[])v, (int)offset);
    }

    public void shaderSource(int id, String source) {
        GLES20.glShaderSource((int)id, (String)source);
    }

    public void compileShader(int id) {
        GLES20.glCompileShader((int)id);
    }

    public void attachShader(int prog, int shader) {
        GLES20.glAttachShader((int)prog, (int)shader);
    }

    public void getShaderiv(int shader, int pname, int[] params, int offset) {
        GLES20.glGetShaderiv((int)shader, (int)pname, (int[])params, (int)offset);
    }

    public String getShaderInfoLog(int shader) {
        return GLES20.glGetShaderInfoLog((int)shader);
    }

    public void getProgramiv(int prog, int pname, int[] params, int offset) {
        GLES20.glGetProgramiv((int)prog, (int)pname, (int[])params, (int)offset);
    }

    public String getProgramInfoLog(int prog) {
        return GLES20.glGetProgramInfoLog((int)prog);
    }

    public void viewport(int x, int y, int width, int height) {
        GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public void scissor(int x, int y, int w, int h) {
        GLES20.glScissor((int)x, (int)y, (int)w, (int)h);
    }

    public void blendEquation(int eq) {
        GLES20.glBlendEquation((int)eq);
    }

    public void blendFunc(int srcFactor, int dstFactor) {
        GLES20.glBlendFunc((int)srcFactor, (int)dstFactor);
    }

    public void readBuffer(int buf) {
    }

    public void readPixels(int x, int y, int width, int height, int format, int type, Buffer buffer) {
        GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (Buffer)buffer);
    }

    public void drawBuffer(int buf) {
    }

    public void clearDepth(float d) {
        GLES20.glClearDepthf((float)d);
    }

    public void clearStencil(int s) {
        GLES20.glClearStencil((int)s);
    }

    public void colorMask(boolean wr, boolean wg, boolean wb, boolean wa) {
        GLES20.glColorMask((boolean)wr, (boolean)wg, (boolean)wb, (boolean)wa);
    }

    public void clearColor(float r, float g, float b, float a) {
        GLES20.glClearColor((float)r, (float)g, (float)b, (float)a);
    }

    public void clear(int mask) {
        GLES20.glClear((int)mask);
    }

    protected Context createEmptyContext() {
        return new Context();
    }

    protected Context getCurrentContext() {
        return new Context(context);
    }

    protected Tessellator createTessellator(TessellatorCallback callback) {
        return new Tessellator(callback);
    }

    protected String tessError(int err) {
        return PGLU.gluErrorString(err);
    }

    protected boolean contextIsCurrent(Context other) {
        return other == null || other.current();
    }

    protected void enableTexturing(int target) {
        if (target == 3553) {
            PGL.texturingTargets[0] = true;
        }
    }

    protected void disableTexturing(int target) {
        if (target == 3553) {
            PGL.texturingTargets[0] = false;
        }
    }

    protected boolean texturingIsEnabled(int target) {
        if (target == 3553) {
            return texturingTargets[0];
        }
        return false;
    }

    protected boolean textureIsBound(int target, int id) {
        if (target == 3553) {
            return boundTextures[0] == id;
        }
        return false;
    }

    protected void initTexture(int target, int format, int width, int height) {
        int[] texels = new int[256];
        int y = 0;
        while (y < height) {
            int h = PApplet.min(16, height - y);
            int x = 0;
            while (x < width) {
                int w = PApplet.min(16, width - x);
                this.texSubImage2D(target, 0, x, y, w, h, format, 5121, IntBuffer.wrap(texels));
                x += 16;
            }
            y += 16;
        }
    }

    protected void copyToTexture(int target, int format, int id, int x, int y, int w, int h, IntBuffer buffer) {
        this.activeTexture(33984);
        boolean enabledTex = false;
        if (!this.texturingIsEnabled(target)) {
            this.enableTexturing(target);
            enabledTex = true;
        }
        this.bindTexture(target, id);
        this.texSubImage2D(target, 0, x, y, w, h, format, 5121, buffer);
        this.bindTexture(target, 0);
        if (enabledTex) {
            this.disableTexturing(target);
        }
    }

    protected void drawTexture(int target, int id, int width, int height, int X0, int Y0, int X1, int Y1) {
        this.drawTexture(target, id, width, height, X0, Y0, X1, Y1, X0, Y0, X1, Y1);
    }

    protected void drawTexture(int target, int id, int width, int height, int texX0, int texY0, int texX1, int texY1, int scrX0, int scrY0, int scrX1, int scrY1) {
        if (!this.loadedTexShader) {
            this.texVertShader = this.createShader(35633, this.texVertShaderSource);
            this.texFragShader = this.createShader(35632, this.texFragShaderSource);
            if (this.texVertShader > 0 && this.texFragShader > 0) {
                this.texShaderProgram = this.createProgram(this.texVertShader, this.texFragShader);
            }
            if (this.texShaderProgram > 0) {
                this.texVertLoc = this.getAttribLocation(this.texShaderProgram, "inVertex");
                this.texTCoordLoc = this.getAttribLocation(this.texShaderProgram, "inTexcoord");
            }
            this.texData = PGL.allocateDirectFloatBuffer(this.texCoords.length);
            this.loadedTexShader = true;
        }
        if (this.texShaderProgram > 0) {
            boolean[] depthTest = new boolean[1];
            this.getBooleanv(2929, depthTest, 0);
            this.disable(2929);
            boolean[] depthMask = new boolean[1];
            this.getBooleanv(2930, depthMask, 0);
            this.depthMask(false);
            this.useProgram(this.texShaderProgram);
            this.enableVertexAttribArray(this.texVertLoc);
            this.enableVertexAttribArray(this.texTCoordLoc);
            this.texCoords[0] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            this.texCoords[1] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            this.texCoords[2] = (float)texX0 / (float)width;
            this.texCoords[3] = (float)texY0 / (float)height;
            this.texCoords[4] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            this.texCoords[5] = 2.0f * (float)scrY0 / (float)this.pg.height - 1.0f;
            this.texCoords[6] = (float)texX1 / (float)width;
            this.texCoords[7] = (float)texY0 / (float)height;
            this.texCoords[8] = 2.0f * (float)scrX0 / (float)this.pg.width - 1.0f;
            this.texCoords[9] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            this.texCoords[10] = (float)texX0 / (float)width;
            this.texCoords[11] = (float)texY1 / (float)height;
            this.texCoords[12] = 2.0f * (float)scrX1 / (float)this.pg.width - 1.0f;
            this.texCoords[13] = 2.0f * (float)scrY1 / (float)this.pg.height - 1.0f;
            this.texCoords[14] = (float)texX1 / (float)width;
            this.texCoords[15] = (float)texY1 / (float)height;
            this.texData.rewind();
            this.texData.put(this.texCoords);
            this.activeTexture(33984);
            boolean enabledTex = false;
            if (!this.texturingIsEnabled(3553)) {
                this.enableTexturing(3553);
                enabledTex = true;
            }
            this.bindTexture(target, id);
            this.texData.position(0);
            this.vertexAttribPointer(this.texVertLoc, 2, 5126, false, 16, this.texData);
            this.texData.position(2);
            this.vertexAttribPointer(this.texTCoordLoc, 2, 5126, false, 16, this.texData);
            this.drawArrays(5, 0, 4);
            this.bindTexture(target, 0);
            if (enabledTex) {
                this.disableTexturing(3553);
            }
            this.disableVertexAttribArray(this.texVertLoc);
            this.disableVertexAttribArray(this.texTCoordLoc);
            this.useProgram(0);
            if (depthTest[0]) {
                this.enable(2929);
            } else {
                this.disable(2929);
            }
            this.depthMask(depthMask[0]);
        }
    }

    protected int getColorValue(int scrX, int scrY) {
        if (this.colorBuffer == null) {
            this.colorBuffer = IntBuffer.allocate(1);
        }
        this.colorBuffer.rewind();
        this.readPixels(scrX, this.pg.height - scrY - 1, 1, 1, 6408, 5121, this.colorBuffer);
        return this.colorBuffer.get();
    }

    protected float getDepthValue(int scrX, int scrY) {
        return 0.0f;
    }

    protected byte getStencilValue(int scrX, int scrY) {
        return 0;
    }

    protected static int nextPowerOfTwo(int val) {
        int ret = 1;
        while (ret < val) {
            ret <<= 1;
        }
        return ret;
    }

    protected static int nativeToJavaARGB(int color) {
        if (BIG_ENDIAN) {
            return color & 0xFF000000 | color >> 8 & 0xFFFFFF;
        }
        return color & 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void nativeToJavaARGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            int y = 0;
            while (y < height / 2) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] >> 8 & 0xFFFFFF;
                        pixels[yindex] = temp & 0xFF000000 | temp >> 8 & 0xFFFFFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                } else {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = temp & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                }
                yindex -= width * 2;
                ++y;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < width) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] >> 8 & 0xFFFFFF;
                    ++index;
                    ++x;
                }
            } else {
                x = 0;
                while (x < width) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                    ++x;
                }
            }
        }
    }

    protected static int nativeToJavaRGB(int color) {
        if (BIG_ENDIAN) {
            return color << 8 & 0xFFFFFF00 | 0xFF;
        }
        return 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void nativeToJavaRGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            int y = 0;
            while (y < height / 2) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] >> 8 & 0xFFFFFF;
                        pixels[yindex] = 0xFF000000 | temp >> 8 & 0xFFFFFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                } else {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                }
                yindex -= width * 2;
                ++y;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < width) {
                    pixels[index] = 0xFF000000 | pixels[index] >> 8 & 0xFFFFFF;
                    ++index;
                    ++x;
                }
            } else {
                x = 0;
                while (x < width) {
                    pixels[index] = 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                    ++x;
                }
            }
        }
    }

    protected static int javaToNativeARGB(int color) {
        if (BIG_ENDIAN) {
            return color >> 24 & 0xFF | color << 8 & 0xFFFFFF00;
        }
        return color & 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void javaToNativeARGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            int y = 0;
            while (y < height / 2) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] >> 24 & 0xFF | pixels[yindex] << 8 & 0xFFFFFF00;
                        pixels[yindex] = temp >> 24 & 0xFF | temp << 8 & 0xFFFFFF00;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                } else {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = pixels[yindex] & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                }
                yindex -= width * 2;
                ++y;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < width) {
                    pixels[index] = pixels[index] >> 24 & 0xFF | pixels[index] << 8 & 0xFFFFFF00;
                    ++index;
                    ++x;
                }
            } else {
                x = 0;
                while (x < width) {
                    pixels[index] = pixels[index] & 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                    ++x;
                }
            }
        }
    }

    protected static int javaToNativeRGB(int color) {
        if (BIG_ENDIAN) {
            return color << 8 & 0xFFFFFF00 | 0xFF;
        }
        return 0xFF000000 | color << 16 & 0xFF0000 | color & 0xFF00 | color >> 16 & 0xFF;
    }

    protected static void javaToNativeRGB(int[] pixels, int width, int height) {
        block9: {
            int x;
            int index = 0;
            int yindex = (height - 1) * width;
            int y = 0;
            while (y < height / 2) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = pixels[yindex] << 8 & 0xFFFFFF00 | 0xFF;
                        pixels[yindex] = temp << 8 & 0xFFFFFF00 | 0xFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                } else {
                    x2 = 0;
                    while (x2 < width) {
                        temp = pixels[index];
                        pixels[index] = 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                        pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                }
                yindex -= width * 2;
                ++y;
            }
            if (height % 2 != 1) break block9;
            index = height / 2 * width;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < width) {
                    pixels[index] = pixels[index] << 8 & 0xFFFFFF00 | 0xFF;
                    ++index;
                    ++x;
                }
            } else {
                x = 0;
                while (x < width) {
                    pixels[index] = 0xFF000000 | pixels[index] << 16 & 0xFF0000 | pixels[index] & 0xFF00 | pixels[index] >> 16 & 0xFF;
                    ++index;
                    ++x;
                }
            }
        }
    }

    protected int createShader(int shaderType, String source) {
        int shader = this.createShader(shaderType);
        if (shader != 0) {
            this.shaderSource(shader, source);
            this.compileShader(shader);
            int[] compiled = new int[1];
            this.getShaderiv(shader, 35713, compiled, 0);
            if (compiled[0] == 0) {
                System.err.println("Could not compile shader " + shaderType + ":");
                System.err.println(this.getShaderInfoLog(shader));
                this.deleteShader(shader);
                shader = 0;
            }
        }
        return shader;
    }

    protected int createProgram(int vertexShader, int fragmentShader) {
        int program = this.createProgram();
        if (program != 0) {
            this.attachShader(program, vertexShader);
            this.attachShader(program, fragmentShader);
            this.linkProgram(program);
            int[] linked = new int[1];
            this.getProgramiv(program, 35714, linked, 0);
            if (linked[0] == 0) {
                System.err.println("Could not link program: ");
                System.err.println(this.getProgramInfoLog(program));
                this.deleteProgram(program);
                program = 0;
            }
        }
        return program;
    }

    protected boolean validateFramebuffer() {
        int status = this.checkFramebufferStatus(36160);
        if (status == 36053) {
            return true;
        }
        if (status == 36054) {
            throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT (" + Integer.toHexString(status) + ")");
        }
        if (status == 36055) {
            throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT (" + Integer.toHexString(status) + ")");
        }
        if (status == 36057) {
            throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS (" + Integer.toHexString(status) + ")");
        }
        if (status == 36058) {
            throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_FORMATS (" + Integer.toHexString(status) + ")");
        }
        if (status == 36061) {
            throw new RuntimeException("GL_FRAMEBUFFER_UNSUPPORTED" + Integer.toHexString(status));
        }
        throw new RuntimeException("unknown framebuffer error (" + Integer.toHexString(status) + ")");
    }

    protected static ByteBuffer allocateDirectByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 1).order(ByteOrder.nativeOrder());
    }

    protected static IntBuffer allocateDirectIntBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    protected static FloatBuffer allocateDirectFloatBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    protected int[] getGLVersion() {
        String version = GLES20.glGetString((int)7938).trim();
        int[] res = new int[3];
        String[] parts = version.split(" ");
        int i = 0;
        while (i < parts.length) {
            if (parts[i].indexOf(".") > 0) {
                String[] nums = parts[i].split("\\.");
                try {
                    res[0] = Integer.parseInt(nums[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (1 < nums.length) {
                    try {
                        res[1] = Integer.parseInt(nums[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (2 >= nums.length) break;
                try {
                    res[2] = Integer.parseInt(nums[2]);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            ++i;
        }
        return res;
    }

    public AndroidRenderer getRenderer() {
        return this.renderer;
    }

    public AndroidContextFactory getContextFactory() {
        return new AndroidContextFactory();
    }

    public AndroidConfigChooser getConfigChooser(int r, int g, int b, int a, int d, int s) {
        return new AndroidConfigChooser(r, g, b, a, d, s);
    }

    protected class AndroidConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        public int redTarget;
        public int greenTarget;
        public int blueTarget;
        public int alphaTarget;
        public int depthTarget;
        public int stencilTarget;
        public int redBits;
        public int greenBits;
        public int blueBits;
        public int alphaBits;
        public int depthBits;
        public int stencilBits;
        public int[] tempValue = new int[1];
        protected int[] configAttribsGL = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, 4, 12344};

        public AndroidConfigChooser(int r, int g, int b, int a, int d, int s) {
            this.redTarget = r;
            this.greenTarget = g;
            this.blueTarget = b;
            this.alphaTarget = a;
            this.depthTarget = d;
            this.stencilTarget = s;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            egl.eglChooseConfig(display, this.configAttribsGL, null, 0, num_config);
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No EGL configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            egl.eglChooseConfig(display, this.configAttribsGL, configs, numConfigs, num_config);
            return this.chooseBestConfig(egl, display, configs);
        }

        public EGLConfig chooseBestConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            EGLConfig bestConfig = null;
            float bestScore = 1000.0f;
            EGLConfig[] eGLConfigArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                EGLConfig config = eGLConfigArray[n2];
                int gl = this.findConfigAttrib(egl, display, config, 12352, 0);
                if (gl == 4) {
                    int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                    int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                    int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                    int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                    int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                    int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                    float score = 0.2f * (float)PApplet.abs(r - this.redTarget) + 0.2f * (float)PApplet.abs(g - this.greenTarget) + 0.2f * (float)PApplet.abs(b - this.blueTarget) + 0.15f * (float)PApplet.abs(a - this.blueTarget) + 0.15f * (float)PApplet.abs(d - this.depthTarget) + 0.1f * (float)PApplet.abs(s - this.stencilTarget);
                    if (score < bestScore) {
                        bestConfig = config;
                        bestScore = score;
                        this.redBits = r;
                        this.greenBits = g;
                        this.blueBits = b;
                        this.alphaBits = a;
                        this.depthBits = d;
                        this.stencilBits = s;
                    }
                }
                ++n2;
            }
            return bestConfig;
        }

        protected String printConfig(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int r = this.findConfigAttrib(egl, display, config, 12324, 0);
            int g = this.findConfigAttrib(egl, display, config, 12323, 0);
            int b = this.findConfigAttrib(egl, display, config, 12322, 0);
            int a = this.findConfigAttrib(egl, display, config, 12321, 0);
            int d = this.findConfigAttrib(egl, display, config, 12325, 0);
            int s = this.findConfigAttrib(egl, display, config, 12326, 0);
            int type = this.findConfigAttrib(egl, display, config, 12352, 0);
            int nat = this.findConfigAttrib(egl, display, config, 12333, 0);
            int bufSize = this.findConfigAttrib(egl, display, config, 12320, 0);
            int bufSurf = this.findConfigAttrib(egl, display, config, 12422, 0);
            return String.valueOf(String.format("EGLConfig rgba=%d%d%d%d depth=%d stencil=%d", r, g, b, a, d, s)) + " type=" + type + " native=" + nat + " buffer size=" + bufSize + " buffer surface=" + bufSurf + String.format(" caveat=0x%04x", this.findConfigAttrib(egl, display, config, 12327, 0));
        }

        protected int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.tempValue)) {
                return this.tempValue[0];
            }
            return defaultValue;
        }
    }

    protected class AndroidContextFactory
    implements GLSurfaceView.EGLContextFactory {
        protected AndroidContextFactory() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig eglConfig) {
            int[] attrib_list = new int[]{12440, 2, 12344};
            EGLContext context = egl.eglCreateContext(display, eglConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
            return context;
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            egl.eglDestroyContext(display, context);
        }
    }

    protected class AndroidRenderer
    implements GLSurfaceView.Renderer {
        public void onDrawFrame(GL10 igl) {
            PGL.this.gl = igl;
            PGL.this.pg.parent.handleDraw();
        }

        public void onSurfaceChanged(GL10 igl, int iwidth, int iheight) {
            PGL.this.gl = igl;
            PGL.this.pg.setSize(iwidth, iheight);
        }

        public void onSurfaceCreated(GL10 igl, EGLConfig config) {
            PGL.this.gl = igl;
            context = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
        }
    }

    protected class Context {
        protected int id;

        Context() {
            this.id = -1;
        }

        Context(EGLContext context) {
            this.id = context != null ? context.hashCode() : -1;
        }

        boolean current() {
            return this.equal(context);
        }

        boolean equal(EGLContext context) {
            if (this.id == -1 || context == null) {
                return true;
            }
            return this.id == context.hashCode();
        }

        int id() {
            return this.id;
        }
    }

    protected class Tessellator {
        protected PGLUtessellator tess;
        protected TessellatorCallback callback;
        protected GLUCallback gluCallback;

        public Tessellator(TessellatorCallback callback) {
            this.callback = callback;
            this.tess = PGLU.gluNewTess();
            this.gluCallback = new GLUCallback();
            PGLU.gluTessCallback(this.tess, 100100, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100102, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100101, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100105, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100103, this.gluCallback);
        }

        public void beginPolygon() {
            PGLU.gluTessBeginPolygon(this.tess, null);
        }

        public void endPolygon() {
            PGLU.gluTessEndPolygon(this.tess);
        }

        public void setWindingRule(int rule) {
            PGLU.gluTessProperty(this.tess, 100140, rule);
        }

        public void beginContour() {
            PGLU.gluTessBeginContour(this.tess);
        }

        public void endContour() {
            PGLU.gluTessEndContour(this.tess);
        }

        public void addVertex(double[] v) {
            PGLU.gluTessVertex(this.tess, v, 0, v);
        }

        protected class GLUCallback
        extends PGLUtessellatorCallbackAdapter {
            protected GLUCallback() {
            }

            public void begin(int type) {
                Tessellator.this.callback.begin(type);
            }

            public void end() {
                Tessellator.this.callback.end();
            }

            public void vertex(Object data) {
                Tessellator.this.callback.vertex(data);
            }

            public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
                Tessellator.this.callback.combine(coords, data, weight, outData);
            }

            public void error(int errnum) {
                Tessellator.this.callback.error(errnum);
            }
        }
    }

    protected static interface TessellatorCallback {
        public void begin(int var1);

        public void end();

        public void vertex(Object var1);

        public void combine(double[] var1, Object[] var2, float[] var3, Object[] var4);

        public void error(int var1);
    }
}

