/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ConfigurationInfo;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.net.Uri;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.os.Handler;
import android.text.format.Time;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PGraphicsAndroid2D;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PStyle;
import processing.data.Table;
import processing.data.XML;
import processing.event.KeyEvent;
import processing.event.MouseEvent;
import processing.event.TouchEvent;
import processing.opengl.PGL;
import processing.opengl.PGraphics2D;
import processing.opengl.PGraphics3D;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PShader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PApplet
extends Activity
implements PConstants,
Runnable {
    public PGraphics g;
    public static final boolean DEBUG = false;
    public int displayWidth;
    public int displayHeight;
    public String sketchPath;
    protected boolean surfaceReady;
    protected boolean surfaceChanged;
    public int[] pixels;
    public int width;
    public int height;
    public int mouseX;
    public int mouseY;
    public float motionX;
    public float motionY;
    public float motionPressure;
    protected int numPointers;
    protected int pnumPointers;
    protected float[] ppointersX = new float[]{0.0f};
    protected float[] ppointersY = new float[]{0.0f};
    protected float[] ppointersPressure = new float[]{0.0f};
    protected float[] pointersX = new float[]{0.0f};
    protected float[] pointersY = new float[]{0.0f};
    protected float[] pointersPressure = new float[]{0.0f};
    protected int downMillis;
    protected float downX;
    protected float downY;
    protected boolean onePointerGesture = false;
    protected boolean twoPointerGesture = true;
    protected final int MIN_SWIPE_LENGTH = 150;
    protected final int MAX_SWIPE_DURATION = 2000;
    protected final int MAX_TAP_DISP = 20;
    protected final int MAX_TAP_DURATION = 1000;
    public int pmouseX;
    public int pmouseY;
    public float pmotionX;
    public float pmotionY;
    protected int dmouseX;
    protected int dmouseY;
    protected float dmotionX;
    protected float dmotionY;
    protected int emouseX;
    protected int emouseY;
    protected float emotionX;
    protected float emotionY;
    public boolean firstMotion;
    public boolean mousePressed;
    Handler handler;
    public char key;
    public int keyCode;
    public boolean keyPressed;
    public KeyEvent keyEvent;
    public boolean focused = false;
    protected boolean windowFocused = false;
    protected boolean viewFocused = false;
    long millisOffset = System.currentTimeMillis();
    public float frameRate = 10.0f;
    protected long frameRateLastNanos = 0L;
    protected float frameRateTarget = 60.0f;
    protected long frameRatePeriod = 16666666L;
    protected boolean looping;
    protected boolean redraw;
    public int frameCount;
    public boolean finished;
    protected boolean paused;
    protected SurfaceView surfaceView;
    protected boolean exitCalled;
    Thread thread;
    public static final String ARGS_EDITOR_LOCATION = "--editor-location";
    public static final String ARGS_EXTERNAL = "--external";
    public static final String ARGS_LOCATION = "--location";
    public static final String ARGS_DISPLAY = "--display";
    public static final String ARGS_BGCOLOR = "--bgcolor";
    public static final String ARGS_PRESENT = "--present";
    public static final String ARGS_EXCLUSIVE = "--exclusive";
    public static final String ARGS_STOP_COLOR = "--stop-color";
    public static final String ARGS_HIDE_STOP = "--hide-stop";
    public static final String ARGS_SKETCH_FOLDER = "--sketch-path";
    public static final String EXTERNAL_STOP = "__STOP__";
    public static final String EXTERNAL_MOVE = "__MOVE__";
    boolean external = false;
    static final String ERROR_MIN_MAX = "Cannot use min() or max() on an empty array.";
    HashMap<String, RegisteredMethods> registerMap = new HashMap();
    Object motionLock = new Object();
    PMotionEvent[] motionEventQueue;
    int motionEventCount;
    KeyEvent[] keyEventQueue = new KeyEvent[10];
    int keyEventCount;
    protected static Time time = new Time();
    Random internalRandom;
    static final int PERLIN_YWRAPB = 4;
    static final int PERLIN_YWRAP = 16;
    static final int PERLIN_ZWRAPB = 8;
    static final int PERLIN_ZWRAP = 256;
    static final int PERLIN_SIZE = 4095;
    int perlin_octaves = 4;
    float perlin_amp_falloff = 0.5f;
    int perlin_TWOPI;
    int perlin_PI;
    float[] perlin_cosTable;
    float[] perlin;
    Random perlinRandom;
    public int requestImageMax = 4;
    volatile int requestImageCount;
    protected static HashMap<String, Pattern> matchPatterns;
    private static NumberFormat int_nf;
    private static int int_nf_digits;
    private static boolean int_nf_commas;
    private static NumberFormat float_nf;
    private static int float_nf_left;
    private static int float_nf_right;
    private static boolean float_nf_commas;
    public static final byte[] ICON_IMAGE;

    static {
        byte[] byArray = new byte[205];
        byArray[0] = 71;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 56;
        byArray[4] = 57;
        byArray[5] = 97;
        byArray[6] = 16;
        byArray[8] = 16;
        byArray[10] = -77;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = 12;
        byArray[20] = 12;
        byArray[21] = 13;
        byArray[22] = -15;
        byArray[23] = -15;
        byArray[24] = -14;
        byArray[25] = 45;
        byArray[26] = 57;
        byArray[27] = 74;
        byArray[28] = 54;
        byArray[29] = 80;
        byArray[30] = 111;
        byArray[31] = 47;
        byArray[32] = 71;
        byArray[33] = 97;
        byArray[34] = 62;
        byArray[35] = 88;
        byArray[36] = 117;
        byArray[37] = 1;
        byArray[38] = 14;
        byArray[39] = 27;
        byArray[40] = 7;
        byArray[41] = 41;
        byArray[42] = 73;
        byArray[43] = 15;
        byArray[44] = 52;
        byArray[45] = 85;
        byArray[46] = 2;
        byArray[47] = 31;
        byArray[48] = 55;
        byArray[49] = 4;
        byArray[50] = 54;
        byArray[51] = 94;
        byArray[52] = 18;
        byArray[53] = 69;
        byArray[54] = 109;
        byArray[55] = 37;
        byArray[56] = 87;
        byArray[57] = 126;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = 33;
        byArray[62] = -7;
        byArray[63] = 4;
        byArray[64] = 1;
        byArray[67] = 15;
        byArray[69] = 44;
        byArray[74] = 16;
        byArray[76] = 16;
        byArray[79] = 4;
        byArray[80] = 122;
        byArray[81] = -16;
        byArray[82] = -107;
        byArray[83] = 114;
        byArray[84] = -86;
        byArray[85] = -67;
        byArray[86] = 83;
        byArray[87] = 30;
        byArray[88] = -42;
        byArray[89] = 26;
        byArray[90] = -17;
        byArray[91] = -100;
        byArray[92] = -45;
        byArray[93] = 56;
        byArray[94] = -57;
        byArray[95] = -108;
        byArray[96] = 48;
        byArray[97] = 40;
        byArray[98] = 122;
        byArray[99] = -90;
        byArray[100] = 104;
        byArray[101] = 67;
        byArray[102] = -91;
        byArray[103] = -51;
        byArray[104] = 32;
        byArray[105] = -53;
        byArray[106] = 77;
        byArray[107] = -78;
        byArray[108] = -100;
        byArray[109] = 47;
        byArray[110] = -86;
        byArray[111] = 12;
        byArray[112] = 76;
        byArray[113] = -110;
        byArray[114] = -20;
        byArray[115] = -74;
        byArray[116] = -101;
        byArray[117] = 97;
        byArray[118] = -93;
        byArray[119] = 27;
        byArray[120] = 40;
        byArray[121] = 20;
        byArray[122] = -65;
        byArray[123] = 65;
        byArray[124] = 48;
        byArray[125] = -111;
        byArray[126] = 99;
        byArray[127] = -20;
        byArray[128] = -112;
        byArray[129] = -117;
        byArray[130] = -123;
        byArray[131] = -47;
        byArray[132] = -105;
        byArray[133] = 24;
        byArray[134] = 114;
        byArray[135] = -112;
        byArray[136] = 74;
        byArray[137] = 69;
        byArray[138] = 84;
        byArray[139] = 25;
        byArray[140] = 93;
        byArray[141] = 88;
        byArray[142] = -75;
        byArray[143] = 9;
        byArray[144] = 46;
        byArray[145] = 2;
        byArray[146] = 49;
        byArray[147] = 88;
        byArray[148] = -116;
        byArray[149] = -67;
        byArray[150] = 7;
        byArray[151] = -19;
        byArray[152] = -83;
        byArray[153] = 60;
        byArray[154] = 38;
        byArray[155] = 3;
        byArray[156] = -34;
        byArray[157] = 2;
        byArray[158] = 66;
        byArray[159] = -95;
        byArray[160] = 27;
        byArray[161] = -98;
        byArray[162] = 13;
        byArray[163] = 4;
        byArray[164] = -17;
        byArray[165] = 55;
        byArray[166] = 33;
        byArray[167] = 109;
        byArray[168] = 11;
        byArray[169] = 11;
        byArray[170] = -2;
        byArray[171] = -128;
        byArray[172] = 121;
        byArray[173] = 123;
        byArray[174] = 62;
        byArray[175] = 91;
        byArray[176] = 120;
        byArray[177] = -128;
        byArray[178] = 127;
        byArray[179] = 122;
        byArray[180] = 115;
        byArray[181] = 102;
        byArray[182] = 2;
        byArray[183] = 119;
        byArray[185] = -116;
        byArray[186] = -113;
        byArray[187] = -119;
        byArray[188] = 6;
        byArray[189] = 102;
        byArray[190] = 121;
        byArray[191] = -108;
        byArray[192] = -126;
        byArray[193] = 5;
        byArray[194] = 18;
        byArray[195] = 6;
        byArray[196] = 4;
        byArray[197] = -102;
        byArray[198] = -101;
        byArray[199] = -100;
        byArray[200] = 114;
        byArray[201] = 15;
        byArray[202] = 17;
        byArray[204] = 59;
        ICON_IMAGE = byArray;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        this.requestWindowFeature(1);
        window.setFlags(256, 256);
        window.setFlags(1024, 1024);
        DisplayMetrics dm = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(dm);
        this.displayWidth = dm.widthPixels;
        this.displayHeight = dm.heightPixels;
        int sw = this.sketchWidth();
        int sh = this.sketchHeight();
        if (this.sketchRenderer().equals("processing.core.PGraphicsAndroid2D")) {
            this.surfaceView = new SketchSurfaceView((Context)this, sw, sh);
        } else if (this.sketchRenderer().equals("processing.opengl.PGraphics2D") || this.sketchRenderer().equals("processing.opengl.PGraphics3D")) {
            this.surfaceView = new SketchSurfaceViewGL((Context)this, sw, sh, this.sketchRenderer().equals("processing.opengl.PGraphics3D"));
        }
        if (sw == this.displayWidth && sh == this.displayHeight) {
            window.setContentView((View)this.surfaceView);
        } else {
            RelativeLayout overallLayout = new RelativeLayout((Context)this);
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
            lp.addRule(13);
            LinearLayout layout = new LinearLayout((Context)this);
            layout.addView((View)this.surfaceView, this.sketchWidth(), this.sketchHeight());
            overallLayout.addView((View)layout, (ViewGroup.LayoutParams)lp);
            window.setContentView((View)overallLayout);
        }
        this.finished = false;
        this.looping = true;
        this.redraw = true;
        this.firstMotion = true;
        Context context = this.getApplicationContext();
        this.sketchPath = context.getFilesDir().getAbsolutePath();
        this.handler = new Handler();
        this.start();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    protected void onResume() {
        super.onResume();
        this.paused = false;
        this.handleMethods("resume");
        this.resume();
    }

    protected void onPause() {
        super.onPause();
        this.paused = true;
        this.handleMethods("pause");
        this.pause();
    }

    public void pause() {
    }

    public void resume() {
    }

    public void onDestroy() {
        this.dispose();
        super.onDestroy();
    }

    public SurfaceHolder getSurfaceHolder() {
        return this.surfaceView.getHolder();
    }

    public void andresNeedsBetterAPI() {
        if (this.looping) {
            ((GLSurfaceView)this.surfaceView).requestRender();
        }
    }

    public void surfaceWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        this.focused = hasFocus;
        if (this.focused) {
            this.focusGained();
        } else {
            this.focusLost();
        }
    }

    public boolean surfaceTouchEvent(MotionEvent event) {
        this.nativeMotionEvent(event);
        return true;
    }

    public boolean surfaceKeyDown(int code, android.view.KeyEvent event) {
        this.nativeKeyEvent(event);
        return super.onKeyDown(code, event);
    }

    public boolean surfaceKeyUp(int code, android.view.KeyEvent event) {
        this.nativeKeyEvent(event);
        return super.onKeyUp(code, event);
    }

    public int sketchQuality() {
        return 1;
    }

    public int sketchWidth() {
        return this.displayWidth;
    }

    public int sketchHeight() {
        return this.displayHeight;
    }

    public String sketchRenderer() {
        return "processing.core.PGraphicsAndroid2D";
    }

    public void orientation(int which) {
        if (which == 1) {
            this.setRequestedOrientation(1);
        } else if (which == 2) {
            this.setRequestedOrientation(0);
        }
    }

    public void start() {
        this.finished = false;
        this.paused = false;
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Animation Thread");
            this.thread.start();
        }
    }

    public void stop() {
        this.paused = true;
    }

    public void destroy() {
        this.exit();
    }

    public void registerMethod(String methodName, Object target) {
        if (methodName.equals("mouseEvent")) {
            this.registerWithArgs("mouseEvent", target, new Class[]{MouseEvent.class});
        } else if (methodName.equals("keyEvent")) {
            this.registerWithArgs("keyEvent", target, new Class[]{KeyEvent.class});
        } else if (methodName.equals("touchEvent")) {
            this.registerWithArgs("touchEvent", target, new Class[]{TouchEvent.class});
        } else {
            this.registerNoArgs(methodName, target);
        }
    }

    private void registerNoArgs(String name, Object o) {
        RegisteredMethods meth = this.registerMap.get(name);
        if (meth == null) {
            meth = new RegisteredMethods();
            this.registerMap.put(name, meth);
        }
        Class<?> c = o.getClass();
        try {
            Method method = c.getMethod(name, new Class[0]);
            meth.add(o, method);
        }
        catch (NoSuchMethodException nsme) {
            this.die("There is no public " + name + "() method in the class " + o.getClass().getName());
        }
        catch (Exception e) {
            this.die("Could not register " + name + " + () for " + o, e);
        }
    }

    private void registerWithArgs(String name, Object o, Class<?>[] cargs) {
        RegisteredMethods meth = this.registerMap.get(name);
        if (meth == null) {
            meth = new RegisteredMethods();
            this.registerMap.put(name, meth);
        }
        Class<?> c = o.getClass();
        try {
            Method method = c.getMethod(name, cargs);
            meth.add(o, method);
        }
        catch (NoSuchMethodException nsme) {
            this.die("There is no public " + name + "() method in the class " + o.getClass().getName());
        }
        catch (Exception e) {
            this.die("Could not register " + name + " + () for " + o, e);
        }
    }

    public void unregisterMethod(String name, Object target) {
        RegisteredMethods meth = this.registerMap.get(name);
        if (meth == null) {
            this.die("No registered methods with the name " + name + "() were found.");
        }
        try {
            meth.remove(target);
        }
        catch (Exception e) {
            this.die("Could not unregister " + name + "() for " + target, e);
        }
    }

    protected void handleMethods(String methodName) {
        RegisteredMethods meth = this.registerMap.get(methodName);
        if (meth != null) {
            meth.handle();
        }
    }

    protected void handleMethods(String methodName, Object[] args) {
        RegisteredMethods meth = this.registerMap.get(methodName);
        if (meth != null) {
            meth.handle(args);
        }
    }

    @Deprecated
    public void registerSize(Object o) {
        System.err.println("The registerSize() command is no longer supported.");
    }

    @Deprecated
    public void registerPre(Object o) {
        this.registerNoArgs("pre", o);
    }

    @Deprecated
    public void registerDraw(Object o) {
        this.registerNoArgs("draw", o);
    }

    @Deprecated
    public void registerPost(Object o) {
        this.registerNoArgs("post", o);
    }

    @Deprecated
    public void registerDispose(Object o) {
        this.registerNoArgs("dispose", o);
    }

    @Deprecated
    public void unregisterSize(Object o) {
        System.err.println("The unregisterSize() command is no longer supported.");
    }

    @Deprecated
    public void unregisterPre(Object o) {
        this.unregisterMethod("pre", o);
    }

    @Deprecated
    public void unregisterDraw(Object o) {
        this.unregisterMethod("draw", o);
    }

    @Deprecated
    public void unregisterPost(Object o) {
        this.unregisterMethod("post", o);
    }

    @Deprecated
    public void unregisterDispose(Object o) {
        this.unregisterMethod("dispose", o);
    }

    public void setup() {
    }

    public void draw() {
        this.finished = true;
    }

    public void size(int iwidth, int iheight) {
        this.size(iwidth, iheight, "processing.opengl.PGraphics2D", null);
    }

    public void size(int iwidth, int iheight, String irenderer) {
        this.size(iwidth, iheight, irenderer, null);
    }

    public void size(int iwidth, int iheight, String irenderer, String ipath) {
        System.out.println("This size() method is ignored on Android.");
        System.out.println("See http://wiki.processing.org/w/Android for more information.");
    }

    public PGraphics createGraphics(int iwidth, int iheight) {
        return this.createGraphics(iwidth, iheight, "processing.core.PGraphicsAndroid2D");
    }

    public PGraphics createGraphics(int iwidth, int iheight, String irenderer) {
        PGraphics pg = null;
        if (irenderer.equals("processing.core.PGraphicsAndroid2D")) {
            pg = new PGraphicsAndroid2D();
        } else if (irenderer.equals("processing.opengl.PGraphics2D")) {
            if (!this.g.isGL()) {
                throw new RuntimeException("createGraphics() with P2D requires size() to use P2D or P3D");
            }
            pg = new PGraphics2D();
        } else if (irenderer.equals("processing.opengl.PGraphics3D")) {
            if (!this.g.isGL()) {
                throw new RuntimeException("createGraphics() with P3D or OPENGL requires size() to use P2D or P3D");
            }
            pg = new PGraphics3D();
        } else {
            Class<?> rendererClass = null;
            Constructor<?> constructor = null;
            try {
                rendererClass = this.getClass().getClassLoader().loadClass(irenderer);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Missing renderer class");
            }
            if (rendererClass != null) {
                try {
                    constructor = rendererClass.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new RuntimeException("Missing renderer constructor");
                }
                if (constructor != null) {
                    try {
                        pg = (PGraphics)constructor.newInstance(new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e.getMessage());
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e.getMessage());
                    }
                }
            }
        }
        pg.setParent(this);
        pg.setPrimary(false);
        ((PGraphics)pg).setSize(iwidth, iheight);
        return pg;
    }

    public PImage createImage(int wide, int high, int format) {
        PImage image = new PImage(wide, high, format);
        image.parent = this;
        return image;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        beforeTime = System.nanoTime();
        overSleepTime = 0L;
        noDelays = 0;
        NO_DELAYS_PER_YIELD = 15;
        ** GOTO lbl29
        {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException var7_5) {
                // empty catch block
            }
            do {
                if (this.paused) continue block4;
                if (this.g != null) {
                    this.g.requestDraw();
                }
                if ((sleepTime = this.frameRatePeriod - (timeDiff = (afterTime = System.nanoTime()) - beforeTime) - overSleepTime) > 0L) {
                    try {
                        Thread.sleep(sleepTime / 1000000L, (int)(sleepTime % 1000000L));
                        noDelays = 0;
                    }
                    catch (InterruptedException var13_9) {
                        // empty catch block
                    }
                    overSleepTime = System.nanoTime() - afterTime - sleepTime;
                } else {
                    overSleepTime = 0L;
                    if (noDelays > 15) {
                        Thread.yield();
                        noDelays = 0;
                    }
                }
                beforeTime = System.nanoTime();
lbl29:
                // 2 sources

            } while (Thread.currentThread() == this.thread && !this.finished);
        }
        if (!this.paused) {
            this.stop();
            if (this.exitCalled) {
                this.exit2();
            }
        }
    }

    public void handleDraw() {
        if (this.surfaceChanged) {
            int newWidth = this.surfaceView.getWidth();
            int newHeight = this.surfaceView.getHeight();
            if (newWidth != this.width || newHeight != this.height) {
                this.width = newWidth;
                this.height = newHeight;
                this.g.setSize(this.width, this.height);
            }
            this.surfaceChanged = false;
            this.surfaceReady = true;
        }
        if (this.g != null && this.surfaceReady && !this.paused && (this.looping || this.redraw)) {
            this.g.beginDraw();
            long now = System.nanoTime();
            if (this.frameCount == 0) {
                try {
                    this.setup();
                }
                catch (RendererChangeException e) {
                    return;
                }
            } else {
                double rate = 1000000.0 / ((double)(now - this.frameRateLastNanos) / 1000000.0);
                float instantaneousRate = (float)rate / 1000.0f;
                this.frameRate = this.frameRate * 0.9f + instantaneousRate * 0.1f;
                if (this.frameCount != 0) {
                    this.handleMethods("pre");
                }
                this.pmouseX = this.dmouseX;
                this.pmouseY = this.dmouseY;
                this.pmotionX = this.dmotionX;
                this.pmotionY = this.dmotionY;
                this.draw();
                this.dmouseX = this.mouseX;
                this.dmouseY = this.mouseY;
                this.dmotionX = this.motionX;
                this.dmotionY = this.motionY;
                this.dequeueMotionEvents();
                this.dequeueKeyEvents();
                this.handleMethods("draw");
                this.redraw = false;
            }
            this.g.endDraw();
            if (this.frameCount != 0) {
                this.handleMethods("post");
            }
            this.frameRateLastNanos = now;
            ++this.frameCount;
        }
    }

    public synchronized void redraw() {
        if (!this.looping) {
            this.redraw = true;
        }
    }

    public synchronized void loop() {
        if (!this.looping) {
            this.looping = true;
        }
    }

    public synchronized void noLoop() {
        if (this.looping) {
            this.looping = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueMotionEvent(MotionEvent event) {
        Object object = this.motionLock;
        synchronized (object) {
            int historyCount;
            if (this.motionEventQueue == null) {
                this.motionEventQueue = new PMotionEvent[20];
                int i = 0;
                while (i < this.motionEventQueue.length) {
                    this.motionEventQueue[i] = new PMotionEvent();
                    ++i;
                }
            }
            if (this.motionEventCount + (historyCount = event.getHistorySize()) >= this.motionEventQueue.length) {
                int atLeast = this.motionEventCount + historyCount + 1;
                PMotionEvent[] temp = new PMotionEvent[PApplet.max(atLeast, this.motionEventCount << 1)];
                System.arraycopy(this.motionEventQueue, 0, temp, 0, this.motionEventCount);
                this.motionEventQueue = temp;
                int i = this.motionEventCount;
                while (i < this.motionEventQueue.length) {
                    this.motionEventQueue[i] = new PMotionEvent();
                    ++i;
                }
            }
            PMotionEvent pme = this.motionEventQueue[this.motionEventCount + historyCount];
            pme.setAction(event.getAction());
            pme.setNumPointers(event.getPointerCount());
            pme.setPointers(event);
            if (pme.action == 2 && historyCount > 0) {
                int i = 0;
                while (i < historyCount) {
                    PMotionEvent hist = this.motionEventQueue[this.motionEventCount++];
                    hist.setAction(event.getAction());
                    hist.setNumPointers(event.getPointerCount());
                    hist.setPointers(event, i);
                    ++i;
                }
            }
            ++this.motionEventCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dequeueMotionEvents() {
        Object object = this.motionLock;
        synchronized (object) {
            int i = 0;
            while (i < this.motionEventCount) {
                this.handleMotionEvent(this.motionEventQueue[i]);
                ++i;
            }
            this.motionEventCount = 0;
        }
    }

    protected void handleMotionEvent(PMotionEvent pme) {
        this.pmotionX = this.emotionX;
        this.pmotionY = this.emotionY;
        this.motionX = pme.motionX[0];
        this.motionY = pme.motionY[0];
        this.motionPressure = pme.motionPressure[0];
        this.pmouseX = this.emouseX;
        this.pmouseY = this.emouseY;
        this.mouseX = pme.mouseX[0];
        this.mouseY = pme.mouseY[0];
        if (this.firstMotion) {
            this.pmouseX = this.mouseX;
            this.pmouseY = this.mouseY;
            this.dmouseX = this.mouseX;
            this.dmouseY = this.mouseY;
            this.pmotionX = this.motionX;
            this.pmotionY = this.motionY;
            this.dmotionX = this.motionX;
            this.dmotionY = this.motionY;
            this.firstMotion = false;
        }
        if (this.ppointersX.length < this.numPointers) {
            this.ppointersX = new float[this.numPointers];
            this.ppointersY = new float[this.numPointers];
            this.ppointersPressure = new float[this.numPointers];
        }
        PApplet.arrayCopy(this.pointersX, this.ppointersX);
        PApplet.arrayCopy(this.pointersY, this.ppointersY);
        PApplet.arrayCopy(this.pointersPressure, this.ppointersPressure);
        this.numPointers = pme.numPointers;
        if (this.pointersX.length < this.numPointers) {
            this.pointersX = new float[this.numPointers];
            this.pointersY = new float[this.numPointers];
            this.pointersPressure = new float[this.numPointers];
        }
        PApplet.arrayCopy(pme.motionX, this.pointersX);
        PApplet.arrayCopy(pme.motionY, this.pointersY);
        PApplet.arrayCopy(pme.motionPressure, this.pointersPressure);
        if (pme.action == 0 || !this.mousePressed && this.numPointers == 1) {
            this.mousePressed = true;
            this.onePointerGesture = true;
            this.twoPointerGesture = false;
            this.downMillis = this.millis();
            this.downX = this.pointersX[0];
            this.downY = this.pointersY[0];
            this.mousePressed();
            this.pressEvent();
        } else if (pme.action == 5 && this.numPointers == 2 || pme.action == 261 || this.pnumPointers == 1 && this.numPointers == 2) {
            this.onePointerGesture = false;
            this.twoPointerGesture = true;
        } else if (pme.action == 6 && this.numPointers == 2 || pme.action == 262 || this.twoPointerGesture && this.numPointers < 2) {
            this.twoPointerGesture = false;
        } else if (pme.action == 2) {
            if (this.onePointerGesture) {
                if (this.mousePressed) {
                    this.mouseDragged();
                    this.dragEvent();
                } else {
                    this.mouseMoved();
                    this.moveEvent();
                }
            } else if (this.twoPointerGesture) {
                float d0 = PApplet.dist(this.ppointersX[0], this.ppointersY[0], this.ppointersX[1], this.ppointersY[1]);
                float d1 = PApplet.dist(this.pointersX[0], this.pointersY[0], this.pointersX[1], this.pointersY[1]);
                if (0.0f < d0 && 0.0f < d1) {
                    float centerX = 0.5f * (this.pointersX[0] + this.pointersX[1]);
                    float centerY = 0.5f * (this.pointersY[0] + this.pointersY[1]);
                    this.zoomEvent(centerX, centerY, d0, d1);
                }
            }
        } else if (pme.action == 1) {
            this.mousePressed = false;
            float upX = this.pointersX[0];
            float upY = this.pointersY[0];
            float gestureLength = PApplet.dist(this.downX, this.downY, upX, upY);
            int upMillis = this.millis();
            int gestureTime = upMillis - this.downMillis;
            if (this.onePointerGesture) {
                boolean tap;
                boolean bl = tap = gestureLength <= 20.0f && gestureTime <= 1000;
                if (tap) {
                    this.mouseClicked();
                    this.tapEvent(this.downX, this.downY);
                } else if (150.0f <= gestureLength && gestureTime <= 2000) {
                    this.mouseReleased();
                    this.swipeEvent(this.downX, this.downY, upX, upY);
                } else {
                    this.mouseReleased();
                    this.releaseEvent();
                }
            } else {
                this.mouseReleased();
                this.releaseEvent();
            }
            this.twoPointerGesture = false;
            this.onePointerGesture = false;
        } else if (pme.action == 3) {
            this.twoPointerGesture = false;
            this.onePointerGesture = false;
            this.mousePressed = false;
            this.mouseReleased();
            this.releaseEvent();
        }
        this.pnumPointers = this.numPointers;
        if (pme.action == 2) {
            this.emotionX = this.motionX;
            this.emotionY = this.motionY;
            this.emouseX = this.mouseX;
            this.emouseY = this.mouseY;
        }
    }

    protected void nativeMotionEvent(MotionEvent event) {
        this.enqueueMotionEvent(event);
        if (!this.looping) {
            this.dequeueMotionEvents();
        }
    }

    public void mousePressed() {
    }

    public void mouseReleased() {
    }

    public void mouseClicked() {
    }

    public void mouseDragged() {
    }

    public void mouseMoved() {
    }

    protected void pressEvent() {
    }

    protected void dragEvent() {
    }

    protected void moveEvent() {
    }

    protected void releaseEvent() {
    }

    protected void zoomEvent(float x, float y, float d0, float d1) {
    }

    protected void tapEvent(float x, float y) {
    }

    protected void swipeEvent(float x0, float y0, float x1, float y1) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueKeyEvent(KeyEvent e) {
        KeyEvent[] keyEventArray = this.keyEventQueue;
        synchronized (this.keyEventQueue) {
            if (this.keyEventCount == this.keyEventQueue.length) {
                this.keyEventQueue = (KeyEvent[])PApplet.expand(this.keyEventQueue);
            }
            this.keyEventQueue[this.keyEventCount++] = e;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dequeueKeyEvents() {
        KeyEvent[] keyEventArray = this.keyEventQueue;
        synchronized (this.keyEventQueue) {
            int i = 0;
            while (i < this.keyEventCount) {
                this.handleKeyEvent(this.keyEventQueue[i]);
                ++i;
            }
            this.keyEventCount = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void handleKeyEvent(KeyEvent event) {
        this.keyEvent = event;
        this.key = event.getKey();
        this.keyCode = event.getKeyCode();
        switch (event.getAction()) {
            case 1: {
                this.keyPressed = true;
                this.keyPressed();
                break;
            }
            case 2: {
                this.keyPressed = false;
                this.keyReleased();
            }
        }
        this.handleMethods("keyEvent", new Object[]{event});
        if (event.getAction() == 1 && event.getKeyCode() == 4) {
            this.exit();
        }
    }

    protected void nativeKeyEvent(android.view.KeyEvent event) {
        char key = (char)event.getUnicodeChar();
        if (key == '\u0000' || key == '\uffff') {
            key = '\uffff';
        }
        int keyCode = event.getKeyCode();
        int keAction = 0;
        int action = event.getAction();
        if (action == 0) {
            keAction = 1;
        } else if (action == 1) {
            keAction = 2;
        }
        int keModifiers = 0;
        KeyEvent ke = new KeyEvent(event, event.getEventTime(), keAction, keModifiers, key, keyCode);
        if (action == 0 && keyCode == 4) {
            this.exit();
        }
        if (this.looping) {
            this.enqueueKeyEvent(ke);
        } else {
            this.handleKeyEvent(ke);
        }
    }

    public void keyPressed() {
    }

    public void keyReleased() {
    }

    public void keyTyped() {
    }

    public void focusGained() {
    }

    public void focusLost() {
    }

    public int millis() {
        return (int)(System.currentTimeMillis() - this.millisOffset);
    }

    public static int second() {
        time.setToNow();
        return PApplet.time.second;
    }

    public static int minute() {
        time.setToNow();
        return PApplet.time.minute;
    }

    public static int hour() {
        time.setToNow();
        return PApplet.time.hour;
    }

    public static int day() {
        time.setToNow();
        return PApplet.time.monthDay;
    }

    public static int month() {
        time.setToNow();
        return PApplet.time.month + 1;
    }

    public static int year() {
        time.setToNow();
        return PApplet.time.year;
    }

    public void delay(int napTime) {
        try {
            Thread.sleep(napTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void frameRate(float newRateTarget) {
        this.frameRateTarget = newRateTarget;
        this.frameRatePeriod = (long)(1.0E9 / (double)this.frameRateTarget);
        this.g.setFrameRate(newRateTarget);
    }

    public void link(String here) {
        this.link(here, null);
    }

    public void link(String url, String frameTitle) {
        Intent viewIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.startActivity(viewIntent);
    }

    public static void open(String filename) {
        PApplet.open(new String[]{filename});
    }

    public static Process open(String[] argv) {
        return PApplet.exec(argv);
    }

    public static Process exec(String[] argv) {
        try {
            return Runtime.getRuntime().exec(argv);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not open " + PApplet.join(argv, ' '));
        }
    }

    public void die(String what) {
        this.stop();
        throw new RuntimeException(what);
    }

    public void die(String what, Exception e) {
        if (e != null) {
            e.printStackTrace();
        }
        this.die(what);
    }

    public void exit() {
        if (this.thread == null) {
            this.exit2();
        } else if (this.looping) {
            this.finished = true;
            this.exitCalled = true;
        } else if (!this.looping) {
            this.dispose();
            this.exit2();
        }
    }

    void exit2() {
        try {
            System.exit(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public final void dispose() {
        this.finished = true;
        if (this.thread == null) {
            return;
        }
        this.thread = null;
        if (this.g != null) {
            this.g.dispose();
        }
        this.handleMethods("dispose");
    }

    public void method(String name) {
        try {
            Method method = this.getClass().getMethod(name, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("There is no public " + name + "() method " + "in the class " + this.getClass().getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void thread(final String name) {
        Thread later = new Thread(){

            public void run() {
                PApplet.this.method(name);
            }
        };
        later.start();
    }

    public void save(String filename) {
        this.g.save(this.savePath(filename));
    }

    public void saveFrame() {
        try {
            this.g.save(this.savePath("screen-" + PApplet.nf(this.frameCount, 4) + ".tif"));
        }
        catch (SecurityException se) {
            System.err.println("Can't use saveFrame() when running in a browser, unless using a signed applet.");
        }
    }

    public void saveFrame(String what) {
        try {
            this.g.save(this.savePath(this.insertFrame(what)));
        }
        catch (SecurityException se) {
            System.err.println("Can't use saveFrame() when running in a browser, unless using a signed applet.");
        }
    }

    protected String insertFrame(String what) {
        int first = what.indexOf(35);
        int last = what.lastIndexOf(35);
        if (first != -1 && last - first > 0) {
            String prefix = what.substring(0, first);
            int count = last - first + 1;
            String suffix = what.substring(last + 1);
            return String.valueOf(prefix) + PApplet.nf(this.frameCount, count) + suffix;
        }
        return what;
    }

    public static void print(byte what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(boolean what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(char what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(int what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(float what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(String what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(Object what) {
        if (what == null) {
            System.out.print("null");
        } else {
            System.out.println(what.toString());
        }
    }

    public static void println() {
        System.out.println();
    }

    public static void println(byte what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(boolean what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(char what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(int what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(float what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(String what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(Object what) {
        block18: {
            block19: {
                block17: {
                    if (what != null) break block17;
                    System.out.println("null");
                    break block18;
                }
                String name = what.getClass().getName();
                if (name.charAt(0) != '[') break block19;
                switch (name.charAt(1)) {
                    case '[': {
                        System.out.println(what);
                        break;
                    }
                    case 'L': {
                        Object[] poo = (Object[])what;
                        int i = 0;
                        while (i < poo.length) {
                            if (poo[i] instanceof String) {
                                System.out.println("[" + i + "] \"" + poo[i] + "\"");
                            } else {
                                System.out.println("[" + i + "] " + poo[i]);
                            }
                            ++i;
                        }
                        break block18;
                    }
                    case 'Z': {
                        boolean[] zz = (boolean[])what;
                        int i = 0;
                        while (i < zz.length) {
                            System.out.println("[" + i + "] " + zz[i]);
                            ++i;
                        }
                        break block18;
                    }
                    case 'B': {
                        byte[] bb = (byte[])what;
                        int i = 0;
                        while (i < bb.length) {
                            System.out.println("[" + i + "] " + bb[i]);
                            ++i;
                        }
                        break block18;
                    }
                    case 'C': {
                        char[] cc = (char[])what;
                        int i = 0;
                        while (i < cc.length) {
                            System.out.println("[" + i + "] '" + cc[i] + "'");
                            ++i;
                        }
                        break block18;
                    }
                    case 'I': {
                        int[] ii = (int[])what;
                        int i = 0;
                        while (i < ii.length) {
                            System.out.println("[" + i + "] " + ii[i]);
                            ++i;
                        }
                        break block18;
                    }
                    case 'F': {
                        float[] ff = (float[])what;
                        int i = 0;
                        while (i < ff.length) {
                            System.out.println("[" + i + "] " + ff[i]);
                            ++i;
                        }
                        break block18;
                    }
                    default: {
                        System.out.println(what);
                        break;
                    }
                }
                break block18;
            }
            System.out.println(what);
        }
    }

    public static final float abs(float n) {
        return n < 0.0f ? -n : n;
    }

    public static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final float sq(float a) {
        return a * a;
    }

    public static final float sqrt(float a) {
        return (float)Math.sqrt(a);
    }

    public static final float log(float a) {
        return (float)Math.log(a);
    }

    public static final float exp(float a) {
        return (float)Math.exp(a);
    }

    public static final float pow(float a, float b) {
        return (float)Math.pow(a, b);
    }

    public static final int max(int a, int b) {
        return a > b ? a : b;
    }

    public static final float max(float a, float b) {
        return a > b ? a : b;
    }

    public static final int max(int a, int b, int c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static final float max(float a, float b, float c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static final int max(int[] list) {
        if (list.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        int max = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] > max) {
                max = list[i];
            }
            ++i;
        }
        return max;
    }

    public static final float max(float[] list) {
        if (list.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        float max = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] > max) {
                max = list[i];
            }
            ++i;
        }
        return max;
    }

    public static final int min(int a, int b) {
        return a < b ? a : b;
    }

    public static final float min(float a, float b) {
        return a < b ? a : b;
    }

    public static final int min(int a, int b, int c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    public static final float min(float a, float b, float c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    public static final int min(int[] list) {
        if (list.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        int min = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] < min) {
                min = list[i];
            }
            ++i;
        }
        return min;
    }

    public static final float min(float[] list) {
        if (list.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        float min = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] < min) {
                min = list[i];
            }
            ++i;
        }
        return min;
    }

    public static final int constrain(int amt, int low, int high) {
        return amt < low ? low : (amt > high ? high : amt);
    }

    public static final float constrain(float amt, float low, float high) {
        return amt < low ? low : (amt > high ? high : amt);
    }

    public static final float sin(float angle) {
        return (float)Math.sin(angle);
    }

    public static final float cos(float angle) {
        return (float)Math.cos(angle);
    }

    public static final float tan(float angle) {
        return (float)Math.tan(angle);
    }

    public static final float asin(float value) {
        return (float)Math.asin(value);
    }

    public static final float acos(float value) {
        return (float)Math.acos(value);
    }

    public static final float atan(float value) {
        return (float)Math.atan(value);
    }

    public static final float atan2(float a, float b) {
        return (float)Math.atan2(a, b);
    }

    public static final float degrees(float radians) {
        return radians * 57.295776f;
    }

    public static final float radians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static final int ceil(float what) {
        return (int)Math.ceil(what);
    }

    public static final int floor(float what) {
        return (int)Math.floor(what);
    }

    public static final int round(float what) {
        return Math.round(what);
    }

    public static final float mag(float a, float b) {
        return (float)Math.sqrt(a * a + b * b);
    }

    public static final float mag(float a, float b, float c) {
        return (float)Math.sqrt(a * a + b * b + c * c);
    }

    public static final float dist(float x1, float y1, float x2, float y2) {
        return PApplet.sqrt(PApplet.sq(x2 - x1) + PApplet.sq(y2 - y1));
    }

    public static final float dist(float x1, float y1, float z1, float x2, float y2, float z2) {
        return PApplet.sqrt(PApplet.sq(x2 - x1) + PApplet.sq(y2 - y1) + PApplet.sq(z2 - z1));
    }

    public static final float lerp(float start, float stop, float amt) {
        return start + (stop - start) * amt;
    }

    public static final float norm(float value, float start, float stop) {
        return (value - start) / (stop - start);
    }

    public static final float map(float value, float istart, float istop, float ostart, float ostop) {
        return ostart + (ostop - ostart) * ((value - istart) / (istop - istart));
    }

    public final float random(float howbig) {
        if (howbig == 0.0f) {
            return 0.0f;
        }
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        float value = 0.0f;
        while ((value = this.internalRandom.nextFloat() * howbig) == howbig) {
        }
        return value;
    }

    public final float random(float howsmall, float howbig) {
        if (howsmall >= howbig) {
            return howsmall;
        }
        float diff = howbig - howsmall;
        return this.random(diff) + howsmall;
    }

    public final void randomSeed(long what) {
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        this.internalRandom.setSeed(what);
    }

    public float noise(float x) {
        return this.noise(x, 0.0f, 0.0f);
    }

    public float noise(float x, float y) {
        return this.noise(x, y, 0.0f);
    }

    public float noise(float x, float y, float z) {
        if (this.perlin == null) {
            if (this.perlinRandom == null) {
                this.perlinRandom = new Random();
            }
            this.perlin = new float[4096];
            int i = 0;
            while (i < 4096) {
                this.perlin[i] = this.perlinRandom.nextFloat();
                ++i;
            }
            this.perlin_cosTable = PGraphics.cosLUT;
            this.perlin_PI = 720;
            this.perlin_TWOPI = 720;
            this.perlin_PI >>= 1;
        }
        if (x < 0.0f) {
            x = -x;
        }
        if (y < 0.0f) {
            y = -y;
        }
        if (z < 0.0f) {
            z = -z;
        }
        int xi = (int)x;
        int yi = (int)y;
        int zi = (int)z;
        float xf = x - (float)xi;
        float yf = y - (float)yi;
        float zf = z - (float)zi;
        float r = 0.0f;
        float ampl = 0.5f;
        int i = 0;
        while (i < this.perlin_octaves) {
            int of = xi + (yi << 4) + (zi << 8);
            float rxf = this.noise_fsc(xf);
            float ryf = this.noise_fsc(yf);
            float n1 = this.perlin[of & 0xFFF];
            n1 += rxf * (this.perlin[of + 1 & 0xFFF] - n1);
            float n2 = this.perlin[of + 16 & 0xFFF];
            n2 += rxf * (this.perlin[of + 16 + 1 & 0xFFF] - n2);
            n1 += ryf * (n2 - n1);
            n2 = this.perlin[(of += 256) & 0xFFF];
            n2 += rxf * (this.perlin[of + 1 & 0xFFF] - n2);
            float n3 = this.perlin[of + 16 & 0xFFF];
            n3 += rxf * (this.perlin[of + 16 + 1 & 0xFFF] - n3);
            n2 += ryf * (n3 - n2);
            n1 += this.noise_fsc(zf) * (n2 - n1);
            r += n1 * ampl;
            ampl *= this.perlin_amp_falloff;
            xi <<= 1;
            xf *= 2.0f;
            yi <<= 1;
            yf *= 2.0f;
            zi <<= 1;
            zf *= 2.0f;
            if (xf >= 1.0f) {
                ++xi;
                xf -= 1.0f;
            }
            if (yf >= 1.0f) {
                ++yi;
                yf -= 1.0f;
            }
            if (zf >= 1.0f) {
                ++zi;
                zf -= 1.0f;
            }
            ++i;
        }
        return r;
    }

    private float noise_fsc(float i) {
        return 0.5f * (1.0f - this.perlin_cosTable[(int)(i * (float)this.perlin_PI) % this.perlin_TWOPI]);
    }

    public void noiseDetail(int lod) {
        if (lod > 0) {
            this.perlin_octaves = lod;
        }
    }

    public void noiseDetail(int lod, float falloff) {
        if (lod > 0) {
            this.perlin_octaves = lod;
        }
        if (falloff > 0.0f) {
            this.perlin_amp_falloff = falloff;
        }
    }

    public void noiseSeed(long what) {
        if (this.perlinRandom == null) {
            this.perlinRandom = new Random();
        }
        this.perlinRandom.setSeed(what);
        this.perlin = null;
    }

    public PImage loadImage(String filename) {
        InputStream stream = this.createInput(filename);
        if (stream == null) {
            System.err.println("Could not find the image " + filename + ".");
            return null;
        }
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)stream);
        }
        finally {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException iOException) {}
        }
        PImage image = new PImage(bitmap);
        image.parent = this;
        return image;
    }

    public PImage requestImage(String filename) {
        PImage vessel = this.createImage(0, 0, 2);
        AsyncImageLoader ail = new AsyncImageLoader(filename, vessel);
        ail.start();
        return vessel;
    }

    public XML loadXML(String filename) {
        try {
            return new XML(this, filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static XML loadXML(File file) {
        try {
            return new XML(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Table loadTable(String filename) {
        return new Table(this, filename);
    }

    public static Table loadTable(File file) {
        return new Table(file);
    }

    public PFont loadFont(String filename) {
        try {
            InputStream input = this.createInput(filename);
            return new PFont(input);
        }
        catch (Exception e) {
            this.die("Could not load font " + filename + ". " + "Make sure that the font has been copied " + "to the data folder of your sketch.", e);
            return null;
        }
    }

    protected PFont createDefaultFont(float size) {
        return this.createFont("SansSerif", size, true, null);
    }

    public PFont createFont(String name, float size) {
        return this.createFont(name, size, true, null);
    }

    public PFont createFont(String name, float size, boolean smooth) {
        return this.createFont(name, size, smooth, null);
    }

    public PFont createFont(String name, float size, boolean smooth, char[] charset) {
        String lowerName = name.toLowerCase();
        Typeface baseFont = null;
        if (lowerName.endsWith(".otf") || lowerName.endsWith(".ttf")) {
            AssetManager assets = this.getBaseContext().getAssets();
            baseFont = Typeface.createFromAsset((AssetManager)assets, (String)name);
        } else {
            baseFont = (Typeface)PFont.findNative(name);
        }
        return new PFont(baseFont, PApplet.round(size), smooth, charset);
    }

    public BufferedReader createReader(String filename) {
        InputStream is;
        block5: {
            try {
                is = this.createInput(filename);
                if (is != null) break block5;
                System.err.println(String.valueOf(filename) + " does not exist or could not be read");
                return null;
            }
            catch (Exception e) {
                if (filename == null) {
                    System.err.println("Filename passed to reader() was null");
                } else {
                    System.err.println("Couldn't create a reader for " + filename);
                }
                return null;
            }
        }
        return PApplet.createReader(is);
    }

    public static BufferedReader createReader(File file) {
        try {
            InputStream is = new FileInputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            return PApplet.createReader(is);
        }
        catch (Exception e) {
            if (file == null) {
                throw new RuntimeException("File passed to createReader() was null");
            }
            e.printStackTrace();
            throw new RuntimeException("Couldn't create a reader for " + file.getAbsolutePath());
        }
    }

    public static BufferedReader createReader(InputStream input) {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(input, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new BufferedReader(isr);
    }

    public PrintWriter createWriter(String filename) {
        return PApplet.createWriter(this.saveFile(filename));
    }

    public static PrintWriter createWriter(File file) {
        try {
            OutputStream output = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                output = new GZIPOutputStream(output);
            }
            return PApplet.createWriter(output);
        }
        catch (Exception e) {
            if (file == null) {
                throw new RuntimeException("File passed to createWriter() was null");
            }
            e.printStackTrace();
            throw new RuntimeException("Couldn't create a writer for " + file.getAbsolutePath());
        }
    }

    public static PrintWriter createWriter(OutputStream output) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(output, 8192);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            return new PrintWriter(osw);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public InputStream createInput(String filename) {
        InputStream input = this.createInputRaw(filename);
        if (input != null && filename.toLowerCase().endsWith(".gz")) {
            try {
                return new GZIPInputStream(input);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return input;
    }

    public InputStream createInputRaw(String filename) {
        File sketchFile;
        InputStream stream = null;
        if (filename == null) {
            return null;
        }
        if (filename.length() == 0) {
            return null;
        }
        if (filename.indexOf(":") != -1) {
            try {
                HttpGet httpRequest = null;
                httpRequest = new HttpGet(URI.create(filename));
                DefaultHttpClient httpclient = new DefaultHttpClient();
                HttpResponse response = httpclient.execute((HttpUriRequest)httpRequest);
                HttpEntity entity = response.getEntity();
                return entity.getContent();
            }
            catch (MalformedURLException httpRequest) {
            }
            catch (FileNotFoundException httpRequest) {
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        AssetManager assets = this.getAssets();
        try {
            stream = assets.open(filename);
            if (stream != null) {
                return stream;
            }
        }
        catch (IOException httpclient) {
            // empty catch block
        }
        File absFile = new File(filename);
        if (absFile.exists()) {
            try {
                stream = new FileInputStream(absFile);
                if (stream != null) {
                    return stream;
                }
            }
            catch (FileNotFoundException response) {
                // empty catch block
            }
        }
        if ((sketchFile = new File(this.sketchPath(filename))).exists()) {
            try {
                stream = new FileInputStream(sketchFile);
                if (stream != null) {
                    return stream;
                }
            }
            catch (FileNotFoundException entity) {
                // empty catch block
            }
        }
        Context context = this.getApplicationContext();
        try {
            stream = context.openFileInput(filename);
            if (stream != null) {
                return stream;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static InputStream createInput(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File passed to createInput() was null");
        }
        try {
            FileInputStream input = new FileInputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new GZIPInputStream(input);
            }
            return input;
        }
        catch (IOException e) {
            System.err.println("Could not createInput() for " + file);
            e.printStackTrace();
            return null;
        }
    }

    public byte[] loadBytes(String filename) {
        InputStream is = this.createInput(filename);
        if (is != null) {
            return PApplet.loadBytes(is);
        }
        System.err.println("The file \"" + filename + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
        return null;
    }

    public static byte[] loadBytes(InputStream input) {
        try {
            BufferedInputStream bis = new BufferedInputStream(input);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int c = bis.read();
            while (c != -1) {
                out.write(c);
                c = bis.read();
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] loadBytes(File file) {
        InputStream is = PApplet.createInput(file);
        return PApplet.loadBytes(is);
    }

    public static String[] loadStrings(File file) {
        InputStream is = PApplet.createInput(file);
        if (is != null) {
            return PApplet.loadStrings(is);
        }
        return null;
    }

    public String[] loadStrings(String filename) {
        InputStream is = this.createInput(filename);
        if (is != null) {
            return PApplet.loadStrings(is);
        }
        System.err.println("The file \"" + filename + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
        return null;
    }

    public static String[] loadStrings(InputStream input) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            String[] lines = new String[100];
            int lineCount = 0;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (lineCount == lines.length) {
                    String[] temp = new String[lineCount << 1];
                    System.arraycopy(lines, 0, temp, 0, lineCount);
                    lines = temp;
                }
                lines[lineCount++] = line;
            }
            reader.close();
            if (lineCount == lines.length) {
                return lines;
            }
            String[] output = new String[lineCount];
            System.arraycopy(lines, 0, output, 0, lineCount);
            return output;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public OutputStream createOutput(String filename) {
        try {
            File file = new File(filename);
            if (!file.isAbsolute()) {
                file = new File(this.sketchPath(filename));
            }
            FileOutputStream fos = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new GZIPOutputStream(fos);
            }
            return fos;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveStream(String targetFilename, String sourceLocation) {
        return this.saveStream(this.saveFile(targetFilename), sourceLocation);
    }

    public boolean saveStream(File targetFile, String sourceLocation) {
        return PApplet.saveStream(targetFile, this.createInputRaw(sourceLocation));
    }

    public boolean saveStream(String targetFilename, InputStream sourceStream) {
        return PApplet.saveStream(this.saveFile(targetFilename), sourceStream);
    }

    public static boolean saveStream(File targetFile, InputStream sourceStream) {
        File tempFile = null;
        try {
            int bytesRead;
            File parentDir = targetFile.getParentFile();
            PApplet.createPath(targetFile);
            tempFile = File.createTempFile(targetFile.getName(), null, parentDir);
            BufferedInputStream bis = new BufferedInputStream(sourceStream, 16384);
            FileOutputStream fos = new FileOutputStream(tempFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            byte[] buffer = new byte[8192];
            while ((bytesRead = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, bytesRead);
            }
            bos.flush();
            bos.close();
            bos = null;
            if (targetFile.exists() && !targetFile.delete()) {
                System.err.println("Could not replace " + targetFile.getAbsolutePath() + ".");
            }
            if (!tempFile.renameTo(targetFile)) {
                System.err.println("Could not rename temporary file " + tempFile.getAbsolutePath());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            if (tempFile != null) {
                tempFile.delete();
            }
            e.printStackTrace();
            return false;
        }
    }

    public void saveBytes(String filename, byte[] buffer) {
        PApplet.saveBytes(this.saveFile(filename), buffer);
    }

    public static void saveBytes(File file, byte[] buffer) {
        try {
            String filename = file.getAbsolutePath();
            PApplet.createPath(filename);
            OutputStream output = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                output = new GZIPOutputStream(output);
            }
            PApplet.saveBytes(output, buffer);
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            System.err.println("error saving bytes to " + file);
            e.printStackTrace();
        }
    }

    public static void saveBytes(OutputStream output, byte[] buffer) {
        try {
            output.write(buffer);
            output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveStrings(String filename, String[] strings) {
        PApplet.saveStrings(this.saveFile(filename), strings);
    }

    public static void saveStrings(File file, String[] strings) {
        try {
            String location = file.getAbsolutePath();
            PApplet.createPath(location);
            OutputStream output = new FileOutputStream(location);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                output = new GZIPOutputStream(output);
            }
            PApplet.saveStrings(output, strings);
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveStrings(OutputStream output, String[] strings) {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(output, "UTF-8");
            PrintWriter writer = new PrintWriter(osw);
            int i = 0;
            while (i < strings.length) {
                writer.println(strings[i]);
                ++i;
            }
            writer.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String sketchPath(String where) {
        if (this.sketchPath == null) {
            return where;
        }
        try {
            if (new File(where).isAbsolute()) {
                return where;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Context context = this.getApplicationContext();
        return context.getFileStreamPath(where).getAbsolutePath();
    }

    public File sketchFile(String where) {
        return new File(this.sketchPath(where));
    }

    public String savePath(String where) {
        if (where == null) {
            return null;
        }
        String filename = this.sketchPath(where);
        PApplet.createPath(filename);
        return filename;
    }

    public File saveFile(String where) {
        return new File(this.savePath(where));
    }

    public String dataPath(String where) {
        if (new File(where).isAbsolute()) {
            return where;
        }
        return String.valueOf(this.sketchPath) + File.separator + "data" + File.separator + where;
    }

    public File dataFile(String where) {
        return new File(this.dataPath(where));
    }

    public static void createPath(String path) {
        PApplet.createPath(new File(path));
    }

    public static void createPath(File file) {
        try {
            File unit;
            String parent = file.getParent();
            if (parent != null && !(unit = new File(parent)).exists()) {
                unit.mkdirs();
            }
        }
        catch (SecurityException se) {
            System.err.println("You don't have permissions to create " + file.getAbsolutePath());
        }
    }

    public static String getExtension(String filename) {
        String extension;
        int question;
        String lower = filename.toLowerCase();
        int dot = filename.lastIndexOf(46);
        if (dot == -1) {
            String string = "unknown";
        }
        if ((question = (extension = lower.substring(dot + 1)).indexOf(63)) != -1) {
            extension = extension.substring(0, question);
        }
        return extension;
    }

    public static String urlEncode(String what) {
        try {
            return URLEncoder.encode(what, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String urlDecode(String what) {
        try {
            return URLDecoder.decode(what, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] sort(byte[] what) {
        return PApplet.sort(what, what.length);
    }

    public static byte[] sort(byte[] what, int count) {
        byte[] outgoing = new byte[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static char[] sort(char[] what) {
        return PApplet.sort(what, what.length);
    }

    public static char[] sort(char[] what, int count) {
        char[] outgoing = new char[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static int[] sort(int[] what) {
        return PApplet.sort(what, what.length);
    }

    public static int[] sort(int[] what, int count) {
        int[] outgoing = new int[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static float[] sort(float[] what) {
        return PApplet.sort(what, what.length);
    }

    public static float[] sort(float[] what, int count) {
        float[] outgoing = new float[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static String[] sort(String[] what) {
        return PApplet.sort(what, what.length);
    }

    public static String[] sort(String[] what, int count) {
        Object[] outgoing = new String[what.length];
        System.arraycopy(what, 0, outgoing, 0, what.length);
        Arrays.sort(outgoing, 0, count);
        return outgoing;
    }

    public static void arrayCopy(Object src, int srcPosition, Object dst, int dstPosition, int length) {
        System.arraycopy(src, srcPosition, dst, dstPosition, length);
    }

    public static void arrayCopy(Object src, Object dst, int length) {
        System.arraycopy(src, 0, dst, 0, length);
    }

    public static void arrayCopy(Object src, Object dst) {
        System.arraycopy(src, 0, dst, 0, Array.getLength(src));
    }

    public static boolean[] expand(boolean[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static boolean[] expand(boolean[] list, int newSize) {
        boolean[] temp = new boolean[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static byte[] expand(byte[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static byte[] expand(byte[] list, int newSize) {
        byte[] temp = new byte[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static char[] expand(char[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static char[] expand(char[] list, int newSize) {
        char[] temp = new char[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static int[] expand(int[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static int[] expand(int[] list, int newSize) {
        int[] temp = new int[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static PImage[] expand(PImage[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static PImage[] expand(PImage[] list, int newSize) {
        PImage[] temp = new PImage[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static float[] expand(float[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static float[] expand(float[] list, int newSize) {
        float[] temp = new float[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static String[] expand(String[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static String[] expand(String[] list, int newSize) {
        String[] temp = new String[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static Object expand(Object array) {
        return PApplet.expand(array, Array.getLength(array) << 1);
    }

    public static Object expand(Object list, int newSize) {
        Class<?> type = list.getClass().getComponentType();
        Object temp = Array.newInstance(type, newSize);
        System.arraycopy(list, 0, temp, 0, Math.min(Array.getLength(list), newSize));
        return temp;
    }

    public static byte[] append(byte[] b, byte value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static char[] append(char[] b, char value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static int[] append(int[] b, int value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static float[] append(float[] b, float value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static String[] append(String[] b, String value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static Object append(Object b, Object value) {
        int length = Array.getLength(b);
        b = PApplet.expand(b, length + 1);
        Array.set(b, length, value);
        return b;
    }

    public static boolean[] shorten(boolean[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static byte[] shorten(byte[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static char[] shorten(char[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static int[] shorten(int[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static float[] shorten(float[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static String[] shorten(String[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static Object shorten(Object list) {
        int length = Array.getLength(list);
        return PApplet.subset(list, 0, length - 1);
    }

    public static final boolean[] splice(boolean[] list, boolean v, int index) {
        boolean[] outgoing = new boolean[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final boolean[] splice(boolean[] list, boolean[] v, int index) {
        boolean[] outgoing = new boolean[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final byte[] splice(byte[] list, byte v, int index) {
        byte[] outgoing = new byte[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final byte[] splice(byte[] list, byte[] v, int index) {
        byte[] outgoing = new byte[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final char[] splice(char[] list, char v, int index) {
        char[] outgoing = new char[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final char[] splice(char[] list, char[] v, int index) {
        char[] outgoing = new char[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final int[] splice(int[] list, int v, int index) {
        int[] outgoing = new int[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final int[] splice(int[] list, int[] v, int index) {
        int[] outgoing = new int[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final float[] splice(float[] list, float v, int index) {
        float[] outgoing = new float[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final float[] splice(float[] list, float[] v, int index) {
        float[] outgoing = new float[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final String[] splice(String[] list, String v, int index) {
        String[] outgoing = new String[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final String[] splice(String[] list, String[] v, int index) {
        String[] outgoing = new String[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final Object splice(Object list, Object v, int index) {
        Object[] outgoing = null;
        int length = Array.getLength(list);
        if (v.getClass().getName().charAt(0) == '[') {
            int vlength = Array.getLength(v);
            outgoing = new Object[length + vlength];
            System.arraycopy(list, 0, outgoing, 0, index);
            System.arraycopy(v, 0, outgoing, index, vlength);
            System.arraycopy(list, index, outgoing, index + vlength, length - index);
        } else {
            outgoing = new Object[length + 1];
            System.arraycopy(list, 0, outgoing, 0, index);
            Array.set(outgoing, index, v);
            System.arraycopy(list, index, outgoing, index + 1, length - index);
        }
        return outgoing;
    }

    public static boolean[] subset(boolean[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static boolean[] subset(boolean[] list, int start, int count) {
        boolean[] output = new boolean[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static byte[] subset(byte[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static byte[] subset(byte[] list, int start, int count) {
        byte[] output = new byte[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static char[] subset(char[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static char[] subset(char[] list, int start, int count) {
        char[] output = new char[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static int[] subset(int[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static int[] subset(int[] list, int start, int count) {
        int[] output = new int[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static float[] subset(float[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static float[] subset(float[] list, int start, int count) {
        float[] output = new float[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static String[] subset(String[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static String[] subset(String[] list, int start, int count) {
        String[] output = new String[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static Object subset(Object list, int start) {
        int length = Array.getLength(list);
        return PApplet.subset(list, start, length - start);
    }

    public static Object subset(Object list, int start, int count) {
        Class<?> type = list.getClass().getComponentType();
        Object outgoing = Array.newInstance(type, count);
        System.arraycopy(list, start, outgoing, 0, count);
        return outgoing;
    }

    public static boolean[] concat(boolean[] a, boolean[] b) {
        boolean[] c = new boolean[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static char[] concat(char[] a, char[] b) {
        char[] c = new char[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static int[] concat(int[] a, int[] b) {
        int[] c = new int[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static float[] concat(float[] a, float[] b) {
        float[] c = new float[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static String[] concat(String[] a, String[] b) {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static Object concat(Object a, Object b) {
        Class<?> type = a.getClass().getComponentType();
        int alength = Array.getLength(a);
        int blength = Array.getLength(b);
        Object outgoing = Array.newInstance(type, alength + blength);
        System.arraycopy(a, 0, outgoing, 0, alength);
        System.arraycopy(b, 0, outgoing, alength, blength);
        return outgoing;
    }

    public static boolean[] reverse(boolean[] list) {
        boolean[] outgoing = new boolean[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static byte[] reverse(byte[] list) {
        byte[] outgoing = new byte[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static char[] reverse(char[] list) {
        char[] outgoing = new char[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static int[] reverse(int[] list) {
        int[] outgoing = new int[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static float[] reverse(float[] list) {
        float[] outgoing = new float[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static String[] reverse(String[] list) {
        String[] outgoing = new String[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static Object reverse(Object list) {
        Class<?> type = list.getClass().getComponentType();
        int length = Array.getLength(list);
        Object outgoing = Array.newInstance(type, length);
        int i = 0;
        while (i < length) {
            Array.set(outgoing, i, Array.get(list, length - 1 - i));
            ++i;
        }
        return outgoing;
    }

    public static String trim(String str) {
        return str.replace('\u00a0', ' ').trim();
    }

    public static String[] trim(String[] array) {
        String[] outgoing = new String[array.length];
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                outgoing[i] = array[i].replace('\u00a0', ' ').trim();
            }
            ++i;
        }
        return outgoing;
    }

    public static String join(String[] str, char separator) {
        return PApplet.join(str, String.valueOf(separator));
    }

    public static String join(String[] str, String separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < str.length) {
            if (i != 0) {
                buffer.append(separator);
            }
            buffer.append(str[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String[] splitTokens(String what) {
        return PApplet.splitTokens(what, " \t\n\r\f\u00a0");
    }

    public static String[] splitTokens(String what, String delim) {
        StringTokenizer toker = new StringTokenizer(what, delim);
        String[] pieces = new String[toker.countTokens()];
        int index = 0;
        while (toker.hasMoreTokens()) {
            pieces[index++] = toker.nextToken();
        }
        return pieces;
    }

    public static String[] split(String what, char delim) {
        if (what == null) {
            return null;
        }
        char[] chars = what.toCharArray();
        int splitCount = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == delim) {
                ++splitCount;
            }
            ++i;
        }
        if (splitCount == 0) {
            String[] splits = new String[]{new String(what)};
            return splits;
        }
        String[] splits = new String[splitCount + 1];
        int splitIndex = 0;
        int startIndex = 0;
        int i2 = 0;
        while (i2 < chars.length) {
            if (chars[i2] == delim) {
                splits[splitIndex++] = new String(chars, startIndex, i2 - startIndex);
                startIndex = i2 + 1;
            }
            ++i2;
        }
        splits[splitIndex] = new String(chars, startIndex, chars.length - startIndex);
        return splits;
    }

    public static String[] split(String what, String delim) {
        int index;
        ArrayList<String> items = new ArrayList<String>();
        int offset = 0;
        while ((index = what.indexOf(delim, offset)) != -1) {
            items.add(what.substring(offset, index));
            offset = index + delim.length();
        }
        items.add(what.substring(offset));
        String[] outgoing = new String[items.size()];
        items.toArray(outgoing);
        return outgoing;
    }

    static Pattern matchPattern(String regexp) {
        Pattern p = null;
        if (matchPatterns == null) {
            matchPatterns = new HashMap();
        } else {
            p = matchPatterns.get(regexp);
        }
        if (p == null) {
            if (matchPatterns.size() == 10) {
                matchPatterns.clear();
            }
            p = Pattern.compile(regexp, 40);
            matchPatterns.put(regexp, p);
        }
        return p;
    }

    public static String[] match(String what, String regexp) {
        Pattern p = PApplet.matchPattern(regexp);
        Matcher m = p.matcher(what);
        if (m.find()) {
            int count = m.groupCount() + 1;
            String[] groups = new String[count];
            int i = 0;
            while (i < count) {
                groups[i] = m.group(i);
                ++i;
            }
            return groups;
        }
        return null;
    }

    public static String[][] matchAll(String what, String regexp) {
        int i;
        Pattern p = PApplet.matchPattern(regexp);
        Matcher m = p.matcher(what);
        ArrayList<String[]> results = new ArrayList<String[]>();
        int count = m.groupCount() + 1;
        while (m.find()) {
            String[] groups = new String[count];
            i = 0;
            while (i < count) {
                groups[i] = m.group(i);
                ++i;
            }
            results.add(groups);
        }
        if (results.isEmpty()) {
            return null;
        }
        String[][] matches = new String[results.size()][count];
        i = 0;
        while (i < matches.length) {
            matches[i] = (String[])results.get(i);
            ++i;
        }
        return matches;
    }

    public static final boolean parseBoolean(int what) {
        return what != 0;
    }

    public static final boolean parseBoolean(String what) {
        return new Boolean(what);
    }

    public static final boolean[] parseBoolean(byte[] what) {
        boolean[] outgoing = new boolean[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = what[i] != 0;
            ++i;
        }
        return outgoing;
    }

    public static final boolean[] parseBoolean(int[] what) {
        boolean[] outgoing = new boolean[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = what[i] != 0;
            ++i;
        }
        return outgoing;
    }

    public static final boolean[] parseBoolean(String[] what) {
        boolean[] outgoing = new boolean[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = new Boolean(what[i]);
            ++i;
        }
        return outgoing;
    }

    public static final byte parseByte(boolean what) {
        return what ? (byte)1 : 0;
    }

    public static final byte parseByte(char what) {
        return (byte)what;
    }

    public static final byte parseByte(int what) {
        return (byte)what;
    }

    public static final byte parseByte(float what) {
        return (byte)what;
    }

    public static final byte[] parseByte(boolean[] what) {
        byte[] outgoing = new byte[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = what[i] ? (byte)1 : 0;
            ++i;
        }
        return outgoing;
    }

    public static final byte[] parseByte(char[] what) {
        byte[] outgoing = new byte[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (byte)what[i];
            ++i;
        }
        return outgoing;
    }

    public static final byte[] parseByte(int[] what) {
        byte[] outgoing = new byte[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (byte)what[i];
            ++i;
        }
        return outgoing;
    }

    public static final byte[] parseByte(float[] what) {
        byte[] outgoing = new byte[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (byte)what[i];
            ++i;
        }
        return outgoing;
    }

    public static final char parseChar(byte what) {
        return (char)(what & 0xFF);
    }

    public static final char parseChar(int what) {
        return (char)what;
    }

    public static final char[] parseChar(byte[] what) {
        char[] outgoing = new char[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (char)(what[i] & 0xFF);
            ++i;
        }
        return outgoing;
    }

    public static final char[] parseChar(int[] what) {
        char[] outgoing = new char[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (char)what[i];
            ++i;
        }
        return outgoing;
    }

    public static final int parseInt(boolean what) {
        return what ? 1 : 0;
    }

    public static final int parseInt(byte what) {
        return what & 0xFF;
    }

    public static final int parseInt(char what) {
        return what;
    }

    public static final int parseInt(float what) {
        return (int)what;
    }

    public static final int parseInt(String what) {
        return PApplet.parseInt(what, 0);
    }

    public static final int parseInt(String what, int otherwise) {
        try {
            int offset = what.indexOf(46);
            if (offset == -1) {
                return Integer.parseInt(what);
            }
            return Integer.parseInt(what.substring(0, offset));
        }
        catch (NumberFormatException numberFormatException) {
            return otherwise;
        }
    }

    public static final int[] parseInt(boolean[] what) {
        int[] list = new int[what.length];
        int i = 0;
        while (i < what.length) {
            list[i] = what[i] ? 1 : 0;
            ++i;
        }
        return list;
    }

    public static final int[] parseInt(byte[] what) {
        int[] list = new int[what.length];
        int i = 0;
        while (i < what.length) {
            list[i] = what[i] & 0xFF;
            ++i;
        }
        return list;
    }

    public static final int[] parseInt(char[] what) {
        int[] list = new int[what.length];
        int i = 0;
        while (i < what.length) {
            list[i] = what[i];
            ++i;
        }
        return list;
    }

    public static int[] parseInt(float[] what) {
        int[] inties = new int[what.length];
        int i = 0;
        while (i < what.length) {
            inties[i] = (int)what[i];
            ++i;
        }
        return inties;
    }

    public static int[] parseInt(String[] what) {
        return PApplet.parseInt(what, 0);
    }

    public static int[] parseInt(String[] what, int missing) {
        int[] output = new int[what.length];
        int i = 0;
        while (i < what.length) {
            try {
                output[i] = Integer.parseInt(what[i]);
            }
            catch (NumberFormatException e) {
                output[i] = missing;
            }
            ++i;
        }
        return output;
    }

    public static final float parseFloat(int what) {
        return what;
    }

    public static final float parseFloat(String what) {
        return PApplet.parseFloat(what, Float.NaN);
    }

    public static final float parseFloat(String what, float otherwise) {
        try {
            return new Float(what).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return otherwise;
        }
    }

    public static final float[] parseByte(byte[] what) {
        float[] floaties = new float[what.length];
        int i = 0;
        while (i < what.length) {
            floaties[i] = what[i];
            ++i;
        }
        return floaties;
    }

    public static final float[] parseFloat(int[] what) {
        float[] floaties = new float[what.length];
        int i = 0;
        while (i < what.length) {
            floaties[i] = what[i];
            ++i;
        }
        return floaties;
    }

    public static final float[] parseFloat(String[] what) {
        return PApplet.parseFloat(what, Float.NaN);
    }

    public static final float[] parseFloat(String[] what, float missing) {
        float[] output = new float[what.length];
        int i = 0;
        while (i < what.length) {
            try {
                output[i] = new Float(what[i]).floatValue();
            }
            catch (NumberFormatException e) {
                output[i] = missing;
            }
            ++i;
        }
        return output;
    }

    public static final String str(boolean x) {
        return String.valueOf(x);
    }

    public static final String str(byte x) {
        return String.valueOf(x);
    }

    public static final String str(char x) {
        return String.valueOf(x);
    }

    public static final String str(int x) {
        return String.valueOf(x);
    }

    public static final String str(float x) {
        return String.valueOf(x);
    }

    public static final String[] str(boolean[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x[i]);
            ++i;
        }
        return s;
    }

    public static final String[] str(byte[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x[i]);
            ++i;
        }
        return s;
    }

    public static final String[] str(char[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x[i]);
            ++i;
        }
        return s;
    }

    public static final String[] str(int[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x[i]);
            ++i;
        }
        return s;
    }

    public static final String[] str(float[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x[i]);
            ++i;
        }
        return s;
    }

    public static String[] nf(int[] num, int digits) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nf(num[i], digits);
            ++i;
        }
        return formatted;
    }

    public static String nf(int num, int digits) {
        if (int_nf != null && int_nf_digits == digits && !int_nf_commas) {
            return int_nf.format(num);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(false);
        int_nf_commas = false;
        int_nf.setMinimumIntegerDigits(digits);
        int_nf_digits = digits;
        return int_nf.format(num);
    }

    public static String[] nfc(int[] num) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfc(num[i]);
            ++i;
        }
        return formatted;
    }

    public static String nfc(int num) {
        if (int_nf != null && int_nf_digits == 0 && int_nf_commas) {
            return int_nf.format(num);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(true);
        int_nf_commas = true;
        int_nf.setMinimumIntegerDigits(0);
        int_nf_digits = 0;
        return int_nf.format(num);
    }

    public static String nfs(int num, int digits) {
        return num < 0 ? PApplet.nf(num, digits) : String.valueOf(' ') + PApplet.nf(num, digits);
    }

    public static String[] nfs(int[] num, int digits) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfs(num[i], digits);
            ++i;
        }
        return formatted;
    }

    public static String nfp(int num, int digits) {
        return num < 0 ? PApplet.nf(num, digits) : String.valueOf('+') + PApplet.nf(num, digits);
    }

    public static String[] nfp(int[] num, int digits) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfp(num[i], digits);
            ++i;
        }
        return formatted;
    }

    public static String[] nf(float[] num, int left, int right) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nf(num[i], left, right);
            ++i;
        }
        return formatted;
    }

    public static String nf(float num, int left, int right) {
        if (float_nf != null && float_nf_left == left && float_nf_right == right && !float_nf_commas) {
            return float_nf.format(num);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(false);
        float_nf_commas = false;
        if (left != 0) {
            float_nf.setMinimumIntegerDigits(left);
        }
        if (right != 0) {
            float_nf.setMinimumFractionDigits(right);
            float_nf.setMaximumFractionDigits(right);
        }
        float_nf_left = left;
        float_nf_right = right;
        return float_nf.format(num);
    }

    public static String[] nfc(float[] num, int right) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfc(num[i], right);
            ++i;
        }
        return formatted;
    }

    public static String nfc(float num, int right) {
        if (float_nf != null && float_nf_left == 0 && float_nf_right == right && float_nf_commas) {
            return float_nf.format(num);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(true);
        float_nf_commas = true;
        if (right != 0) {
            float_nf.setMinimumFractionDigits(right);
            float_nf.setMaximumFractionDigits(right);
        }
        float_nf_left = 0;
        float_nf_right = right;
        return float_nf.format(num);
    }

    public static String[] nfs(float[] num, int left, int right) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfs(num[i], left, right);
            ++i;
        }
        return formatted;
    }

    public static String nfs(float num, int left, int right) {
        return num < 0.0f ? PApplet.nf(num, left, right) : String.valueOf(' ') + PApplet.nf(num, left, right);
    }

    public static String[] nfp(float[] num, int left, int right) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfp(num[i], left, right);
            ++i;
        }
        return formatted;
    }

    public static String nfp(float num, int left, int right) {
        return num < 0.0f ? PApplet.nf(num, left, right) : String.valueOf('+') + PApplet.nf(num, left, right);
    }

    public static final String hex(byte what) {
        return PApplet.hex(what, 2);
    }

    public static final String hex(char what) {
        return PApplet.hex(what, 4);
    }

    public static final String hex(int what) {
        return PApplet.hex(what, 8);
    }

    public static final String hex(int what, int digits) {
        int length;
        String stuff = Integer.toHexString(what).toUpperCase();
        if (digits > 8) {
            digits = 8;
        }
        if ((length = stuff.length()) > digits) {
            return stuff.substring(length - digits);
        }
        if (length < digits) {
            return String.valueOf("00000000".substring(8 - (digits - length))) + stuff;
        }
        return stuff;
    }

    public static final int unhex(String what) {
        return (int)Long.parseLong(what, 16);
    }

    public static final String binary(byte what) {
        return PApplet.binary(what, 8);
    }

    public static final String binary(char what) {
        return PApplet.binary(what, 16);
    }

    public static final String binary(int what) {
        return PApplet.binary(what, 32);
    }

    public static final String binary(int what, int digits) {
        int length;
        String stuff = Integer.toBinaryString(what);
        if (digits > 32) {
            digits = 32;
        }
        if ((length = stuff.length()) > digits) {
            return stuff.substring(length - digits);
        }
        if (length < digits) {
            int offset = 32 - (digits - length);
            return String.valueOf("00000000000000000000000000000000".substring(offset)) + stuff;
        }
        return stuff;
    }

    public static final int unbinary(String what) {
        return Integer.parseInt(what, 2);
    }

    public final int color(int gray) {
        if (this.g == null) {
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            return 0xFF000000 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(gray);
    }

    public final int color(float fgray) {
        if (this.g == null) {
            int gray = (int)fgray;
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            return 0xFF000000 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(fgray);
    }

    public final int color(int gray, int alpha) {
        if (this.g == null) {
            if (alpha > 255) {
                alpha = 255;
            } else if (alpha < 0) {
                alpha = 0;
            }
            if (gray > 255) {
                return alpha << 24 | gray & 0xFFFFFF;
            }
            return alpha << 24 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(gray, alpha);
    }

    public final int color(float fgray, float falpha) {
        if (this.g == null) {
            int gray = (int)fgray;
            int alpha = (int)falpha;
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            if (alpha > 255) {
                alpha = 255;
            } else if (alpha < 0) {
                alpha = 0;
            }
            return 0xFF000000 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(fgray, falpha);
    }

    public final int color(int x, int y, int z) {
        if (this.g == null) {
            if (x > 255) {
                x = 255;
            } else if (x < 0) {
                x = 0;
            }
            if (y > 255) {
                y = 255;
            } else if (y < 0) {
                y = 0;
            }
            if (z > 255) {
                z = 255;
            } else if (z < 0) {
                z = 0;
            }
            return 0xFF000000 | x << 16 | y << 8 | z;
        }
        return this.g.color(x, y, z);
    }

    public final int color(float x, float y, float z) {
        if (this.g == null) {
            if (x > 255.0f) {
                x = 255.0f;
            } else if (x < 0.0f) {
                x = 0.0f;
            }
            if (y > 255.0f) {
                y = 255.0f;
            } else if (y < 0.0f) {
                y = 0.0f;
            }
            if (z > 255.0f) {
                z = 255.0f;
            } else if (z < 0.0f) {
                z = 0.0f;
            }
            return 0xFF000000 | (int)x << 16 | (int)y << 8 | (int)z;
        }
        return this.g.color(x, y, z);
    }

    public final int color(int x, int y, int z, int a) {
        if (this.g == null) {
            if (a > 255) {
                a = 255;
            } else if (a < 0) {
                a = 0;
            }
            if (x > 255) {
                x = 255;
            } else if (x < 0) {
                x = 0;
            }
            if (y > 255) {
                y = 255;
            } else if (y < 0) {
                y = 0;
            }
            if (z > 255) {
                z = 255;
            } else if (z < 0) {
                z = 0;
            }
            return a << 24 | x << 16 | y << 8 | z;
        }
        return this.g.color(x, y, z, a);
    }

    public final int color(float x, float y, float z, float a) {
        if (this.g == null) {
            if (a > 255.0f) {
                a = 255.0f;
            } else if (a < 0.0f) {
                a = 0.0f;
            }
            if (x > 255.0f) {
                x = 255.0f;
            } else if (x < 0.0f) {
                x = 0.0f;
            }
            if (y > 255.0f) {
                y = 255.0f;
            } else if (y < 0.0f) {
                y = 0.0f;
            }
            if (z > 255.0f) {
                z = 255.0f;
            } else if (z < 0.0f) {
                z = 0.0f;
            }
            return (int)a << 24 | (int)x << 16 | (int)y << 8 | (int)z;
        }
        return this.g.color(x, y, z, a);
    }

    public static int blendColor(int c1, int c2, int mode) {
        return PImage.blendColor(c1, c2, mode);
    }

    public static void main(String[] args) {
    }

    public void loadPixels() {
        this.g.loadPixels();
        this.pixels = this.g.pixels;
    }

    public void updatePixels() {
        this.g.updatePixels();
    }

    public void updatePixels(int x1, int y1, int x2, int y2) {
        this.g.updatePixels(x1, y1, x2, y2);
    }

    private void tellPDE(String message) {
        Log.i((String)this.getComponentName().getPackageName(), (String)("PROCESSING " + message));
    }

    protected void onStart() {
        this.tellPDE("onStart");
        super.onStart();
    }

    protected void onStop() {
        this.tellPDE("onStop");
        super.onStop();
    }

    public void setCache(PImage image, Object storage) {
        this.g.setCache(image, storage);
    }

    public Object getCache(PImage image) {
        return this.g.getCache(image);
    }

    public void removeCache(PImage image) {
        this.g.removeCache(image);
    }

    public void flush() {
        this.g.flush();
    }

    public PGL beginPGL() {
        return this.g.beginPGL();
    }

    public void endPGL() {
        this.g.endPGL();
    }

    public void hint(int which) {
        this.g.hint(which);
    }

    public void beginShape() {
        this.g.beginShape();
    }

    public void beginShape(int kind) {
        this.g.beginShape(kind);
    }

    public void edge(boolean edge) {
        this.g.edge(edge);
    }

    public void normal(float nx, float ny, float nz) {
        this.g.normal(nx, ny, nz);
    }

    public void textureMode(int mode) {
        this.g.textureMode(mode);
    }

    public void textureWrap(int wrap) {
        this.g.textureWrap(wrap);
    }

    public void texture(PImage image) {
        this.g.texture(image);
    }

    public void noTexture() {
        this.g.noTexture();
    }

    public void vertex(float x, float y) {
        this.g.vertex(x, y);
    }

    public void vertex(float x, float y, float z) {
        this.g.vertex(x, y, z);
    }

    public void vertex(float[] v) {
        this.g.vertex(v);
    }

    public void vertex(float x, float y, float u, float v) {
        this.g.vertex(x, y, u, v);
    }

    public void vertex(float x, float y, float z, float u, float v) {
        this.g.vertex(x, y, z, u, v);
    }

    public void breakShape() {
        this.g.breakShape();
    }

    public void beginContour() {
        this.g.beginContour();
    }

    public void endContour() {
        this.g.endContour();
    }

    public void endShape() {
        this.g.endShape();
    }

    public void endShape(int mode) {
        this.g.endShape(mode);
    }

    public void clip(float a, float b, float c, float d) {
        this.g.clip(a, b, c, d);
    }

    public void noClip() {
        this.g.noClip();
    }

    public void blendMode(int mode) {
        this.g.blendMode(mode);
    }

    public PShape loadShape(String filename) {
        return this.g.loadShape(filename);
    }

    public PShape createShape(PShape source) {
        return this.g.createShape(source);
    }

    public PShape createShape() {
        return this.g.createShape();
    }

    public PShape createShape(int type) {
        return this.g.createShape(type);
    }

    public PShape createShape(int kind, float ... p) {
        return this.g.createShape(kind, p);
    }

    public PShader loadShader(String fragFilename) {
        return this.g.loadShader(fragFilename);
    }

    public PShader loadShader(String fragFilename, String vertFilename) {
        return this.g.loadShader(fragFilename, vertFilename);
    }

    public void shader(PShader shader) {
        this.g.shader(shader);
    }

    public void shader(PShader shader, int kind) {
        this.g.shader(shader, kind);
    }

    public void resetShader() {
        this.g.resetShader();
    }

    public void resetShader(int kind) {
        this.g.resetShader(kind);
    }

    public PShader getShader(int kind) {
        return this.g.getShader(kind);
    }

    public void filter(PShader shader) {
        this.g.filter(shader);
    }

    public void bezierVertex(float x2, float y2, float x3, float y3, float x4, float y4) {
        this.g.bezierVertex(x2, y2, x3, y3, x4, y4);
    }

    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.g.bezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    public void quadraticVertex(float cx, float cy, float x3, float y3) {
        this.g.quadraticVertex(cx, cy, x3, y3);
    }

    public void quadraticVertex(float cx, float cy, float cz, float x3, float y3, float z3) {
        this.g.quadraticVertex(cx, cy, cz, x3, y3, z3);
    }

    public void curveVertex(float x, float y) {
        this.g.curveVertex(x, y);
    }

    public void curveVertex(float x, float y, float z) {
        this.g.curveVertex(x, y, z);
    }

    public void point(float x, float y) {
        this.g.point(x, y);
    }

    public void point(float x, float y, float z) {
        this.g.point(x, y, z);
    }

    public void line(float x1, float y1, float x2, float y2) {
        this.g.line(x1, y1, x2, y2);
    }

    public void line(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.g.line(x1, y1, z1, x2, y2, z2);
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.g.triangle(x1, y1, x2, y2, x3, y3);
    }

    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.g.quad(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public void rectMode(int mode) {
        this.g.rectMode(mode);
    }

    public void rect(float a, float b, float c, float d) {
        this.g.rect(a, b, c, d);
    }

    public void rect(float a, float b, float c, float d, float r) {
        this.g.rect(a, b, c, d, r);
    }

    public void rect(float a, float b, float c, float d, float tl, float tr, float br, float bl) {
        this.g.rect(a, b, c, d, tl, tr, br, bl);
    }

    public void ellipseMode(int mode) {
        this.g.ellipseMode(mode);
    }

    public void ellipse(float a, float b, float c, float d) {
        this.g.ellipse(a, b, c, d);
    }

    public void arc(float a, float b, float c, float d, float start, float stop) {
        this.g.arc(a, b, c, d, start, stop);
    }

    public void box(float size) {
        this.g.box(size);
    }

    public void box(float w, float h, float d) {
        this.g.box(w, h, d);
    }

    public void sphereDetail(int res) {
        this.g.sphereDetail(res);
    }

    public void sphereDetail(int ures, int vres) {
        this.g.sphereDetail(ures, vres);
    }

    public void sphere(float r) {
        this.g.sphere(r);
    }

    public float bezierPoint(float a, float b, float c, float d, float t) {
        return this.g.bezierPoint(a, b, c, d, t);
    }

    public float bezierTangent(float a, float b, float c, float d, float t) {
        return this.g.bezierTangent(a, b, c, d, t);
    }

    public void bezierDetail(int detail) {
        this.g.bezierDetail(detail);
    }

    public void bezier(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.g.bezier(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public void bezier(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.g.bezier(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    public float curvePoint(float a, float b, float c, float d, float t) {
        return this.g.curvePoint(a, b, c, d, t);
    }

    public float curveTangent(float a, float b, float c, float d, float t) {
        return this.g.curveTangent(a, b, c, d, t);
    }

    public void curveDetail(int detail) {
        this.g.curveDetail(detail);
    }

    public void curveTightness(float tightness) {
        this.g.curveTightness(tightness);
    }

    public void curve(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.g.curve(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public void curve(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.g.curve(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    public void smooth() {
        this.g.smooth();
    }

    public void smooth(int level) {
        this.g.smooth(level);
    }

    public void noSmooth() {
        this.g.noSmooth();
    }

    public void imageMode(int mode) {
        this.g.imageMode(mode);
    }

    public void image(PImage image, float x, float y) {
        this.g.image(image, x, y);
    }

    public void image(PImage image, float x, float y, float c, float d) {
        this.g.image(image, x, y, c, d);
    }

    public void image(PImage image, float a, float b, float c, float d, int u1, int v1, int u2, int v2) {
        this.g.image(image, a, b, c, d, u1, v1, u2, v2);
    }

    public void shapeMode(int mode) {
        this.g.shapeMode(mode);
    }

    public void shape(PShape shape) {
        this.g.shape(shape);
    }

    public void shape(PShape shape, float x, float y) {
        this.g.shape(shape, x, y);
    }

    public void shape(PShape shape, float x, float y, float c, float d) {
        this.g.shape(shape, x, y, c, d);
    }

    public void textAlign(int align) {
        this.g.textAlign(align);
    }

    public void textAlign(int alignX, int alignY) {
        this.g.textAlign(alignX, alignY);
    }

    public float textAscent() {
        return this.g.textAscent();
    }

    public float textDescent() {
        return this.g.textDescent();
    }

    public void textFont(PFont which) {
        this.g.textFont(which);
    }

    public void textFont(PFont which, float size) {
        this.g.textFont(which, size);
    }

    public void textLeading(float leading) {
        this.g.textLeading(leading);
    }

    public void textMode(int mode) {
        this.g.textMode(mode);
    }

    public void textSize(float size) {
        this.g.textSize(size);
    }

    public float textWidth(char c) {
        return this.g.textWidth(c);
    }

    public float textWidth(String str) {
        return this.g.textWidth(str);
    }

    public void text(char c, float x, float y) {
        this.g.text(c, x, y);
    }

    public void text(char c, float x, float y, float z) {
        this.g.text(c, x, y, z);
    }

    public void text(String str, float x, float y) {
        this.g.text(str, x, y);
    }

    public void text(String str, float x, float y, float z) {
        this.g.text(str, x, y, z);
    }

    public void text(String str, float x1, float y1, float x2, float y2) {
        this.g.text(str, x1, y1, x2, y2);
    }

    public void text(int num, float x, float y) {
        this.g.text(num, x, y);
    }

    public void text(int num, float x, float y, float z) {
        this.g.text(num, x, y, z);
    }

    public void text(float num, float x, float y) {
        this.g.text(num, x, y);
    }

    public void text(float num, float x, float y, float z) {
        this.g.text(num, x, y, z);
    }

    public void pushMatrix() {
        this.g.pushMatrix();
    }

    public void popMatrix() {
        this.g.popMatrix();
    }

    public void translate(float tx, float ty) {
        this.g.translate(tx, ty);
    }

    public void translate(float tx, float ty, float tz) {
        this.g.translate(tx, ty, tz);
    }

    public void rotate(float angle) {
        this.g.rotate(angle);
    }

    public void rotateX(float angle) {
        this.g.rotateX(angle);
    }

    public void rotateY(float angle) {
        this.g.rotateY(angle);
    }

    public void rotateZ(float angle) {
        this.g.rotateZ(angle);
    }

    public void rotate(float angle, float vx, float vy, float vz) {
        this.g.rotate(angle, vx, vy, vz);
    }

    public void scale(float s) {
        this.g.scale(s);
    }

    public void scale(float sx, float sy) {
        this.g.scale(sx, sy);
    }

    public void scale(float x, float y, float z) {
        this.g.scale(x, y, z);
    }

    public void shearX(float angle) {
        this.g.shearX(angle);
    }

    public void shearY(float angle) {
        this.g.shearY(angle);
    }

    public void resetMatrix() {
        this.g.resetMatrix();
    }

    public void applyMatrix(PMatrix source) {
        this.g.applyMatrix(source);
    }

    public void applyMatrix(PMatrix2D source) {
        this.g.applyMatrix(source);
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.g.applyMatrix(n00, n01, n02, n10, n11, n12);
    }

    public void applyMatrix(PMatrix3D source) {
        this.g.applyMatrix(source);
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.g.applyMatrix(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    public PMatrix getMatrix() {
        return this.g.getMatrix();
    }

    public PMatrix2D getMatrix(PMatrix2D target) {
        return this.g.getMatrix(target);
    }

    public PMatrix3D getMatrix(PMatrix3D target) {
        return this.g.getMatrix(target);
    }

    public void setMatrix(PMatrix source) {
        this.g.setMatrix(source);
    }

    public void setMatrix(PMatrix2D source) {
        this.g.setMatrix(source);
    }

    public void setMatrix(PMatrix3D source) {
        this.g.setMatrix(source);
    }

    public void printMatrix() {
        this.g.printMatrix();
    }

    public void beginCamera() {
        this.g.beginCamera();
    }

    public void endCamera() {
        this.g.endCamera();
    }

    public void camera() {
        this.g.camera();
    }

    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        this.g.camera(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
    }

    public void printCamera() {
        this.g.printCamera();
    }

    public void ortho() {
        this.g.ortho();
    }

    public void ortho(float left, float right, float bottom, float top) {
        this.g.ortho(left, right, bottom, top);
    }

    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        this.g.ortho(left, right, bottom, top, near, far);
    }

    public void perspective() {
        this.g.perspective();
    }

    public void perspective(float fovy, float aspect, float zNear, float zFar) {
        this.g.perspective(fovy, aspect, zNear, zFar);
    }

    public void frustum(float left, float right, float bottom, float top, float near, float far) {
        this.g.frustum(left, right, bottom, top, near, far);
    }

    public void printProjection() {
        this.g.printProjection();
    }

    public float screenX(float x, float y) {
        return this.g.screenX(x, y);
    }

    public float screenY(float x, float y) {
        return this.g.screenY(x, y);
    }

    public float screenX(float x, float y, float z) {
        return this.g.screenX(x, y, z);
    }

    public float screenY(float x, float y, float z) {
        return this.g.screenY(x, y, z);
    }

    public float screenZ(float x, float y, float z) {
        return this.g.screenZ(x, y, z);
    }

    public float modelX(float x, float y, float z) {
        return this.g.modelX(x, y, z);
    }

    public float modelY(float x, float y, float z) {
        return this.g.modelY(x, y, z);
    }

    public float modelZ(float x, float y, float z) {
        return this.g.modelZ(x, y, z);
    }

    public void pushStyle() {
        this.g.pushStyle();
    }

    public void popStyle() {
        this.g.popStyle();
    }

    public void style(PStyle s) {
        this.g.style(s);
    }

    public void strokeWeight(float weight) {
        this.g.strokeWeight(weight);
    }

    public void strokeJoin(int join) {
        this.g.strokeJoin(join);
    }

    public void strokeCap(int cap) {
        this.g.strokeCap(cap);
    }

    public void noStroke() {
        this.g.noStroke();
    }

    public void stroke(int rgb) {
        this.g.stroke(rgb);
    }

    public void stroke(int rgb, float alpha) {
        this.g.stroke(rgb, alpha);
    }

    public void stroke(float gray) {
        this.g.stroke(gray);
    }

    public void stroke(float gray, float alpha) {
        this.g.stroke(gray, alpha);
    }

    public void stroke(float x, float y, float z) {
        this.g.stroke(x, y, z);
    }

    public void stroke(float x, float y, float z, float a) {
        this.g.stroke(x, y, z, a);
    }

    public void noTint() {
        this.g.noTint();
    }

    public void tint(int rgb) {
        this.g.tint(rgb);
    }

    public void tint(int rgb, float alpha) {
        this.g.tint(rgb, alpha);
    }

    public void tint(float gray) {
        this.g.tint(gray);
    }

    public void tint(float gray, float alpha) {
        this.g.tint(gray, alpha);
    }

    public void tint(float x, float y, float z) {
        this.g.tint(x, y, z);
    }

    public void tint(float x, float y, float z, float a) {
        this.g.tint(x, y, z, a);
    }

    public void noFill() {
        this.g.noFill();
    }

    public void fill(int rgb) {
        this.g.fill(rgb);
    }

    public void fill(int rgb, float alpha) {
        this.g.fill(rgb, alpha);
    }

    public void fill(float gray) {
        this.g.fill(gray);
    }

    public void fill(float gray, float alpha) {
        this.g.fill(gray, alpha);
    }

    public void fill(float x, float y, float z) {
        this.g.fill(x, y, z);
    }

    public void fill(float x, float y, float z, float a) {
        this.g.fill(x, y, z, a);
    }

    public void ambient(int rgb) {
        this.g.ambient(rgb);
    }

    public void ambient(float gray) {
        this.g.ambient(gray);
    }

    public void ambient(float x, float y, float z) {
        this.g.ambient(x, y, z);
    }

    public void specular(int rgb) {
        this.g.specular(rgb);
    }

    public void specular(float gray) {
        this.g.specular(gray);
    }

    public void specular(float x, float y, float z) {
        this.g.specular(x, y, z);
    }

    public void shininess(float shine) {
        this.g.shininess(shine);
    }

    public void emissive(int rgb) {
        this.g.emissive(rgb);
    }

    public void emissive(float gray) {
        this.g.emissive(gray);
    }

    public void emissive(float x, float y, float z) {
        this.g.emissive(x, y, z);
    }

    public void lights() {
        this.g.lights();
    }

    public void noLights() {
        this.g.noLights();
    }

    public void ambientLight(float red, float green, float blue) {
        this.g.ambientLight(red, green, blue);
    }

    public void ambientLight(float red, float green, float blue, float x, float y, float z) {
        this.g.ambientLight(red, green, blue, x, y, z);
    }

    public void directionalLight(float red, float green, float blue, float nx, float ny, float nz) {
        this.g.directionalLight(red, green, blue, nx, ny, nz);
    }

    public void pointLight(float red, float green, float blue, float x, float y, float z) {
        this.g.pointLight(red, green, blue, x, y, z);
    }

    public void spotLight(float red, float green, float blue, float x, float y, float z, float nx, float ny, float nz, float angle, float concentration) {
        this.g.spotLight(red, green, blue, x, y, z, nx, ny, nz, angle, concentration);
    }

    public void lightFalloff(float constant, float linear, float quadratic) {
        this.g.lightFalloff(constant, linear, quadratic);
    }

    public void lightSpecular(float x, float y, float z) {
        this.g.lightSpecular(x, y, z);
    }

    public void background(int rgb) {
        this.g.background(rgb);
    }

    public void background(int rgb, float alpha) {
        this.g.background(rgb, alpha);
    }

    public void background(float gray) {
        this.g.background(gray);
    }

    public void background(float gray, float alpha) {
        this.g.background(gray, alpha);
    }

    public void background(float x, float y, float z) {
        this.g.background(x, y, z);
    }

    public void background(float x, float y, float z, float a) {
        this.g.background(x, y, z, a);
    }

    public void background(PImage image) {
        this.g.background(image);
    }

    public void colorMode(int mode) {
        this.g.colorMode(mode);
    }

    public void colorMode(int mode, float max) {
        this.g.colorMode(mode, max);
    }

    public void colorMode(int mode, float maxX, float maxY, float maxZ) {
        this.g.colorMode(mode, maxX, maxY, maxZ);
    }

    public void colorMode(int mode, float maxX, float maxY, float maxZ, float maxA) {
        this.g.colorMode(mode, maxX, maxY, maxZ, maxA);
    }

    public final float alpha(int what) {
        return this.g.alpha(what);
    }

    public final float red(int what) {
        return this.g.red(what);
    }

    public final float green(int what) {
        return this.g.green(what);
    }

    public final float blue(int what) {
        return this.g.blue(what);
    }

    public final float hue(int what) {
        return this.g.hue(what);
    }

    public final float saturation(int what) {
        return this.g.saturation(what);
    }

    public final float brightness(int what) {
        return this.g.brightness(what);
    }

    public int lerpColor(int c1, int c2, float amt) {
        return this.g.lerpColor(c1, c2, amt);
    }

    public static int lerpColor(int c1, int c2, float amt, int mode) {
        return PGraphics.lerpColor(c1, c2, amt, mode);
    }

    public static void showDepthWarning(String method) {
        PGraphics.showDepthWarning(method);
    }

    public static void showDepthWarningXYZ(String method) {
        PGraphics.showDepthWarningXYZ(method);
    }

    public static void showMethodWarning(String method) {
        PGraphics.showMethodWarning(method);
    }

    public static void showVariationWarning(String str) {
        PGraphics.showVariationWarning(str);
    }

    public static void showMissingWarning(String method) {
        PGraphics.showMissingWarning(method);
    }

    public boolean displayable() {
        return this.g.displayable();
    }

    public boolean isGL() {
        return this.g.isGL();
    }

    public Object getNative() {
        return this.g.getNative();
    }

    public int get(int x, int y) {
        return this.g.get(x, y);
    }

    public PImage get(int x, int y, int w, int h) {
        return this.g.get(x, y, w, h);
    }

    public PImage get() {
        return this.g.get();
    }

    public void set(int x, int y, int c) {
        this.g.set(x, y, c);
    }

    public void set(int x, int y, PImage src) {
        this.g.set(x, y, src);
    }

    public void mask(int[] alpha) {
        this.g.mask(alpha);
    }

    public void mask(PImage alpha) {
        this.g.mask(alpha);
    }

    public void filter(int kind) {
        this.g.filter(kind);
    }

    public void filter(int kind, float param) {
        this.g.filter(kind, param);
    }

    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.g.copy(sx, sy, sw, sh, dx, dy, dw, dh);
    }

    public void copy(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.g.copy(src, sx, sy, sw, sh, dx, dy, dw, dh);
    }

    public void blend(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        this.g.blend(sx, sy, sw, sh, dx, dy, dw, dh, mode);
    }

    public void blend(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        this.g.blend(src, sx, sy, sw, sh, dx, dy, dw, dh, mode);
    }

    class AsyncImageLoader
    extends Thread {
        String filename;
        PImage vessel;

        public AsyncImageLoader(String filename, PImage vessel) {
            this.filename = filename;
            this.vessel = vessel;
        }

        public void run() {
            while (PApplet.this.requestImageCount == PApplet.this.requestImageMax) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++PApplet.this.requestImageCount;
            PImage actual = PApplet.this.loadImage(this.filename);
            if (actual == null) {
                this.vessel.width = -1;
                this.vessel.height = -1;
            } else {
                this.vessel.width = actual.width;
                this.vessel.height = actual.height;
                this.vessel.format = actual.format;
                this.vessel.pixels = actual.pixels;
                this.vessel.bitmap = actual.bitmap;
            }
            --PApplet.this.requestImageCount;
        }
    }

    class PMotionEvent {
        int action;
        int numPointers;
        float[] motionX;
        float[] motionY;
        float[] motionPressure;
        int[] mouseX;
        int[] mouseY;

        PMotionEvent() {
        }

        void setAction(int action) {
            this.action = action;
        }

        void setNumPointers(int n) {
            this.numPointers = n;
            this.motionX = new float[n];
            this.motionY = new float[n];
            this.motionPressure = new float[n];
            this.mouseX = new int[n];
            this.mouseY = new int[n];
        }

        void setPointers(MotionEvent event) {
            int ptIdx = 0;
            while (ptIdx < this.numPointers) {
                this.motionX[ptIdx] = event.getX(ptIdx);
                this.motionY[ptIdx] = event.getY(ptIdx);
                this.motionPressure[ptIdx] = event.getPressure(ptIdx);
                this.mouseX[ptIdx] = (int)this.motionX[ptIdx];
                this.mouseY[ptIdx] = (int)this.motionY[ptIdx];
                ++ptIdx;
            }
        }

        void setPointers(MotionEvent event, int hisIdx) {
            int ptIdx = 0;
            while (ptIdx < this.numPointers) {
                this.motionX[ptIdx] = event.getHistoricalX(ptIdx, hisIdx);
                this.motionY[ptIdx] = event.getHistoricalY(ptIdx, hisIdx);
                this.motionPressure[ptIdx] = event.getHistoricalPressure(ptIdx, hisIdx);
                this.mouseX[ptIdx] = (int)this.motionX[ptIdx];
                this.mouseY[ptIdx] = (int)this.motionY[ptIdx];
                ++ptIdx;
            }
        }
    }

    class RegisteredMethods {
        int count;
        Object[] objects;
        Method[] methods;
        Object[] emptyArgs = new Object[0];

        RegisteredMethods() {
        }

        void handle() {
            this.handle(this.emptyArgs);
        }

        void handle(Object[] args) {
            int i = 0;
            while (i < this.count) {
                try {
                    this.methods[i].invoke(this.objects[i], args);
                }
                catch (Exception e) {
                    Throwable t;
                    if (e instanceof InvocationTargetException) {
                        InvocationTargetException ite = (InvocationTargetException)e;
                        t = ite.getCause();
                    } else {
                        t = e;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    t.printStackTrace();
                }
                ++i;
            }
        }

        void add(Object object, Method method) {
            if (this.findIndex(object) == -1) {
                if (this.objects == null) {
                    this.objects = new Object[5];
                    this.methods = new Method[5];
                } else if (this.count == this.objects.length) {
                    this.objects = (Object[])PApplet.expand(this.objects);
                    this.methods = (Method[])PApplet.expand(this.methods);
                }
                this.objects[this.count] = object;
                this.methods[this.count] = method;
                ++this.count;
            } else {
                PApplet.this.die(String.valueOf(method.getName()) + "() already added for this instance of " + object.getClass().getName());
            }
        }

        public void remove(Object object) {
            int index = this.findIndex(object);
            if (index != -1) {
                --this.count;
                int i = index;
                while (i < this.count) {
                    this.objects[i] = this.objects[i + 1];
                    this.methods[i] = this.methods[i + 1];
                    ++i;
                }
                this.objects[this.count] = null;
                this.methods[this.count] = null;
            }
        }

        protected int findIndex(Object object) {
            int i = 0;
            while (i < this.count) {
                if (this.objects[i] == object) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    public static class RendererChangeException
    extends RuntimeException {
    }

    public class SketchSurfaceView
    extends SurfaceView
    implements SurfaceHolder.Callback {
        PGraphicsAndroid2D g2;
        SurfaceHolder surfaceHolder;

        public SketchSurfaceView(Context context, int wide, int high) {
            super(context);
            this.surfaceHolder = this.getHolder();
            this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            this.surfaceHolder.setType(2);
            this.g2 = new PGraphicsAndroid2D();
            this.g2.setSize(wide, high);
            this.g2.setParent(PApplet.this);
            this.g2.setPrimary(true);
            PApplet.this.g = this.g2;
            this.setFocusable(true);
            this.setFocusableInTouchMode(true);
            this.requestFocus();
        }

        public void surfaceCreated(SurfaceHolder holder) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            PApplet.this.surfaceChanged = true;
        }

        public void onWindowFocusChanged(boolean hasFocus) {
            PApplet.this.surfaceWindowFocusChanged(hasFocus);
        }

        public boolean onTouchEvent(MotionEvent event) {
            return PApplet.this.surfaceTouchEvent(event);
        }

        public boolean onKeyDown(int code, android.view.KeyEvent event) {
            return PApplet.this.surfaceKeyDown(code, event);
        }

        public boolean onKeyUp(int code, android.view.KeyEvent event) {
            return PApplet.this.surfaceKeyUp(code, event);
        }
    }

    public class SketchSurfaceViewGL
    extends GLSurfaceView {
        PGraphicsOpenGL g3;
        SurfaceHolder surfaceHolder;

        public SketchSurfaceViewGL(Context context, int wide, int high, boolean is3D) {
            boolean supportsGLES2;
            super(context);
            ActivityManager activityManager = (ActivityManager)PApplet.this.getSystemService("activity");
            ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
            boolean bl = supportsGLES2 = configurationInfo.reqGlEsVersion >= 131072;
            if (!supportsGLES2) {
                throw new RuntimeException("OpenGL ES 2.0 is not supported by this device.");
            }
            this.surfaceHolder = this.getHolder();
            this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            this.g3 = is3D ? new PGraphics3D() : new PGraphics2D();
            this.g3.setParent(PApplet.this);
            this.g3.setPrimary(true);
            this.g3.setSize(wide, high);
            this.setEGLContextClientVersion(2);
            this.setRenderer(this.g3.pgl.getRenderer());
            this.setRenderMode(0);
            PApplet.this.g = this.g3;
            this.setFocusable(true);
            this.setFocusableInTouchMode(true);
            this.requestFocus();
        }

        public PGraphics getGraphics() {
            return this.g3;
        }

        public void surfaceCreated(SurfaceHolder holder) {
            super.surfaceCreated(holder);
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            super.surfaceDestroyed(holder);
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            super.surfaceChanged(holder, format, w, h);
            PApplet.this.surfaceChanged = true;
        }

        public void onWindowFocusChanged(boolean hasFocus) {
            PApplet.this.surfaceWindowFocusChanged(hasFocus);
        }

        public boolean onTouchEvent(MotionEvent event) {
            return PApplet.this.surfaceTouchEvent(event);
        }

        public boolean onKeyDown(int code, android.view.KeyEvent event) {
            return PApplet.this.surfaceKeyDown(code, event);
        }

        public boolean onKeyUp(int code, android.view.KeyEvent event) {
            return PApplet.this.surfaceKeyUp(code, event);
        }
    }
}

