/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.HashSet;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.PGL;
import processing.opengl.PGraphics2D;
import processing.opengl.PGraphics3D;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PShader;
import processing.opengl.Texture;

public class PShapeOpenGL
extends PShape {
    protected static final int TRANSLATE = 0;
    protected static final int ROTATE = 1;
    protected static final int SCALE = 2;
    protected static final int MATRIX = 3;
    protected PGraphicsOpenGL pg;
    protected PGL pgl;
    protected PGL.Context context;
    protected PShapeOpenGL root;
    protected PGraphicsOpenGL.InGeometry inGeo;
    protected PGraphicsOpenGL.TessGeometry tessGeo;
    protected PGraphicsOpenGL.Tessellator tessellator;
    protected HashSet<PImage> textures;
    protected boolean strokedTexture;
    public int glPolyVertex;
    public int glPolyColor;
    public int glPolyNormal;
    public int glPolyTexcoord;
    public int glPolyAmbient;
    public int glPolySpecular;
    public int glPolyEmissive;
    public int glPolyShininess;
    public int glPolyIndex;
    public int glLineVertex;
    public int glLineColor;
    public int glLineAttrib;
    public int glLineIndex;
    public int glPointVertex;
    public int glPointColor;
    public int glPointAttrib;
    public int glPointIndex;
    protected int polyVertCopyOffset;
    protected int polyIndCopyOffset;
    protected int lineVertCopyOffset;
    protected int lineIndCopyOffset;
    protected int pointVertCopyOffset;
    protected int pointIndCopyOffset;
    protected int polyIndexOffset;
    protected int polyVertexOffset;
    protected int polyVertexAbs;
    protected int polyVertexRel;
    protected int lineIndexOffset;
    protected int lineVertexOffset;
    protected int lineVertexAbs;
    protected int lineVertexRel;
    protected int pointIndexOffset;
    protected int pointVertexOffset;
    protected int pointVertexAbs;
    protected int pointVertexRel;
    protected int firstPolyIndexCache;
    protected int lastPolyIndexCache;
    protected int firstLineIndexCache;
    protected int lastLineIndexCache;
    protected int firstPointIndexCache;
    protected int lastPointIndexCache;
    protected int firstPolyVertex;
    protected int lastPolyVertex;
    protected int firstLineVertex;
    protected int lastLineVertex;
    protected int firstPointVertex;
    protected int lastPointVertex;
    protected PMatrix transform;
    protected boolean tessellated;
    protected boolean needBufferInit;
    protected boolean isSolid;
    protected boolean isClosed;
    protected boolean openContour = false;
    protected boolean breakShape = false;
    protected boolean shapeEnded = false;
    protected boolean hasPolys;
    protected boolean hasLines;
    protected boolean hasPoints;
    protected int textureMode;
    protected int rectMode;
    protected int ellipseMode;
    protected int shapeMode;
    protected int imageMode;
    protected int bezierDetail = 20;
    protected int curveDetail = 20;
    protected float curveTightness = 0.0f;
    protected float normalX;
    protected float normalY;
    protected float normalZ;
    protected static final int NORMAL_MODE_AUTO = 0;
    protected static final int NORMAL_MODE_SHAPE = 1;
    protected static final int NORMAL_MODE_VERTEX = 2;
    protected int normalMode;
    protected boolean modified;
    protected boolean modifiedPolyVertices;
    protected boolean modifiedPolyColors;
    protected boolean modifiedPolyNormals;
    protected boolean modifiedPolyTexcoords;
    protected boolean modifiedPolyAmbient;
    protected boolean modifiedPolySpecular;
    protected boolean modifiedPolyEmissive;
    protected boolean modifiedPolyShininess;
    protected boolean modifiedLineVertices;
    protected boolean modifiedLineColors;
    protected boolean modifiedLineAttributes;
    protected boolean modifiedPointVertices;
    protected boolean modifiedPointColors;
    protected boolean modifiedPointAttributes;
    protected int firstModifiedPolyVertex;
    protected int lastModifiedPolyVertex;
    protected int firstModifiedPolyColor;
    protected int lastModifiedPolyColor;
    protected int firstModifiedPolyNormal;
    protected int lastModifiedPolyNormal;
    protected int firstModifiedPolyTexcoord;
    protected int lastModifiedPolyTexcoord;
    protected int firstModifiedPolyAmbient;
    protected int lastModifiedPolyAmbient;
    protected int firstModifiedPolySpecular;
    protected int lastModifiedPolySpecular;
    protected int firstModifiedPolyEmissive;
    protected int lastModifiedPolyEmissive;
    protected int firstModifiedPolyShininess;
    protected int lastModifiedPolyShininess;
    protected int firstModifiedLineVertex;
    protected int lastModifiedLineVertex;
    protected int firstModifiedLineColor;
    protected int lastModifiedLineColor;
    protected int firstModifiedLineAttribute;
    protected int lastModifiedLineAttribute;
    protected int firstModifiedPointVertex;
    protected int lastModifiedPointVertex;
    protected int firstModifiedPointColor;
    protected int lastModifiedPointColor;
    protected int firstModifiedPointAttribute;
    protected int lastModifiedPointAttribute;

    PShapeOpenGL() {
    }

    public PShapeOpenGL(PApplet parent, int family) {
        this.pg = (PGraphicsOpenGL)parent.g;
        this.pgl = this.pg.pgl;
        this.context = this.pgl.createEmptyContext();
        this.glPolyVertex = 0;
        this.glPolyColor = 0;
        this.glPolyNormal = 0;
        this.glPolyTexcoord = 0;
        this.glPolyAmbient = 0;
        this.glPolySpecular = 0;
        this.glPolyEmissive = 0;
        this.glPolyShininess = 0;
        this.glPolyIndex = 0;
        this.glLineVertex = 0;
        this.glLineColor = 0;
        this.glLineAttrib = 0;
        this.glLineIndex = 0;
        this.glPointVertex = 0;
        this.glPointColor = 0;
        this.glPointAttrib = 0;
        this.glPointIndex = 0;
        this.tessellator = PGraphicsOpenGL.tessellator;
        this.family = family;
        this.root = this;
        this.parent = null;
        this.tessellated = false;
        if (family == 3 || family == 1 || family == 2) {
            this.inGeo = this.pg.newInGeometry(1);
        }
        this.textureMode = this.pg.textureMode;
        this.rectMode = this.pg.rectMode;
        this.ellipseMode = this.pg.ellipseMode;
        this.shapeMode = this.pg.shapeMode;
        this.imageMode = this.pg.imageMode;
        this.colorMode(this.pg.colorMode, this.pg.colorModeX, this.pg.colorModeY, this.pg.colorModeZ, this.pg.colorModeA);
        this.fill = this.pg.fill;
        this.fillColor = this.pg.fillColor;
        this.stroke = this.pg.stroke;
        this.strokeColor = this.pg.strokeColor;
        this.strokeWeight = this.pg.strokeWeight;
        this.strokeCap = this.pg.strokeCap;
        this.strokeJoin = this.pg.strokeJoin;
        this.tint = this.pg.tint;
        this.tintColor = this.pg.tintColor;
        this.ambientColor = this.pg.ambientColor;
        this.specularColor = this.pg.specularColor;
        this.emissiveColor = this.pg.emissiveColor;
        this.shininess = this.pg.shininess;
        this.normalY = 0.0f;
        this.normalX = 0.0f;
        this.normalZ = 1.0f;
        this.normalMode = 0;
        if (family == 0) {
            this.shapeEnded = true;
        }
    }

    public void addChild(PShape child) {
        if (child instanceof PShapeOpenGL) {
            if (this.family == 0) {
                PShapeOpenGL c3d = (PShapeOpenGL)child;
                super.addChild(c3d);
                c3d.updateRoot(this.root);
                this.markForTessellation();
                if (c3d.family == 0) {
                    if (c3d.textures != null) {
                        for (PImage tex : c3d.textures) {
                            this.addTexture(tex);
                        }
                    }
                    if (c3d.strokedTexture) {
                        this.strokedTexture(true);
                    }
                } else if (c3d.image != null) {
                    this.addTexture(c3d.image);
                    if (c3d.stroke) {
                        this.strokedTexture(true);
                    }
                }
            } else {
                PGraphics.showWarning("Cannot add child shape to non-group shape.");
            }
        } else {
            PGraphics.showWarning("Shape must be 3D to be added to the group.");
        }
    }

    protected void updateRoot(PShape root) {
        this.root = (PShapeOpenGL)root;
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.updateRoot(root);
                ++i;
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.finalizePolyBuffers();
            this.finalizeLineBuffers();
            this.finalizePointBuffers();
        }
        finally {
            super.finalize();
        }
    }

    protected void finalizePolyBuffers() {
        if (this.glPolyVertex != 0) {
            this.pg.finalizeVertexBufferObject(this.glPolyVertex, this.context.id());
        }
        if (this.glPolyColor != 0) {
            this.pg.finalizeVertexBufferObject(this.glPolyColor, this.context.id());
        }
        if (this.glPolyNormal != 0) {
            this.pg.finalizeVertexBufferObject(this.glPolyNormal, this.context.id());
        }
        if (this.glPolyTexcoord != 0) {
            this.pg.finalizeVertexBufferObject(this.glPolyTexcoord, this.context.id());
        }
        if (this.glPolyAmbient != 0) {
            this.pg.finalizeVertexBufferObject(this.glPolyAmbient, this.context.id());
        }
        if (this.glPolySpecular != 0) {
            this.pg.finalizeVertexBufferObject(this.glPolySpecular, this.context.id());
        }
        if (this.glPolyEmissive != 0) {
            this.pg.finalizeVertexBufferObject(this.glPolyEmissive, this.context.id());
        }
        if (this.glPolyShininess != 0) {
            this.pg.finalizeVertexBufferObject(this.glPolyShininess, this.context.id());
        }
        if (this.glPolyIndex != 0) {
            this.pg.finalizeVertexBufferObject(this.glPolyIndex, this.context.id());
        }
    }

    protected void finalizeLineBuffers() {
        if (this.glLineVertex != 0) {
            this.pg.finalizeVertexBufferObject(this.glLineVertex, this.context.id());
        }
        if (this.glLineColor != 0) {
            this.pg.finalizeVertexBufferObject(this.glLineColor, this.context.id());
        }
        if (this.glLineAttrib != 0) {
            this.pg.finalizeVertexBufferObject(this.glLineAttrib, this.context.id());
        }
        if (this.glLineIndex != 0) {
            this.pg.finalizeVertexBufferObject(this.glLineIndex, this.context.id());
        }
    }

    protected void finalizePointBuffers() {
        if (this.glPointVertex != 0) {
            this.pg.finalizeVertexBufferObject(this.glPointVertex, this.context.id());
        }
        if (this.glPointColor != 0) {
            this.pg.finalizeVertexBufferObject(this.glPointColor, this.context.id());
        }
        if (this.glPointAttrib != 0) {
            this.pg.finalizeVertexBufferObject(this.glPointAttrib, this.context.id());
        }
        if (this.glPointIndex != 0) {
            this.pg.finalizeVertexBufferObject(this.glPointIndex, this.context.id());
        }
    }

    protected static PShapeOpenGL createShape3D(PApplet parent, PShape src) {
        PShapeOpenGL dest = null;
        if (src.getFamily() == 0) {
            dest = PGraphics3D.createShapeImpl(parent, 0);
            PShapeOpenGL.copyGroup3D(parent, src, dest);
        } else if (src.getFamily() == 1) {
            dest = PGraphics3D.createShapeImpl(parent, src.getKind(), src.getParams());
            PShape.copyPrimitive(src, dest);
        } else if (src.getFamily() == 3) {
            dest = PGraphics3D.createShapeImpl(parent, src.getKind());
            PShape.copyGeometry(src, dest);
        } else if (src.getFamily() == 2) {
            dest = PGraphics3D.createShapeImpl(parent, 2);
            PShape.copyPath(src, dest);
        }
        dest.setName(src.getName());
        return dest;
    }

    public static PShapeOpenGL createShape2D(PApplet parent, PShape src) {
        PShapeOpenGL dest = null;
        if (src.getFamily() == 0) {
            dest = PGraphics2D.createShapeImpl(parent, 0);
            PShapeOpenGL.copyGroup2D(parent, src, dest);
        } else if (src.getFamily() == 1) {
            dest = PGraphics2D.createShapeImpl(parent, src.getKind(), src.getParams());
            PShape.copyPrimitive(src, dest);
        } else if (src.getFamily() == 3) {
            dest = PGraphics2D.createShapeImpl(parent, src.getKind());
            PShape.copyGeometry(src, dest);
        } else if (src.getFamily() == 2) {
            dest = PGraphics2D.createShapeImpl(parent, 2);
            PShape.copyPath(src, dest);
        }
        dest.setName(src.getName());
        return dest;
    }

    public static void copyGroup3D(PApplet parent, PShape src, PShape dest) {
        PShapeOpenGL.copyMatrix(src, dest);
        PShapeOpenGL.copyStyles(src, dest);
        PShapeOpenGL.copyImage(src, dest);
        int i = 0;
        while (i < src.getChildCount()) {
            PShapeOpenGL c = PShapeOpenGL.createShape3D(parent, src.getChild(i));
            dest.addChild(c);
            ++i;
        }
    }

    public static void copyGroup2D(PApplet parent, PShape src, PShape dest) {
        PShapeOpenGL.copyMatrix(src, dest);
        PShapeOpenGL.copyStyles(src, dest);
        PShapeOpenGL.copyImage(src, dest);
        int i = 0;
        while (i < src.getChildCount()) {
            PShapeOpenGL c = PShapeOpenGL.createShape2D(parent, src.getChild(i));
            dest.addChild(c);
            ++i;
        }
    }

    public float getWidth() {
        PVector min = new PVector(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        PVector max = new PVector(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        if (this.shapeEnded) {
            this.getVertexMin(min);
            this.getVertexMax(max);
        }
        this.width = max.x - min.x;
        return this.width;
    }

    public float getHeight() {
        PVector min = new PVector(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        PVector max = new PVector(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        if (this.shapeEnded) {
            this.getVertexMin(min);
            this.getVertexMax(max);
        }
        this.height = max.y - min.y;
        return this.height;
    }

    public float getDepth() {
        PVector min = new PVector(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        PVector max = new PVector(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        if (this.shapeEnded) {
            this.getVertexMin(min);
            this.getVertexMax(max);
        }
        this.depth = max.z - min.z;
        return this.depth;
    }

    protected void getVertexMin(PVector min) {
        this.updateTessellation();
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.getVertexMin(min);
                ++i;
            }
        } else {
            if (this.hasPolys) {
                this.tessGeo.getPolyVertexMin(min, this.firstPolyVertex, this.lastPolyVertex);
            }
            if (this.is3D()) {
                if (this.hasLines) {
                    this.tessGeo.getLineVertexMin(min, this.firstLineVertex, this.lastLineVertex);
                }
                if (this.hasPoints) {
                    this.tessGeo.getPointVertexMin(min, this.firstPointVertex, this.lastPointVertex);
                }
            }
        }
    }

    protected void getVertexMax(PVector max) {
        this.updateTessellation();
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.getVertexMax(max);
                ++i;
            }
        } else {
            if (this.hasPolys) {
                this.tessGeo.getPolyVertexMax(max, this.firstPolyVertex, this.lastPolyVertex);
            }
            if (this.is3D()) {
                if (this.hasLines) {
                    this.tessGeo.getLineVertexMax(max, this.firstLineVertex, this.lastLineVertex);
                }
                if (this.hasPoints) {
                    this.tessGeo.getPointVertexMax(max, this.firstPointVertex, this.lastPointVertex);
                }
            }
        }
    }

    protected int getVertexSum(PVector sum, int count) {
        this.updateTessellation();
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                count += child.getVertexSum(sum, count);
                ++i;
            }
        } else {
            if (this.hasPolys) {
                count += this.tessGeo.getPolyVertexSum(sum, this.firstPolyVertex, this.lastPolyVertex);
            }
            if (this.is3D()) {
                if (this.hasLines) {
                    count += this.tessGeo.getLineVertexSum(sum, this.firstLineVertex, this.lastLineVertex);
                }
                if (this.hasPoints) {
                    count += this.tessGeo.getPointVertexSum(sum, this.firstPointVertex, this.lastPointVertex);
                }
            }
        }
        return count;
    }

    public void textureMode(int mode) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.textureMode(mode);
                ++i;
            }
        } else {
            this.textureMode = mode;
        }
    }

    public void texture(PImage tex) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.texture(tex);
                ++i;
            }
        } else {
            PImage tex0 = this.image;
            this.image = tex;
            if (tex0 != tex && this.parent != null) {
                ((PShapeOpenGL)this.parent).removeTexture(tex);
            }
            if (this.parent != null) {
                ((PShapeOpenGL)this.parent).addTexture(this.image);
                if (this.is2D() && this.stroke) {
                    ((PShapeOpenGL)this.parent).strokedTexture(true);
                }
            }
        }
    }

    public void noTexture() {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.noTexture();
                ++i;
            }
        } else {
            PImage tex0 = this.image;
            this.image = null;
            if (tex0 != null && this.parent != null) {
                ((PShapeOpenGL)this.parent).removeTexture(tex0);
                if (this.is2D()) {
                    ((PShapeOpenGL)this.parent).strokedTexture(false);
                }
            }
        }
    }

    protected void addTexture(PImage tex) {
        if (this.textures == null) {
            this.textures = new HashSet();
        }
        this.textures.add(tex);
        if (this.parent != null) {
            ((PShapeOpenGL)this.parent).addTexture(tex);
        }
    }

    protected void removeTexture(PImage tex) {
        if (this.textures == null || !this.textures.contains(tex)) {
            return;
        }
        boolean childHasTex = false;
        int i = 0;
        while (i < this.childCount) {
            PShapeOpenGL child = (PShapeOpenGL)this.children[i];
            if (child.hasTexture(tex)) {
                childHasTex = true;
                break;
            }
            ++i;
        }
        if (!childHasTex) {
            this.textures.remove(tex);
            if (this.textures.size() == 0) {
                this.textures = null;
            }
        }
        if (this.parent != null) {
            ((PShapeOpenGL)this.parent).removeTexture(tex);
        }
    }

    protected void strokedTexture(boolean newValue) {
        if (this.strokedTexture == newValue) {
            return;
        }
        if (newValue) {
            this.strokedTexture = true;
        } else {
            boolean childHasStrokedTex = false;
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                if (child.hasStrokedTexture()) {
                    childHasStrokedTex = true;
                    break;
                }
                ++i;
            }
            if (!childHasStrokedTex) {
                this.strokedTexture = false;
            }
        }
        if (this.parent != null) {
            ((PShapeOpenGL)this.parent).strokedTexture(newValue);
        }
    }

    protected boolean hasTexture(PImage tex) {
        if (this.family == 0) {
            return this.textures != null && this.textures.contains(tex);
        }
        return this.image == tex;
    }

    protected boolean hasStrokedTexture() {
        if (this.family == 0) {
            return this.strokedTexture;
        }
        return this.image != null && this.stroke;
    }

    public void solid(boolean solid) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.solid(solid);
                ++i;
            }
        } else {
            this.isSolid = solid;
        }
    }

    public void beginContour() {
        if (this.family == 0) {
            PGraphics.showWarning("Cannot begin contour in GROUP shapes");
            return;
        }
        if (this.openContour) {
            PGraphics.showWarning("Already called beginContour().");
            return;
        }
        this.openContour = true;
    }

    public void endContour() {
        if (this.family == 0) {
            PGraphics.showWarning("Cannot end contour in GROUP shapes");
            return;
        }
        if (!this.openContour) {
            PGraphics.showWarning("Need to call beginContour() first.");
            return;
        }
        this.openContour = false;
        this.breakShape = true;
    }

    public void vertex(float x, float y) {
        this.vertexImpl(x, y, 0.0f, 0.0f, 0.0f);
    }

    public void vertex(float x, float y, float u, float v) {
        this.vertexImpl(x, y, 0.0f, u, v);
    }

    public void vertex(float x, float y, float z) {
        this.vertexImpl(x, y, z, 0.0f, 0.0f);
    }

    public void vertex(float x, float y, float z, float u, float v) {
        this.vertexImpl(x, y, z, u, v);
    }

    protected void vertexImpl(float x, float y, float z, float u, float v) {
        if (this.family == 0) {
            PGraphics.showWarning("Cannot add vertices to GROUP shape");
            return;
        }
        boolean textured = this.image != null;
        int fcolor = 0;
        if (this.fill || textured) {
            fcolor = !textured ? this.fillColor : (this.tint ? this.tintColor : -1);
        }
        if (this.image != null && this.textureMode == 2) {
            u = PApplet.min(1.0f, u / (float)this.image.width);
            v = PApplet.min(1.0f, v / (float)this.image.height);
        }
        int scolor = 0;
        float sweight = 0.0f;
        if (this.stroke) {
            scolor = this.strokeColor;
            sweight = this.strokeWeight;
        }
        this.inGeo.addVertex(x, y, z, fcolor, this.normalX, this.normalY, this.normalZ, u, v, scolor, sweight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess, this.vertexCode());
        this.markForTessellation();
    }

    protected int vertexCode() {
        int code = 0;
        if (this.breakShape) {
            code = 4;
            this.breakShape = false;
        }
        return code;
    }

    public void normal(float nx, float ny, float nz) {
        if (this.family == 0) {
            PGraphics.showWarning("Cannot set normal in GROUP shape");
            return;
        }
        this.normalX = nx;
        this.normalY = ny;
        this.normalZ = nz;
        if (this.normalMode == 0) {
            this.normalMode = 1;
        } else if (this.normalMode == 1) {
            this.normalMode = 2;
        }
    }

    public void end() {
        this.end(1);
    }

    public void end(int mode) {
        if (this.family == 0) {
            PGraphics.showWarning("Cannot end GROUP shape");
            return;
        }
        this.inGeo.trim();
        this.isClosed = mode == 2;
        this.markForTessellation();
        this.shapeEnded = true;
    }

    public void setParams(float[] source) {
        if (this.family != 1) {
            PGraphics.showWarning("Parameters can only be set to PRIMITIVE shapes");
            return;
        }
        super.setParams(source);
        this.markForTessellation();
        this.shapeEnded = true;
    }

    public void setPath(int vcount, float[][] verts, int ccount, int[] codes) {
        if (this.family != 2) {
            PGraphics.showWarning("Vertex coordinates and codes can only be set to PATH shapes");
            return;
        }
        super.setPath(vcount, verts, ccount, codes);
        this.markForTessellation();
        this.shapeEnded = true;
    }

    public void strokeWeight(float weight) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.strokeWeight(weight);
                ++i;
            }
        } else {
            this.updateStrokeWeight(weight);
        }
    }

    protected void updateStrokeWeight(float newWeight) {
        if (PGraphicsOpenGL.same(this.strokeWeight, newWeight)) {
            return;
        }
        float oldWeight = this.strokeWeight;
        this.strokeWeight = newWeight;
        Arrays.fill(this.inGeo.strokeWeights, 0, this.inGeo.vertexCount, this.strokeWeight);
        if (this.shapeEnded && this.tessellated && (this.hasLines || this.hasPoints)) {
            int i;
            float resizeFactor = newWeight / oldWeight;
            if (this.hasLines) {
                if (this.is3D()) {
                    i = this.firstLineVertex;
                    while (i <= this.lastLineVertex) {
                        int n = 4 * i + 3;
                        this.tessGeo.lineAttribs[n] = this.tessGeo.lineAttribs[n] * resizeFactor;
                        ++i;
                    }
                    this.root.setModifiedLineAttributes(this.firstLineVertex, this.lastLineVertex);
                } else if (this.is2D()) {
                    this.markForTessellation();
                }
            }
            if (this.hasPoints) {
                if (this.is3D()) {
                    i = this.firstPointVertex;
                    while (i <= this.lastPointVertex) {
                        int n = 2 * i + 0;
                        this.tessGeo.pointAttribs[n] = this.tessGeo.pointAttribs[n] * resizeFactor;
                        int n2 = 2 * i + 1;
                        this.tessGeo.pointAttribs[n2] = this.tessGeo.pointAttribs[n2] * resizeFactor;
                        ++i;
                    }
                    this.root.setModifiedPointAttributes(this.firstPointVertex, this.lastPointVertex);
                } else if (this.is2D()) {
                    this.markForTessellation();
                }
            }
        }
    }

    public void strokeJoin(int join) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.strokeJoin(join);
                ++i;
            }
        } else {
            if (this.is2D() && this.strokeJoin != join) {
                this.markForTessellation();
            }
            this.strokeJoin = join;
        }
    }

    public void strokeCap(int cap) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.strokeCap(cap);
                ++i;
            }
        } else {
            if (this.is2D() && this.strokeCap != cap) {
                this.markForTessellation();
            }
            this.strokeCap = cap;
        }
    }

    public void noFill() {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.noFill();
                ++i;
            }
        } else {
            this.fill = false;
            this.updateFillColor(0);
        }
    }

    public void fill(int rgb) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.fill(rgb);
                ++i;
            }
        } else {
            this.colorCalc(rgb);
            this.fillFromCalc();
        }
    }

    public void fill(int rgb, float alpha) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.fill(rgb, alpha);
                ++i;
            }
        } else {
            this.colorCalc(rgb, alpha);
            this.fillFromCalc();
        }
    }

    public void fill(float gray) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.fill(gray);
                ++i;
            }
        } else {
            this.colorCalc(gray);
            this.fillFromCalc();
        }
    }

    public void fill(float gray, float alpha) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.fill(gray, alpha);
                ++i;
            }
        } else {
            this.colorCalc(gray, alpha);
            this.fillFromCalc();
        }
    }

    public void fill(float x, float y, float z) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.fill(x, y, z);
                ++i;
            }
        } else {
            this.colorCalc(x, y, z);
            this.fillFromCalc();
        }
    }

    public void fill(float x, float y, float z, float a) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.fill(x, y, z, a);
                ++i;
            }
        } else {
            this.colorCalc(x, y, z, a);
            this.fillFromCalc();
        }
    }

    protected void fillFromCalc() {
        this.fill = true;
        this.updateFillColor(this.calcColor);
    }

    protected void updateFillColor(int newFillColor) {
        if (this.fillColor == newFillColor) {
            return;
        }
        this.fillColor = newFillColor;
        if (this.image == null) {
            Arrays.fill(this.inGeo.colors, 0, this.inGeo.vertexCount, PGL.javaToNativeARGB(this.fillColor));
            if (this.shapeEnded && this.tessellated && this.hasPolys) {
                if (this.is3D()) {
                    Arrays.fill(this.tessGeo.polyColors, this.firstPolyVertex, this.lastPolyVertex + 1, PGL.javaToNativeARGB(this.fillColor));
                    this.root.setModifiedPolyColors(this.firstPolyVertex, this.lastPolyVertex);
                } else if (this.is2D()) {
                    int last1 = this.lastPolyVertex + 1;
                    if (-1 < this.firstLineVertex) {
                        last1 = this.firstLineVertex;
                    }
                    if (-1 < this.firstPointVertex) {
                        last1 = this.firstPointVertex;
                    }
                    Arrays.fill(this.tessGeo.polyColors, this.firstPolyVertex, last1, PGL.javaToNativeARGB(this.fillColor));
                    this.root.setModifiedPolyColors(this.firstPolyVertex, last1 - 1);
                }
            }
        }
    }

    public void noStroke() {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.noStroke();
                ++i;
            }
        } else {
            if (this.stroke) {
                this.markForTessellation();
                this.stroke = false;
            }
            this.updateStrokeColor(0);
            if (this.is2D() && this.parent != null) {
                ((PShapeOpenGL)this.parent).strokedTexture(false);
            }
        }
    }

    public void stroke(int rgb) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.stroke(rgb);
                ++i;
            }
        } else {
            this.colorCalc(rgb);
            this.strokeFromCalc();
        }
    }

    public void stroke(int rgb, float alpha) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.stroke(rgb, alpha);
                ++i;
            }
        } else {
            this.colorCalc(rgb, alpha);
            this.strokeFromCalc();
        }
    }

    public void stroke(float gray) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.stroke(gray);
                ++i;
            }
        } else {
            this.colorCalc(gray);
            this.strokeFromCalc();
        }
    }

    public void stroke(float gray, float alpha) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.stroke(gray, alpha);
                ++i;
            }
        } else {
            this.colorCalc(gray, alpha);
            this.strokeFromCalc();
        }
    }

    public void stroke(float x, float y, float z) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.stroke(x, y, z);
                ++i;
            }
        } else {
            this.colorCalc(x, y, z);
            this.strokeFromCalc();
        }
    }

    public void stroke(float x, float y, float z, float alpha) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.stroke(x, y, z, alpha);
                ++i;
            }
        } else {
            this.colorCalc(x, y, z, alpha);
            this.strokeFromCalc();
        }
    }

    protected void strokeFromCalc() {
        if (!this.stroke) {
            this.markForTessellation();
            this.stroke = true;
        }
        this.updateStrokeColor(this.calcColor);
        if (this.is2D() && this.image != null && this.parent != null) {
            ((PShapeOpenGL)this.parent).strokedTexture(true);
        }
    }

    protected void updateStrokeColor(int newStrokeColor) {
        if (this.strokeColor == newStrokeColor) {
            return;
        }
        this.strokeColor = newStrokeColor;
        Arrays.fill(this.inGeo.strokeColors, 0, this.inGeo.vertexCount, PGL.javaToNativeARGB(this.strokeColor));
        if (this.shapeEnded && this.tessellated && (this.hasLines || this.hasPoints)) {
            if (this.hasLines) {
                if (this.is3D()) {
                    Arrays.fill(this.tessGeo.lineColors, this.firstLineVertex, this.lastLineVertex + 1, PGL.javaToNativeARGB(this.strokeColor));
                    this.root.setModifiedLineColors(this.firstLineVertex, this.lastLineVertex);
                } else if (this.is2D()) {
                    Arrays.fill(this.tessGeo.polyColors, this.firstLineVertex, this.lastLineVertex + 1, PGL.javaToNativeARGB(this.strokeColor));
                    this.root.setModifiedPolyColors(this.firstLineVertex, this.lastLineVertex);
                }
            }
            if (this.hasPoints) {
                if (this.is3D()) {
                    Arrays.fill(this.tessGeo.pointColors, this.firstPointVertex, this.lastPointVertex + 1, PGL.javaToNativeARGB(this.strokeColor));
                    this.root.setModifiedPointColors(this.firstPointVertex, this.lastPointVertex);
                } else if (this.is2D()) {
                    Arrays.fill(this.tessGeo.polyColors, this.firstPointVertex, this.lastPointVertex + 1, PGL.javaToNativeARGB(this.strokeColor));
                    this.root.setModifiedPolyColors(this.firstPointVertex, this.lastPointVertex);
                }
            }
        }
    }

    public void noTint() {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.noTint();
                ++i;
            }
        } else {
            this.tint = false;
            this.updateTintColor(0);
        }
    }

    public void tint(int rgb) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.tint(rgb);
                ++i;
            }
        } else {
            this.colorCalc(rgb);
            this.tintFromCalc();
        }
    }

    public void tint(int rgb, float alpha) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.tint(rgb, alpha);
                ++i;
            }
        } else {
            this.colorCalc(rgb, alpha);
            this.tintFromCalc();
        }
    }

    public void tint(float gray) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.tint(gray);
                ++i;
            }
        } else {
            this.colorCalc(gray);
            this.tintFromCalc();
        }
    }

    public void tint(float gray, float alpha) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.tint(gray, alpha);
                ++i;
            }
        } else {
            this.colorCalc(gray, alpha);
            this.tintFromCalc();
        }
    }

    public void tint(float x, float y, float z) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.tint(x, y, z);
                ++i;
            }
        } else {
            this.colorCalc(x, y, z);
            this.tintFromCalc();
        }
    }

    public void tint(float x, float y, float z, float alpha) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.tint(x, y, z, alpha);
                ++i;
            }
        } else {
            this.colorCalc(x, y, z, alpha);
            this.tintFromCalc();
        }
    }

    protected void tintFromCalc() {
        this.tint = true;
        this.updateTintColor(this.calcColor);
    }

    protected void updateTintColor(int newTintColor) {
        if (this.tintColor == newTintColor) {
            return;
        }
        this.tintColor = newTintColor;
        if (this.image != null) {
            Arrays.fill(this.inGeo.colors, 0, this.inGeo.vertexCount, PGL.javaToNativeARGB(this.tintColor));
            if (this.shapeEnded && this.tessellated && this.hasPolys) {
                if (this.is3D()) {
                    Arrays.fill(this.tessGeo.polyColors, this.firstPolyVertex, this.lastPolyVertex + 1, PGL.javaToNativeARGB(this.tintColor));
                    this.root.setModifiedPolyColors(this.firstPolyVertex, this.lastPolyVertex);
                } else if (this.is2D()) {
                    int last1 = this.lastPolyVertex + 1;
                    if (-1 < this.firstLineVertex) {
                        last1 = this.firstLineVertex;
                    }
                    if (-1 < this.firstPointVertex) {
                        last1 = this.firstPointVertex;
                    }
                    Arrays.fill(this.tessGeo.polyColors, this.firstPolyVertex, last1, PGL.javaToNativeARGB(this.tintColor));
                    this.root.setModifiedPolyColors(this.firstPolyVertex, last1 - 1);
                }
            }
        }
    }

    public void ambient(int rgb) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.ambient(rgb);
                ++i;
            }
        } else {
            this.colorCalc(rgb);
            this.ambientFromCalc();
        }
    }

    public void ambient(float gray) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.ambient(gray);
                ++i;
            }
        } else {
            this.colorCalc(gray);
            this.ambientFromCalc();
        }
    }

    public void ambient(float x, float y, float z) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.ambient(x, y, z);
                ++i;
            }
        } else {
            this.colorCalc(x, y, z);
            this.ambientFromCalc();
        }
    }

    protected void ambientFromCalc() {
        this.updateAmbientColor(this.calcColor);
    }

    protected void updateAmbientColor(int newAmbientColor) {
        if (this.ambientColor == newAmbientColor) {
            return;
        }
        this.ambientColor = newAmbientColor;
        Arrays.fill(this.inGeo.ambient, 0, this.inGeo.vertexCount, PGL.javaToNativeARGB(this.ambientColor));
        if (this.shapeEnded && this.tessellated && this.hasPolys) {
            if (this.is3D()) {
                this.lastPolyVertex = 1;
                Arrays.fill(this.tessGeo.polyAmbient, this.firstPolyVertex, 1, PGL.javaToNativeARGB(this.ambientColor));
                this.root.setModifiedPolyAmbient(this.firstPolyVertex, this.lastPolyVertex);
            } else if (this.is2D()) {
                int last1 = this.lastPolyVertex + 1;
                if (-1 < this.firstLineVertex) {
                    last1 = this.firstLineVertex;
                }
                if (-1 < this.firstPointVertex) {
                    last1 = this.firstPointVertex;
                }
                Arrays.fill(this.tessGeo.polyAmbient, this.firstPolyVertex, last1, PGL.javaToNativeARGB(this.ambientColor));
                this.root.setModifiedPolyColors(this.firstPolyVertex, last1 - 1);
            }
        }
    }

    public void specular(int rgb) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.specular(rgb);
                ++i;
            }
        } else {
            this.colorCalc(rgb);
            this.specularFromCalc();
        }
    }

    public void specular(float gray) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.specular(gray);
                ++i;
            }
        } else {
            this.colorCalc(gray);
            this.specularFromCalc();
        }
    }

    public void specular(float x, float y, float z) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.specular(x, y, z);
                ++i;
            }
        } else {
            this.colorCalc(x, y, z);
            this.specularFromCalc();
        }
    }

    protected void specularFromCalc() {
        this.updateSpecularColor(this.calcColor);
    }

    protected void updateSpecularColor(int newSpecularColor) {
        if (this.specularColor == newSpecularColor) {
            return;
        }
        this.specularColor = newSpecularColor;
        Arrays.fill(this.inGeo.specular, 0, this.inGeo.vertexCount, PGL.javaToNativeARGB(this.specularColor));
        if (this.shapeEnded && this.tessellated && this.hasPolys) {
            if (this.is3D()) {
                Arrays.fill(this.tessGeo.polySpecular, this.firstPolyVertex, this.lastPolyVertex + 1, PGL.javaToNativeARGB(this.specularColor));
                this.root.setModifiedPolySpecular(this.firstPolyVertex, this.lastPolyVertex);
            } else if (this.is2D()) {
                int last1 = this.lastPolyVertex + 1;
                if (-1 < this.firstLineVertex) {
                    last1 = this.firstLineVertex;
                }
                if (-1 < this.firstPointVertex) {
                    last1 = this.firstPointVertex;
                }
                Arrays.fill(this.tessGeo.polySpecular, this.firstPolyVertex, last1, PGL.javaToNativeARGB(this.specularColor));
                this.root.setModifiedPolyColors(this.firstPolyVertex, last1 - 1);
            }
        }
    }

    public void emissive(int rgb) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.emissive(rgb);
                ++i;
            }
        } else {
            this.colorCalc(rgb);
            this.emissiveFromCalc();
        }
    }

    public void emissive(float gray) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.emissive(gray);
                ++i;
            }
        } else {
            this.colorCalc(gray);
            this.emissiveFromCalc();
        }
    }

    public void emissive(float x, float y, float z) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.emissive(x, y, z);
                ++i;
            }
        } else {
            this.colorCalc(x, y, z);
            this.emissiveFromCalc();
        }
    }

    protected void emissiveFromCalc() {
        this.updateEmissiveColor(this.calcColor);
    }

    protected void updateEmissiveColor(int newEmissiveColor) {
        if (this.emissiveColor == newEmissiveColor) {
            return;
        }
        this.emissiveColor = newEmissiveColor;
        Arrays.fill(this.inGeo.emissive, 0, this.inGeo.vertexCount, PGL.javaToNativeARGB(this.emissiveColor));
        if (this.shapeEnded && this.tessellated && this.tessGeo.polyVertexCount > 0) {
            if (this.is3D()) {
                Arrays.fill(this.tessGeo.polyEmissive, this.firstPolyVertex, this.lastPolyVertex + 1, PGL.javaToNativeARGB(this.emissiveColor));
                this.root.setModifiedPolyEmissive(this.firstPolyVertex, this.lastPolyVertex);
            } else if (this.is2D()) {
                int last1 = this.lastPolyVertex + 1;
                if (-1 < this.firstLineVertex) {
                    last1 = this.firstLineVertex;
                }
                if (-1 < this.firstPointVertex) {
                    last1 = this.firstPointVertex;
                }
                Arrays.fill(this.tessGeo.polyEmissive, this.firstPolyVertex, last1, PGL.javaToNativeARGB(this.emissiveColor));
                this.root.setModifiedPolyColors(this.firstPolyVertex, last1 - 1);
            }
        }
    }

    public void shininess(float shine) {
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.shininess(shine);
                ++i;
            }
        } else {
            this.updateShininessFactor(shine);
        }
    }

    protected void updateShininessFactor(float newShininess) {
        if (PGraphicsOpenGL.same(this.shininess, newShininess)) {
            return;
        }
        this.shininess = newShininess;
        Arrays.fill(this.inGeo.shininess, 0, this.inGeo.vertexCount, this.shininess);
        if (this.shapeEnded && this.tessellated && this.hasPolys) {
            if (this.is3D()) {
                Arrays.fill(this.tessGeo.polyShininess, this.firstPolyVertex, this.lastPolyVertex + 1, this.shininess);
                this.root.setModifiedPolyShininess(this.firstPolyVertex, this.lastPolyVertex);
            } else if (this.is2D()) {
                int last1 = this.lastPolyVertex + 1;
                if (-1 < this.firstLineVertex) {
                    last1 = this.firstLineVertex;
                }
                if (-1 < this.firstPointVertex) {
                    last1 = this.firstPointVertex;
                }
                Arrays.fill(this.tessGeo.polyShininess, this.firstPolyVertex, last1, this.shininess);
                this.root.setModifiedPolyColors(this.firstPolyVertex, last1 - 1);
            }
        }
    }

    public void translate(float tx, float ty) {
        this.transform(0, tx, ty);
    }

    public void translate(float tx, float ty, float tz) {
        this.transform(0, tx, ty, tz);
    }

    public void rotate(float angle) {
        this.transform(1, angle);
    }

    public void rotateX(float angle) {
        this.rotate(angle, 1.0f, 0.0f, 0.0f);
    }

    public void rotateY(float angle) {
        this.rotate(angle, 0.0f, 1.0f, 0.0f);
    }

    public void rotateZ(float angle) {
        this.transform(1, angle);
    }

    public void rotate(float angle, float v0, float v1, float v2) {
        this.transform(1, angle, v0, v1, v2);
    }

    public void scale(float s) {
        this.transform(2, s, s);
    }

    public void scale(float x, float y) {
        this.transform(2, x, y);
    }

    public void scale(float x, float y, float z) {
        this.transform(2, x, y, z);
    }

    public void applyMatrix(PMatrix2D source) {
        this.transform(3, source.m00, source.m01, source.m02, source.m10, source.m11, source.m12);
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.transform(3, n00, n01, n02, n10, n11, n12);
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.transform(3, n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    public void resetMatrix() {
        if (this.shapeEnded && this.matrix != null) {
            boolean res;
            if (this.family == 0) {
                this.updateTessellation();
            }
            if (res = this.matrix.invert()) {
                if (this.tessellated) {
                    this.applyMatrixImpl(this.matrix);
                }
                this.matrix = null;
            } else {
                PGraphics.showWarning("The transformation matrix cannot be inverted");
            }
        }
    }

    protected void transform(int type, float ... args) {
        int dimensions = type == 1 ? (args.length == 1 ? 2 : 3) : (type == 3 ? (args.length == 6 ? 2 : 3) : args.length);
        this.transformImpl(type, dimensions, args);
    }

    protected void transformImpl(int type, int ncoords, float ... args) {
        this.checkMatrix(ncoords);
        this.calcTransform(type, ncoords, args);
        if (this.tessellated) {
            this.applyMatrixImpl(this.transform);
        }
    }

    protected void calcTransform(int type, int dimensions, float ... args) {
        if (this.transform == null) {
            this.transform = dimensions == 2 ? new PMatrix2D() : new PMatrix3D();
        } else {
            this.transform.reset();
        }
        switch (type) {
            case 0: {
                if (dimensions == 3) {
                    this.transform.translate(args[0], args[1], args[2]);
                    break;
                }
                this.transform.translate(args[0], args[1]);
                break;
            }
            case 1: {
                if (dimensions == 3) {
                    this.transform.rotate(args[0], args[1], args[2], args[3]);
                    break;
                }
                this.transform.rotate(args[0]);
                break;
            }
            case 2: {
                if (dimensions == 3) {
                    this.transform.scale(args[0], args[1], args[2]);
                    break;
                }
                this.transform.scale(args[0], args[1]);
                break;
            }
            case 3: {
                if (dimensions == 3) {
                    this.transform.set(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15]);
                    break;
                }
                this.transform.set(args[0], args[1], args[2], args[3], args[4], args[5]);
            }
        }
        this.matrix.apply(this.transform);
    }

    protected void applyMatrixImpl(PMatrix matrix) {
        if (this.hasPolys) {
            this.tessGeo.applyMatrixOnPolyGeometry(matrix, this.firstPolyVertex, this.lastPolyVertex);
            this.root.setModifiedPolyVertices(this.firstPolyVertex, this.lastPolyVertex);
            this.root.setModifiedPolyNormals(this.firstPolyVertex, this.lastPolyVertex);
        }
        if (this.is3D()) {
            if (this.hasLines) {
                this.tessGeo.applyMatrixOnLineGeometry(matrix, this.firstLineVertex, this.lastLineVertex);
                this.root.setModifiedLineVertices(this.firstLineVertex, this.lastLineVertex);
                this.root.setModifiedLineAttributes(this.firstLineVertex, this.lastLineVertex);
            }
            if (this.hasPoints) {
                this.tessGeo.applyMatrixOnPointGeometry(matrix, this.firstPointVertex, this.lastPointVertex);
                this.root.setModifiedPointVertices(this.firstPointVertex, this.lastPointVertex);
            }
        }
    }

    public void bezierDetail(int detail) {
        this.bezierDetail = detail;
        this.pg.bezierDetail(detail);
    }

    public void bezierVertex(float x2, float y2, float x3, float y3, float x4, float y4) {
        this.bezierVertexImpl(x2, y2, 0.0f, x3, y3, 0.0f, x4, y4, 0.0f);
    }

    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.bezierVertexImpl(x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    protected void bezierVertexImpl(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addBezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4, this.fill, this.stroke, this.bezierDetail, this.vertexCode(), this.kind);
    }

    public void quadraticVertex(float cx, float cy, float x3, float y3) {
        this.quadraticVertexImpl(cx, cy, 0.0f, x3, y3, 0.0f);
    }

    public void quadraticVertex(float cx, float cy, float cz, float x3, float y3, float z3) {
        this.quadraticVertexImpl(cx, cy, cz, x3, y3, z3);
    }

    protected void quadraticVertexImpl(float cx, float cy, float cz, float x3, float y3, float z3) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuadraticVertex(cx, cy, cz, x3, y3, z3, this.fill, this.stroke, this.bezierDetail, this.vertexCode(), this.kind);
    }

    public void curveDetail(int detail) {
        this.curveDetail = detail;
        this.pg.curveDetail(detail);
    }

    public void curveTightness(float tightness) {
        this.curveTightness = tightness;
        this.pg.curveTightness(tightness);
    }

    public void curveVertex(float x, float y) {
        this.curveVertexImpl(x, y, 0.0f);
    }

    public void curveVertex(float x, float y, float z) {
        this.curveVertexImpl(x, y, z);
    }

    protected void curveVertexImpl(float x, float y, float z) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addCurveVertex(x, y, z, this.fill, this.stroke, this.curveDetail, this.vertexCode(), this.kind);
    }

    public int getVertexCount() {
        return this.inGeo.vertexCount;
    }

    public PVector getVertex(int index, PVector vec) {
        if (vec == null) {
            vec = new PVector();
        }
        vec.x = this.inGeo.vertices[3 * index + 0];
        vec.y = this.inGeo.vertices[3 * index + 1];
        vec.z = this.inGeo.vertices[3 * index + 2];
        return vec;
    }

    public float getVertexX(int index) {
        return this.inGeo.vertices[3 * index + 0];
    }

    public float getVertexY(int index) {
        return this.inGeo.vertices[3 * index + 1];
    }

    public float getVertexZ(int index) {
        return this.inGeo.vertices[3 * index + 2];
    }

    public void setVertex(int index, float x, float y) {
        this.setVertex(index, x, y, 0.0f);
    }

    public void setVertex(int index, float x, float y, float z) {
        this.inGeo.vertices[3 * index + 0] = x;
        this.inGeo.vertices[3 * index + 1] = y;
        this.inGeo.vertices[3 * index + 2] = z;
        this.markForTessellation();
    }

    public void setVertex(int index, PVector vec) {
        this.inGeo.vertices[3 * index + 0] = vec.x;
        this.inGeo.vertices[3 * index + 1] = vec.y;
        this.inGeo.vertices[3 * index + 2] = vec.z;
        this.markForTessellation();
    }

    public PVector getNormal(int index, PVector vec) {
        if (vec == null) {
            vec = new PVector();
        }
        vec.x = this.inGeo.normals[3 * index + 0];
        vec.y = this.inGeo.normals[3 * index + 1];
        vec.z = this.inGeo.normals[3 * index + 2];
        return vec;
    }

    public float getNormalX(int index) {
        return this.inGeo.normals[3 * index + 0];
    }

    public float getNormalY(int index) {
        return this.inGeo.normals[3 * index + 1];
    }

    public float getNormalZ(int index) {
        return this.inGeo.normals[3 * index + 2];
    }

    public void setNormal(int index, float nx, float ny, float nz) {
        this.inGeo.normals[3 * index + 0] = nx;
        this.inGeo.normals[3 * index + 1] = ny;
        this.inGeo.normals[3 * index + 2] = nz;
        this.markForTessellation();
    }

    public float getTextureU(int index) {
        return this.inGeo.texcoords[2 * index + 0];
    }

    public float getTextureV(int index) {
        return this.inGeo.texcoords[2 * index + 1];
    }

    public void setTextureUV(int index, float u, float v) {
        this.inGeo.texcoords[2 * index + 0] = u;
        this.inGeo.texcoords[2 * index + 1] = v;
        this.markForTessellation();
    }

    public int getFill(int index) {
        return PGL.nativeToJavaARGB(this.inGeo.colors[index]);
    }

    public void setFill(int index, int fill) {
        this.inGeo.colors[index] = PGL.javaToNativeARGB(fill);
        this.markForTessellation();
    }

    public int getStroke(int index) {
        return PGL.nativeToJavaARGB(this.inGeo.strokeColors[index]);
    }

    public void setStroke(int index, int stroke) {
        this.inGeo.strokeColors[index] = PGL.javaToNativeARGB(stroke);
        this.markForTessellation();
    }

    public float getStrokeWeight(int index) {
        return this.inGeo.strokeWeights[index];
    }

    public void setStrokeWeight(int index, float weight) {
        this.inGeo.strokeWeights[index] = weight;
        this.markForTessellation();
    }

    public int getAmbient(int index) {
        return PGL.nativeToJavaARGB(this.inGeo.ambient[index]);
    }

    public void setAmbient(int index, int ambient) {
        this.inGeo.ambient[index] = PGL.javaToNativeARGB(ambient);
        this.markForTessellation();
    }

    public int getSpecular(int index) {
        return PGL.nativeToJavaARGB(this.inGeo.specular[index]);
    }

    public void setSpecular(int index, int specular) {
        this.inGeo.specular[index] = PGL.javaToNativeARGB(specular);
        this.markForTessellation();
    }

    public int getEmissive(int index) {
        return PGL.nativeToJavaARGB(this.inGeo.emissive[index]);
    }

    public void setEmissive(int index, int emissive) {
        this.inGeo.emissive[index] = PGL.javaToNativeARGB(emissive);
        this.markForTessellation();
    }

    public float getShininess(int index) {
        return this.inGeo.shininess[index];
    }

    public void setShininess(int index, float shine) {
        this.inGeo.shininess[index] = shine;
        this.markForTessellation();
    }

    public PShape getTessellation() {
        PShapeOpenGL tess;
        this.updateTessellation();
        float[] vertices = this.tessGeo.polyVertices;
        float[] normals = this.tessGeo.polyNormals;
        int[] color = this.tessGeo.polyColors;
        float[] uv = this.tessGeo.polyTexcoords;
        short[] indices = this.tessGeo.polyIndices;
        if (this.is3D()) {
            tess = PGraphics3D.createShapeImpl(this.pg.parent, 9);
        } else if (this.is2D()) {
            tess = PGraphics2D.createShapeImpl(this.pg.parent, 9);
        } else {
            PGraphics.showWarning("This shape is not either 2D or 3D!");
            return null;
        }
        ((PShape)tess).noStroke();
        PGraphicsOpenGL.IndexCache cache = this.tessGeo.polyIndexCache;
        int n = this.firstPolyIndexCache;
        while (n <= this.lastPolyIndexCache) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            int tr = ioffset / 3;
            while (tr < (ioffset + icount) / 3) {
                float y0;
                float x0;
                int i0 = voffset + indices[3 * tr + 0];
                int i1 = voffset + indices[3 * tr + 1];
                int i2 = voffset + indices[3 * tr + 2];
                if (this.is3D()) {
                    x0 = vertices[4 * i0 + 0];
                    y0 = vertices[4 * i0 + 1];
                    float z0 = vertices[4 * i0 + 2];
                    float x1 = vertices[4 * i1 + 0];
                    float y1 = vertices[4 * i1 + 1];
                    float z1 = vertices[4 * i1 + 2];
                    float x2 = vertices[4 * i2 + 0];
                    float y2 = vertices[4 * i2 + 1];
                    float z2 = vertices[4 * i2 + 2];
                    float nx0 = normals[3 * i0 + 0];
                    float ny0 = normals[3 * i0 + 1];
                    float nz0 = normals[3 * i0 + 2];
                    float nx1 = normals[3 * i1 + 0];
                    float ny1 = normals[3 * i1 + 1];
                    float nz1 = normals[3 * i1 + 2];
                    float nx2 = normals[3 * i2 + 0];
                    float ny2 = normals[3 * i2 + 1];
                    float nz2 = normals[3 * i2 + 2];
                    int argb0 = PGL.nativeToJavaARGB(color[i0]);
                    int argb1 = PGL.nativeToJavaARGB(color[i1]);
                    int argb2 = PGL.nativeToJavaARGB(color[i2]);
                    ((PShape)tess).fill(argb0);
                    ((PShape)tess).normal(nx0, ny0, nz0);
                    ((PShape)tess).vertex(x0, y0, z0, uv[2 * i0 + 0], uv[2 * i0 + 1]);
                    ((PShape)tess).fill(argb1);
                    ((PShape)tess).normal(nx1, ny1, nz1);
                    ((PShape)tess).vertex(x1, y1, z1, uv[2 * i1 + 0], uv[2 * i1 + 1]);
                    ((PShape)tess).fill(argb2);
                    ((PShape)tess).normal(nx2, ny2, nz2);
                    ((PShape)tess).vertex(x2, y2, z2, uv[2 * i2 + 0], uv[2 * i2 + 1]);
                } else if (this.is2D()) {
                    x0 = vertices[4 * i0 + 0];
                    y0 = vertices[4 * i0 + 1];
                    float x1 = vertices[4 * i1 + 0];
                    float y1 = vertices[4 * i1 + 1];
                    float x2 = vertices[4 * i2 + 0];
                    float y2 = vertices[4 * i2 + 1];
                    int argb0 = PGL.nativeToJavaARGB(color[i0]);
                    int argb1 = PGL.nativeToJavaARGB(color[i1]);
                    int argb2 = PGL.nativeToJavaARGB(color[i2]);
                    ((PShape)tess).fill(argb0);
                    ((PShape)tess).vertex(x0, y0, uv[2 * i0 + 0], uv[2 * i0 + 1]);
                    ((PShape)tess).fill(argb1);
                    ((PShape)tess).vertex(x1, y1, uv[2 * i1 + 0], uv[2 * i1 + 1]);
                    ((PShape)tess).fill(argb2);
                    ((PShape)tess).vertex(x2, y2, uv[2 * i2 + 0], uv[2 * i2 + 1]);
                }
                ++tr;
            }
            ++n;
        }
        ((PShape)tess).end();
        return tess;
    }

    protected void updateTessellation() {
        if (!this.root.tessellated || this.root.contextIsOutdated()) {
            this.root.tessellate();
            this.root.aggregate();
        }
    }

    protected void markForTessellation() {
        this.root.tessellated = false;
        this.tessellated = false;
    }

    protected void tessellate() {
        if (this.root == this && this.parent == null) {
            if (this.tessGeo == null) {
                this.tessGeo = this.pg.newTessGeometry(1);
            }
            this.tessGeo.clear();
            this.tessellateImpl();
            this.tessGeo.trim();
            this.modified = false;
            this.needBufferInit = true;
            this.modifiedPolyVertices = false;
            this.modifiedPolyColors = false;
            this.modifiedPolyNormals = false;
            this.modifiedPolyTexcoords = false;
            this.modifiedPolyAmbient = false;
            this.modifiedPolySpecular = false;
            this.modifiedPolyEmissive = false;
            this.modifiedPolyShininess = false;
            this.modifiedLineVertices = false;
            this.modifiedLineColors = false;
            this.modifiedLineAttributes = false;
            this.modifiedPointVertices = false;
            this.modifiedPointColors = false;
            this.modifiedPointAttributes = false;
            this.firstModifiedPolyVertex = Integer.MAX_VALUE;
            this.lastModifiedPolyVertex = Integer.MIN_VALUE;
            this.firstModifiedPolyColor = Integer.MAX_VALUE;
            this.lastModifiedPolyColor = Integer.MIN_VALUE;
            this.firstModifiedPolyNormal = Integer.MAX_VALUE;
            this.lastModifiedPolyNormal = Integer.MIN_VALUE;
            this.firstModifiedPolyTexcoord = Integer.MAX_VALUE;
            this.lastModifiedPolyTexcoord = Integer.MIN_VALUE;
            this.firstModifiedPolyAmbient = Integer.MAX_VALUE;
            this.lastModifiedPolyAmbient = Integer.MIN_VALUE;
            this.firstModifiedPolySpecular = Integer.MAX_VALUE;
            this.lastModifiedPolySpecular = Integer.MIN_VALUE;
            this.firstModifiedPolyEmissive = Integer.MAX_VALUE;
            this.lastModifiedPolyEmissive = Integer.MIN_VALUE;
            this.firstModifiedPolyShininess = Integer.MAX_VALUE;
            this.lastModifiedPolyShininess = Integer.MIN_VALUE;
            this.firstModifiedLineVertex = Integer.MAX_VALUE;
            this.lastModifiedLineVertex = Integer.MIN_VALUE;
            this.firstModifiedLineColor = Integer.MAX_VALUE;
            this.lastModifiedLineColor = Integer.MIN_VALUE;
            this.firstModifiedLineAttribute = Integer.MAX_VALUE;
            this.lastModifiedLineAttribute = Integer.MIN_VALUE;
            this.firstModifiedPointVertex = Integer.MAX_VALUE;
            this.lastModifiedPointVertex = Integer.MIN_VALUE;
            this.firstModifiedPointColor = Integer.MAX_VALUE;
            this.lastModifiedPointColor = Integer.MIN_VALUE;
            this.firstModifiedPointAttribute = Integer.MAX_VALUE;
            this.lastModifiedPointAttribute = Integer.MIN_VALUE;
        }
    }

    protected void tessellateImpl() {
        this.tessGeo = this.root.tessGeo;
        this.firstPolyIndexCache = -1;
        this.lastPolyIndexCache = -1;
        this.firstLineIndexCache = -1;
        this.lastLineIndexCache = -1;
        this.firstPointIndexCache = -1;
        this.lastPointIndexCache = -1;
        if (this.family == 0) {
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.tessellateImpl();
                ++i;
            }
        } else if (this.shapeEnded) {
            this.inGeo.clearEdges();
            this.tessellator.setInGeometry(this.inGeo);
            this.tessellator.setTessGeometry(this.tessGeo);
            this.tessellator.setFill(this.fill || this.image != null);
            this.tessellator.setStroke(this.stroke);
            this.tessellator.setStrokeColor(this.strokeColor);
            this.tessellator.setStrokeWeight(this.strokeWeight);
            this.tessellator.setStrokeCap(this.strokeCap);
            this.tessellator.setStrokeJoin(this.strokeJoin);
            this.tessellator.setTexCache(null, null, null);
            this.tessellator.setTransform(this.matrix);
            this.tessellator.set3D(this.is3D());
            if (this.family == 3) {
                if (this.kind == 3) {
                    this.tessellator.tessellatePoints();
                } else if (this.kind == 5) {
                    this.tessellator.tessellateLines();
                } else if (this.kind == 50) {
                    this.tessellator.tessellateLineStrip();
                } else if (this.kind == 51) {
                    this.tessellator.tessellateLineLoop();
                } else if (this.kind == 8 || this.kind == 9) {
                    if (this.stroke) {
                        this.inGeo.addTrianglesEdges();
                    }
                    if (this.normalMode == 0) {
                        this.inGeo.calcTrianglesNormals();
                    }
                    this.tessellator.tessellateTriangles();
                } else if (this.kind == 11) {
                    if (this.stroke) {
                        this.inGeo.addTriangleFanEdges();
                    }
                    if (this.normalMode == 0) {
                        this.inGeo.calcTriangleFanNormals();
                    }
                    this.tessellator.tessellateTriangleFan();
                } else if (this.kind == 10) {
                    if (this.stroke) {
                        this.inGeo.addTriangleStripEdges();
                    }
                    if (this.normalMode == 0) {
                        this.inGeo.calcTriangleStripNormals();
                    }
                    this.tessellator.tessellateTriangleStrip();
                } else if (this.kind == 16 || this.kind == 17) {
                    if (this.stroke) {
                        this.inGeo.addQuadsEdges();
                    }
                    if (this.normalMode == 0) {
                        this.inGeo.calcQuadsNormals();
                    }
                    this.tessellator.tessellateQuads();
                } else if (this.kind == 18) {
                    if (this.stroke) {
                        this.inGeo.addQuadStripEdges();
                    }
                    if (this.normalMode == 0) {
                        this.inGeo.calcQuadStripNormals();
                    }
                    this.tessellator.tessellateQuadStrip();
                } else if (this.kind == 20) {
                    if (this.stroke) {
                        this.inGeo.addPolygonEdges(this.isClosed);
                    }
                    this.tessellator.tessellatePolygon(this.isSolid, this.isClosed, this.normalMode == 0);
                }
            } else if (this.family == 1) {
                this.inGeo.clear();
                if (this.kind == 2) {
                    this.tessellatePoint();
                } else if (this.kind == 4) {
                    this.tessellateLine();
                } else if (this.kind == 8) {
                    this.tessellateTriangle();
                } else if (this.kind == 16) {
                    this.tessellateQuad();
                } else if (this.kind == 30) {
                    this.tessellateRect();
                } else if (this.kind == 31) {
                    this.tessellateEllipse();
                } else if (this.kind == 32) {
                    this.tessellateArc();
                } else if (this.kind == 41) {
                    this.tessellateBox();
                } else if (this.kind == 40) {
                    this.tessellateSphere();
                }
            } else if (this.family == 2) {
                this.inGeo.clear();
                this.tessellatePath();
            }
            if (this.image != null && this.parent != null) {
                ((PShapeOpenGL)this.parent).addTexture(this.image);
            }
            this.firstPolyIndexCache = this.tessellator.firstPolyIndexCache;
            this.lastPolyIndexCache = this.tessellator.lastPolyIndexCache;
            this.firstLineIndexCache = this.tessellator.firstLineIndexCache;
            this.lastLineIndexCache = this.tessellator.lastLineIndexCache;
            this.firstPointIndexCache = this.tessellator.firstPointIndexCache;
            this.lastPointIndexCache = this.tessellator.lastPointIndexCache;
        }
        this.lastPolyVertex = -1;
        this.firstPolyVertex = -1;
        this.lastLineVertex = -1;
        this.firstLineVertex = -1;
        this.lastPointVertex = -1;
        this.firstPointVertex = -1;
        this.tessellated = true;
    }

    protected void tessellatePoint() {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (this.params.length == 2) {
            x = this.params[0];
            y = this.params[1];
            z = 0.0f;
        } else if (this.params.length == 3) {
            x = this.params[0];
            y = this.params[1];
            z = this.params[2];
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addPoint(x, y, z, this.fill, this.stroke);
        this.tessellator.tessellatePoints();
    }

    protected void tessellateLine() {
        float x1 = 0.0f;
        float y1 = 0.0f;
        float z1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float z2 = 0.0f;
        if (this.params.length == 4) {
            x1 = this.params[0];
            y1 = this.params[1];
            x2 = this.params[2];
            y2 = this.params[3];
        } else if (this.params.length == 6) {
            x1 = this.params[0];
            y1 = this.params[1];
            z1 = this.params[2];
            x2 = this.params[3];
            y2 = this.params[4];
            z2 = this.params[5];
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addLine(x1, y1, z1, x2, y2, z2, this.fill, this.stroke);
        this.tessellator.tessellateLines();
    }

    protected void tessellateTriangle() {
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x3 = 0.0f;
        float y3 = 0.0f;
        if (this.params.length == 6) {
            x1 = this.params[0];
            y1 = this.params[1];
            x2 = this.params[2];
            y2 = this.params[3];
            x3 = this.params[4];
            y3 = this.params[5];
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addTriangle(x1, y1, 0.0f, x2, y2, 0.0f, x3, y3, 0.0f, this.fill, this.stroke);
        this.tessellator.tessellateTriangles();
    }

    protected void tessellateQuad() {
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x3 = 0.0f;
        float y3 = 0.0f;
        float x4 = 0.0f;
        float y4 = 0.0f;
        if (this.params.length == 8) {
            x1 = this.params[0];
            y1 = this.params[1];
            x2 = this.params[2];
            y2 = this.params[3];
            x3 = this.params[4];
            y3 = this.params[5];
            x4 = this.params[6];
            y4 = this.params[7];
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuad(x1, y1, 0.0f, x2, y2, 0.0f, x3, y3, 0.0f, x4, y4, 0.0f, this.fill, this.stroke);
        this.tessellator.tessellateQuads();
    }

    protected void tessellateRect() {
        float a = 0.0f;
        float b = 0.0f;
        float c = 0.0f;
        float d = 0.0f;
        float tl = 0.0f;
        float tr = 0.0f;
        float br = 0.0f;
        float bl = 0.0f;
        boolean rounded = false;
        if (this.params.length == 4) {
            rounded = false;
            a = this.params[0];
            b = this.params[1];
            c = this.params[2];
            d = this.params[3];
        } else if (this.params.length == 5) {
            a = this.params[0];
            b = this.params[1];
            c = this.params[2];
            d = this.params[3];
            br = bl = this.params[4];
            tr = bl;
            tl = bl;
            rounded = true;
        } else if (this.params.length == 8) {
            a = this.params[0];
            b = this.params[1];
            c = this.params[2];
            d = this.params[3];
            tl = this.params[4];
            tr = this.params[5];
            br = this.params[6];
            bl = this.params[7];
            rounded = true;
        }
        this.rectMode = 0;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        if (rounded) {
            this.inGeo.addRect(a, b, c, d, tl, tr, br, bl, this.fill, this.stroke, this.bezierDetail, this.rectMode);
            this.tessellator.tessellatePolygon(false, true, true);
        } else {
            this.inGeo.addRect(a, b, c, d, this.fill, this.stroke, this.rectMode);
            this.tessellator.tessellateQuads();
        }
    }

    protected void tessellateEllipse() {
        float a = 0.0f;
        float b = 0.0f;
        float c = 0.0f;
        float d = 0.0f;
        if (this.params.length == 4) {
            a = this.params[0];
            b = this.params[1];
            c = this.params[2];
            d = this.params[3];
        }
        this.ellipseMode = 0;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addEllipse(a, b, c, d, this.fill, this.stroke, this.ellipseMode);
        this.tessellator.tessellateTriangleFan();
    }

    protected void tessellateArc() {
        float a = 0.0f;
        float b = 0.0f;
        float c = 0.0f;
        float d = 0.0f;
        float start = 0.0f;
        float stop = 0.0f;
        if (this.params.length == 6) {
            a = this.params[0];
            b = this.params[1];
            c = this.params[2];
            d = this.params[3];
            start = this.params[4];
            stop = this.params[5];
        }
        this.ellipseMode = 0;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addArc(a, b, c, d, start, stop, this.fill, this.stroke, this.ellipseMode);
        this.tessellator.tessellateTriangleFan();
    }

    protected void tessellateBox() {
        float w = 0.0f;
        float h = 0.0f;
        float d = 0.0f;
        if (this.params.length == 1) {
            h = d = this.params[0];
            w = d;
        } else if (this.params.length == 3) {
            w = this.params[0];
            h = this.params[1];
            d = this.params[2];
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.addBox(w, h, d, this.fill, this.stroke);
        this.tessellator.tessellateQuads();
    }

    protected void tessellateSphere() {
        int nu = this.pg.sphereDetailU;
        int nv = this.pg.sphereDetailV;
        float r = 0.0f;
        if (this.params.length == 1) {
            r = this.params[0];
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        int[] indices = this.inGeo.addSphere(r, nu, nv, this.fill, this.stroke);
        this.tessellator.tessellateTriangles(indices);
    }

    protected void tessellatePath() {
        if (this.vertices == null) {
            return;
        }
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        if (this.vertexCodeCount == 0) {
            if (this.vertices[0].length == 2) {
                int i = 0;
                while (i < this.vertexCount) {
                    this.inGeo.addVertex(this.vertices[i][0], this.vertices[i][1], 0);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.vertexCount) {
                    this.inGeo.addVertex(this.vertices[i][0], this.vertices[i][1], this.vertices[i][2], 0);
                    ++i;
                }
            }
        } else {
            int idx = 0;
            int code = 4;
            if (this.vertices[0].length == 2) {
                int j = 0;
                while (j < this.vertexCodeCount) {
                    switch (this.vertexCodes[j]) {
                        case 0: {
                            this.inGeo.addVertex(this.vertices[idx][0], this.vertices[idx][1], code);
                            code = 0;
                            ++idx;
                            break;
                        }
                        case 2: {
                            this.inGeo.addQuadraticVertex(this.vertices[idx + 0][0], this.vertices[idx + 0][1], 0.0f, this.vertices[idx + 1][0], this.vertices[idx + 1][1], 0.0f, this.fill, this.stroke, this.bezierDetail, code);
                            code = 0;
                            idx += 2;
                            break;
                        }
                        case 1: {
                            this.inGeo.addBezierVertex(this.vertices[idx + 0][0], this.vertices[idx + 0][1], 0.0f, this.vertices[idx + 1][0], this.vertices[idx + 1][1], 0.0f, this.vertices[idx + 2][0], this.vertices[idx + 2][1], 0.0f, this.fill, this.stroke, this.bezierDetail, code);
                            code = 0;
                            idx += 3;
                            break;
                        }
                        case 3: {
                            this.inGeo.addCurveVertex(this.vertices[idx][0], this.vertices[idx][1], 0.0f, this.fill, this.stroke, this.curveDetail, code);
                            code = 0;
                            ++idx;
                            break;
                        }
                        case 4: {
                            code = 4;
                        }
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j < this.vertexCodeCount) {
                    switch (this.vertexCodes[j]) {
                        case 0: {
                            this.inGeo.addVertex(this.vertices[idx][0], this.vertices[idx][1], this.vertices[idx][2], code);
                            code = 0;
                            ++idx;
                            break;
                        }
                        case 2: {
                            this.inGeo.addQuadraticVertex(this.vertices[idx + 0][0], this.vertices[idx + 0][1], this.vertices[idx + 0][2], this.vertices[idx + 1][0], this.vertices[idx + 1][1], this.vertices[idx + 0][2], this.fill, this.stroke, this.bezierDetail, code);
                            code = 0;
                            idx += 2;
                            break;
                        }
                        case 1: {
                            this.inGeo.addBezierVertex(this.vertices[idx + 0][0], this.vertices[idx + 0][1], this.vertices[idx + 0][2], this.vertices[idx + 1][0], this.vertices[idx + 1][1], this.vertices[idx + 1][2], this.vertices[idx + 2][0], this.vertices[idx + 2][1], this.vertices[idx + 2][2], this.fill, this.stroke, this.bezierDetail, code);
                            code = 0;
                            idx += 3;
                            break;
                        }
                        case 3: {
                            this.inGeo.addCurveVertex(this.vertices[idx][0], this.vertices[idx][1], this.vertices[idx][2], this.fill, this.stroke, this.curveDetail, code);
                            code = 0;
                            ++idx;
                            break;
                        }
                        case 4: {
                            code = 4;
                        }
                    }
                    ++j;
                }
            }
        }
        if (this.stroke) {
            this.inGeo.addPolygonEdges(this.isClosed);
        }
        this.tessellator.tessellatePolygon(false, this.isClosed, true);
    }

    protected void aggregate() {
        if (this.root == this && this.parent == null) {
            this.polyIndexOffset = 0;
            this.polyVertexOffset = 0;
            this.polyVertexAbs = 0;
            this.polyVertexRel = 0;
            this.lineIndexOffset = 0;
            this.lineVertexOffset = 0;
            this.lineVertexAbs = 0;
            this.lineVertexRel = 0;
            this.pointIndexOffset = 0;
            this.pointVertexOffset = 0;
            this.pointVertexAbs = 0;
            this.pointVertexRel = 0;
            this.aggregateImpl();
        }
    }

    protected void aggregateImpl() {
        if (this.family == 0) {
            this.hasPolys = false;
            this.hasLines = false;
            this.hasPoints = false;
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                child.aggregateImpl();
                this.hasPolys |= child.hasPolys;
                this.hasLines |= child.hasLines;
                this.hasPoints |= child.hasPoints;
                ++i;
            }
        } else {
            this.hasPolys = -1 < this.firstPolyIndexCache && -1 < this.lastPolyIndexCache;
            this.hasLines = -1 < this.firstLineIndexCache && -1 < this.lastLineIndexCache;
            boolean bl = this.hasPoints = -1 < this.firstPointIndexCache && -1 < this.lastPointIndexCache;
        }
        if (this.hasPolys) {
            this.updatePolyIndexCache();
        }
        if (this.is3D()) {
            if (this.hasLines) {
                this.updateLineIndexCache();
            }
            if (this.hasPoints) {
                this.updatePointIndexCache();
            }
        }
        if (this.matrix != null) {
            if (this.hasPolys) {
                this.tessGeo.applyMatrixOnPolyGeometry(this.matrix, this.firstPolyVertex, this.lastPolyVertex);
            }
            if (this.is3D()) {
                if (this.hasLines) {
                    this.tessGeo.applyMatrixOnLineGeometry(this.matrix, this.firstLineVertex, this.lastLineVertex);
                }
                if (this.hasPoints) {
                    this.tessGeo.applyMatrixOnPointGeometry(this.matrix, this.firstPointVertex, this.lastPointVertex);
                }
            }
        }
    }

    protected void updatePolyIndexCache() {
        PGraphicsOpenGL.IndexCache cache = this.tessGeo.polyIndexCache;
        if (this.family == 0) {
            this.lastPolyIndexCache = -1;
            this.firstPolyIndexCache = -1;
            int gindex = -1;
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                int first = child.firstPolyIndexCache;
                int count = -1 < first ? child.lastPolyIndexCache - first + 1 : -1;
                int n = first;
                while (n < first + count) {
                    if (gindex == -1) {
                        this.firstPolyIndexCache = gindex = cache.addNew(n);
                    } else if (cache.vertexOffset[gindex] == cache.vertexOffset[n]) {
                        cache.incCounts(gindex, cache.indexCount[n], cache.vertexCount[n]);
                    } else {
                        gindex = cache.addNew(n);
                    }
                    ++n;
                }
                if (-1 < child.firstPolyVertex) {
                    if (this.firstPolyVertex == -1) {
                        this.firstPolyVertex = Integer.MAX_VALUE;
                    }
                    this.firstPolyVertex = PApplet.min(this.firstPolyVertex, child.firstPolyVertex);
                }
                if (-1 < child.lastPolyVertex) {
                    this.lastPolyVertex = PApplet.max(this.lastPolyVertex, child.lastPolyVertex);
                }
                ++i;
            }
            this.lastPolyIndexCache = gindex;
        } else {
            this.firstPolyVertex = this.lastPolyVertex = cache.vertexOffset[this.firstPolyIndexCache];
            int n = this.firstPolyIndexCache;
            while (n <= this.lastPolyIndexCache) {
                int ioffset = cache.indexOffset[n];
                int icount = cache.indexCount[n];
                int vcount = cache.vertexCount[n];
                if (32768 <= this.root.polyVertexRel + vcount || this.is2D() && this.startStrokedTex(n)) {
                    this.root.polyVertexRel = 0;
                    this.root.polyVertexOffset = this.root.polyVertexAbs;
                    cache.indexOffset[n] = this.root.polyIndexOffset;
                } else {
                    this.tessGeo.incPolyIndices(ioffset, ioffset + icount - 1, this.root.polyVertexRel);
                }
                cache.vertexOffset[n] = this.root.polyVertexOffset;
                if (this.is2D()) {
                    this.setFirstStrokeVertex(n, this.lastPolyVertex);
                }
                this.root.polyIndexOffset += icount;
                this.root.polyVertexAbs += vcount;
                this.root.polyVertexRel += vcount;
                this.lastPolyVertex += vcount;
                ++n;
            }
            --this.lastPolyVertex;
            if (this.is2D()) {
                this.setLastStrokeVertex(this.lastPolyVertex);
            }
        }
    }

    protected boolean startStrokedTex(int n) {
        return this.image != null && (n == this.firstLineIndexCache || n == this.firstPointIndexCache);
    }

    protected void setFirstStrokeVertex(int n, int vert) {
        if (n == this.firstLineIndexCache && this.firstLineVertex == -1) {
            this.firstLineVertex = this.lastLineVertex = vert;
        }
        if (n == this.firstPointIndexCache && this.firstPointVertex == -1) {
            this.firstPointVertex = this.lastPointVertex = vert;
        }
    }

    protected void setLastStrokeVertex(int vert) {
        if (-1 < this.lastLineVertex) {
            this.lastLineVertex = vert;
        }
        if (-1 < this.lastPointVertex) {
            this.lastPointVertex += vert;
        }
    }

    protected void updateLineIndexCache() {
        PGraphicsOpenGL.IndexCache cache = this.tessGeo.lineIndexCache;
        if (this.family == 0) {
            this.lastLineIndexCache = -1;
            this.firstLineIndexCache = -1;
            int gindex = -1;
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                int first = child.firstLineIndexCache;
                int count = -1 < first ? child.lastLineIndexCache - first + 1 : -1;
                int n = first;
                while (n < first + count) {
                    if (gindex == -1) {
                        this.firstLineIndexCache = gindex = cache.addNew(n);
                    } else if (cache.vertexOffset[gindex] == cache.vertexOffset[n]) {
                        cache.incCounts(gindex, cache.indexCount[n], cache.vertexCount[n]);
                    } else {
                        gindex = cache.addNew(n);
                    }
                    ++n;
                }
                if (-1 < child.firstLineVertex) {
                    if (this.firstLineVertex == -1) {
                        this.firstLineVertex = Integer.MAX_VALUE;
                    }
                    this.firstLineVertex = PApplet.min(this.firstLineVertex, child.firstLineVertex);
                }
                if (-1 < child.lastLineVertex) {
                    this.lastLineVertex = PApplet.max(this.lastLineVertex, child.lastLineVertex);
                }
                ++i;
            }
            this.lastLineIndexCache = gindex;
        } else {
            this.firstLineVertex = this.lastLineVertex = cache.vertexOffset[this.firstLineIndexCache];
            int n = this.firstLineIndexCache;
            while (n <= this.lastLineIndexCache) {
                int ioffset = cache.indexOffset[n];
                int icount = cache.indexCount[n];
                int vcount = cache.vertexCount[n];
                if (32768 <= this.root.lineVertexRel + vcount) {
                    this.root.lineVertexRel = 0;
                    this.root.lineVertexOffset = this.root.lineVertexAbs;
                    cache.indexOffset[n] = this.root.lineIndexOffset;
                } else {
                    this.tessGeo.incLineIndices(ioffset, ioffset + icount - 1, this.root.lineVertexRel);
                }
                cache.vertexOffset[n] = this.root.lineVertexOffset;
                this.root.lineIndexOffset += icount;
                this.root.lineVertexAbs += vcount;
                this.root.lineVertexRel += vcount;
                this.lastLineVertex += vcount;
                ++n;
            }
            --this.lastLineVertex;
        }
    }

    protected void updatePointIndexCache() {
        PGraphicsOpenGL.IndexCache cache = this.tessGeo.pointIndexCache;
        if (this.family == 0) {
            this.lastPointIndexCache = -1;
            this.firstPointIndexCache = -1;
            int gindex = -1;
            int i = 0;
            while (i < this.childCount) {
                PShapeOpenGL child = (PShapeOpenGL)this.children[i];
                int first = child.firstPointIndexCache;
                int count = -1 < first ? child.lastPointIndexCache - first + 1 : -1;
                int n = first;
                while (n < first + count) {
                    if (gindex == -1) {
                        this.firstPointIndexCache = gindex = cache.addNew(n);
                    } else if (cache.vertexOffset[gindex] == cache.vertexOffset[n]) {
                        cache.incCounts(gindex, cache.indexCount[n], cache.vertexCount[n]);
                    } else {
                        gindex = cache.addNew(n);
                    }
                    ++n;
                }
                if (-1 < child.firstPointVertex) {
                    if (this.firstPointVertex == -1) {
                        this.firstPointVertex = Integer.MAX_VALUE;
                    }
                    this.firstPointVertex = PApplet.min(this.firstPointVertex, child.firstPointVertex);
                }
                if (-1 < child.lastPointVertex) {
                    this.lastPointVertex = PApplet.max(this.lastPointVertex, child.lastPointVertex);
                }
                ++i;
            }
            this.lastPointIndexCache = gindex;
        } else {
            this.firstPointVertex = this.lastPointVertex = cache.vertexOffset[this.firstPointIndexCache];
            int n = this.firstPointIndexCache;
            while (n <= this.lastPointIndexCache) {
                int ioffset = cache.indexOffset[n];
                int icount = cache.indexCount[n];
                int vcount = cache.vertexCount[n];
                if (32768 <= this.root.pointVertexRel + vcount) {
                    this.root.pointVertexRel = 0;
                    this.root.pointVertexOffset = this.root.pointVertexAbs;
                    cache.indexOffset[n] = this.root.pointIndexOffset;
                } else {
                    this.tessGeo.incPointIndices(ioffset, ioffset + icount - 1, this.root.pointVertexRel);
                }
                cache.vertexOffset[n] = this.root.pointVertexOffset;
                this.root.pointIndexOffset += icount;
                this.root.pointVertexAbs += vcount;
                this.root.pointVertexRel += vcount;
                this.lastPointVertex += vcount;
                ++n;
            }
            --this.lastPointVertex;
        }
    }

    protected void initBuffers() {
        if (this.needBufferInit) {
            this.context = this.pgl.getCurrentContext();
            if (this.tessGeo.polyVertexCount > 0 && this.tessGeo.polyIndexCount > 0) {
                this.initPolyBuffers();
            }
            if (this.tessGeo.lineVertexCount > 0 && this.tessGeo.lineIndexCount > 0) {
                this.initLineBuffers();
            }
            if (this.tessGeo.pointVertexCount > 0 && this.tessGeo.pointIndexCount > 0) {
                this.initPointBuffers();
            }
            this.needBufferInit = false;
        }
    }

    protected void initPolyBuffers() {
        int size = this.tessGeo.polyVertexCount;
        int sizef = size * 4;
        int sizei = size * 4;
        this.glPolyVertex = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glPolyVertex);
        this.pgl.bufferData(34962, 4 * sizef, FloatBuffer.wrap(this.tessGeo.polyVertices, 0, 4 * size), 35044);
        this.glPolyColor = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glPolyColor);
        this.pgl.bufferData(34962, sizei, IntBuffer.wrap(this.tessGeo.polyColors, 0, size), 35044);
        this.glPolyNormal = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glPolyNormal);
        this.pgl.bufferData(34962, 3 * sizef, FloatBuffer.wrap(this.tessGeo.polyNormals, 0, 3 * size), 35044);
        this.glPolyTexcoord = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glPolyTexcoord);
        this.pgl.bufferData(34962, 2 * sizef, FloatBuffer.wrap(this.tessGeo.polyTexcoords, 0, 2 * size), 35044);
        this.glPolyAmbient = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glPolyAmbient);
        this.pgl.bufferData(34962, sizei, IntBuffer.wrap(this.tessGeo.polyAmbient, 0, size), 35044);
        this.glPolySpecular = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glPolySpecular);
        this.pgl.bufferData(34962, sizei, IntBuffer.wrap(this.tessGeo.polySpecular, 0, size), 35044);
        this.glPolyEmissive = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glPolyEmissive);
        this.pgl.bufferData(34962, sizei, IntBuffer.wrap(this.tessGeo.polyEmissive, 0, size), 35044);
        this.glPolyShininess = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glPolyShininess);
        this.pgl.bufferData(34962, sizef, FloatBuffer.wrap(this.tessGeo.polyShininess, 0, size), 35044);
        this.pgl.bindBuffer(34962, 0);
        this.glPolyIndex = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34963, this.glPolyIndex);
        this.pgl.bufferData(34963, this.tessGeo.polyIndexCount * 2, ShortBuffer.wrap(this.tessGeo.polyIndices, 0, this.tessGeo.polyIndexCount), 35044);
        this.pgl.bindBuffer(34963, 0);
    }

    protected void initLineBuffers() {
        int size = this.tessGeo.lineVertexCount;
        int sizef = size * 4;
        int sizei = size * 4;
        this.glLineVertex = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glLineVertex);
        this.pgl.bufferData(34962, 4 * sizef, FloatBuffer.wrap(this.tessGeo.lineVertices, 0, 4 * size), 35044);
        this.glLineColor = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glLineColor);
        this.pgl.bufferData(34962, sizei, IntBuffer.wrap(this.tessGeo.lineColors, 0, size), 35044);
        this.glLineAttrib = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glLineAttrib);
        this.pgl.bufferData(34962, 4 * sizef, FloatBuffer.wrap(this.tessGeo.lineAttribs, 0, 4 * size), 35044);
        this.pgl.bindBuffer(34962, 0);
        this.glLineIndex = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34963, this.glLineIndex);
        this.pgl.bufferData(34963, this.tessGeo.lineIndexCount * 2, ShortBuffer.wrap(this.tessGeo.lineIndices, 0, this.tessGeo.lineIndexCount), 35044);
        this.pgl.bindBuffer(34963, 0);
    }

    protected void initPointBuffers() {
        int size = this.tessGeo.pointVertexCount;
        int sizef = size * 4;
        int sizei = size * 4;
        this.glPointVertex = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glPointVertex);
        this.pgl.bufferData(34962, 4 * sizef, FloatBuffer.wrap(this.tessGeo.pointVertices, 0, 4 * size), 35044);
        this.glPointColor = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glPointColor);
        this.pgl.bufferData(34962, sizei, IntBuffer.wrap(this.tessGeo.pointColors, 0, size), 35044);
        this.glPointAttrib = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34962, this.glPointAttrib);
        this.pgl.bufferData(34962, 2 * sizef, FloatBuffer.wrap(this.tessGeo.pointAttribs, 0, 2 * size), 35044);
        this.pgl.bindBuffer(34962, 0);
        this.glPointIndex = this.pg.createVertexBufferObject(this.context.id());
        this.pgl.bindBuffer(34963, this.glPointIndex);
        this.pgl.bufferData(34963, this.tessGeo.pointIndexCount * 2, ShortBuffer.wrap(this.tessGeo.pointIndices, 0, this.tessGeo.pointIndexCount), 35044);
        this.pgl.bindBuffer(34963, 0);
    }

    protected boolean contextIsOutdated() {
        boolean outdated;
        boolean bl = outdated = !this.pgl.contextIsCurrent(this.context);
        if (outdated) {
            this.pg.removeVertexBufferObject(this.glPolyVertex, this.context.id());
            this.pg.removeVertexBufferObject(this.glPolyColor, this.context.id());
            this.pg.removeVertexBufferObject(this.glPolyNormal, this.context.id());
            this.pg.removeVertexBufferObject(this.glPolyTexcoord, this.context.id());
            this.pg.removeVertexBufferObject(this.glPolyAmbient, this.context.id());
            this.pg.removeVertexBufferObject(this.glPolySpecular, this.context.id());
            this.pg.removeVertexBufferObject(this.glPolyEmissive, this.context.id());
            this.pg.removeVertexBufferObject(this.glPolyShininess, this.context.id());
            this.pg.removeVertexBufferObject(this.glPolyIndex, this.context.id());
            this.pg.removeVertexBufferObject(this.glLineVertex, this.context.id());
            this.pg.removeVertexBufferObject(this.glLineColor, this.context.id());
            this.pg.removeVertexBufferObject(this.glLineAttrib, this.context.id());
            this.pg.removeVertexBufferObject(this.glLineIndex, this.context.id());
            this.pg.removeVertexBufferObject(this.glPointVertex, this.context.id());
            this.pg.removeVertexBufferObject(this.glPointColor, this.context.id());
            this.pg.removeVertexBufferObject(this.glPointAttrib, this.context.id());
            this.pg.removeVertexBufferObject(this.glPointIndex, this.context.id());
            this.glPolyVertex = 0;
            this.glPolyColor = 0;
            this.glPolyNormal = 0;
            this.glPolyTexcoord = 0;
            this.glPolyAmbient = 0;
            this.glPolySpecular = 0;
            this.glPolyEmissive = 0;
            this.glPolyShininess = 0;
            this.glPolyIndex = 0;
            this.glLineVertex = 0;
            this.glLineColor = 0;
            this.glLineAttrib = 0;
            this.glLineIndex = 0;
            this.glPointVertex = 0;
            this.glPointColor = 0;
            this.glPointAttrib = 0;
            this.glPointIndex = 0;
        }
        return outdated;
    }

    protected void release() {
        this.deletePolyBuffers();
        this.deleteLineBuffers();
        this.deletePointBuffers();
    }

    protected void deletePolyBuffers() {
        if (this.glPolyVertex != 0) {
            this.pg.deleteVertexBufferObject(this.glPolyVertex, this.context.id());
            this.glPolyVertex = 0;
        }
        if (this.glPolyColor != 0) {
            this.pg.deleteVertexBufferObject(this.glPolyColor, this.context.id());
            this.glPolyColor = 0;
        }
        if (this.glPolyNormal != 0) {
            this.pg.deleteVertexBufferObject(this.glPolyNormal, this.context.id());
            this.glPolyNormal = 0;
        }
        if (this.glPolyTexcoord != 0) {
            this.pg.deleteVertexBufferObject(this.glPolyTexcoord, this.context.id());
            this.glPolyTexcoord = 0;
        }
        if (this.glPolyAmbient != 0) {
            this.pg.deleteVertexBufferObject(this.glPolyAmbient, this.context.id());
            this.glPolyAmbient = 0;
        }
        if (this.glPolySpecular != 0) {
            this.pg.deleteVertexBufferObject(this.glPolySpecular, this.context.id());
            this.glPolySpecular = 0;
        }
        if (this.glPolyEmissive != 0) {
            this.pg.deleteVertexBufferObject(this.glPolyEmissive, this.context.id());
            this.glPolyEmissive = 0;
        }
        if (this.glPolyShininess != 0) {
            this.pg.deleteVertexBufferObject(this.glPolyShininess, this.context.id());
            this.glPolyShininess = 0;
        }
        if (this.glPolyIndex != 0) {
            this.pg.deleteVertexBufferObject(this.glPolyIndex, this.context.id());
            this.glPolyIndex = 0;
        }
    }

    protected void deleteLineBuffers() {
        if (this.glLineVertex != 0) {
            this.pg.deleteVertexBufferObject(this.glLineVertex, this.context.id());
            this.glLineVertex = 0;
        }
        if (this.glLineColor != 0) {
            this.pg.deleteVertexBufferObject(this.glLineColor, this.context.id());
            this.glLineColor = 0;
        }
        if (this.glLineAttrib != 0) {
            this.pg.deleteVertexBufferObject(this.glLineAttrib, this.context.id());
            this.glLineAttrib = 0;
        }
        if (this.glLineIndex != 0) {
            this.pg.deleteVertexBufferObject(this.glLineIndex, this.context.id());
            this.glLineIndex = 0;
        }
    }

    protected void deletePointBuffers() {
        if (this.glPointVertex != 0) {
            this.pg.deleteVertexBufferObject(this.glPointVertex, this.context.id());
            this.glPointVertex = 0;
        }
        if (this.glPointColor != 0) {
            this.pg.deleteVertexBufferObject(this.glPointColor, this.context.id());
            this.glPointColor = 0;
        }
        if (this.glPointAttrib != 0) {
            this.pg.deleteVertexBufferObject(this.glPointAttrib, this.context.id());
            this.glPointAttrib = 0;
        }
        if (this.glPointIndex != 0) {
            this.pg.deleteVertexBufferObject(this.glPointIndex, this.context.id());
            this.glPointIndex = 0;
        }
    }

    protected void updateGeometry() {
        this.root.initBuffers();
        if (this.root.modified) {
            this.root.updateGeometryImpl();
        }
    }

    protected void updateGeometryImpl() {
        int size;
        int offset;
        if (this.modifiedPolyVertices) {
            offset = this.firstModifiedPolyVertex;
            size = this.lastModifiedPolyVertex - offset + 1;
            this.copyPolyVertices(offset, size);
            this.modifiedPolyVertices = false;
            this.firstModifiedPolyVertex = Integer.MAX_VALUE;
            this.lastModifiedPolyVertex = Integer.MIN_VALUE;
        }
        if (this.modifiedPolyColors) {
            offset = this.firstModifiedPolyColor;
            size = this.lastModifiedPolyColor - offset + 1;
            this.copyPolyColors(offset, size);
            this.modifiedPolyColors = false;
            this.firstModifiedPolyColor = Integer.MAX_VALUE;
            this.lastModifiedPolyColor = Integer.MIN_VALUE;
        }
        if (this.modifiedPolyNormals) {
            offset = this.firstModifiedPolyNormal;
            size = this.lastModifiedPolyNormal - offset + 1;
            this.copyPolyNormals(offset, size);
            this.modifiedPolyNormals = false;
            this.firstModifiedPolyNormal = Integer.MAX_VALUE;
            this.lastModifiedPolyNormal = Integer.MIN_VALUE;
        }
        if (this.modifiedPolyTexcoords) {
            offset = this.firstModifiedPolyTexcoord;
            size = this.lastModifiedPolyTexcoord - offset + 1;
            this.copyPolyTexcoords(offset, size);
            this.modifiedPolyTexcoords = false;
            this.firstModifiedPolyTexcoord = Integer.MAX_VALUE;
            this.lastModifiedPolyTexcoord = Integer.MIN_VALUE;
        }
        if (this.modifiedPolyAmbient) {
            offset = this.firstModifiedPolyAmbient;
            size = this.lastModifiedPolyAmbient - offset + 1;
            this.copyPolyAmbient(offset, size);
            this.modifiedPolyAmbient = false;
            this.firstModifiedPolyAmbient = Integer.MAX_VALUE;
            this.lastModifiedPolyAmbient = Integer.MIN_VALUE;
        }
        if (this.modifiedPolySpecular) {
            offset = this.firstModifiedPolySpecular;
            size = this.lastModifiedPolySpecular - offset + 1;
            this.copyPolySpecular(offset, size);
            this.modifiedPolySpecular = false;
            this.firstModifiedPolySpecular = Integer.MAX_VALUE;
            this.lastModifiedPolySpecular = Integer.MIN_VALUE;
        }
        if (this.modifiedPolyEmissive) {
            offset = this.firstModifiedPolyEmissive;
            size = this.lastModifiedPolyEmissive - offset + 1;
            this.copyPolyEmissive(offset, size);
            this.modifiedPolyEmissive = false;
            this.firstModifiedPolyEmissive = Integer.MAX_VALUE;
            this.lastModifiedPolyEmissive = Integer.MIN_VALUE;
        }
        if (this.modifiedPolyShininess) {
            offset = this.firstModifiedPolyShininess;
            size = this.lastModifiedPolyShininess - offset + 1;
            this.copyPolyShininess(offset, size);
            this.modifiedPolyShininess = false;
            this.firstModifiedPolyShininess = Integer.MAX_VALUE;
            this.lastModifiedPolyShininess = Integer.MIN_VALUE;
        }
        if (this.modifiedLineVertices) {
            offset = this.firstModifiedLineVertex;
            size = this.lastModifiedLineVertex - offset + 1;
            this.copyLineVertices(offset, size);
            this.modifiedLineVertices = false;
            this.firstModifiedLineVertex = Integer.MAX_VALUE;
            this.lastModifiedLineVertex = Integer.MIN_VALUE;
        }
        if (this.modifiedLineColors) {
            offset = this.firstModifiedLineColor;
            size = this.lastModifiedLineColor - offset + 1;
            this.copyLineColors(offset, size);
            this.modifiedLineColors = false;
            this.firstModifiedLineColor = Integer.MAX_VALUE;
            this.lastModifiedLineColor = Integer.MIN_VALUE;
        }
        if (this.modifiedLineAttributes) {
            offset = this.firstModifiedLineAttribute;
            size = this.lastModifiedLineAttribute - offset + 1;
            this.copyLineAttributes(offset, size);
            this.modifiedLineAttributes = false;
            this.firstModifiedLineAttribute = Integer.MAX_VALUE;
            this.lastModifiedLineAttribute = Integer.MIN_VALUE;
        }
        if (this.modifiedPointVertices) {
            offset = this.firstModifiedPointVertex;
            size = this.lastModifiedPointVertex - offset + 1;
            this.copyPointVertices(offset, size);
            this.modifiedPointVertices = false;
            this.firstModifiedPointVertex = Integer.MAX_VALUE;
            this.lastModifiedPointVertex = Integer.MIN_VALUE;
        }
        if (this.modifiedPointColors) {
            offset = this.firstModifiedPointColor;
            size = this.lastModifiedPointColor - offset + 1;
            this.copyPointColors(offset, size);
            this.modifiedPointColors = false;
            this.firstModifiedPointColor = Integer.MAX_VALUE;
            this.lastModifiedPointColor = Integer.MIN_VALUE;
        }
        if (this.modifiedPointAttributes) {
            offset = this.firstModifiedPointAttribute;
            size = this.lastModifiedPointAttribute - offset + 1;
            this.copyPointAttributes(offset, size);
            this.modifiedPointAttributes = false;
            this.firstModifiedPointAttribute = Integer.MAX_VALUE;
            this.lastModifiedPointAttribute = Integer.MIN_VALUE;
        }
        this.modified = false;
    }

    protected void copyPolyVertices(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glPolyVertex);
        this.pgl.bufferSubData(34962, 4 * offset * 4, 4 * size * 4, FloatBuffer.wrap(this.tessGeo.polyVertices, 4 * offset, 4 * size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyPolyColors(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glPolyColor);
        this.pgl.bufferSubData(34962, offset * 4, size * 4, IntBuffer.wrap(this.tessGeo.polyColors, offset, size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyPolyNormals(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glPolyNormal);
        this.pgl.bufferSubData(34962, 3 * offset * 4, 3 * size * 4, FloatBuffer.wrap(this.tessGeo.polyNormals, 3 * offset, 3 * size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyPolyTexcoords(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glPolyTexcoord);
        this.pgl.bufferSubData(34962, 2 * offset * 4, 2 * size * 4, FloatBuffer.wrap(this.tessGeo.polyTexcoords, 2 * offset, 2 * size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyPolyAmbient(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glPolyAmbient);
        this.pgl.bufferSubData(34962, offset * 4, size * 4, IntBuffer.wrap(this.tessGeo.polyAmbient, offset, size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyPolySpecular(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glPolySpecular);
        this.pgl.bufferSubData(34962, offset * 4, size * 4, IntBuffer.wrap(this.tessGeo.polySpecular, offset, size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyPolyEmissive(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glPolyEmissive);
        this.pgl.bufferSubData(34962, offset * 4, size * 4, IntBuffer.wrap(this.tessGeo.polyEmissive, offset, size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyPolyShininess(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glPolyShininess);
        this.pgl.bufferSubData(34962, offset * 4, size * 4, FloatBuffer.wrap(this.tessGeo.polyShininess, offset, size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyLineVertices(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glLineVertex);
        this.pgl.bufferSubData(34962, 4 * offset * 4, 4 * size * 4, FloatBuffer.wrap(this.tessGeo.lineVertices, 4 * offset, 4 * size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyLineColors(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glLineColor);
        this.pgl.bufferSubData(34962, offset * 4, size * 4, IntBuffer.wrap(this.tessGeo.lineColors, offset, size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyLineAttributes(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glLineAttrib);
        this.pgl.bufferSubData(34962, 4 * offset * 4, 4 * size * 4, FloatBuffer.wrap(this.tessGeo.lineAttribs, 4 * offset, 4 * size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyPointVertices(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glPointVertex);
        this.pgl.bufferSubData(34962, 4 * offset * 4, 4 * size * 4, FloatBuffer.wrap(this.tessGeo.pointVertices, 4 * offset, 4 * size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyPointColors(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glPointColor);
        this.pgl.bufferSubData(34962, offset * 4, size * 4, IntBuffer.wrap(this.tessGeo.pointColors, offset, size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void copyPointAttributes(int offset, int size) {
        this.pgl.bindBuffer(34962, this.glPointAttrib);
        this.pgl.bufferSubData(34962, 2 * offset * 4, 2 * size * 4, FloatBuffer.wrap(this.tessGeo.pointAttribs, 2 * offset, 2 * size));
        this.pgl.bindBuffer(34962, 0);
    }

    protected void setModifiedPolyVertices(int first, int last) {
        if (first < this.firstModifiedPolyVertex) {
            this.firstModifiedPolyVertex = first;
        }
        if (last > this.lastModifiedPolyVertex) {
            this.lastModifiedPolyVertex = last;
        }
        this.modifiedPolyVertices = true;
        this.modified = true;
    }

    protected void setModifiedPolyColors(int first, int last) {
        if (first < this.firstModifiedPolyColor) {
            this.firstModifiedPolyColor = first;
        }
        if (last > this.lastModifiedPolyColor) {
            this.lastModifiedPolyColor = last;
        }
        this.modifiedPolyColors = true;
        this.modified = true;
    }

    protected void setModifiedPolyNormals(int first, int last) {
        if (first < this.firstModifiedPolyNormal) {
            this.firstModifiedPolyNormal = first;
        }
        if (last > this.lastModifiedPolyNormal) {
            this.lastModifiedPolyNormal = last;
        }
        this.modifiedPolyNormals = true;
        this.modified = true;
    }

    protected void setModifiedPolyTexcoords(int first, int last) {
        if (first < this.firstModifiedPolyTexcoord) {
            this.firstModifiedPolyTexcoord = first;
        }
        if (last > this.lastModifiedPolyTexcoord) {
            this.lastModifiedPolyTexcoord = last;
        }
        this.modifiedPolyTexcoords = true;
        this.modified = true;
    }

    protected void setModifiedPolyAmbient(int first, int last) {
        if (first < this.firstModifiedPolyAmbient) {
            this.firstModifiedPolyAmbient = first;
        }
        if (last > this.lastModifiedPolyAmbient) {
            this.lastModifiedPolyAmbient = last;
        }
        this.modifiedPolyAmbient = true;
        this.modified = true;
    }

    protected void setModifiedPolySpecular(int first, int last) {
        if (first < this.firstModifiedPolySpecular) {
            this.firstModifiedPolySpecular = first;
        }
        if (last > this.lastModifiedPolySpecular) {
            this.lastModifiedPolySpecular = last;
        }
        this.modifiedPolySpecular = true;
        this.modified = true;
    }

    protected void setModifiedPolyEmissive(int first, int last) {
        if (first < this.firstModifiedPolyEmissive) {
            this.firstModifiedPolyEmissive = first;
        }
        if (last > this.lastModifiedPolyEmissive) {
            this.lastModifiedPolyEmissive = last;
        }
        this.modifiedPolyEmissive = true;
        this.modified = true;
    }

    protected void setModifiedPolyShininess(int first, int last) {
        if (first < this.firstModifiedPolyShininess) {
            this.firstModifiedPolyShininess = first;
        }
        if (last > this.lastModifiedPolyShininess) {
            this.lastModifiedPolyShininess = last;
        }
        this.modifiedPolyShininess = true;
        this.modified = true;
    }

    protected void setModifiedLineVertices(int first, int last) {
        if (first < this.firstModifiedLineVertex) {
            this.firstModifiedLineVertex = first;
        }
        if (last > this.lastModifiedLineVertex) {
            this.lastModifiedLineVertex = last;
        }
        this.modifiedLineVertices = true;
        this.modified = true;
    }

    protected void setModifiedLineColors(int first, int last) {
        if (first < this.firstModifiedLineColor) {
            this.firstModifiedLineColor = first;
        }
        if (last > this.lastModifiedLineColor) {
            this.lastModifiedLineColor = last;
        }
        this.modifiedLineColors = true;
        this.modified = true;
    }

    protected void setModifiedLineAttributes(int first, int last) {
        if (first < this.firstModifiedLineAttribute) {
            this.firstModifiedLineAttribute = first;
        }
        if (last > this.lastModifiedLineAttribute) {
            this.lastModifiedLineAttribute = last;
        }
        this.modifiedLineAttributes = true;
        this.modified = true;
    }

    protected void setModifiedPointVertices(int first, int last) {
        if (first < this.firstModifiedPointVertex) {
            this.firstModifiedPointVertex = first;
        }
        if (last > this.lastModifiedPointVertex) {
            this.lastModifiedPointVertex = last;
        }
        this.modifiedPointVertices = true;
        this.modified = true;
    }

    protected void setModifiedPointColors(int first, int last) {
        if (first < this.firstModifiedPointColor) {
            this.firstModifiedPointColor = first;
        }
        if (last > this.lastModifiedPointColor) {
            this.lastModifiedPointColor = last;
        }
        this.modifiedPointColors = true;
        this.modified = true;
    }

    protected void setModifiedPointAttributes(int first, int last) {
        if (first < this.firstModifiedPointAttribute) {
            this.firstModifiedPointAttribute = first;
        }
        if (last > this.lastModifiedPointAttribute) {
            this.lastModifiedPointAttribute = last;
        }
        this.modifiedPointAttributes = true;
        this.modified = true;
    }

    protected void styles(PGraphics g) {
        if (g instanceof PGraphicsOpenGL) {
            if (this.stroke) {
                this.stroke(g.strokeColor);
                this.strokeWeight(g.strokeWeight);
                this.strokeCap(g.strokeCap);
                this.strokeJoin(g.strokeJoin);
            } else {
                this.noStroke();
            }
            if (this.fill) {
                this.fill(g.fillColor);
            } else {
                this.noFill();
            }
            this.ambient(g.ambientColor);
            this.specular(g.specularColor);
            this.emissive(g.emissiveColor);
            this.shininess(g.shininess);
        } else {
            super.styles(g);
        }
    }

    public void draw() {
        this.draw(this.pg);
    }

    public void draw(PGraphics g) {
        if (g instanceof PGraphicsOpenGL) {
            PGraphicsOpenGL gl = (PGraphicsOpenGL)g;
            if (this.visible) {
                this.pre(gl);
                this.updateTessellation();
                this.updateGeometry();
                if (this.family == 0) {
                    if (this.fragmentedGroup(gl)) {
                        int i = 0;
                        while (i < this.childCount) {
                            ((PShapeOpenGL)this.children[i]).draw(gl);
                            ++i;
                        }
                    } else {
                        PImage tex = null;
                        if (this.textures != null && this.textures.size() == 1) {
                            tex = (PImage)this.textures.toArray()[0];
                        }
                        this.render(gl, tex);
                    }
                } else {
                    this.render(gl, this.image);
                }
                this.post(gl);
            }
        } else {
            super.draw(g);
        }
    }

    protected boolean fragmentedGroup(PGraphicsOpenGL g) {
        return g.getHint(7) || this.textures != null && 1 < this.textures.size() || this.strokedTexture;
    }

    protected void pre(PGraphics g) {
        if (g instanceof PGraphicsOpenGL) {
            if (!this.style) {
                this.styles(g);
            }
        } else {
            super.pre(g);
        }
    }

    protected void post(PGraphics g) {
        if (!(g instanceof PGraphicsOpenGL)) {
            super.post(g);
        }
    }

    protected void drawGeometry(PGraphics g) {
        this.vertexCount = this.inGeo.vertexCount;
        this.vertices = this.inGeo.getVertexData();
        super.drawGeometry(g);
        this.vertexCount = 0;
        this.vertices = null;
    }

    protected void render(PGraphicsOpenGL g, PImage texture) {
        if (this.root == null) {
            throw new RuntimeException("Error rendering PShapeOpenGL, root shape is null");
        }
        if (this.hasPolys) {
            this.renderPolys(g, texture);
            if (g.haveRaw()) {
                this.rawPolys(g, texture);
            }
        }
        if (this.is3D()) {
            if (this.hasLines) {
                this.renderLines(g);
                if (g.haveRaw()) {
                    this.rawLines(g);
                }
            }
            if (this.hasPoints) {
                this.renderPoints(g);
                if (g.haveRaw()) {
                    this.rawPoints(g);
                }
            }
        }
    }

    protected void renderPolys(PGraphicsOpenGL g, PImage textureImage) {
        Texture tex = null;
        if (textureImage != null && (tex = g.getTexture(textureImage)) != null) {
            tex.bind();
        }
        boolean renderingFill = false;
        boolean renderingStroke = false;
        PShader shader = null;
        PGraphicsOpenGL.IndexCache cache = this.tessGeo.polyIndexCache;
        int n = this.firstPolyIndexCache;
        while (n <= this.lastPolyIndexCache) {
            if (this.is3D() || tex != null && (this.firstLineIndexCache == -1 || n < this.firstLineIndexCache) && (this.firstPointIndexCache == -1 || n < this.firstPointIndexCache)) {
                if (!renderingFill) {
                    shader = g.getPolyShader(g.lights, tex != null);
                    shader.bind();
                    renderingFill = true;
                }
            } else if (!renderingStroke) {
                if (tex != null) {
                    tex.unbind();
                    tex = null;
                }
                if (shader != null && shader.bound()) {
                    shader.unbind();
                }
                shader = g.getPolyShader(g.lights, false);
                shader.bind();
                renderingFill = false;
                renderingStroke = true;
            }
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            ((PGraphicsOpenGL.PolyShader)shader).setVertexAttribute(this.root.glPolyVertex, 4, 5126, 0, 4 * voffset * 4);
            ((PGraphicsOpenGL.PolyShader)shader).setColorAttribute(this.root.glPolyColor, 4, 5121, 0, 4 * voffset * 1);
            if (g.lights) {
                ((PGraphicsOpenGL.PolyShader)shader).setNormalAttribute(this.root.glPolyNormal, 3, 5126, 0, 3 * voffset * 4);
                ((PGraphicsOpenGL.PolyShader)shader).setAmbientAttribute(this.root.glPolyAmbient, 4, 5121, 0, 4 * voffset * 1);
                ((PGraphicsOpenGL.PolyShader)shader).setSpecularAttribute(this.root.glPolySpecular, 4, 5121, 0, 4 * voffset * 1);
                ((PGraphicsOpenGL.PolyShader)shader).setEmissiveAttribute(this.root.glPolyEmissive, 4, 5121, 0, 4 * voffset * 1);
                ((PGraphicsOpenGL.PolyShader)shader).setShininessAttribute(this.root.glPolyShininess, 1, 5126, 0, voffset * 4);
            }
            if (tex != null) {
                ((PGraphicsOpenGL.PolyShader)shader).setTexcoordAttribute(this.root.glPolyTexcoord, 2, 5126, 0, 2 * voffset * 4);
                ((PGraphicsOpenGL.PolyShader)shader).setTexture(tex);
            }
            this.pgl.bindBuffer(34963, this.root.glPolyIndex);
            this.pgl.drawElements(4, icount, 5123, ioffset * 2);
            this.pgl.bindBuffer(34963, 0);
            ++n;
        }
        if (shader != null && shader.bound()) {
            shader.unbind();
        }
        if (tex != null) {
            tex.unbind();
        }
    }

    protected void rawPolys(PGraphicsOpenGL g, PImage textureImage) {
        PGraphics raw = g.getRaw();
        raw.colorMode(1);
        raw.noStroke();
        raw.beginShape(9);
        float[] vertices = this.tessGeo.polyVertices;
        int[] color = this.tessGeo.polyColors;
        float[] uv = this.tessGeo.polyTexcoords;
        short[] indices = this.tessGeo.polyIndices;
        PGraphicsOpenGL.IndexCache cache = this.tessGeo.polyIndexCache;
        int n = this.firstPolyIndexCache;
        while (n <= this.lastPolyIndexCache) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            int tr = ioffset / 3;
            while (tr < (ioffset + icount) / 3) {
                float sy2;
                float sx2;
                float sy1;
                float sx1;
                float sy0;
                float sx0;
                int i0 = voffset + indices[3 * tr + 0];
                int i1 = voffset + indices[3 * tr + 1];
                int i2 = voffset + indices[3 * tr + 2];
                float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] src1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] src2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] pt1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] pt2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                int argb0 = PGL.nativeToJavaARGB(color[i0]);
                int argb1 = PGL.nativeToJavaARGB(color[i1]);
                int argb2 = PGL.nativeToJavaARGB(color[i2]);
                PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                PApplet.arrayCopy(vertices, 4 * i1, src1, 0, 4);
                PApplet.arrayCopy(vertices, 4 * i2, src2, 0, 4);
                g.modelview.mult(src0, pt0);
                g.modelview.mult(src1, pt1);
                g.modelview.mult(src2, pt2);
                if (textureImage != null) {
                    raw.texture(textureImage);
                    if (raw.is3D()) {
                        raw.fill(argb0);
                        raw.vertex(pt0[0], pt0[1], pt0[2], uv[2 * i0 + 0], uv[2 * i0 + 1]);
                        raw.fill(argb1);
                        raw.vertex(pt1[0], pt1[1], pt1[2], uv[2 * i1 + 0], uv[2 * i1 + 1]);
                        raw.fill(argb2);
                        raw.vertex(pt2[0], pt2[1], pt2[2], uv[2 * i2 + 0], uv[2 * i2 + 1]);
                    } else if (raw.is2D()) {
                        sx0 = g.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                        sy0 = g.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                        sx1 = g.screenXImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                        sy1 = g.screenYImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                        sx2 = g.screenXImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                        sy2 = g.screenYImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                        raw.fill(argb0);
                        raw.vertex(sx0, sy0, uv[2 * i0 + 0], uv[2 * i0 + 1]);
                        raw.fill(argb1);
                        raw.vertex(sx1, sy1, uv[2 * i1 + 0], uv[2 * i1 + 1]);
                        raw.fill(argb1);
                        raw.vertex(sx2, sy2, uv[2 * i2 + 0], uv[2 * i2 + 1]);
                    }
                } else if (raw.is3D()) {
                    raw.fill(argb0);
                    raw.vertex(pt0[0], pt0[1], pt0[2]);
                    raw.fill(argb1);
                    raw.vertex(pt1[0], pt1[1], pt1[2]);
                    raw.fill(argb2);
                    raw.vertex(pt2[0], pt2[1], pt2[2]);
                } else if (raw.is2D()) {
                    sx0 = g.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                    sy0 = g.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                    sx1 = g.screenXImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                    sy1 = g.screenYImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                    sx2 = g.screenXImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                    sy2 = g.screenYImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                    raw.fill(argb0);
                    raw.vertex(sx0, sy0);
                    raw.fill(argb1);
                    raw.vertex(sx1, sy1);
                    raw.fill(argb2);
                    raw.vertex(sx2, sy2);
                }
                ++tr;
            }
            ++n;
        }
        raw.endShape();
    }

    protected void renderLines(PGraphicsOpenGL g) {
        PGraphicsOpenGL.LineShader shader = g.getLineShader();
        shader.bind();
        PGraphicsOpenGL.IndexCache cache = this.tessGeo.lineIndexCache;
        int n = this.firstLineIndexCache;
        while (n <= this.lastLineIndexCache) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            shader.setVertexAttribute(this.root.glLineVertex, 4, 5126, 0, 4 * voffset * 4);
            shader.setColorAttribute(this.root.glLineColor, 4, 5121, 0, 4 * voffset * 1);
            shader.setLineAttribute(this.root.glLineAttrib, 4, 5126, 0, 4 * voffset * 4);
            this.pgl.bindBuffer(34963, this.root.glLineIndex);
            this.pgl.drawElements(4, icount, 5123, ioffset * 2);
            this.pgl.bindBuffer(34963, 0);
            ++n;
        }
        shader.unbind();
    }

    protected void rawLines(PGraphicsOpenGL g) {
        PGraphics raw = g.getRaw();
        raw.colorMode(1);
        raw.noFill();
        raw.strokeCap(this.strokeCap);
        raw.strokeJoin(this.strokeJoin);
        raw.beginShape(5);
        float[] vertices = this.tessGeo.lineVertices;
        int[] color = this.tessGeo.lineColors;
        float[] attribs = this.tessGeo.lineAttribs;
        short[] indices = this.tessGeo.lineIndices;
        PGraphicsOpenGL.IndexCache cache = this.tessGeo.lineIndexCache;
        int n = this.firstLineIndexCache;
        while (n <= this.lastLineIndexCache) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            int ln = ioffset / 6;
            while (ln < (ioffset + icount) / 6) {
                int i0 = voffset + indices[6 * ln + 0];
                int i1 = voffset + indices[6 * ln + 5];
                float sw0 = 2.0f * attribs[4 * i0 + 3];
                float sw1 = 2.0f * attribs[4 * i1 + 3];
                if (!PGraphicsOpenGL.zero(sw0)) {
                    float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] src1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] pt1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    int argb0 = PGL.nativeToJavaARGB(color[i0]);
                    int argb1 = PGL.nativeToJavaARGB(color[i1]);
                    PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                    PApplet.arrayCopy(vertices, 4 * i1, src1, 0, 4);
                    g.modelview.mult(src0, pt0);
                    g.modelview.mult(src1, pt1);
                    if (raw.is3D()) {
                        raw.strokeWeight(sw0);
                        raw.stroke(argb0);
                        raw.vertex(pt0[0], pt0[1], pt0[2]);
                        raw.strokeWeight(sw1);
                        raw.stroke(argb1);
                        raw.vertex(pt1[0], pt1[1], pt1[2]);
                    } else if (raw.is2D()) {
                        float sx0 = g.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                        float sy0 = g.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                        float sx1 = g.screenXImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                        float sy1 = g.screenYImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                        raw.strokeWeight(sw0);
                        raw.stroke(argb0);
                        raw.vertex(sx0, sy0);
                        raw.strokeWeight(sw1);
                        raw.stroke(argb1);
                        raw.vertex(sx1, sy1);
                    }
                }
                ++ln;
            }
            ++n;
        }
        raw.endShape();
    }

    protected void renderPoints(PGraphicsOpenGL g) {
        PGraphicsOpenGL.PointShader shader = g.getPointShader();
        shader.bind();
        PGraphicsOpenGL.IndexCache cache = this.tessGeo.pointIndexCache;
        int n = this.firstPointIndexCache;
        while (n <= this.lastPointIndexCache) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            shader.setVertexAttribute(this.root.glPointVertex, 4, 5126, 0, 4 * voffset * 4);
            shader.setColorAttribute(this.root.glPointColor, 4, 5121, 0, 4 * voffset * 1);
            shader.setPointAttribute(this.root.glPointAttrib, 2, 5126, 0, 2 * voffset * 4);
            this.pgl.bindBuffer(34963, this.root.glPointIndex);
            this.pgl.drawElements(4, icount, 5123, ioffset * 2);
            this.pgl.bindBuffer(34963, 0);
            ++n;
        }
        shader.unbind();
    }

    protected void rawPoints(PGraphicsOpenGL g) {
        PGraphics raw = g.getRaw();
        raw.colorMode(1);
        raw.noFill();
        raw.strokeCap(this.strokeCap);
        raw.beginShape(3);
        float[] vertices = this.tessGeo.pointVertices;
        int[] color = this.tessGeo.pointColors;
        float[] attribs = this.tessGeo.pointAttribs;
        short[] indices = this.tessGeo.pointIndices;
        PGraphicsOpenGL.IndexCache cache = this.tessGeo.pointIndexCache;
        int n = 0;
        while (n < cache.size) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            int pt = ioffset;
            while (pt < (ioffset + icount) / 3) {
                int perim;
                float weight;
                float size = attribs[2 * pt + 2];
                if (0.0f < size) {
                    weight = size / 0.5f;
                    perim = PApplet.max(20, (int)((float)Math.PI * 2 * weight / 10.0f)) + 1;
                } else {
                    weight = -size / 0.5f;
                    perim = 5;
                }
                int i0 = voffset + indices[3 * pt];
                int argb0 = PGL.nativeToJavaARGB(color[i0]);
                float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                g.modelview.mult(src0, pt0);
                if (raw.is3D()) {
                    raw.strokeWeight(weight);
                    raw.stroke(argb0);
                    raw.vertex(pt0[0], pt0[1], pt0[2]);
                } else if (raw.is2D()) {
                    float sx0 = g.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                    float sy0 = g.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                    raw.strokeWeight(weight);
                    raw.stroke(argb0);
                    raw.vertex(sx0, sy0);
                }
                pt += perim;
            }
            ++n;
        }
        raw.endShape();
    }
}

