/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.nio.IntBuffer;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

public class FrameBuffer
implements PConstants {
    protected PApplet parent;
    protected PGraphicsOpenGL pg;
    protected PGL pgl;
    protected PGL.Context context;
    public int glFbo;
    public int glDepth;
    public int glStencil;
    public int glDepthStencil;
    public int glMultisample;
    public int width;
    public int height;
    protected int depthBits;
    protected int stencilBits;
    protected boolean packedDepthStencil;
    protected boolean multisample;
    protected int nsamples;
    protected int numColorBuffers;
    protected Texture[] colorBufferTex;
    protected boolean screenFb;
    protected boolean noDepth;
    protected IntBuffer pixelBuffer;

    FrameBuffer(PApplet parent, int w, int h) {
        this(parent, w, h, 1, 1, 0, 0, false, false);
    }

    FrameBuffer(PApplet parent, int w, int h, boolean screen) {
        this(parent, w, h, 1, 1, 0, 0, false, screen);
    }

    FrameBuffer(PApplet parent) {
        this.parent = parent;
        this.pg = (PGraphicsOpenGL)parent.g;
        this.pgl = this.pg.pgl;
        this.context = this.pgl.createEmptyContext();
    }

    FrameBuffer(PApplet parent, int w, int h, int samples, int colorBuffers, int depthBits, int stencilBits, boolean packedDepthStencil, boolean screen) {
        this(parent);
        this.glFbo = 0;
        this.glDepth = 0;
        this.glStencil = 0;
        this.glDepthStencil = 0;
        this.glMultisample = 0;
        if (screen) {
            colorBuffers = 0;
            samples = 0;
            stencilBits = 0;
            depthBits = 0;
        }
        this.width = w;
        this.height = h;
        if (1 < samples) {
            this.multisample = true;
            this.nsamples = samples;
        } else {
            this.multisample = false;
            this.nsamples = 1;
        }
        this.numColorBuffers = colorBuffers;
        this.colorBufferTex = new Texture[this.numColorBuffers];
        int i = 0;
        while (i < this.numColorBuffers) {
            this.colorBufferTex[i] = null;
            ++i;
        }
        if (depthBits < 1 && stencilBits < 1) {
            this.depthBits = 0;
            this.stencilBits = 0;
            this.packedDepthStencil = false;
        } else if (packedDepthStencil) {
            this.depthBits = 24;
            this.stencilBits = 8;
            this.packedDepthStencil = true;
        } else {
            this.depthBits = depthBits;
            this.stencilBits = stencilBits;
            this.packedDepthStencil = false;
        }
        this.screenFb = screen;
        this.allocate();
        this.noDepth = false;
        this.pixelBuffer = null;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.screenFb) {
                if (this.glFbo != 0) {
                    this.pg.finalizeFrameBufferObject(this.glFbo, this.context.id());
                }
                if (this.glDepth != 0) {
                    this.pg.finalizeRenderBufferObject(this.glDepth, this.context.id());
                }
                if (this.glStencil != 0) {
                    this.pg.finalizeRenderBufferObject(this.glStencil, this.context.id());
                }
                if (this.glMultisample != 0) {
                    this.pg.finalizeRenderBufferObject(this.glMultisample, this.context.id());
                }
                if (this.glDepthStencil != 0) {
                    this.pg.finalizeRenderBufferObject(this.glDepthStencil, this.context.id());
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    public void clear() {
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.pgl.clearDepth(1.0f);
        this.pgl.clearStencil(0);
        this.pgl.clearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.pgl.clear(17664);
        this.pg.popFramebuffer();
    }

    public void copy(FrameBuffer dest) {
        this.pgl.bindFramebuffer(-1, this.glFbo);
        this.pgl.bindFramebuffer(-1, dest.glFbo);
        this.pgl.blitFramebuffer(0, 0, this.width, this.height, 0, 0, dest.width, dest.height, 16384, 9728);
    }

    public void bind() {
        this.pgl.bindFramebuffer(36160, this.glFbo);
    }

    public void disableDepthTest() {
        this.noDepth = true;
    }

    public void finish() {
        if (this.noDepth) {
            if (this.pg.getHint(-2)) {
                this.pgl.enable(2929);
            } else {
                this.pgl.disable(2929);
            }
        }
    }

    public void readPixels() {
        if (this.pixelBuffer == null) {
            this.createPixelBuffer();
        }
        this.pixelBuffer.rewind();
        this.pgl.readPixels(0, 0, this.width, this.height, 6408, 5121, this.pixelBuffer);
    }

    public void getPixels(int[] pixels) {
        if (this.pixelBuffer != null) {
            this.pixelBuffer.get(pixels, 0, pixels.length);
            this.pixelBuffer.rewind();
        }
    }

    public IntBuffer getPixelBuffer() {
        return this.pixelBuffer;
    }

    public boolean hasDepthBuffer() {
        return this.depthBits > 0;
    }

    public boolean hasStencilBuffer() {
        return this.stencilBits > 0;
    }

    public void setFBO(int id) {
        if (this.screenFb) {
            this.glFbo = id;
        }
    }

    public void setColorBuffer(Texture tex) {
        this.setColorBuffers(new Texture[]{tex}, 1);
    }

    public void setColorBuffers(Texture[] textures) {
        this.setColorBuffers(textures, textures.length);
    }

    public void setColorBuffers(Texture[] textures, int n) {
        if (this.screenFb) {
            return;
        }
        if (this.numColorBuffers != PApplet.min(n, textures.length)) {
            throw new RuntimeException("Wrong number of textures to set the color buffers.");
        }
        int i = 0;
        while (i < this.numColorBuffers) {
            this.colorBufferTex[i] = textures[i];
            ++i;
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        i = 0;
        while (i < this.numColorBuffers) {
            this.pgl.framebufferTexture2D(36160, 36064 + i, 3553, 0, 0);
            ++i;
        }
        i = 0;
        while (i < this.numColorBuffers) {
            this.pgl.framebufferTexture2D(36160, 36064 + i, this.colorBufferTex[i].glTarget, this.colorBufferTex[i].glName, 0);
            ++i;
        }
        this.pgl.validateFramebuffer();
        this.pg.popFramebuffer();
    }

    public void swapColorBuffers() {
        int i = 0;
        while (i < this.numColorBuffers - 1) {
            int i1 = i + 1;
            Texture tmp = this.colorBufferTex[i];
            this.colorBufferTex[i] = this.colorBufferTex[i1];
            this.colorBufferTex[i1] = tmp;
            ++i;
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        i = 0;
        while (i < this.numColorBuffers) {
            this.pgl.framebufferTexture2D(36160, 36064 + i, this.colorBufferTex[i].glTarget, this.colorBufferTex[i].glName, 0);
            ++i;
        }
        this.pgl.validateFramebuffer();
        this.pg.popFramebuffer();
    }

    protected void allocate() {
        this.release();
        this.context = this.pgl.getCurrentContext();
        if (this.screenFb) {
            this.glFbo = 0;
        } else {
            this.glFbo = this.pg.createFrameBufferObject(this.context.id());
            if (this.multisample) {
                this.createColorBufferMultisample();
            }
            if (this.packedDepthStencil) {
                this.createPackedDepthStencilBuffer();
            } else {
                if (this.depthBits > 0) {
                    this.createDepthBuffer();
                }
                if (this.stencilBits > 0) {
                    this.createStencilBuffer();
                }
            }
        }
    }

    protected void release() {
        if (this.screenFb) {
            return;
        }
        if (this.glFbo != 0) {
            this.pg.finalizeFrameBufferObject(this.glFbo, this.context.id());
            this.glFbo = 0;
        }
        if (this.glDepth != 0) {
            this.pg.finalizeRenderBufferObject(this.glDepth, this.context.id());
            this.glDepth = 0;
        }
        if (this.glStencil != 0) {
            this.pg.finalizeRenderBufferObject(this.glStencil, this.context.id());
            this.glStencil = 0;
        }
        if (this.glMultisample != 0) {
            this.pg.finalizeRenderBufferObject(this.glMultisample, this.context.id());
            this.glMultisample = 0;
        }
        if (this.glDepthStencil != 0) {
            this.pg.finalizeRenderBufferObject(this.glDepthStencil, this.context.id());
            this.glDepthStencil = 0;
        }
    }

    protected boolean contextIsOutdated() {
        boolean outdated;
        if (this.screenFb) {
            return false;
        }
        boolean bl = outdated = !this.pgl.contextIsCurrent(this.context);
        if (outdated) {
            this.pg.removeFrameBufferObject(this.glFbo, this.context.id());
            this.pg.removeRenderBufferObject(this.glDepth, this.context.id());
            this.pg.removeRenderBufferObject(this.glStencil, this.context.id());
            this.pg.removeRenderBufferObject(this.glDepthStencil, this.context.id());
            this.pg.removeRenderBufferObject(this.glMultisample, this.context.id());
            this.glFbo = 0;
            this.glDepth = 0;
            this.glStencil = 0;
            this.glDepthStencil = 0;
            this.glMultisample = 0;
            int i = 0;
            while (i < this.numColorBuffers) {
                this.colorBufferTex[i] = null;
                ++i;
            }
        }
        return outdated;
    }

    protected void createColorBufferMultisample() {
        if (this.screenFb) {
            return;
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.glMultisample = this.pg.createRenderBufferObject(this.context.id());
        this.pgl.bindRenderbuffer(36161, this.glMultisample);
        this.pgl.renderbufferStorageMultisample(36161, this.nsamples, -1, this.width, this.height);
        this.pgl.framebufferRenderbuffer(36160, 36064, 36161, this.glMultisample);
        this.pg.popFramebuffer();
    }

    protected void createPackedDepthStencilBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.glDepthStencil = this.pg.createRenderBufferObject(this.context.id());
        this.pgl.bindRenderbuffer(36161, this.glDepthStencil);
        if (this.multisample) {
            this.pgl.renderbufferStorageMultisample(36161, this.nsamples, 35056, this.width, this.height);
        } else {
            this.pgl.renderbufferStorage(36161, 35056, this.width, this.height);
        }
        this.pgl.framebufferRenderbuffer(36160, 36096, 36161, this.glDepthStencil);
        this.pgl.framebufferRenderbuffer(36160, 36128, 36161, this.glDepthStencil);
        this.pg.popFramebuffer();
    }

    protected void createDepthBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.glDepth = this.pg.createRenderBufferObject(this.context.id());
        this.pgl.bindRenderbuffer(36161, this.glDepth);
        int glConst = 33189;
        if (this.depthBits == 16) {
            glConst = 33189;
        } else if (this.depthBits == 24) {
            glConst = 33190;
        } else if (this.depthBits == 32) {
            glConst = 33191;
        }
        if (this.multisample) {
            this.pgl.renderbufferStorageMultisample(36161, this.nsamples, glConst, this.width, this.height);
        } else {
            this.pgl.renderbufferStorage(36161, glConst, this.width, this.height);
        }
        this.pgl.framebufferRenderbuffer(36160, 36096, 36161, this.glDepth);
        this.pg.popFramebuffer();
    }

    protected void createStencilBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.glStencil = this.pg.createRenderBufferObject(this.context.id());
        this.pgl.bindRenderbuffer(36161, this.glStencil);
        int glConst = 36166;
        if (this.stencilBits == 1) {
            glConst = 36166;
        } else if (this.stencilBits == 4) {
            glConst = 36167;
        } else if (this.stencilBits == 8) {
            glConst = 36168;
        }
        if (this.multisample) {
            this.pgl.renderbufferStorageMultisample(36161, this.nsamples, glConst, this.width, this.height);
        } else {
            this.pgl.renderbufferStorage(36161, glConst, this.width, this.height);
        }
        this.pgl.framebufferRenderbuffer(36160, 36128, 36161, this.glStencil);
        this.pg.popFramebuffer();
    }

    protected void createPixelBuffer() {
        this.pixelBuffer = IntBuffer.allocate(this.width * this.height);
        this.pixelBuffer.rewind();
    }
}

