/** This MIDLET sends data to a website using an HTTP Post method and then exits
 * 
 */
package edu.uci.ics.luci.projects.nomatic.test.hh;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

import edu.uci.ics.luci.projects.nomatic.Network.HTTPPostData;

public class HTTPPostExample extends MIDlet implements CommandListener, 
		ItemCommandListener {

	private Display display;

	private Form mainForm;

	private Command exitCommand = new Command("Exit", Command.EXIT, 99);

	private synchronized Form getMainForm() {
		return mainForm;
	}

	private synchronized void setMainForm(Form mainForm) {
		this.mainForm = mainForm;
	}

	private synchronized Display getDisplay() {
		return display;
	}

	private synchronized void setDisplay(Display display) {
		this.display = display;
	}


	/*
	 * destroyApp() is called by the AMS when the MIDlet is to be destroyed
	 */
	protected void destroyApp(boolean unconditional) {

	}

	/*
	 * pauseApp() is called by the AMS when the MIDlet should enter a paused
	 * state. This is an environment pause. The most common example is an
	 * incoming phone call on the device, which will cause the pauseApp() method
	 * to be called. This allows us to perform the needed actions within our
	 * MIDlet
	 */
	protected void pauseApp() {
	}

	/**
	 * startApp() is called by the AMS after it has successfully created an
	 * instance of our MIDlet class. startApp() causes our MIDlet to go into a
	 * "Active" state.
	 */
	protected void startApp() throws MIDletStateChangeException {

		if (getMainForm() == null) {
			Form f = new Form("HTTP Post Example");
			setMainForm(f);
			getMainForm().addCommand(exitCommand);
			getMainForm().setCommandListener(this);
		}
		if (getDisplay() == null) {
			setDisplay(Display.getDisplay(this));
		}
		getDisplay().setCurrent(getMainForm());
		
		new HTTPPostData("TextField=test",getMainForm());
	}

	public void commandAction(Command c, Item arg1) {

		if (c == exitCommand) {
			destroyApp(true);
			notifyDestroyed();
		}
	}

	public void commandAction(Command arg0, Displayable arg1) {
		commandAction(arg0, arg1);
	}

}
