/** This MIDLET sends networked GPS data to a website via a POST script
 * 
 */
package edu.uci.ics.luci.projects.nomatic.test.hh;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

import edu.uci.ics.luci.projects.nomatic.GPS.GPSComponent;
import edu.uci.ics.luci.projects.nomatic.GPS.NMEASentence;
import edu.uci.ics.luci.projects.nomatic.Network.HTTPPostData;

public class GPSHTTPPostExample extends MIDlet implements CommandListener,
		ItemCommandListener, Runnable {

	private Display display;

	private Form mainForm;

	private NMEASentence lastNMEA = null;

	private Command postDataCommand = new Command("Send GPS Data",
			Command.SCREEN, 1);

	private Command exitCommand = new Command("Exit", Command.EXIT, 99);

	Gauge gauge = new Gauge("Initializing", false, 100, 0);

	Ticker ticker = new Ticker("Initializing Status");

	private Thread time;

	GPSComponent gPS;

	private synchronized NMEASentence getLastNMEA() {
		return lastNMEA;
	}

	private synchronized void setLastNMEA(NMEASentence lastNMEA) {
		this.lastNMEA = lastNMEA;
	}

	private synchronized Form getMainForm() {
		return mainForm;
	}

	private synchronized void setMainForm(Form mainForm) {
		this.mainForm = mainForm;
	}

	private synchronized Display getDisplay() {
		return display;
	}

	private synchronized void setDisplay(Display display) {
		this.display = display;
	}

	private synchronized GPSComponent getGPS() {
		return gPS;
	}

	private synchronized void setGPS(GPSComponent gps) {
		gPS = gps;
	}

	private synchronized Thread getTime() {
		return time;
	}

	private synchronized void setTime(Thread time) {
		this.time = time;
	}

	public synchronized void tick() {
		// mainFormAppend("Starting Tick\n");
		if (getGPS().getBlueTooth() != null) {
			// mainFormAppend("Bluetooth log messages:\n\n");
			// mainFormAppend(getGPS().getBlueTooth().getLogMessage());
			// Clear the bluetooth log buffer
			getGPS().getBlueTooth().getLogMessage();
			if (getGPS().isGPSComponentSetupDone()) {
				if (getGPS().getInputStream() != null) {
					// mainFormAppend("\n");
					getGPS().fillGPSBuffer();
					if (getGPS().checkGPSBufferForNMEASentence("$GPRMC")) {
						String x;
						gauge.setValue(100);// Then immediately deleted
						ticker.setString("Active");
						getMainForm().deleteAll();
						// mainForm.append("GPS Data Found\n");
						setLastNMEA(getGPS().getGPSBuffer("$GPRMC", true));
						if (getLastNMEA()
								.safeNMEAFieldsGet(NMEASentence.STATUS)
								.compareTo("A") == 0) {
							getMainForm().append("Data Is Valid\n");
						} else {
							getMainForm().append("Data Is Invalid\n");
						}

						getMainForm().append("Latitude: ");
						x = getLastNMEA().safeNMEAFieldsGet(
								NMEASentence.LATITUDE);
						getMainForm().append(
								x.substring(0, 2) + " " + x.substring(2) + " ");
						getMainForm().append(
								getLastNMEA().safeNMEAFieldsGet(
										NMEASentence.LATITUDEHEMISPHERE));
						getMainForm().append("\n");
						getMainForm().append("Longitude: ");
						x = getLastNMEA().safeNMEAFieldsGet(
								NMEASentence.LONGITUDE);
						getMainForm().append(
								x.substring(0, 3) + " " + x.substring(3) + " ");
						getMainForm().append(" ");
						getMainForm().append(
								getLastNMEA().safeNMEAFieldsGet(
										NMEASentence.LONGITUDEHEMISPHERE));
						getMainForm().append("\n");

						getMainForm().append("Heading: ");
						getMainForm().append(
								getLastNMEA().safeNMEAFieldsGet(
										NMEASentence.COURSEOVERGROUND));
						getMainForm().append("\n");

						getMainForm().append("Speed: ");
						getMainForm().append(
								getLastNMEA().safeNMEAFieldsGet(
										NMEASentence.SPEEDOVERGROUND));
						getMainForm().append("\n");
						// for (Iterator i = n.NMEAFields.keySet().iterator();
						// i.hasNext();) {
						// String key = (String) i.next();
						// mainForm.append(key + ":" +
						// n.safeNMEAFieldsGet(key)+"\n");
						// }
					} else {
						gauge.setValue(80);
						ticker.setString("GPS Data Not Found");
					}
				} else {
					gauge.setValue(60);
					ticker.setString("Input Stream not ready");
				}
			} else {
				gauge.setValue(40);
				ticker.setString("Bluetooth not set up yet");
			}
		} else {
			gauge.setValue(20);
			ticker.setString("GPS Component set up is not complete");
		}
		// mainFormAppend("Ending Tick\n\n");
	}

	/**
	 * Our main loop, called at a fixed rate by our game Thread
	 */
	public void run() {

		while (true) {
			// set wanted loop delay in milliseconds
			int loopDelay = 10000;
			// get the time at the start of the loop
			long loopStartTime = System.currentTimeMillis();
			// call our tick() function which will be our apps heartbeat
			tick();
			// get time at end of loop
			long loopEndTime = System.currentTimeMillis();
			// caluclate the difference in time from start til end of loop
			int loopTime = (int) (loopEndTime - loopStartTime);
			// if the difference is less than what we want
			if (loopTime < loopDelay) {
				try {
					// then sleep for the time needed to fullfill our wanted
					// rate
					Thread.sleep(loopDelay - loopTime);
				} catch (Exception e) {
				}
			}
		}
	}

	/*
	 * destroyApp() is called by the AMS when the MIDlet is to be destroyed
	 */
	protected void destroyApp(boolean unconditional) {

	}

	/*
	 * pauseApp() is called by the AMS when the MIDlet should enter a paused
	 * state. This is an environment pause. The most common example is an
	 * incoming phone call on the device, which will cause the pauseApp() method
	 * to be called. This allows us to perform the needed actions within our
	 * MIDlet
	 */
	protected void pauseApp() {
	}

	/**
	 * startApp() is called by the AMS after it has successfully created an
	 * instance of our MIDlet class. startApp() causes our MIDlet to go into a
	 * "Active" state.
	 */
	protected void startApp() throws MIDletStateChangeException {

		if (getMainForm() == null) {
			Form f = new Form("GPS HTTP Post Example");
			setMainForm(f);
			getMainForm().addCommand(postDataCommand);
			getMainForm().addCommand(exitCommand);
			getMainForm().append(gauge);
			getMainForm().setTicker(ticker);
			getMainForm().setCommandListener(this);
		}
		if (getTime() == null) {
			setTime(new Thread(this));
		}

		if (getDisplay() == null) {
			setDisplay(Display.getDisplay(this));
		}
		getDisplay().setCurrent(getMainForm());
		if (getGPS() == null) {
			// mainFormAppend("Constructing GPSComponent\n");
			setGPS(new GPSComponent(
					GPSComponent.CONFIG_USE_NETWORK_GPS_PROXY,
					"http://www.ics.uci.edu/~djp3/classes/2007_04_02_INF132/code/GPSDATA01.txt"));
			// mainFormAppend("Done Constructing GPSComponent");
		}

		getTime().start();
	}

	public void commandAction(Command c, Item arg1) {

	}

	private synchronized void packageAndPostData() {
		if (lastNMEA != null) {
			StringBuffer x = new StringBuffer();
			x.append("do=addPictures&");
			x.append("name="
					+ getLastNMEA().safeNMEAFieldsGet(NMEASentence.TIME_OF_FIX)
					+ "&");
			String y = getLastNMEA().safeNMEAFieldsGet(NMEASentence.LONGITUDE);
			x.append("longi=-" + y + "&");
			y = getLastNMEA().safeNMEAFieldsGet(NMEASentence.LATITUDE);
			x.append("lat=" + y + "&");
			x.append("URL=http://www.ics.uci.edu/~djp3/bio_image.jpg" + "&");
			x.append("info=I_was_going_this_speed_"
					+ getLastNMEA().safeNMEAFieldsGet(
							NMEASentence.SPEEDOVERGROUND));
			System.out.println(x.toString());
			// x.append("&Submit=Submit");
			new HTTPPostData("http://www.kahliu.com/199/process.php", x
					.toString(), getMainForm());
		} else {
			getMainForm().append("GPS data not ready to send\n");
		}
	}

	public void commandAction(Command c, Displayable arg1) {

		if (c == exitCommand) {
			destroyApp(true);
			notifyDestroyed();
		} else if (c == postDataCommand) {
			packageAndPostData();
		}
	}

}
