/** This MIDLET reads GPS data from the bluetooth device and then uploads it to a website using a GET method */
package edu.uci.ics.luci.projects.nomatic.test.ee;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

import edu.uci.ics.luci.projects.nomatic.GPS.GPSComponent;
import edu.uci.ics.luci.projects.nomatic.GPS.NMEASentence;

public class BlueGPSLogger extends MIDlet implements CommandListener, Runnable,
		ItemCommandListener {

	private Display display;

	private Form mainForm;

	private Command exitCommand = new Command("Exit", Command.EXIT, 99);
	private Command checkGPSBuffer = new Command("Check GPS Buffer", Command.ITEM, 1);
	private Command setUpdateTo60 = new Command("Update every 60 seconds", Command.ITEM, 1);
	private Command setUpdateTo30 = new Command("Update every 30 seconds", Command.ITEM, 1);
	private Command setUpdateTo10 = new Command("Update every 10 seconds", Command.ITEM, 1);
	private boolean firstTimeA = true;
	private boolean firstTimeB = true;
	private boolean firstTimeC = true;
	private boolean firstTimeD = true;

	Gauge gauge = new Gauge("Initializing", false, 100, 0);

	Ticker ticker = new Ticker("Initializing Status");

	private Thread time;
	
	// set wanted loop delay in milliseconds
	private static int loopDelayValue= 60000;
	private static int loopDelay = 1000;

	GPSComponent gPS;

	private synchronized Form getMainForm() {
		return mainForm;
	}

	private synchronized void setMainForm(Form mainForm) {
		this.mainForm = mainForm;
	}

	private synchronized Display getDisplay() {
		return display;
	}

	private synchronized void setDisplay(Display display) {
		this.display = display;
	}

	private synchronized GPSComponent getGPS() {
		return gPS;
	}

	private synchronized void setGPS(GPSComponent gps) {
		gPS = gps;
	}

	private synchronized Thread getTime() {
		return time;
	}

	private synchronized void setTime(Thread time) {
		this.time = time;
	}

	public void tick() {
		if (getGPS().getBlueTooth() != null) {
			// Clear the bluetooth log buffer
			getGPS().getBlueTooth().getLogMessage();
			if (firstTimeA) {
				loopDelay = 1000;
				firstTimeA = false;
			}
			if (getGPS().isGPSComponentSetupDone()) {
				if (firstTimeB) {
					loopDelay = 1000;
					firstTimeB = false;
				}
				if (getGPS().getInputStream() != null) {
					if (firstTimeC) {
						loopDelay = 1000;
						firstTimeC = false;
					}
					int numChars = getGPS().fillGPSBuffer();
					if (getGPS().checkGPSBufferForNMEASentence("$GPRMC")) {
						if (firstTimeD) {
							getMainForm().addCommand(checkGPSBuffer);
							getMainForm().addCommand(setUpdateTo60);
							getMainForm().addCommand(setUpdateTo30);
							getMainForm().addCommand(setUpdateTo10);
							loopDelay = 10000;
							gauge.setValue(100);// Then immediately deleted
							firstTimeD = false;
						}
						else{
							loopDelay = loopDelayValue;
						}
						getMainForm().deleteAll();
						ticker.setString("Active");

						String x;
						String URLParameters = new String();
						getMainForm().append(
								"Filled buffer with " + numChars
										+ " characters\n");

						NMEASentence n = getGPS().getGPSBuffer("$GPRMC", true);
						boolean validData;

						if (n.safeNMEAFieldsGet(NMEASentence.STATUS).compareTo(
								"A") == 0) {
							getMainForm().append(
									"Data Is Valid\n  Posting to web\n");
							validData = true;
						} else {
							getMainForm().append(
									"Data Is Invalid\n Not posting to web\n");
							validData = false;
						}
						/* Process Date */
						getMainForm().append("Date: ");
						x = n.safeNMEAFieldsGet(NMEASentence.DATEOFFIX);
						String day = x.substring(0, 2);
						String month = x.substring(2, 4);
						String year = x.substring(4, 6);
						getMainForm().append(
								month + "/" + day + "/" + year + "\n");
						URLParameters = "Month=" + month + "&Day=" + day
								+ "&Year=" + year;

						/* Process Time */
						getMainForm().append("Time: ");
						x = n.safeNMEAFieldsGet(NMEASentence.TIME_OF_FIX);
						int hour = Integer.valueOf(x.substring(0, 2))
								.intValue();
						String minute = x.substring(2, 4);
						String second = x.substring(4, 6);
						hour -= 7; /* Time zone correction */
						if (hour < 0)
							hour += 24;
						getMainForm().append(
								hour + ":" + minute + ":" + second + "\n");
						URLParameters += "&Hour=" + hour + "&Minute=" + minute
								+ "&Second=" + second;

						/* Process Latitude */
						getMainForm().append("Latitude: ");
						x = n.safeNMEAFieldsGet(NMEASentence.LATITUDE);
						getMainForm().append(
								x.substring(0, 2) + " " + x.substring(2) + " ");
						getMainForm()
								.append(
										n
												.safeNMEAFieldsGet(NMEASentence.LATITUDEHEMISPHERE));
						getMainForm().append("\n");

						URLParameters += "&Latitude="
								+ x.substring(0, 2)
								+ "&LatitudeTail="
								+ x.substring(2)
								+ "&LatitudeHemisphere="
								+ n
										.safeNMEAFieldsGet(NMEASentence.LATITUDEHEMISPHERE);

						/* Process Longitude */
						getMainForm().append("Longitude: ");
						x = n.safeNMEAFieldsGet(NMEASentence.LONGITUDE);
						getMainForm().append(
								x.substring(0, 3) + " " + x.substring(3) + " ");
						getMainForm().append(" ");
						getMainForm()
								.append(
										n
												.safeNMEAFieldsGet(NMEASentence.LONGITUDEHEMISPHERE));
						getMainForm().append("\n");
						URLParameters += "&Longitude="
								+ x.substring(0, 3)
								+ "&LongitudeTail="
								+ x.substring(3)
								+ "&LongitudeHemisphere="
								+ n
										.safeNMEAFieldsGet(NMEASentence.LONGITUDEHEMISPHERE);

						/* Process Heading */
						getMainForm().append("Heading: ");
						getMainForm()
								.append(
										n
												.safeNMEAFieldsGet(NMEASentence.COURSEOVERGROUND));
						getMainForm().append("\n");
						URLParameters += "&Heading="
								+ n
										.safeNMEAFieldsGet(NMEASentence.COURSEOVERGROUND);

						/* Process Speed */
						getMainForm().append("Speed: ");
						getMainForm()
								.append(
										n
												.safeNMEAFieldsGet(NMEASentence.SPEEDOVERGROUND));
						getMainForm().append("\n");
						URLParameters += "&Speed="
								+ n
										.safeNMEAFieldsGet(NMEASentence.SPEEDOVERGROUND);

						/* Extra parameters for web */
						URLParameters += "&Name=Location%20Data&Source=Mobile%20Phone%20Plus%20GPS&Comment=No%20Comment";

						/* Send to website */
						if (validData) {
							new DataUploader(URLParameters);
						}
					} else {
						gauge.setValue(80);
						ticker.setString("Waiting for good GPS data");
						// Increase loopDelay
						loopDelay += 1000;
					}
				} else {
					gauge.setValue(60);
					ticker.setString("Waiting for data stream connection");
					getGPS().getLogMessage(true);
					// Increase loopDelay
					loopDelay += 1000;
				}
			} else {
				gauge.setValue(40);
				ticker
						.setString("Waiting for GPS bluetooth component creation");
				// Increase loopDelay
				loopDelay += 1000;
			}
		} else {
			gauge.setValue(20);
			ticker.setString("Waiting for bluetooth component creation");
			// Increase loopDelay
			loopDelay += 1000;
		}
	}

	/**
	 * Our main loop, called at a fixed rate by our game Thread
	 */
	public void run() {

		while (true) {
			// get the time at the start of the loop
			long loopStartTime = System.currentTimeMillis();
			// call our tick() function which will be our apps heartbeat
			tick();
			// get time at end of loop
			long loopEndTime = System.currentTimeMillis();
			// caluclate the difference in time from start til end of loop
			int loopTime = (int) (loopEndTime - loopStartTime);
			// if the difference is less than what we want
			if (loopTime < loopDelay) {
				try {
					// then sleep for the time needed to fullfill our wanted
					// rate
					Thread.sleep(loopDelay - loopTime);
				} catch (Exception e) {
				}
			}
		}
	}

	/*
	 * destroyApp() is called by the AMS when the MIDlet is to be destroyed
	 */
	protected void destroyApp(boolean unconditional) {

	}

	/*
	 * pauseApp() is called by the AMS when the MIDlet should enter a paused
	 * state. This is an environment pause. The most common example is an
	 * incoming phone call on the device, which will cause the pauseApp() method
	 * to be called. This allows us to perform the needed actions within our
	 * MIDlet
	 */
	protected void pauseApp() {
	}

	/**
	 * startApp() is called by the AMS after it has successfully created an
	 * instance of our MIDlet class. startApp() causes our MIDlet to go into a
	 * "Active" state.
	 */
	protected void startApp() throws MIDletStateChangeException {

		if (getMainForm() == null) {
			Form f = new Form("Bluetooth GPS Logger");
			setMainForm(f);
			getMainForm().addCommand(exitCommand);
			getMainForm().append(gauge);
			getMainForm().setTicker(ticker);
			getMainForm().setCommandListener(this);
		}
		if (getTime() == null) {
			setTime(new Thread(this));
		}

		if (getDisplay() == null) {
			setDisplay(Display.getDisplay(this));
		}
		getDisplay().setCurrent(getMainForm());

		if (getGPS() == null) {
			setGPS(new GPSComponent(GPSComponent.CONFIG_USE_BLUETOOTH_GPS));
			//setGPS(new GPSComponent( GPSComponent.CONFIG_USE_NETWORK_GPS_PROXY, "http://www.ics.uci.edu/~djp3/classes/2007_04_02_INF132/code/GPSDATA01.txt"));

		}

		getTime().start();
	}

	public void commandAction(Command c, Item arg1) {

	}

	public void commandAction(Command c, Displayable arg1) {

		if (c == exitCommand) {
			destroyApp(true);
			notifyDestroyed();
		}
		else if (c == checkGPSBuffer){
			Integer length = new Integer(getGPS().getGPSBuffer().length());
			getMainForm().deleteAll();
			getMainForm().append("GPS Buffer Info:\n");
			getMainForm().append(length.toString());
			getMainForm().append("\nBuffer Contents:\n");
			getMainForm().append(getGPS().getGPSBuffer().toString().substring(0,250));
		}
		else if (c == setUpdateTo60){
			loopDelay=loopDelayValue=60000;
		}
		else if (c == setUpdateTo30){
			loopDelay=loopDelayValue=30000;
		}
		else if (c == setUpdateTo10){
			loopDelay=loopDelayValue=10000;
		}
	}

}
